<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/PrivateAccesor.php';
require_once 'iplan/orm/exceptions/UnknowAttribute.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class LazyLoader extends PrivateAccesor {
  /**
   * @var ORMObject el objeto sobre el que se desea modificar el atributo
   */
  private $object;

  /**
   * @var el atributo a recuperar
   */
  private $attribute;

  /**
   * @var ORM el manejador de objetos que mediar la consulta del campo
   */
  private $orm;

  /**
   * Crea un cargador perezoso para el atributo.
   * 
   * @param ORMObject $object un objeto de la jerarqua de ORMObject
   * @param string $attribute el nombre del atributo
   * @param ORM $orm el objeto que mediar para recuperar el atributo
   * 
   * @return LazyLoader el cargador perezoso para el atributo
   */
  public function __construct($object, $attribute, &$orm)
  {
    // Bouml preserved body begin 00070905
    $this->attribute=$attribute;
    $this->orm = $orm;
    $this->object=$object;
    return $this;
    // Bouml preserved body end 00070905
  }

  /**
   * Recupera el valor del campo pre-configurado.
   * 
   * @return mixed el objeto o valor recuperado
   */
  public function load()
  {
    // Bouml preserved body begin 00070985
    $definition = $this->orm->getDefinition(get_class($this->object));
    $db = $this->orm->getDatabase();
    if ($fieldMap = $definition->getFieldDefinition($this->attribute)){
        $data = $db->getField($fieldMap['table'], $this->object->getId(), $fieldMap['fieldName']);
        //Con el valor del campo, me fijo si es un ID de objeto o un valor común
        if ($fieldMap['type']!=ORM_TYPES::ORM_ENTITY) {
            return $data;
        } else {
            if (!is_null($data))
                return $this->orm->load($fieldMap['class'], $data);
            else
                return null;
        }
    } else {
        //Si se trata de una relación, recupero la definición de la clase objetivo (target)
        //y procedo a ver el tipo de relación. De todos modos el modus operandi es el mismo:
        //encontrar los ids de los objetos asociados y cargarlos en una ORMCollection.
        if ($relationMap = $definition->getRelationDefinition($this->attribute)) {
            $targetClassDefinition = $this->orm->getDefinition($relationMap['class']);
            switch ($relationMap['type']) {
                case ORM_RELATION_TYPE::OneToMany:
                case ORM_RELATION_TYPE::OneToOne:
                    $targetIdDefinition = $targetClassDefinition->getFieldDefinition('id');
                    $relatedIds = $db->filter($targetIdDefinition['table'], array($targetIdDefinition['fieldName']),
                                              array($db->makeCondition('=', $relationMap['fieldName'], $this->object->getId())));
                    if ($relatedIds != false) {
                        $collection = new ORMCollection();
                        foreach($relatedIds as $key=>$relId)
                            $collection[] = $this->orm->load($relationMap['class'], $relId[$targetIdDefinition['fieldName']]);
                        return $collection->reset();
                    } else {
                        return null;
                    }
                    break;
                case ORM_RELATION_TYPE::ManyToMany:
                    //Recuperar ids de la tabla intermedia y recarcar el array, parecido a 1:N pero sobre otra tabla
                    $relatedIds = $db->filter($relationMap['table'], array($relationMap['associatedFieldName']),
                                              array($db->makeCondition('=', $relationMap['fieldName'], $this->object->getId())));
                    if ($relatedIds != false) {
                        $collection = new ORMCollection();
                        foreach($relatedIds as $key=>$relId) {
                            $collection[] = $this->orm->load($relationMap['class'], $relId[$relationMap['associatedFieldName']]);
                        }
                        return $collection->reset();
                    } else {
                        return null;
                    }
                    break;
                default:
                    throw new InternalError("El tipo de relación de $this->attribute es incorrecto");
            }
        } else {
            throw new UnknowAttribute("El LazyLoad de $this->attribute falló");
        }
    }
    // Bouml preserved body end 00070985
  }

}
?>