<?php

/*
 * This file is part of Twig.
 *
 * (c) 2009 Fabien Potencier
 * (c) 2009 Armin Ronacher
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
class Twig_TokenParser_Parent extends Twig_TokenParser
{
    /**
     * Parses a token and returns a node.
     *
     * @param Twig_Token $token A Twig_Token instance
     *
     * @return Twig_NodeInterface A Twig_NodeInterface instance
     */
    public function parse(Twig_Token $token)
    {
        if (!count($this->parser->getBlockStack())) {
            throw new Twig_Error_Syntax('Calling "parent" outside a block is forbidden', $token->getLine());
        }
        $this->parser->getStream()->expect(Twig_Token::BLOCK_END_TYPE);

        if (!$this->parser->getParent()) {
            throw new Twig_Error_Syntax('Calling "parent" on a template that does not extend another one is forbidden', $token->getLine());
        }

        return new Twig_Node_Parent($this->parser->peekBlockStack(), $token->getLine(), $this->getTag());
    }

    /**
     * Gets the tag name associated with this token parser.
     *
     * @param string The tag name
     */
    public function getTag()
    {
        return 'parent';
    }
}
