<?php
require_once 'modelo/Socket.php';
require_once 'modelo/Parser.php';
require_once 'modelo/constantes.php';

class ACP {

    private $socket;
    private $parser;
    private $CSeq=1;

    private $CLogin="LOGIN %s ACP/1.1\r\nCSeq: %s LOGIN\r\n\r\n";
    
    //private $CAdd="ADD %s ACP/1.1\r\nTarget-ID: %s\r\nLawful-Intercept-TID: %s\r\nIntercept-Type: All\r\nTarget-Type: E.164\r\nCSeq: %s ADD\r\n\r\n";
    private $CAdd="ADD %s ACP/1.1\r\nTarget-ID: %s\r\nLawful-Intercept-TID: %s\r\nIntercept-Type: All\r\nTarget-Type: E.164-Leading-Digits\r\nCSeq: %s ADD\r\n\r\n";
    
    private $CDelete="DELETE %s ACP/1.1\r\nTarget-ID: %s\r\nLawful-Intercept-TID: %s\r\nTarget-Type: E.164\r\nCSeq: %s DELETE\r\n\r\n";
    
    private $CGet="GET %s ACP/1.1\r\nCSeq: %s GET\r\n\r\n";

    private $CKeepAlive="KEEPALIVE %s ACP/1.1\r\nCSeq: %s KEEPALIVE\r\n\r\n ";

    private static $instance;

    public static function getInstance() {

        if (self::$instance == null || ! self::$instance instanceof ACP)
         {
           self::$instance = new ACP();
         }
         return self::$instance;
   }

   function __construct()
    {
        $this->socket = Socket::getInstance();
        $this->parser = Parser::getInstance();
    }

   public function login($ip,$port)
    {   
        //Creamos la conexion contra ACME
        try{ 
            if($this->socket->connect($ip,$port)== false){
                return array(true,"No se pudo conectar al ACME $ip puerto $port");
            }
        }
        catch(Exception $e){
                return array(true,"No se pudo conectar al ACME $ip");
        }

        $bsend=sprintf($this->CLogin,CLIENT_ACP,$this->getCSeq());
        $bwrite=$this->socket->sendCmd($bsend);
        $buf="";
        $salir=0;
        
        do{
            $recv="";
            $recv= $this->socket->getResponse();
                if($recv != ""){
                    $buf .= $recv;
                    $salir=1;
                }
                else{
                   $this->socket->disconnect();
                   return array(true,"No se recibe respuesta de ACME al intentar loguear");
                }
         }while ($recv !="" && $salir===0);
            
            $this->setNextCSeq();

         return array(!$this->checkStatus($buf,LOGIN_ACME),"");
    }

   public function iniciar_escucha($ani,$targetID)
    {
      if($this->socket->validateConnection()){
          $bsend=sprintf($this->CAdd,CLIENT_ACP,$ani,$targetID,$this->getCSeq());
          $bwrite=$this->socket->sendCmd($bsend);
          $buf=$this->socket->getResponse();
          //echo $bsend."\r\n";
          //echo $buf."\r\n";
          $this->setNextCSeq();
          return array(!$this->checkStatus($buf,ADD),"");
      }else
          return array(true,"No se encuentra una conexion contra ACME para iniciar la escucha");
    }

   public function parar_escucha($ani,$targetID)
    {
      if($this->socket->validateConnection()){
          $bsend=sprintf($this->CDelete,CLIENT_ACP,$ani,$targetID,$this->getCSeq());
          $bwrite=$this->socket->sendCmd($bsend);
          $buf=$this->socket->getResponse();
          $this->setNextCSeq();
          return array(!$this->checkStatus($buf,DEL),"");
      }else
          return array(true,"No se encuentra una conexion contra ACME para parar la escucha");
    }

   public function listar_escuchas()
    {
      if($this->socket->validateConnection()){
          $bsend=sprintf($this->CGet,CLIENT_ACP,$this->getCSeq());
          $bwrite=$this->socket->sendCmd($bsend);
          $recv= $this->socket->getResponse();
          $this->setNextCSeq();
          //echo $recv;
          return array(!$this->checkStatus($buf,GET),$recv);
      }else
          return array(true,"No se encuentra una conexion contra ACME para listar las escuchas");
    }

   public function verificar_escucha($ani)
    {
    
    }

   public function desconectar()
    {
      $this->socket->disconnect();
    }

   private function setNextCSeq()
    {
      $this->CSeq = ($this->getCSeq()+1);
    }

   private function getCSeq()
   {
      return $this->CSeq;
   }

   private function checkStatus($buf,$accion)
   {
         if ($this->parser->parse_headers($buf)){
            
            switch ($this->parser->getStatusResponse()){
                  case 200:
                  case 202: return true;
                            break;
                  case 404: if ($accion==DEL)
                             return true;
                            return false;
                            break;
                  case 409: if($accion===ADD){
                             return true;
                             }
                            return false;
                            break;
                  default: 
                            return false;
            }
         }else{
            return false;
         }
   }
}
?>
