<?php


require_once 'interfaces.php';
require_once 'modelo/Usuario.php';
require_once 'modelo/Logs.php';
require_once 'modelo/Acme.php';
require_once 'modelo/Escucha.php';
require_once 'modelo/EscuchaAcme.php';
require_once 'modelo/ACP.php';
require_once 'modelo/Socket.php';
require_once 'BaseDeDatos.php';
require_once 'constantes.php';
require_once 'class.phpmailer.php';

class SistemaEscuchaJudicial implements ISistemaEscuchaJudicial {
  
  private $db; # base de datos
  public $usuarioweb;
  private $log;
  private $error=false;
  private $estado=0;

  function __construct()
  {
  	# creo la base de datos
	$this->db = BaseDeDatos::conectar();
  }

  function login($nombre, $clave)
  {
     # Obtengo el usuario web
     $usuario = Usuario::login($this->db,$nombre);
     # existe usuario con ese nombre?
     if ($usuario==NULL)
        return false;

     if ($usuario->verificar_clave($clave)){
          $this->usuarioweb = $usuario;
	  $this->log = new Logs($this->usuarioweb->dar_idUsuario(),LOGIN,'El usuario ingreso a la plataforma');
	  $this->log->guardar($this->db);
          return true;
     } else {
         return false;
       }
  }

  function iniciarEscucha($ani,$id,$idEscucha)
  {  
     $acmes=$this->dar_lista_acmes(1);
     $loginACME= ACP::getInstance();
     
     foreach($acmes as $acme=>$acme_info){
        
        $info_log = "ANI: $ani ID: $idEscucha (".$acme_info['ip_x1'].")"; 
        $respuesta_login = $loginACME->login($acme_info['ip_x1'],$acme_info['port_x1']);
        
        if ($respuesta_login[0]){
           $this->loguear(ERROR_ACME,'Error al loguear contra ACME '.$info_log.' Error: '.$respuesta_login[1]);
           $this->error=true;
           $this->estado=ERROR;
        }
        
        $respuesta_iniciar = $loginACME->iniciar_escucha($ani,$idEscucha);

        if(!$respuesta_iniciar[0]){
           $this->loguear(ESCUCHA_ACME,'Iniciar escucha '.$info_log);
           $this->error=false;
           $this->estado=EN_ESCUCHA;
        }
        else
        {
           $this->loguear(ERROR_ACME,'Error al iniciar escucha '.$info_log.' Error: '.$respuesta_iniciar[1]);
           $this->error=true;
           $this->estado=ERROR;
        }
        $loginACME->desconectar();
        $EscuchaAcme= EscuchaAcme::alta($this->db,$id,$idEscucha,$acme_info['idAcme'],$this->estado);
     }
     $Escucha= Escucha::modificacion($this->db,$id,0,0,$this->estado);
     return array(!$this->error,"Error al intentar iniciar la escucha. Ver logs");
  }
  
  function pararEscucha($ani,$id,$idEscucha)
  {  
     $acmes=$this->dar_lista_acmes(1);
     $loginACME= ACP::getInstance();
     
     foreach($acmes as $acme=>$acme_info){
        
        $info_log = "ANI: $ani ID: $idEscucha (".$acme_info['ip_x1'].")"; 
        $respuesta_login = $loginACME->login($acme_info['ip_x1'],$acme_info['port_x1']);
        
        if ($respuesta_login[0]){
           $this->loguear(ERROR_ACME,'Error al loguear contra ACME '.$info_log.' Error: '.$respuesta_login[1]);
           $this->error=true;
           $this->estado=ERROR;
        }
        $respuesta_parar = $loginACME->parar_escucha($ani,$idEscucha);
        
        if(!$respuesta_parar[0]){
            $this->loguear(ESCUCHA_ACME,'Parar escucha '.$info_log);
            $this->error=false;
            $this->estado=PAUSADA;
        }
        else
        {
            $this->loguear(ERROR_ACME,'Error al parar escucha '.$info_log.' Error: '.$respuesta_parar[1]);
            $this->error=true;
            $this->estado=ERROR;
        }
        $loginACME->desconectar();
        $EscuchaAcme= EscuchaAcme::alta($this->db,$id,$idEscucha,$acme_info['idAcme'],$this->estado);
     }
     $Escucha= Escucha::modificacion($this->db,$id,$idEscucha,0,$this->estado);
     return array(!$this->error,"Error al intentar parar la escucha. Ver logs");
  }
  
  function listarEscuchas()
  {  
     $acmes=$this->dar_lista_acmes(1);
     $loginACME= ACP::getInstance();
     
     foreach($acmes as $acme=>$acme_info){
        $respuesta_login = $loginACME->login($acme_info['ip_x1'],$acme_info['port_x1']);
         
        if ($respuesta_login[0]){
           $this->loguear(ERROR_ACME,'Error al loguear contra ACME '.$acme_info['ip_x1'].' Error: '.$respuesta_login[1]);
           return false;
        }
        $respuesta_listar = $loginACME->listar_escuchas(); 
        $loginACME->desconectar();
        echo $respuesta_listar[1];
        return array($respuesta_listar[0],$respuesta_listar[1]);
     }
     return array(false,"");
  }
  
  function listar_logs($idTipo,$idUsuario,$fecha_desde,$fecha_hasta)
  {
	if ($idUsuario==0){
		$usuarios=$this->dar_usuarios();
		if (sizeof($usuarios)==1)
			$idUsuario=$usuarios[0]['idUsuario'];
		else{
		  $idUsuario="";
		  foreach($usuarios as $usuario=>$valor)
	          {
			$idUsuario.=$valor['idUsuario'];
				if ((sizeof($usuarios)-1)!=$usuario)
					$idUsuario.=",";
		  }
		}
	}
	return Logs::listar_logs($this->db,$idTipo,$idUsuario,$fecha_desde,$fecha_hasta);
  }
  
  function dar_tipos_eventos($idPerfil)
  {
     return Logs::dar_tipos_eventos($this->db,$idPerfil);
  }

  function dar_usuarios($idCliente=0,$idRevendedor=0,$criterio=0)
  {
     $idPerfil=$_SESSION['idPerfil'];
     switch($idPerfil){
          case ADMINISTRADOR:
          case LEGALES:
                        $idPerfil=0;
          break;
          case CONSULTA:
          break;
          default:
       }
    return Usuario::dar_usuarios($this->db,$idPerfil);
  }

  function dar_perfiles()
  {
     $idPerfil=$_SESSION['idPerfil'];
     switch($idPerfil){
          case ADMINISTRADOR:
                        $idPerfil=0;
          break;
          case LEGALES:
          case CONSULTA:
          break;
          default:
       }
    return Usuario::dar_perfiles($this->db,$idPerfil);
  }
  
  function dar_acmes()
  {
    return Acme::dar_acmes($this->db);
  }

  function dar_lista_acmes($flag=0)
  {
    return Acme::dar_lista_acmes($this->db,$flag);
  }

  function dar_escuchas($idEscucha=0)
  {
    return Escucha::dar_escuchas($this->db,$idEscucha);
  }
  
  function dar_detalle_escucha($idEscucha)
  {
    return EscuchaAcme::dar_detalle_escucha($this->db,$idEscucha);
  }

  function loguear($id_log,$texto)
  {
    $this->log = new Logs($_SESSION['idUsuario'],$id_log,$texto);
    $this->log->guardar($this->db);
  }
  
  function baja_usuario($idUsuario)
  {
      Usuario::baja($this->db,$idUsuario);
      return true;
  }

  function baja_escucha($ani,$idEscucha)
  {   
    $escuchas=$this->dar_escuchas($idEscucha);
    $j=1;
    
    foreach($escuchas as $escucha=>$escucha_info){
        $respuesta_parar[$j]=$this->pararEscucha($escucha_info['ani'],$escucha_info['id'],$escucha_info['idEscucha']);
        $j++;
    }
      
    if($respuesta_parar[1][0] && $respuesta_parar[2][0]){
          Escucha::baja($this->db,$idEscucha);
          EscuchaAcme::baja($this->db,$idEscucha);
          return array(false,"");
    }
    return array(true,$respuesta_parar[1][1].$respuesta_parar[2][1]);
  }

  function pausar_escucha($ani,$idEscucha)
  {
    $escuchas=$this->dar_escuchas($idEscucha);
    $j=1;

    foreach($escuchas as $escucha=>$escucha_info){
        $respuesta_parar[$j]=$this->pararEscucha($escucha_info['ani'],$escucha_info['id'],$escucha_info['idEscucha']);
        $j++;    
    }
    
    if($respuesta_parar[1][0] && $respuesta_parar[2][0])
        return array(false,"");
    else
        return array(true,$respuesta_parar[1].$respuesta_parar[1]);
  }
  
  function iniciar_escucha($ani,$idEscucha)
  {
    $escuchas=$this->dar_escuchas($idEscucha);
    $j=1;

    foreach($escuchas as $escucha=>$escucha_info){
        $respuesta_parar[$j]=$this->iniciarEscucha($escucha_info['ani'],$escucha_info['id'],$escucha_info['idEscucha']);
        $j++;    
    }
    
    if($respuesta_parar[1][0] && $respuesta_parar[2][0])
        return array(false,"");
    else
        return array(true,$respuesta_parar[1].$respuesta_parar[1]);
  }
  
  function baja_acme($idAcme)
  {
      Acme::baja($this->db,$idAcme);
      return true;
  }

  function guardar_usuario($nombre,$usuario,$clave,$idUsuario,$idPerfil)
  {
     if ($idUsuario==0){
         if(Usuario::alta($this->db,$idPerfil,$nombre,$usuario,$clave)){
            $this->loguear(ALTA_USUARIO,"Se ha dado de alta el usuario $nombre");
            return true;
         }
     }else{
         Usuario::modificacion($this->db,$nombre,$usuario,$clave,$idUsuario,$idPerfil);
         $this->loguear(MODIFICACION_USUARIO,"Se ha dado modificado el usuario $nombre");
         return true;
     }
  }

  function guardar_escucha($ani,$dias,$idEscucha) 
  {
     if ($idEscucha==0){
           $idEscucha=Escucha::alta($this->db,$ani,$dias);
                if($idEscucha[0]&&$idEscucha[1]&&$idEscucha[2]){
                    
                    $escuchas=$this->dar_escuchas($idEscucha[2]);
                    $j=1;

                    foreach($escuchas as $escucha=>$escucha_info){
                        $respuesta[$j] = $this->iniciarEscucha($escucha_info['ani'],$escucha_info['id'],$escucha_info['idEscucha']);
                    } 
                    
                    if ($respuesta_parar[1][0] && $respuesta_parar[2][0])
                        return array(false,"");
                    else
                        return array(true,"Hubo errores al iniciar la escucha. Ver logs");
                }
     }else{
         Escucha::modificacion($this->db,0,$idEscucha,$dias,0);
         return array(false,"");
     }
     return array(true,"Hubo errores al iniciar la escucha. Ver logs");
  }
  
  function guardar_acme($ip,$nombre,$activo,$port,$idAcme) 
  {
     if ($idAcme==0){
         if(Acme::alta($this->db,$ip,$nombre,$activo,$port)){
            return true;
         }
     }else{
         Acme::modificacion($this->db,$ip,$nombre,$activo,$port,$idAcme);
         return true;
     }
  }
  
  function enviar_mail($email,$subject,$mensaje,$cabeceras)
  {
  	$mail = new PHPMailer();
        $mail -> From = "miratucamara@gmail.com";
        $mail -> FromName = "Alarmas MiratuCamara";
        $direccionmail=split(",",$email);
	        for ($i=0;$i<count($direccionmail);$i++){
	               $mail -> AddAddress ($direccionmail[$i]);
	        }
        // $mail -> AddAttachment ($archivo);
        $mail -> Subject = "$subject";
        $mail -> Body = "$mensaje";
        $mail -> IsHTML (true);
        $mail->IsSMTP();
        $mail->Host = 'ssl://smtp.gmail.com';
        $mail->Host = 'smtp.gmail.com';
        $mail->Port = 465;
        $mail->SMTPAuth = true;
        $mail->Username = 'miratucamara@gmail.com';
        $mail->Password = 'Qcqhed!!';
        $mail->Send();
  }
}
?>
