<?php

require_once 'SistemaEscuchaJudicial.php';
require_once 'modelo/constantes.php';

error_reporting(0);

class InterfaceWeb implements IInterfaceWeb {
  private $sEscuchaJudicial;

  function __construct()
  {
   	# Creo una instancia del sistema:
  	$this->sEscuchaJudicial = new SistemaEscuchaJudicial();
  }

  function mostrar_login()
  {
  	include "vistas/login.php";
  }

  function procesar_login($nombre, $clave)
  {
	if (!$this->sEscuchaJudicial->login($nombre,$clave)) {
             $this->mostrar_msg("Usuario o Clave incorrecta!");
             return False;
        } else {
      $_SESSION['idPerfil']=$this->sEscuchaJudicial->usuarioweb->dar_idPerfil();
		$_SESSION['idUsuario']=$this->sEscuchaJudicial->usuarioweb->dar_idUsuario();
	      switch ($this->sEscuchaJudicial->usuarioweb->dar_idperfil())
	      {
	        case ADMINISTRADOR:
       		$this->mostrar_administrador();
		   	break;
		     case LEGALES:
    			$this->mostrar_legales();
	     		break;
		     case CONSULTA: 
			   $this->mostrar_consulta();
			break;
		default:
	      }
                return True;
	       }

  }

  function eliminar_sesion()
  {
       session_destroy();
  }

  function valida_accion($accion)
  {	
	switch($_SESSION['idPerfil']) {
		case ADMINISTRADOR:
			 switch($accion) {
				case 'menu_escucha':
				case 'modificar_escucha':
				case 'menu_logs':
				case 'iniciar_escucha':
				case 'reiniciar_escucha':
				case 'pausar_escucha':
				case 'parar_escucha':
				case 'listar_logs':
				case 'form_usuarios':
				case 'usuarios':
            case 'guardar_usuario':
            case 'guardar_ruta':
            case 'guardar_acme':
            case 'baja_usuario':
            case 'baja_escucha':
            case 'escuchas':
            case 'acmes':
            case 'form_acme':
            case 'baja_acme':
				case '':
					break;
				default:
					$accion = 'salir';
					break;
				}
		break;
		case LEGALES:
			 switch($accion) {
				case 'menu_escucha':
            case 'modificar_escucha':
				case 'menu_logs':
				case 'iniciar_escucha':
				case 'reiniciar_escucha':
				case 'pausar_escucha':
				case 'parar_escucha':
				case 'listar_logs':
				case 'usuarios':
				case 'form_usuarios':
            case 'guardar_usuario':
            case 'escuchas':
				case '':
					break;
				default:
					$accion = 'salir';
					break;
				}
		break;
		default:
			switch($accion) {
				case '':
				case 'login':
				        break;
				default:
					$accion = 'salir';
					break;
				}
	}
	return $accion;
  }
  
  function mostrar_logs()
  {
      echo "<table class=\"buscar_log\"><tr><th>Seleccione tipo de log</th><th>Seleccione un usuario</th><th>Fecha desde</th><th>Fecha hasta</th><th></th></tr>";
      echo "<tr><td>".$this->mostrar_select_tipos_eventos()."</td>";
      echo "<td>".$this->mostrar_select_usuarios()."</td>";
      echo "<td><input id=\"fecha_desde\" name=\"fecha_desde\"/ value=".date('Y-m-d')."><a href=\"javascript:popUpCalendar(document.getElementById('fecha_desde'),document.getElementById('fecha_desde'),'yyyy-mm-dd')\"><img src=\"images/calendar.gif\"></a></td><td><input name=\"fecha_hasta\" id=\"fecha_hasta\"/ value=".date('Y-m-d')."><a href=\"javascript:popUpCalendar(document.getElementById('fecha_hasta'),document.getElementById('fecha_hasta'),'yyyy-mm-dd')\"><img src=\"images/calendar.gif\"></a></td><td><input type=\"submit\" name=\"buscar_logs\" value=\"Buscar\" onclick='listar_logs()'/></td></tr></table>";
  }

  function mostrar_select_tipos_eventos()
  {
       $tipos_eventos=$this->sEscuchaJudicial->dar_tipos_eventos($_SESSION['idPerfil']);

       foreach($tipos_eventos as $tipos=>$valor)
       {
          $options.="<option value=\"".$valor['idTipo']."\">".$valor['descripcion']."</option>";
       }
       
       $html="<select id='tipo_evento'><option value=0>Todos</option>$options</select>";

       return $html;
  }

  function mostrar_select_usuarios()
  {
       $usuarios=$this->sEscuchaJudicial->dar_usuarios();

       foreach($usuarios as $usuario=>$valor)
       {
          $options.="<option value=\"".$valor['idUsuario']."\">".$valor['usuario']."</option>";
       }

       $html="<select id='usuario'><option value=0>Todos</option>$options</select>";

       return $html;
  }

  function mostrar_msg($mensaje)
  {
      echo "<script language=\"JavaScript\">\n";
      echo "alert(\"$mensaje\");\n";
      echo "</script>";
  }
 
  function mostrar_administrador()
  {
      include('vistas/administrador.php');
  }

  function mostrar_legales()
  {
      include('vistas/legales.php');
  }
 
  function form_usuarios()
  {
      $html= "<table bgcolor=\"#C0C0C0\" width=\"672\" cellspacing=\"2\" cellpadding=\"0\" align=\"left\"><tr><td colspan=\"1\">Perfil: ";
      $html.=$this->mostrar_select_perfiles();
      $html.="</td></tr></table></br>";
      echo $html;
      include('vistas/form_usuario.php');
  }

  function form_acme()
  {
      include('vistas/form_acme.php');
  }
  
  function listar_escuchas()
  {
    $escuchas=$this->sEscuchaJudicial->dar_escuchas();
    $html.="<center><table class=\"listados\" align=\"center\"><tr><th colspan=\"1\" style=\"background-color:grey;\"><h3>Listado de Escuchas</h3></th></tr></table>";

	 foreach($escuchas as $escucha=>$escucha_info){
        
        switch ($escucha_info['idEstado']){
            case EN_ESCUCHA: $color="green";
                    break;
            case PENDIENTE:
            case ERROR: $color="red";
                    break;
            case PAUSADA: $color="yellow";
                    break;
            case FINALIZADA: $color="grey";
                    break;
            default: 
        }
        
        $html.="<center><table class=\"listados\" align=\"center\"><tr><th colspan=\"7\" style=\"background-color:$color;\" onclick=\"Mostrar('".$escucha_info['idEscucha']."');\">L&iacute;nea ".$escucha_info['ani']." ".$escucha_info['estado']."</th></tr></table></div>";
    
        $html.="<center><div class=\"".$escucha_info['idEscucha']."\" style=\"display: none;\"><table class=\"listados\" align=\"center\"><tr><th>ID Escucha</th><th class\"gris\">Duraci&oacute;n</th><th>Estado</th><th>Fecha Creaci&oacute;n</th><th>Fecha Modificaci&oacute;n</th><th>Usuario</th><th>Acciones</th></tr>";
		  
        $html.= "<tr align=\"center\"><td>".$escucha_info['idEscucha']."</td><td>".$escucha_info['duracion']." d&iacute;as</td><td>".$escucha_info['estado']."</td><td>".$escucha_info['fecha_creacion']."</td><td>".$escucha_info['fecha_modificacion']."</td><td>".$escucha_info['nombre']."</td><td>"; 
        if (substr($escucha_info['ani'],0,1)!=0) {
            $html.= "<a href=\"#\" onclick=\"baja_escucha('".$escucha_info['idEscucha']."','".$escucha_info['ani']."')\">Borrar</a> <a href=\"#\" onclick=\"modificar_escucha('".$escucha_info['idEscucha']."','".$escucha_info['ani']."','".$escucha_info['duracion']."')\">Modificar</a>";
        if ($escucha_info['idEstado']==EN_ESCUCHA)
            $html.=" <a href=\"#\" onclick=\"pausar_escucha('".$escucha_info['idEscucha']."','".$escucha_info['ani']."')\">Pausar</a>";

        if ($escucha_info['idEstado']!=EN_ESCUCHA)
            $html.=" <a href=\"#\" onclick=\"reiniciar_escucha('".$escucha_info['idEscucha']."','".$escucha_info['ani']."')\">Iniciar</a>";
        }
        $html.="</td></tr></table>";

        $detalles_escucha=$this->sEscuchaJudicial->dar_detalle_escucha($escucha_info['id']);
        $html.="<center><table class=\"listados\" align=\"center\"><tr><th>ACME</th><th>Estado</th></tr>";

        foreach($detalles_escucha as $detalle_escucha=>$detalle_escucha_info){
            
            if ($detalle_escucha_info['idEstado']==ERROR)
                $style=" style=\"background-color:red;\"";
            
            $html.="<tr align=\"center\"><td $style>".$detalle_escucha_info['acme']."</td><td $style>".$detalle_escucha_info['estado']."</td></tr>";
            $style="";
        }
        $html.="</table></div>";
    }
    return $html;
  }
  
  function listar_acmes()
  {
    $acmes=$this->sEscuchaJudicial->dar_lista_acmes();
    $html.="</br><center><table class=\"listados\" align=\"center\"><tr><th colspan=\"5\" style=\"background-color:grey;\">Listado de ACME</th></tr><tr><th>Descripcion</th><th>IP X1</th><th>PORT X1</th><th>Activo</th><th>Acciones</th></tr>";

	 foreach($acmes as $acme=>$acme_info){
			$html.= "<tr align=\"center\"><td>".$acme_info['descripcion']."</td><td>".$acme_info['ip_x1']."</td><td>".$acme_info['port_x1']."</td><td>".$acme_info['activo']."</td><td><a href=\"#\" onclick=\"baja_acme('".$acme_info['idAcme']."','".$acme_info['descripcion']."')\">Borrar</a> <a href=\"#\" onclick=\"modificar_acme('".$acme_info['idAcme']."','".$acme_info['descripcion']."','".$acme_info['ip_x1']."','".$acme_info['port_x1']."','".$acme_info['fl_activo']."')\">Modificar</a></td></tr>";
    }
    return $html;
  } 
  
  function mostrar_escucha()
  {
  	include "vistas/form_escucha.php";
  }
  
  function reiniciar_escucha($ani,$idEscucha)
  {
    $respuesta=$this->sEscuchaJudicial->iniciar_escucha($ani,$idEscucha);  
    
    if(!$respuesta[0])
        echo "<h2 class=\"error\">".$respuesta[1]."</h2>";
    return $this->listar_escuchas();
  }
  
  function pausar_escucha($ani,$idEscucha)
  {
    $respuesta=$this->sEscuchaJudicial->pausar_escucha($ani,$idEscucha);  
    
    if(!$respuesta[0])
        echo "<h2 class=\"error\">".$respuesta[1]."</h2>";
    return $this->listar_escuchas();
  }
  
  function listar_logs($idTipo,$idUsuario,$fecha_desde,$fecha_hasta)
  {
     	echo $this->mostrar_logs();
  
     	$logs=$this->sEscuchaJudicial->listar_logs($idTipo,$idUsuario,$fecha_desde,$fecha_hasta);

  	$html.="</br><center><table class=\"listados\" ><tr><th colspan=\"4\" style=\"background-color:grey;\">Listado de Logs</th></tr><tr><th>Tipo de log</th><th>Descripcion</th><th>Usuario</th><th>Fecha de creacion</th></tr>";	

		foreach($logs as $log=>$log_info){
			$html.= "<tr align=\"center\"><td>".$log_info['tipo_log']."</td><td>".$log_info['descripcion']."</td><td>".$log_info['usuario']."</td><td>".$log_info['fechaCreacion']."</td></tr>";
			}
        return $html; 
  }

  function listar_usuarios()
  {
      $usuarios=$this->sEscuchaJudicial->dar_usuarios(0,0,$_POST['criterio']);
//      $html="Ingrese Nombre: <input name=\"criterio\" id=\"criterio\" value=\"\" size=\"20\"/><input type=\"submit\" name=\"buscar\" value=\"Buscar\" onclick=\"buscar('usuarios')\"/>";
      $html.="<center><table class=\"listados\" ><tr><th colspan=\"5\" style=\"background-color:grey;\">Listado de Usuarios</th></tr><tr><th>Nombre</th><th>Usuario</th><th>Perfil</th><th>Acciones</th></tr>";
          foreach($usuarios as $usuario=>$valor){
                   $html.= "<tr align=\"center\"><td>".$valor['nombre']."</td><td>".$valor['usuario']."</td><td>".$valor['descripcion']."</td><td>";
                    if ($_SESSION['idUsuario']!=$valor['idUsuario']){
                             $html.="<a href=\"#\" onclick=\"baja_usuario('".$valor['idUsuario']."','".$valor['usuario']."')\">Borrar</a>";
                    }
             $html.=" <a href=\"#\" onclick=\"modificar_usuario(".$valor['idUsuario'].",'".$valor['nombre']."','".$valor['usuario']."','".$valor['idPerfil']."')\">Modificar</a></td></tr>";
          }
    return $html;
  }

  function baja_usuario($idUsuario)
  {
       $res = $this->sEscuchaJudicial->baja_usuario($idUsuario);

           if ($res){
                return $this->listar_usuarios();
           }else{
                return "<h2>No se pudo dar de baja<h2>";
                }
  }

  function baja_escucha($ani,$idEscucha)
  {
    $respuesta = $this->sEscuchaJudicial->baja_escucha($ani,$idEscucha);
    
    if($respuesta[0])
       echo "<h2 class=\"error\">".$respuesta[1]."</h2>";
    
    return $this->listar_escuchas();
  }

  function baja_acme($idAcme)
  {
       $res = $this->sEscuchaJudicial->baja_acme($idAcme);

           if ($res){
                return $this->listar_acmes();
           }else{
                return "<h2>No se pudo dar de baja el ACME<h2>";
                }
  }

  function guardar_usuario($nombre,$usuario,$clave,$idUsuario,$idPerfil)
  {
     $res=$this->sEscuchaJudicial->guardar_usuario($nombre,$usuario,$clave,$idUsuario,$idPerfil);
     
     if ($res){
        return $this->listar_usuarios();
     }else{
        return "<h2>No se pudo guardar el usuario<h2>";
     }
  }

  function iniciar_escucha($ani,$dias,$idEscucha)
  {
    $respuesta = $this->sEscuchaJudicial->guardar_escucha($ani,$dias,$idEscucha);
    
    if(!$respuesta[0])
       echo "<h2 class=\"error\">".$respuesta[1]."</h2>";
    
    return $this->listar_escuchas();
  }
  
  function guardar_acme($ip,$nombre,$activo,$port,$idAcme)
  {
    $res=$this->sEscuchaJudicial->guardar_acme($ip,$nombre,$activo,$port,$idAcme);
    
    if ($res){
       return $this->listar_acmes();
    }else{
       return "<h2>No se pudo guardar el acme<h2>";
    }
  }
  
  function mostrar_select_acmes($accion)
  {
	$acmes=$this->sEscuchaJudicial->dar_acmes();

	foreach($acmes as $acme=>$valor)
	{
	        $options.="<option value=\"".$valor['id_group']."\">".$valor['description']."</option>";
	}

	$html="<select id='group' onchange=$accion><option value=0>---</option>$options</select>";
	return $html;
  }

  function mostrar_select_perfiles()
  {
	$perfiles=$this->sEscuchaJudicial->dar_perfiles();
	foreach($perfiles as $perfil=>$valor)
	{
	        $options.="<option value=\"".$valor['idPerfil']."\">".$valor['descripcion']."</option>";
	}

	$html="<select id='perfil'>$options</select>";
	return $html;
  }
}
# inicializo la sesión con el usuario
session_start();

?>
