<?

ini_set("soap.wsdl_cache_enabled", "0");

//function_lu produccion
//require_once("/usr/local/apache2/htdocs/detalleiuni.iplan.com.ar/detalleiuni/function_lu.php");

//function_lu desarrollo
require_once("/www/detalleiuni.iplan.com.ar/detalleiuni/function_lu.php");

//auxiliares xd
require_once("BaseDatos.php");
require_once('funciones.php');

// Funcion auxiliar para agarrar los errores y tirarlos a los logs xd
function miGestorErrores($num_err, $cadena_err, $archivo_err, $linea_err) {
	$log = LogErrorWeekDay::GetLog();
	$log->AddLog("Error Agarrado: Linea [$linea_err], Archivo [$archivo_err], Numero [$num_err], Descripcion [$cadena_err]");
}


//Cosas del LOG
define("LOG_LOCATION", "log/");
define("LOG_FILE_NAME", "webservice_detalle_iuni");



//Constantes de coneccion al host local xd
define("ICV_HOST", "172.16.213.12");
define("ICV_USER", "icv");
define("ICV_PASSWD", "icv1234");
define("ICV_DB", "ICV");
define("ICV_PORT", "3306");


function microtime_float() {
    list($useg, $seg) = explode(" ", microtime());
    return ((float)$useg + (float)$seg);
}

function AddDetalle($nro_tenfold, $linea, $id_product_offering, $razon_social, $codigo_subscripcion, $tiene_detalle) {
	$errorFeo = false;

	$log = LogErrorWeekDay::GetLog();
	$aRespuesta = array("codigo" => "99", "descripcion" => "desconocido");

	$dbase = BaseDatos::NuevaConeccion(MY_SQL, ICV_HOST . ":" . ICV_PORT , ICV_DB, ICV_USER, ICV_PASSWD); 

	$aProductOffering = array("31" => "Central IUNI", "32" => "Central IUNI - Internos", "33" => "Central IUNI - Auto Attendant", "34" => "Central IUNI - Licencia Hunt Group", "35" => "Central IUNI - Internos Off Net", "37" => "Central IUNI - Licencia Call Center");

	$sqlAltaLu = "	SELECT alta_lu 
					FROM customer 
					WHERE id_tenfold = $nro_tenfold";

	$dbase->Query($sqlAltaLu, 1);

	$asdxd = $dbase->FetchArray(1);

	if (!is_array($asdxd)) {
		$alta_lu = false;
	} else {
		$alta_lu = ($asdxd['alta_lu'] > 0) ? true : false;
	}
	
	//$alta_lu = ($resAltaLu) ? true : false;
	
	if ((!$alta_lu) && ($tiene_detalle)) {
		$cgp = get_cgp($nro_tenfold);
		
		if ($cgp != "0000000") {
			$rta = crear_administrador_cliente($cgp, 80);
			//$rta = true;
			if ($rta != true) {
				$log->AddLog($rta);
				$aRespuesta = array("codigo" => "90", "descripcion" => "Error al agregarlo al Login Unificado");
				$errorFeo = true;
			} else {
				$log->AddLog("id_tenfold [$nro_tenfold] - Agregado a LU.", LOG_INFO);
				$alta_lu = true;
			}
		} else {
			$log->AddLog($rta);
			$aRespuesta = array("codigo" => "92", "descripcion" => "tenfold mal formado");
			$errorFeo = true;
		}
	}
	
	if ($errorFeo === false) {
		$query = "CALL fu_add_data_tenfold($nro_tenfold, '" . addslashes($razon_social) . "', $linea , 'AC', '" . $aProductOffering[$id_product_offering] . "', 1, " . (int)$tiene_detalle . ", '00-00-0000 00:00:00', $codigo_subscripcion, " . (int)$alta_lu . ")";
		$log->AddLog($query, LOG_INFO);

		$okey = $dbase->Query($query, 1);
	
		if (!$okey) {
			$aRespuesta = array("codigo" => "91", "descripcion" => "Error al crear la linea el y/o cliente en la plataforma [$query]");
			$log->AddLog("id_tenfold [$nro_tenfold] - Error al crear la linea el y/o cliente en la plataforma.", LOG_ERROR);
		} else {
			$aRespuesta = array("codigo" => "1", "descripcion" => "Okey");
		}
	}

	return ($aRespuesta);
	
}

function DelDetalle($nro_tenfold, $linea, $id_product_offering, $razon_social, $codigo_subscripcion, $estado_subscripcion /* AC - IN - etc */) {
	$errorFeo = false;

	$log = LogErrorWeekDay::GetLog();
	$aRespuesta = array("codigo" => "99", "descripcion" => "desconocido");

	$dbase = BaseDatos::NuevaConeccion(MY_SQL, ICV_HOST . ":" . ICV_PORT , ICV_DB, ICV_USER, ICV_PASSWD); 
	
	$aProductOffering = array("31" => "Central IUNI", "32" => "Central IUNI - Internos", "33" => "Central IUNI - Auto Attendant", "34" => "Central IUNI - Licencia Hunt Group", "35" => "Central IUNI - Internos Off Net");
	//Busco en la base de datos si tiene alguna linea activa, ade+ de la q me dan para bajar.-
	$sqlNums = "SELECT count(*) cant
				FROM line 
				WHERE	ani != $linea AND 
						is_iuni = 1 AND 
						id_tenfold = $nro_tenfold AND 
						product_offering like '%Central IUNI - Internos%' AND 
						feature_enable = 1";

	$dbase->Query($sqlNums, 1);

	$asdxd = $dbase->FetchArray(1);
	
	if (!is_array($asdxd)) {
		$tiene_otras = false;
	} else {
		$tiene_otras = ($asdxd['cant'] > 0) ? true : false;
	}
	
	$sqlAltaLu = "	SELECT alta_lu 
					FROM customer 
					WHERE id_tenfold = $nro_tenfold";

	$dbase->Query($sqlAltaLu, 1);

	$asdxd = $dbase->FetchArray(1);

	if (!is_array($asdxd)) {
		$alta_lu = false;
	} else {
		$alta_lu = ($asdxd['alta_lu'] > 0) ? true : false;
	}

	if ($alta_lu) { //si esta dado de alta
		if (!$tiene_otras) { //si no le quedan otras lineas
			//Lo bajo de LU
			//$cgp = get_cgp($nro_tenfold);
			$err = delete_administrador_login($nro_tenfold);
			if ($err) {
				$log->AddLog($err);
				$errorFeo = true;
				$aRespuesta = array("codigo" => "97", "descripcion" => "No se pudo dar de baja del LU [$err]");
			} else {
				$log->AddLog("id_tenfold [$nro_tenfold] - Eliminado de LU", LOG_INFO);
				//update
				$udp = "update customer set alta_lu = 0 where id_tenfold = $nro_tenfold";
				$log->AddLog($udp, LOG_DEBUG);
				
				$result = $dbase->Query($udp, 2);
				
				//$result = true;
				if (!$result) {
					$log->AddLog("1 - No se pudo actualizar el valor de alta_lu en customer - $nro_tenfold", LOG_ERROR);
					$errorFeo = true;
					$aRespuesta = array("codigo" => "96", "descripcion" => "No se pudo actualizar el valor de alta_lu en customer - $nro_tenfold");
				} else {
					$log->AddLog("customer $nro_tenfold updateado correctamente" , LOG_DEBUG);
					$alta_lu = 0;
				}
			}
		}
	}

	if ($errorFeo === false) {
		$fecha_finalizacion = ($estado_subscripcion == 'AC') ? "'0000-00-00 00:00:00'" : "now()";
		$query = "CALL fu_add_data_tenfold($nro_tenfold, '" . addslashes($razon_social) . "', $linea , '$estado_subscripcion', '" . $aProductOffering["$id_product_offering"] . "', 1, 0, $fecha_finalizacion, $codigo_subscripcion, " . (int)$alta_lu . ")";

		$log->AddLog($query, LOG_INFO);
		$okey = $dbase->Query($query, 1);
		if (!$okey) {
			$aRespuesta = array("codigo" => "95", "descripcion" => "Error al dar de baja la linea y/o el cliente en la plataforma");
			$log->AddLog("id_tenfold [$nro_tenfold] - Error al dar de baja la linea y/o el cliente en la plataforma.", LOG_ERROR);
		} else {
			$aRespuesta = array("codigo" => "1", "descripcion" => "Okey");
		}
	}
	
	return ($aRespuesta);

}

set_error_handler("miGestorErrores");

//abro el log de archivo
$log = LogErrorWeekDay::GetLog();

$log->SetPathLog(LOG_LOCATION);

$log->SetStartScriptTime(date("c"));


$server = new SoapServer("detalleiuni.wsdl");

$server->addFunction(array("AddDetalle", "DelDetalle"));

$server->handle();

?>
