<?php

/**
 * Authentication type normal
 * Authenticates by user and password
 */
define('CLL_AUTHENTICATION_TYPE_NORMAL', '1');
/**
 * Authentication type extended
 * Authenticates by user, password and idClient
 */
define('CLL_AUTHENTICATION_TYPE_EXTENDED', '2');

/**
 * Metadata related to an application
 * Private, this metadata can only be modified or readed by the owner application
 */
define('CLL_METADATA_APP', '1');
/**
 * Metadata related to an application and to a client
 * Private, this metadata can only be modified or readed by the owner application
 */
define('CLL_METADATA_APP_CLIENT', '2');
/**
 * Metadata related to an application and to a login
 * Private, this metadata can only be modified or readed by the owner application
 */
define('CLL_METADATA_APP_LOGIN', '3');
/**
 * Metadata related to a client
 * Public, this metadata can be modified or readed by all the applications
 */
define('CLL_METADATA_CLIENT', '4');
/**
 * Metadata related to a login
 * Public, this metadata can be modified or readed by all the applications
 */
define('CLL_METADATA_LOGIN', '5');


# Clone definition for php4
if (version_compare(phpversion(), '5.0') < 0) {
  eval('
    function clone($object) {
      return $object;
    }
  ');
}

/**
 * This class represents a client
 */
class CLL_Client
{
  /**
   * @var string
   * Id (Unified Login)
   */
  var $id;
  
  /**
   * @var string
   * Name
   */
  var $client;
  
  /**
   * @var string
   * Tenfold ID
   */
  var $tenfold_number;
  
  /**
   * @var string
   * CUIT
   */
  var $cuit;
  
  /**
   * @var string
   * The dates when the client was deleted
   */
  var $deleted_at;
  
  /**
   * @var string
   * Personal Gestion Code
   */
  var $cgp;
  
  /**
   * @var string
   * Segment
   */
  var $sub_segment_position;
  
  /**
   * @var string
   * Email
   */
  var $email;
  
  /**
   * Gets the client's ID (Unified Login)
   * @return string Client's id (Unified Login)
   */
  function getId()
  {
    return($this->id);
  }
  
  /**
   * Sets the client's ID (Unified Login)
   * @param string $value The client's ID
   */
  function setId($value)
  {
    $this->id = $value;
  }
  
  /**
   * Gets the client's name
   * @return string Client's name
   */
  function getClient()
  {
    return($this->client);
  }
  
  /**
   * Sets the client's name
   * @param string $value Client's name
   */
  function setClient($value)
  {
    $this->client = $value;
  }
  
  /**
   * Gets the tenfold number
   * @return string Thenfold number
   */
  function getTenfoldNumber()
  {
    return($this->tenfold_number);
  }
  
  /**
   * Sets the tenfold number
   * @param string $value Thenfold number
   */
  function setTenfoldNumber($value)
  {
    $this->tenfold_number = $value;
  }
  
  /**
   * Gets the client's CUIT
   * @return string Client's CUIT
   */
  function getCuit()
  {
    return($this->cuit);
  }
  
  /**
   * Sets the client's CUIT
   * @param string $value Client's CUIT
   */
  function setCuit($value)
  {
    $this->cuit = $value;
  }
  
  /**
   * Gets the date that the client was deleted
   * @return string The date when the client was deleted
   */
  function getDeletedAt()
  {
    return($this->deleted_at);
  }
  
  /**
   * Sets the date when the client was deleted
   * @param string $value The date when the client was deleted
   */
  function setDeletedAt($value)
  {
    $this->deleted_at = $value;
  }
  
  /**
   * Gets the Personal Gestion Code
   * @return string The personal gestion code
   */
  function getCgp()
  {
    return($this->cgp);
  }
  
  /**
   * Sets the personal gestion code
   * @param string $value The personal gestion code
   */
  function setCgp($value)
  {
    $this->cgp = $value;
  }
  
  /**
   * Gets the client's segment
   * @return string The client's segment
   */
  function getSubSegmentPosition()
  {
    return($this->sub_segment_position);
  }
  
  /**
   * Sets the client's segment
   * @param string $value The client's segment
   */
  function setSubSegmentPosition($value)
  {
    $this->sub_segment_position = $value;
  }
  
  /**
   * Gets the client's email
   * @return string The client's email
   */
  function getEmail()
  {
    return($this->email);
  }
  
  /**
   * Sets the client's email
   * @param string $value The client's email
   */
  function setEmail($value)
  {
    $this->email = $value;
  }
}

/**
 * This class represents a user's login
 */
class CLL_Login
{
  /**
   * @var string
   * User's username
   */
  var $username;
  
  /**
   * @var string
   * User's password
   */
  var $password;
   
  /**
   * @var integer
   * Authentication type
   */
  var $authentication_type;
  
  /**
   * @var string
   * Login Id
   */
  var $id;
  
  /**
   * @var string
   * Client Id
   */
  var $client_id;
  
  /**
   * @var string
   * Ultima vez logueado
   */
  var $last_login_on;
  
  /**
   * @var string
   * Creado en...
   */
  var $created_at;
  
  /**
   * @var string
   * Nombre del login
   */
  var $name;
  
  /**
   * @var bool
   * Primer login?
   */
  var $first_login;  
  
  /**
   * @var string
   * cuando fue eliminado el login
   */
  var $deleted_at;
  
  /**
   * @var bool
   * status
   */
  var $status;

  /**
   * string
   */
  var $tenfold_number;
  
  /**
   * string
   */
  var $email;
  
  /**
   * Constructor
   * Sets the authentication type normal by default
   */
  function CLL_Login()
  {
    $this->authentication_type = CLL_AUTHENTICATION_TYPE_NORMAL;
  }
   
  /**
   * Gets the user's username
   * @return string The username
   */
  function getUsername()
  {
    return($this->username);
  }
  
  /**
   * Sets the user's username
   * @param string $value The username
   */
  function setUsername($value)
  {
    $this->username = $value;
  }
  
  /**
   * Gets the user's password
   * @return string The password
   */
  function getPassword()
  {
    return($this->password);
  }
  
  /**
   * Sets the user's password
   * @param string $value The password
   */
  function setPassword($value)
  {
    $this->password = $value;
  }
  
  /**
   * Gets the authentication type
   * @return int Authentication type
   */
  function getAuthenticationType() 
  {
    return($this->authentication_type);
  }
  
  /**
   * Sets the authentication type
   * @param int $value Authentication type
   */
  function setAuthenticationType($value) 
  {
    $this->authentication_type = $value;
  }
  
  
  /**
   * Gets the login id
   * @return string Login id
   */
  function getId()
  {
    return($this->id);
  }
  
  /**
   * Sets the login id
   * @param string $value The login id
   */
  function setId($value)
  {
    $this->id = $value;
  }
  
  /**
   * Gets the client id
   * @return string Client id
   */
  function getClientId()
  {
    return($this->client_id);
  }
  
  /**
   * Sets the client id
   * @param string $value The client id
   */
  function setClientId($value)
  {
    $this->client_id = $value;
  }
  
  /**
   * gets the last day that the client logged in
   * @return string the last day that the client logged in
   */
  function getLastLoginOn()
  {
    return($this->last_login_on);
  }
  
  /**
   * sets the last day that the client logged in
   * @param string $value the last day that the client logged in
   */
  function setLastLoginOn($value)
  {
    $this->last_login_on = $value;
  }
  
  /**
   * gets the time that the login was created
   * @return string the time that the login was created
   */  
  function getCreatedAt()
  {
    return($this->created_at);
  }
  
  /**
   * sets the time that the login was created
   * @param string $value the time that the login was created
   */
  function setCreatedAt($value)
  {
    $this->created_at = $value;
  }
  
  /**
   * gets the name associated to the login
   * @return string the name associated to the login
   */
  function getName()
  {
    return($this->name);
  }
  
  /**
   * sets the name associated to the login
   * @param string $value the name associated to the login
   */
  function setName($value)
  {
    $this->name = $value;
  }
  
  /**
   * is the first time that the client logged in?
   * @return bool is the first time that the client logged in?
   */
  function isFirstLogin()
  {
    return($this->first_login == true);
  }
  
  /**
   * set wether the first time that the client logged in
   * @param bool $value the first time that the client logged in
   */
  function setFirstLogin($value)
  {
    $this->first_login = $value;
  }
  
  /**
   * gets the date when the client was deleted
   * @return date the date when the client was deleted
   */
  function getDeletedAt()
  {
    return($this->deleted_at);
  }
  
  /**
   * sets the date when the client was deleted
   * @param date $value the date when the client was deleted
   */
  function setDeletedAt($value)
  {
    $this->deleted_at = $value;
  }
  
  /**
   * gets the client's status
   * @return string the client's status
   */
  function getStatus()
  {
    return($this->status);
  }
  
  /**
   * sets the client's status
   * @param string $value the client's status
   */
  function setStatus($value)
  {
    $this->status = $value;
  }  

  /**
   * Gets the tenfold id
   * @return string Tenfold id
   */
  function getTenfoldNumber()
  {
    return($this->tenfold_number);
  }

  /**
   * Sets the tenfold id
   * @param string $value The tenfold id
   */
  function setTenfoldNumber($value)
  {
    $this->tenfold_number = $value;
  }
  
  /**
   * Gets the email
   * @return string email
   */
  function getEmail()
  {
  	return($this->email);
  }
  
  /**
   * Sets the email
   * @param string $value The email
   */
  function setEmail($value)
  {
  	$this->email = $value;
  }

}

/**
 * Creates an instance of CLL_Login
 * @param string $username User's username
 * @param string $password User's password
 * @param string $tenfold_number User's client id (default NULL)
 * @param string $login_id Login's id (default NULL)
 * @return CLL_Login The CLL_Login instance
 */
function CLL_NewLogin($username, $password = NULL, $tenfold_number = NULL, $login_id = NULL, $client_id = NULL) 
{
  $login = new CLL_Login();
  $login->setUsername($username);
  $login->setPassword($password);
  $login->setId($login_id);
  $login->setClientId($client_id);
  if ($tenfold_number) 
  {
    $login->setTenfoldNumber($tenfold_number);
    $login->setAuthenticationType(CLL_AUTHENTICATION_TYPE_EXTENDED);
  }
  else 
  {
    $login->setAuthenticationType(CLL_AUTHENTICATION_TYPE_NORMAL);
  }
  return($login);
}

class CLL_WebApplication {
  /**
   * @var string
   * ID
   */
  var $id;
  
  /**
   * @var string
   * Name
   */
  var $name;
  
  /**
   * @var string
   * URL
   */
  var $url;
  
  /**
   * @var string
   * URL to the web service
   */
  var $path_webservice;
  
  /**
   * @var string
   * Public key to encrypt data
   */
  var $public_key;
  
  /**
   * @var string
   * Private key to desencrypt data
   */
  var $private_key;
  
  /**
   * @var string
   * IP
   */
  var $ip;
  
  /**
   * gets the web application id
   * @return string ID
   */
  function getId()
  {
    return($this->id);
  }
  
  /**
   * sets the web application id
   * @param string $value string ID
   */
  function setId($value)
  {
    $this->id = $value;
  }
  
  /**
   * gets the web application name
   * @return string name
   */
  function getName()
  {
    return($this->name);
  }
  
  /**
   * sets the web application name
   * @param string $value name
   */
  function setName($value)
  {
    $this->name = $value;
  }
  
  /**
   * gets the web application url
   * @return string url
   */
  function getUrl()
  {
    return($this->url);
  }
  
  /**
   * sets the web application url
   * @param string $value name
   */
  function setUrl($value)
  {
    $this->url = $value;
  }
  
  /**
   * gets the web application path to the web service authentification
   * @return string web service path
   */
  function getPathWebservice()
  {
    return($this->path_webservice);
  }
  
  /**
   * sets the web application path to the web service authentification
   * @param string $value web service path
   */
  function setPathWebservice($value)
  {
    $this->path_webservice = $value;
  }
  
  /**
   * gets the public key to encrypt data
   * @return string public key to encrypt data
   */
  function getPulicKey()
  {
    return($this->public_key);
  }
  
  /**
   * sets the public key to encrypt data
   * @param string $value public key to encrypt data
   */
  function setPublicKey($value)
  {
    $this->public_key = $value;
  }
  
  /**
   * gets the private key to desencrypt data
   * @return string private key to desencrypt data
   */
  function getPrivateKey()
  {
    return($this->private_key);
  }
  
  /**
   * sets the private key to desencrypt data
   * @param string $value private key to desencrypt data
   */
  function setPrivateKey($value)
  {
    $this->private_key = $value;
  }
  
  /**
   * gest the web application IP
   * @return string IP
   */
  function getIp()
  {
    return($this->ip);
  }
  
  /**
   * sets the web application IP
   * @param string $value web application IP
   */
  function setIp($value)
  {
    $this->ip = $value;
  }
}
/**
 * This class represents the Centralized Login Answer.
 *
 * Basically, there is a variable named server_status, with setServerStatus() and getServerStatus() acceders.
 * This functions says whether the server is up or down.<br/><br/>
 *
 * There is a variable named error, with setError() and getError() acceders.
 * This function says whether there was an error in the request or not.
 * There is a variable named erorr_description, with setErrorDescription() and getErrorDescription() acceders.
 * This function describes the error. <br/><br/>
 *
 * There is a variable named answer, with getAnswer() and setAnswer() acceders.
 * This function asys wheteher the answer was true (exit) or false (failure).
 * There is a variable named answer_description, with setAnswerDescription() and getAnswerDescription() acceders.
 * This function describes the request's answer.
 * 
 * The var $answer, could be a boolean (true or false), an array of values, a class, etc.
 */
class CLL_Answer {
  /**
   * @var bool
   * Answer's status: True or False
   * If true, the server processed the request
   * If false, the server is not responding.
   */
  var $server_status;

  /**
   * @var bool
   * Answer
   */
  var $answer;
  
  /**
   * @var string
   * Answer's description
   */
  var $answer_description;
  
  
  /**
   * @var mixed
   * Metadata
   */
  var $metadata;
  
  /**
   * @var mixed
   * Login asociado a la respuesta
   */
  var $login;
  
  /**
   * @var mixed
   * Cliente asociado a la respuesta
   */
  var $client;
  
  /**
   * @var array
   * Logins asociado a la respuesta
   */
  var $logins;
  
  /**
   * @var array
   * Clientes asociados a la respuesta
   */
  var $clients;
  
  /**
   * @var bool
   * Indicates wheter there was errors or not
   */
  var $error;
  
  /**
   * @var string
   * Describes the error
   */
  var $error_description;
  
  /**
   * @var mixed
   * Web Application
   */
  var $web_application;
  
  /**
   * @var array
   * Web applications
   */
  var $web_applications;
  
  /**
   * Gets the server's status.
   * true: OK, the server answered.
   *
   * false: ERROR, there is not connection with the centralized login.
   *
   * @return bool Answer's status
   */
  function getServerStatus() 
  {
    return($this->server_status);
  }  
  
  /**
   * Sets the server's status.
   * true: OK, the server answered.
   * 
   * false: ERROR, there is not connection with the centralized login.
   *
   * @param bool $status The answer's status.
   */
  function setServerStatus($value) 
  {
    $this->server_status = $value;
  }
  
  /**
   * Gets the answer
   * @return bool The answer.
   */
  function getAnswer() 
  {
    return($this->answer);
  }
  
  /**
   * Sets the answer
   * @param bool $vale The answer.
   */
  function setAnswer($value) 
  {
    $this->answer = $value;
  }
  
  /**
   * Gets the answer's description.
   * @return string The answer's description
   */
  function getAnswerDescription() 
  {
    return($this->answer_description);
  }
  
  /**
   * Sets the answer's description.
   * @param string $value Answer's description.
   */
  function setAnswerDescription($value) 
  {
    $this->answer_description = $value;
  }
  
  /**
   * Gets the metadata associated with the answer
   * @return mixed Metadata
   */
  function getMetadata()
  {
    return($this->metadata);
  }
  
  /**
   * Sets the metadata associated with the answer
   * @param mixed $value Metadata
   */
  function setMetadata($value)
  {
    $this->metadata = $value;
  }
  
  /**
   * Gets the login associated to the answer
   * @return mixed Login
   */
  function getLogin()
  {
    return($this->login);
  }
  
  /**
   * Sets the login associated to the answer
   * @param mixed $value Login
   */
  function setLogin($value)
  {
    $this->login = $value;
  }
  
  /**
   * Gets the client associated to the answer
   * @return mixed Client
   */
  function getClient()
  {
    return($this->client);
  }
  
  /**
   * Sets the logins associated to the answer
   * @param array $value Logins
   */
  function setLogins($value)
  {
    $this->logins = $value;
  }
  
  /**
   * Gets the logins associated to the answer
   * @return array Logins
   */
  function getLogins()
  {
    return($this->logins);
  }
  
  /**
   * Sets the clients associated to the answer
   * @param array $value Clients
   */
  function setClients($value)
  {
    $this->clients = $value;
  }
  
  /**
   * Gets the clients assocated to the answer
   * @return array Clients
   */
  function getClients()
  {
    return($this->clients);
  }
  
  /**
   * Sets the client associated to the answer
   * @param mixed $value Client
   */
  function setClient($value)
  {
    $this->client = $value;
  } 
  
  /**
   * Gets whether there was an error or not
   * @return bool Whether there was an error or not
   */
  function getError() 
  {
    return($this->error);
  }
  
  /**
   * Sets whether there was an error or not
   * @param bool $vale The error
   */
  function setError($value) 
  {
    $this->error = $value;
  }
  
  /**
   * Gets the error description
   * @return string The error description
   */
  function getErrorDescription() 
  {
    return($this->error_description);
  }
  
  /**
   * Sets the error description
   * @param string $value The error description
   */
  function setErrorDescription($value) 
  {
    $this->error_description = $value;
  }

  /**
   * gets the web applications associated to the answer
   * @return array web applications
   */
  function getWebApplications()
  {
    return($this->web_applications);
  }
  
  /** 
   * sets the web applications associated to the answer
   * @param array $value web applications
   */
  function setWebApplications($value)
  {
    $this->web_applications = $value;
  }
}

/**
 * This class represents a metadata.
 */
class CLL_Metadata {
  /**
   * @var string
   * Metadata's name
   */
  var $name;
  
  /**
   * @var int
   * Metadata's type
   */
  var $metadata_type;
  
  /**
   * @var string
   * Metadata's value
   */
  var $value;
  
  /**
   * @var string
   * Webapplication's id value
   */
  var $webapplication_id;
  
  /**
   * @var string
   * Tenfold number
   */
  var $tenfold_number;
  
  /**
   * @var string
   * Login's username
   */
  var $username;

  /**
   * @var string
   * Login's ID
   */
  var $login_id; 
 
  /** 
   * @var string
   * Client's ID
   */
  var $client_id;
  
  /**
   * @var bool
   * Error flag
   */
  var $error;
  
  /**
   * @var string
   * Error description
   */
  var $error_description;
  
  /**
   * Sets the metadata name
   * @param string $value The key
   */
  function setName($value)
  {
    $this->name = $value;
  }

  /**
   * Gets the metadata key
   * @return string The key
   */
  function getName()
  {
    return($this->name);
  }
  
  /**
   * Sets the metadata type
   * @param int $value The Type
   */
  function setMetadataType($value)
  {
    $this->metadata_type = $value;
  }
  
  /**
   * Gets the metadata type
   * @return int The metadata type
   */
  function getMetadataType()
  {
    return($this->metadata_type);
  }
  
  /**
   * Sets the metadata value
   * @param string $value The Value
   */
  function setValue($value)
  {
    $this->value = $value;
  }
  
  /**
   * Gets the metadata value
   * @return string The Value
   */
  function getValue()
  {
    return($this->value);
  }
  
  /**
   * Sets the id web application
   * @param string $value The id web application
   */
  function setWebapplicationId($value)
  {
    $this->webapplication_id = $value;
  }
  
  /**
   * Gets the id web application
   * @return string The id web application
   */
  function getWebapplicationId()
  {
    return($this->webapplication_id);
  }
  
  /**
   * Geths the tenfold id
   * @return string Tenfold id
   */
  function getTenfoldNumber()
  {
    return($this->tenfold_number);
  }
  
  /**
   * Sets the tenfold id
   * @param string $value The tenfold id
   */
  function setTenfoldNumber($value)
  {
    $this->tenfold_number = $value;
  }
   
  /**
   * Sets the username
   * @param string $value The username
   */
  function setUsername($value)
  {
    $this->username = $value;
  }
  
  /**
   * Gets the username
   * @return The username
   */
  function getUsername()
  {
    return($this->username);
  }
  
  /**
   * Sets the login id
   * @param string $value The login id
   */
  function setId($value)
  {
    $this->id = $value;
  }
  
  /**
   * Gets the login id
   * @return string login id
   */
  function getId()
  {
    return($this->id);
  }

  /**
   * Sets the id login
   * @param string $value The id login
   */
  function setLoginId($value)
  {
    $this->login_id = $value;
  }

  /**
   * Gets the id client
   * @return string The id client
   */
  function getLoginId()
  {
    return($this->login_id);
  }
  
  /**
   * Sets the id client
   * @param string $value The id client
   */
  function setClientId($value)
  {
    $this->client_id = $value;
  }
  
  /**
   * Gets the id client
   * @return string The id client
   */
  function getClientId()
  {
    return($this->client_id);
  }
  
  /**
   * Gets whether there was an error or not
   * @return bool Whether there was an error or not
   */
  function getError() 
  {
    return($this->error);
  }
  
  /**
   * Sets whether there was an error or not
   * @param bool $vale The error
   */
  function setError($value) 
  {
    $this->error = $value;
  }
  
  /**
   * Gets the error description
   * @return string The error description
   */
  function getErrorDescription() 
  {
    return($this->error_description);
  }
  
  /**
   * Sets the error description
   * @param string $value The error description
   */
  function setErrorDescription($value) 
  {
    $this->error_description = $value;
  }
  
  /**
   * gets the web application associated to the answer
   * @return mixed web application
   */
  function getWebApplication()
  {
    return($this->web_application);
  }
  
  /**
   * sets the web application associated to the answer
   * @param mixed $value the web application
   */
  function setWebApplication($value)
  {
    $this->web_application = $value;
  }

  function __toString() {
    return("CLL_Metadata Object");
  }
  
}

/**
 * It justs creates a metadata instance, the web application ID is setted by the library automatically. <br/>
 * If you're creating a CLL_METADATA_APP you don't have to set anything at all. <br/>
 * If you're creating a CLL_METADATA_APP_CLIENT, you have to set the client id, or the client's tenfold number. <br/>
 * If you're creating a CLL_METADATA_APP_LOGIN, you have to set the login id, or the username. <br/>
 * If you're creating a CLL_METADATA_CLIENT, you have to set the client id, or the tenfold number. <br/>
 * If you're creating a CLL_METADATA_LOGIN, you have to set the login id, or the username. <br/>
 *
 * @param string $name The metadata's key
 * @param int $metadata_type The metadata's type
 * @param string $value The metadata's value
 * @param string $tenfold_number The tenfold id
 * @param string $username The client's login username
 * @param string $login_id The login's id
 * @param string $client_id The client's id
 * @return CLL_Metadata
 */ 
function CLL_NewMetadata($name, $metadata_type, $value = null, $tenfold_number = null, $username = null, $login_id = null, $client_id = null)
{
  $metadata = new CLL_Metadata();
  $metadata->setWebapplicationId(CLL_WEB_APPLICATION_ID);
  $metadata->setName($name);
  $metadata->setMetadataType($metadata_type);
  $metadata->setValue($value);
  $metadata->setTenfoldNumber($tenfold_number);
  $metadata->setUsername($username);
  $metadata->setLoginId($login_id);
  $metadata->setClientId($client_id);
  return($metadata);
}





/*-----------------------------------------------------------------------------------------------------------------*/


/**
 * Static variable to hold the SOAP Connection
 */
static $CLL_SOAP_Client;

/**
 * Initiates the connection with the web service
 * @return SOAP Connection
 */
function CLL_Initiate_SOAP_Connection($proxyhost = null, $proxyport = null, $proxyusername = null, $proxypassword = null) {
  global $CLL_SOAP_Client;
  
  if ($CLL_SOAP_Client == NULL)
    $CLL_SOAP_Client = new mysoapclient(CLL_SOAP_SERVICE,
                                        true,
                                        $proxyhost,
                                        $proxyport,
                                        $proxyusername,
                                        $proxypassword);
	return($CLL_SOAP_Client);
}

/**
 * Converts the result in a CLL_Answer
 * @return CLL_Answer
 */
function CLL_Get_Answer($data) {
  //Rta
  $answer = new CLL_Answer();

  if ($data) {
    //Login
    if (count($data["login"]) > 0) {
      $cll_login = $data["login"];
      $login = new CLL_Login();
      $login->setAuthenticationType(CLL_DecryptValue($cll_login["authentication_type"]));
      $login->setId(CLL_DecryptValue($cll_login["id"]));
      $login->setClientId(CLL_DecryptValue($cll_login["client_id"]));
      $login->setUsername(CLL_DecryptValue($cll_login["username"]));
      $login->setPassword(CLL_DecryptValue($cll_login["password"]));
      $login->setLastLoginOn(CLL_DecryptValue($cll_login["last_login_on"]));
      $login->setCreatedAt(CLL_DecryptValue($cll_login["created_at"]));
      $login->setDeletedAt(CLL_DecryptValue($cll_login["deleted_at"]));
      $login->setStatus(CLL_DecryptValue($cll_login["status"]));
      $login->setName(CLL_DecryptValue($cll_login["name"]));
      $login->setEmail(CLL_DecryptValue($cll_login["email"]));
      if ($cll_login["first_login"] == "1")
        $login->setFirstLogin(true);
      else
        $login->setFirstLogin(false);
    }
      
    //Cliente
    if (count($data["client"]) > 0) {
      $cll_client = $data["client"];
      $client = new CLL_Client();
      $client->setId(CLL_DecryptValue($cll_client["id"]));
      $client->setClient(CLL_DecryptValue($cll_client["client"]));
      $client->setTenfoldNumber(CLL_DecryptValue($cll_client["tenfold_number"]));
      $client->setCuit(CLL_DecryptValue($cll_client["cuit"]));
      $client->setDeletedAt(CLL_DecryptValue($cll_client["deleted_at"]));
      $client->setCgp(CLL_DecryptValue($cll_client["cgp"]));
      $client->setSubSegmentPosition(CLL_DecryptValue($cll_client["sub_segment_position"]));
    }
    
    //Logins
    if (count($data["logins"]) > 0) {
      $logins = array();
      for ($i = 0; $i < count($data["logins"]); $i++) {
        $cll_login = $data["logins"][$i];
        $login = new CLL_Login();
        $login->setAuthenticationType(CLL_DecryptValue($cll_login["authentication_type"]));
        $login->setId(CLL_DecryptValue($cll_login["id"]));
        $login->setClientId(CLL_DecryptValue($cll_login["client_id"]));
        $login->setUsername(CLL_DecryptValue($cll_login["username"]));
        $login->setPassword(CLL_DecryptValue($cll_login["password"]));
        $login->setLastLoginOn(CLL_DecryptValue($cll_login["last_login_on"]));
        $login->setCreatedAt(CLL_DecryptValue($cll_login["created_at"]));
        $login->setDeletedAt(CLL_DecryptValue($cll_login["deleted_at"]));
        $login->setStatus(CLL_DecryptValue($cll_login["status"]));
        $login->setName(CLL_DecryptValue($cll_login["name"]));
        $login->setEmail(CLL_DecryptValue($cll_login["email"]));
        if ($cll_login["first_login"] == "1")
          $login->setFirstLogin(true);
        else
          $login->setFirstLogin(false);
        
        $logins[] = $login;
      }
      unset($login);
    }
    
    //Clientes
    if (count($data["clients"]) > 0) {
      $clients = array();
      for ($i = 0; $i < count($data["clients"]); $i++) {
        $cll_client = $data["client"];
        $client = new CLL_Client();
        $client->setId(CLL_DecryptValue($cll_client["id"]));
        $client->setClient(CLL_DecryptValue($cll_client["client"]));
        $client->setTenfoldNumber(CLL_DecryptValue($cll_client["tenfold_number"]));
        $client->setCuit(CLL_DecryptValue($cll_client["cuit"]));
        $client->setDeletedAt(CLL_DecryptValue($cll_client["deleted_at"]));
        $client->setCgp(CLL_DecryptValue($cll_client["cgp"]));
        $client->setSubSegmentPosition(CLL_DecryptValue($cll_client["sub_segment_position"]));
        $cllent->setEmail(CLL_DecryptValue($cll_client["email"]));
        
        $clients[] = $client;
      }
      unset($client);
    }
    
    //Estructura de la metadata
    if (count($data["metadata"]) > 0) {
      $metadatos = $data["metadata"];
      $metadata = array();
      for ($i = 0; $i < count($metadatos); $i++) {
        $item = $metadatos[$i];
        $metadato = new CLL_Metadata();
        $metadato->setValue(CLL_DecryptValue($item["value"]));
        $metadato->setTenfoldNumber(CLL_DecryptValue($item["tenfold_number"]));
        $metadato->setUsername(CLL_DecryptValue($item["username"]));
        $metadato->setClientId(CLL_DecryptValue($item["client_id"]));
        $metadato->setWebapplicationId(CLL_DecryptValue($item["webapplication_id"]));
        $metadato->setName(CLL_DecryptValue($item["name"]));
        $metadato->setLoginId(CLL_DecryptValue($item["login_id"]));
        $metadato->setMetadataType(CLL_DecryptValue($item["metadata_type"]));
        if ($item["error"] == "1")
          $metadato->setError(true);
        else
          $metadato->setError(false);
        $metadato->setErrorDescription(CLL_DecryptValue($item["error_description"]));
        
        $metadata[$metadato->getMetadataType()][$metadato->getName()] = $metadato;
      }
    }
    
    //Web application
    if (count($data["web_application"]) > 0) {
      $cll_webapplication = $data["web_application"];
      $web_application = new CLL_WebApplication();
      $web_application->setId(CLL_DecryptValue($cll_webapplication["id"]));
      $web_application->setName(CLL_DecryptValue($cll_webapplication["name"]));
      $web_application->setUrl(CLL_DecryptValue($cll_webapplication["url"]));
      $web_application->setPathWebservice(CLL_DecryptValue($cll_webapplication["path_webservice"]));
      $web_application->setPublicKey(CLL_DecryptValue($cll_webapplication["public_key"]));
      $web_application->setPrivateKey(CLL_DecryptValue($cll_webapplication["private_key"]));
      $web_application->setIp(CLL_DecryptValue($cll_webapplication["ip"]));
    }
    
    //Web applications
    if (count($data["web_applications"]) > 0) {
      $web_applications = array();
      for ($i = 0; $i < count($data["web_applications"]); $i++) {
        $cll_webapplication = $data["web_applications"][$i];
        $web_application = new CLL_WebApplication();
        $web_application->setId(CLL_DecryptValue($cll_webapplication["id"]));
        $web_application->setName(CLL_DecryptValue($cll_webapplication["name"]));
        $web_application->setUrl(CLL_DecryptValue($cll_webapplication["url"]));
        $web_application->setPathWebservice(CLL_DecryptValue($cll_webapplication["path_webservice"]));
        $web_application->setPublicKey(CLL_DecryptValue($cll_webapplication["public_key"]));
        $web_application->setPrivateKey(CLL_DecryptValue($cll_webapplication["private_key"]));
        $web_application->setIp(CLL_DecryptValue($cll_webapplication["ip"]));
        $web_applications[] = $web_application;
      }
      unset($web_application);
    }


    
    //Estructura de la respuesta
    if ($data["server_status"] == "1")
      $answer->setServerStatus(true);
    else
      $answer->setServerStatus(false);
    if ($data["answer"] == "1")
      $answer->setAnswer(true);
    else
      $answer->setAnswer(false);
    $answer->setAnswerDescription(CLL_DecryptValue($data["answer_description"]));
    if (isset($login))
      $answer->setLogin($login);
    if (isset($client))
      $answer->setClient($client);
    if (isset($logins))
      $answer->setLogins($logins);
    if (isset($clients))
      $answer->setClients($clients);
    if (isset($metadata))
      $answer->setMetadata($metadata);
    if (isset($web_application))
      $answer->setWebApplication($web_application);
    if (isset($web_applications))
      $answer->setWebApplications($web_applications);
    if ($data["error"] == "1")
      $answer->setError(true);
    else
      $answer->setError(false);
    if (isset($data["error_description"]))
      $answer->setErrorDescription(CLL_DecryptValue($data["error_description"]));
  }
  else
  {
    $answer->setServerStatus(false);
    $answer->setAnswerDescription("Can't connect to the unified login server");
  }
  
  //Devolver la respuesta
  return($answer);
}

function CLL_GetLoginFromRequest()
{
  global $_POST, $_GET;

  isset($_POST["username"]) ? $username = $_POST["username"] : $username = NULL;
  if (isset($_GET["username"]) && (strlen($username) <= 0)) $username = $_GET["username"];
  isset($_POST["password"]) ? $password = $_POST["password"] : $password = NULL;
  if (isset($_GET["password"]) && (strlen($password) <= 0)) $password = $_GET["password"];
  isset($_POST["tenfold_id"]) ? $tenfold_id = $_POST["tenfold_id"] : $tenfold_id = NULL;
  if (isset($_GET["tenfold_id"]) && (strlen($tenfold_id) <= 0)) $tenfold_id = $_GET["tenfold_id"];
  if (strlen(trim($tenfold_id)) > 0)
    $login = CLL_NewLogin(CLL_DecryptValue($username), CLL_DecryptValue($password), CLL_DecryptValue($tenfold_id));
  else
    $login = CLL_NewLogin(CLL_DecryptValue($username), CLL_DecryptValue($password));
  
  return($login);
}

function CLL_EncryptCLLMetadatas($metadatas)
{
  if ($metadatas == NULL) return NULL;
  if (count($metadatas) == 0) return $metadatas;
  for ($i = 0; $i < count($metadatas); $i++)
  {
    $metadatas[$i] = CLL_EncryptMetadata($metadatas[$i]);
  }
  return($metadatas);
}

function CLL_EncryptMetadata($metadata)
{
  if ($metadata == NULL) return NULL;
  $metadata->name = CLL_EncryptValue($metadata->name);
  $metadata->metadata_type = CLL_EncryptValue($metadata->metadata_type);
  $metadata->value = CLL_EncryptValue($metadata->value);
  $metadata->webapplication_id = CLL_EncryptValue($metadata->webapplication_id);
  $metadata->tenfold_number = CLL_EncryptValue($metadata->tenfold_number);
  $metadata->username = CLL_EncryptValue($metadata->username);
  $metadata->login_id = CLL_EncryptValue($metadata->login_id);
  $metadata->client_id = CLL_EncryptValue($metadata->client_id);
  $metadata->error_description = CLL_EncryptValue($metadata->error_description);
  return($metadata);  
}

function CLL_EncryptCLLLogin($login)
{
  if ($login == NULL) return NULL;
  $login->username = CLL_EncryptValue($login->username);
  $login->password = CLL_EncryptValue($login->password);
  $login->id = CLL_EncryptValue($login->id);
  $login->client_id = CLL_EncryptValue($login->client_id);
  $login->last_login_on = CLL_EncryptValue($login->last_login_on);
  $login->created_at = CLL_EncryptValue($login->created_at);
  $login->name = CLL_EncryptValue($login->name);
  $login->first_login = CLL_EncryptValue($login->first_login);
  $login->deleted_at = CLL_EncryptValue($login->deleted_at);
  $login->status = CLL_EncryptValue($login->status);
  $login->tenfold_number = CLL_EncryptValue($login->tenfold_number);
  $login->email = CLL_EncryptValue($login->email);
  return($login);
}


function CLL_DecryptValue($value)
{
  if ($value == NULL) return NULL;
  if ($value == "") return("");
  if (!is_string($value)) $value = (string)$value;

  $value = base64_decode($value);
  
  $td = mcrypt_module_open(MCRYPT_ARCFOUR, '', MCRYPT_MODE_STREAM, '');
  mcrypt_generic_init($td, CLL_PUBLIC_KEY, NULL);
  $result = mdecrypt_generic($td, $value);
  mcrypt_generic_deinit($td);
  mcrypt_module_close($td);
  
  return($result);
}

function CLL_EncryptArray($array)
{
  if ($array == NULL) return(NULL);
  if (!is_array($array)) return($array);
  if (count($array) == 0) return($array);
  for ($i = 0; $i < count($array); $i++)
  {
    $array[$i] = CLL_EncryptValue($array[$i]);
  }
  return $array;
}

function CLL_EncryptValue($value)
{
  if ($value == NULL) return NULL;
  if ($value == "") return("");

  $td = mcrypt_module_open(MCRYPT_ARCFOUR, '', MCRYPT_MODE_STREAM, '');
  mcrypt_generic_init($td, CLL_PUBLIC_KEY, NULL);
  $result = mcrypt_generic($td, $value);
  mcrypt_generic_deinit($td);
  mcrypt_module_close($td);
  
  return(base64_encode($result));
}


?>
