<?php

/* CONSTANTES DE BASES DE DATOS */
define("MS_SQL", 1);
define("MY_SQL", 2);
define("PG_SQL", 3);
define("ORACLE", 4);
define("MY_SQLi", 5);

define("ARCHIVO_LOG_ERROR", "log_error.txt");

class BaseDatos {
  	
	static function NuevaConeccion($idTipoBase, $cServidor, $cDatabase, $cUsuario, $cPassword) {
		switch ($idTipoBase) {
			case MS_SQL:
				/*$bHay = false;
				if ((isset($_SESSION['rBaseMS_SQL'])) && (is_array($_SESSION['rBaseMS_SQL'])) && (count($_SESSION['rBaseMS_SQL'] > 0)) && (!$bHay)) {
					foreach ($_SESSION['rBaseMS_SQL'] AS $rDatos) {
						if (($cServidor == $rDatos->cServidor) && ($cDatabase == $rDatos->cDatabase)) {
							$frutafruta = $rDatos;
							$bHay = true;
						}
					}
					if (!$bHay) {
						$frutafruta = new BaseDatosMS_SQL($cServidor, $cDatabase, $cUsuario, $cPassword);
						$_SESSION['rBaseMS_SQL'][] = $frutafruta;
						echo "$cDatabase";
					}
					
				}
				if (!$bHay) {
					$frutafruta = new BaseDatosMS_SQL($cServidor, $cDatabase, $cUsuario, $cPassword);
					$_SESSION['rBaseMS_SQL'][] = $frutafruta;
				}
				*/
				$frutafruta = new BaseDatosMS_SQL($cServidor, $cDatabase, $cUsuario, $cPassword);
				break;
			case MY_SQL:
				/*
				if (isset($_SESSION['rBaseMY_SQL']) && ($cServidor == $_SESSION['rBaseMY_SQL']->cServidor) && ($cDatabase == $_SESSION['rBaseMY_SQL']->cDatabase) && ($_SESSION['rBaseMY_SQL']->EstadoConeccion())) {
						$frutafruta = $_SESSION['rBaseMY_SQL'];
				} else {
					$frutafruta = new BaseDatosMySQL($cServidor, $cDatabase, $cUsuario, $cPassword);
					$_SESSION['rBaseMY_SQL'] = $frutafruta;
				}
				*/
				$frutafruta = new BaseDatosMySQL($cServidor, $cDatabase, $cUsuario, $cPassword);
				break;
			case MY_SQLi:
				$frutafruta = new BaseDatosMySQLi($cServidor, $cDatabase, $cUsuario, $cPassword);
				break;
			case ORACLE:
				$frutafruta = new BaseDatosOracle($cServidor, $cDatabase, $cUsuario, $cPassword);
				break;
			default:
				break;
		}
		return $frutafruta;
	}
}

abstract Class BaseDatosTemplate {

	public $rBase;
	public $cServidor = "";
	public $cDatabase = "";
	public $cUsuario = "";
	public $cPassword = "";
	public $rQuery;
	public $bEstadoConeccion = false;
	
	
	abstract function Conectar($cServidor, $cDatabase, $cUsuario, $cPassword);

	abstract function Query($cSql, $cIdQuery);
	
	abstract function CambiarDatabase($cDatabase);
	
	abstract function FetchArray($cIdQuery);
	
	abstract function NextResultset($cIdQuery);
	
	abstract function FreeResultset($cIdQuery);
		
	abstract function Desconectar();
	
	abstract function EstadoConeccion();
	
	abstract function EscribirArchivo($cFile, $cTabla, $cCampo, $nPrimary, $ncModoCompresion = 1, $nBuffSize = 204800);
	
	abstract function LeerArchivo($cFile, $cTabla, $cCampo, $nPrimary, $nBuffSize = 204800);

	abstract function LimpiarArchivo($cTabla, $cCampo, $nPrimary);
	
	abstract function QueryXMLListado($cIdQuery, $aAtributos = array(), $aOcultos = array(), $cEncoding = "");
	
	abstract function QuerySelect($cIdQuery);
	
}

class BaseDatosMS_SQL extends BaseDatosTemplate {
  	
  	public function __construct($cServidor, $cDatabase, $cUsuario, $cPassword) {
		$this->Conectar($cServidor, $cDatabase, $cUsuario, $cPassword);
	}
	
	public function Conectar($cServidor, $cDatabase, $cUsuario, $cPassword) {
	  	$bOk = false;
		$this->rBase = mssql_connect($cServidor, $cUsuario, $cPassword);
		if ($this->rBase === false) {
		  	SRM_Servicios::agregarError("Error conectando al servidor [" . $cServidor . "]");
		} else {
		  	$bOk = $this->CambiarDatabase($cDatabase);
		  	if ($bOk) {
				$this->cServidor = $cServidor;
				$this->cUsuario = $cUsuario;
				$this->cPassword = $cPassword;
				$this->cDatabase = $cDatabase;
				$this->bEstadoConeccion = true;
			}
		}
		return $bOk;
	}
	
	public function CambiarDatabase($cDatabase) {
		$bOk = mssql_select_db($cDatabase, $this->rBase);
		if ($bOk === false) {
			SRM_Servicios::agregarError("No se puedo conectar a la base de datos [" . $cDatabase . "]");
		}
		return $bOk;
	}
	
	public function Query($cSql, $cIdQuery) {
	  	/*if (isset($_SESSION['rQuery'][$cIdQuery])) {
		$this->rQuery[$cIdQuery] = $_SESSION['rQuery'][$cIdQuery];
		/* si existe mmover el puntero al inicio.
		mssql_data_seek(0);
		} else {
		*/
		$this->rQuery[$cIdQuery] = mssql_query($cSql, $this->rBase);
		
		if ($this->rQuery[$cIdQuery] === false) {
			SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
		}
		/*}*/
		return (!($this->rQuery[$cIdQuery] === false));
	}
	
	
	public function FetchArray($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
			$aFila = mssql_fetch_assoc($this->rQuery[$cIdQuery]);
			return $aFila;
		} else {
			return false;
		}
	}

	public function NextResultset($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
			$bHayProximo = mssql_next_result($this->rQuery[$cIdQuery]);
			if ($bHayProximo === false)
				mssql_free_result($this->rBase);
		} else {
			return false;
		}
	}


	public function FreeResultset($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
		  	mssql_free_result($this->rQuery[$cIdQuery]);
		  	/*unset($_SESSION['rQuery']);*/
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	
	/*
	public function FreeTempResultsets() {
	  	foreach($_SESSION['rQuery'] AS $nQuerys) {
	  		
	 		unset($_SESSION['rQuery']);
	  	}
		if (!($this->rQuery[$cIdQuery] === false)) {
		  	mssql_free_result($this->rQuery[$cIdQuery]);
		  	
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	*/
	
	public function Desconectar() {
		$bRes = mssql_close($this->rBase);
		if ($bRes) {
			$this->cServidor = "";
			$this->cUsuario = "";
			$this->cPassword = "";
			$this->cDatabase = "";
			$this->bEstadoConeccion = false;
		}
		return $bRes;
	}
	
	public function EstadoConeccion() {
		return $this->bEstadoConeccion;
	}
	
	public function EscribirArchivo($cFile, $cTabla, $cCampo, $nPrimary, $ncModoCompresion = 1, $nBuffSize = 204800) {
		//COMPRESION:
		if (file_exists($cFile)) {
			switch ($ncModoCompresion) {
			  	case 1:
			  		$oArchivo = fopen($cFile, "r+");
			  		$cFileSize = filesize($cFile);
	  				$cMd5 = md5_file($cFile);
					$cSha1 = sha1_file($cFile);
			  		break;
				case 2:
					$cFileZip = $cFile . ".tmp";
					$xd = shell_exec("/usr/bin/zip -j '$cFileZip' '$cFile'");
					$cFileSize = filesize($cFile);
					$cMd5 = md5_file($cFileZip);
					$cSha1 = sha1_file($cFileZip);
					$oArchivo = fopen($cFileZip, "r+");
					break;
			}
			
			$cBaseName = basename($cFile);
			
			$mime = trim(shell_exec("file --mime --brief '$cFile'"));
			$cSqlxd = "SELECT ncTipoContenidoMime FROM dtTipoContenidoMime WHERE cdTipoContenidoMime = '$mime'";
			$this->Query($cSqlxd, 343);
			$aTipoContenidoMime = $this->FetchArray(343);
			$ncTipoContenidoMime = $aTipoContenidoMime['ncTipoContenidoMime'];
			$this->FreeResultset(343);
			
			if (!($ncTipoContenidoMime)) {
				$cSqlxd = 	"DECLARE @ncTipoContenidoMime INT
							SELECT @ncTipoContenidoMime = ISNULL(MAX(ncTipoContenidoMime), 0) + 1 FROM dtTipoContenidoMime
							INSERT INTO dtTipoContenidoMime (ncTipoContenidoMime, cdTipoContenidoMime) VALUES (@ncTipoContenidoMime, '$mime')
							SELECT @ncTipoContenidoMime AS ncTipoContenidoMime";
				$this->Query($cSqlxd, 343);
				$aTipoContenidoMime = $this->FetchArray(343);
				$ncTipoContenidoMime = $aTipoContenidoMime['ncTipoContenidoMime'];
				$this->FreeResultset(343);
			}
			
			//INFORMACION DEL ARCHIVO
			$cSql = "UPDATE $cTabla
					SET cNombreArchivo = '$cBaseName',
						sha1 = '$cSha1',
						md5 = '$cMd5',
						tamano = $cFileSize,
						ncModoCompresion = $ncModoCompresion,
						ncTipoContenidoMime = $ncTipoContenidoMime
					WHERE $cCampo = $nPrimary";
					
			$this->Query($cSql, 74);
	
			$cSql = "	SELECT ISNULL(DATALENGTH(bDatos), 0) AS nSubido
						FROM $cTabla
						WHERE $cCampo = $nPrimary";
						
			$this->Query($cSql, 1);
			
			$aSubido = $this->FetchArray(1);
			$this->FreeResultset(1);
			
			$nTotalQueda = $cFileSize - $aSubido['nSubido'];
			
			fseek($oArchivo, $aSubido['nSubido'], SEEK_SET);
			$nPasada = 0;
			while ($nTotalQueda > 0) {
			  	if ($nBuffSize < $nTotalQueda) {
			  		$bBuffer = fread($oArchivo, $nBuffSize);
					$nTotalQueda -= $nBuffSize;
				} else {
					$bBuffer = fread($oArchivo, $nTotalQueda);
					$nTotalQueda = 0;
				}
				$hString = bin2hex($bBuffer);
				$cSql = "	DECLARE @ptrval binary(16)
							DECLARE @largo int
							SELECT @ptrval = TEXTPTR(bDatos), @largo = DATALENGTH(bDatos)
							FROM $cTabla
							WHERE $cCampo = $nPrimary
							UPDATETEXT $cTabla.bDatos @ptrval @largo 0 0x" . $hString;
				
				$oRscFiles = $this->Query($cSql, 2);
			  	$nPasada++;
	
			}
			fclose($oArchivo);
			
			switch ($ncModoCompresion) {
			  	case 1:
			  		break;
				case 2:
					unlink($cFileZip);
					break;
			}
			$bOk = true;
		} else {
			//no existe el archivo (?)
			$bOk = false;
		}
		return $bOk;
	}
	
	function LeerArchivo($cFile, $cTabla, $cCampo, $nPrimary, $nBuffSize = 204800) {

	  	$cSql = "SELECT ISNULL(DATALENGTH(bDatos), 0) AS Dato, ncModoCompresion FROM $cTabla WHERE $cCampo = $nPrimary";
		$this->Query($cSql, 1);
		$asd = $this->FetchArray(1);
		$nLargo = $asd['Dato'];
		$ncModoCompresion  = $asd['ncModoCompresion'];

		switch ($ncModoCompresion) {
			case 1:
				$oArchivo = fopen($cFile, "w");
				break;
			case 2:
				$oArchivo = fopen($cFile . ".tmp", "w");
				break;
		}
		
		$nTotalQueda = $nLargo;
		
		$nPasada = 0;
		while ($nTotalQueda > 0) {
		  	if ($nBuffSize < $nTotalQueda) {
		  		$nCantidadLeer = $nBuffSize;
				$nTotalQueda -= $nBuffSize;
			} else {
				$nCantidadLeer = $nTotalQueda;
				$nTotalQueda = 0;
			}
			
			$nPosicionLeer = ($nPasada * $nBuffSize);

			$cSql = "	DECLARE @ptrval binary(16)
						SELECT @ptrval = TEXTPTR(bDatos)
						FROM $cTabla
						WHERE $cCampo = $nPrimary
						IF  NOT (@ptrval IS null)
						READTEXT $cTabla.bDatos @ptrval $nPosicionLeer $nCantidadLeer";
			
			$this->Query($cSql, 1);
			$aRes = $this->FetchArray(1);
			fwrite($oArchivo, $aRes["bDatos"]);
			$this->FreeResultset(1);
			$nPasada++;
		}
		fclose($oArchivo);
		
		switch ($ncModoCompresion) {
				case 1:
					break;
				case 2:
					shell_exec("/usr/bin/unzip '$cFile.tmp'");
					unlink("$cFile.tmp");
					break;
		}
	}

	function LimpiarArchivo($cTabla, $cCampo, $nPrimary) {
		$cSql = "	DECLARE @ptrval binary(16)
					DECLARE @largo int
					SELECT @ptrval = TEXTPTR(bDatos), @largo = ISNULL(DATALENGTH(bDatos), 0)
					FROM $cTabla
					WHERE $cCampo = $nPrimary
					IF  NOT (@ptrval IS null)
					UPDATETEXT $cTabla.bDatos @ptrval 0 @largo
					ELSE
					UPDATE $cTabla SET bDatos = 0x0 WHERE $cCampo = $nPrimary";
		
		$this->Query($cSql, 1);
	}
	
	function QueryXMLListado($cIdQuery, $aAtributos = array(), $aOcultos = array(), $cEncoding = "") {
		
		$doc = new DOMDocument('1.0', $cEncoding);

		$aXD = $this->FetchArray($cIdQuery);
		
		if (is_array($aXD)) {
		  	$listado = $doc->createElement('listado');
		  	
			while($aXD) {
				$filas = $doc->createElement('filas');
				foreach($aXD AS $cClave => $cValor) {
				  	if (array_search($cClave, $aOcultos) === false) {
						$dato = $doc->createElement('dato', $cValor);
						$filas->appendChild($dato);
					}
				}
				if (is_array($aAtributos) && (count($aAtributos) > 0)) {
				  	foreach($aAtributos AS $cNombreAtributo) {
						$atributo = $doc->createAttribute($cNombreAtributo);
						$textoAtributo = $doc->createTextNode($aXD[$cNombreAtributo]); 
						$atributo->appendChild($textoAtributo);
						$filas->appendChild($atributo);
					}
				}
				$listado->appendChild($filas);
				$aXD = $this->FetchArray($cIdQuery);
			}
		}
		
		if (isset($listado))
			$doc->appendChild($listado);

		return ($doc);
	}
	
	function QuerySelect($cIdQuery) {
	  	$aRes = array();
		$aXD = mssql_fetch_row($this->rQuery[$cIdQuery]);
		if (is_array($aXD)) {
			while($aXD) {
				$aRes[$aXD[0]] = $aXD[1];
				$aXD = mssql_fetch_row($this->rQuery[$cIdQuery]);
			}
		}	
		return ($aRes);
	}
}

Class BaseDatosPOSTGRE_SQL extends BaseDatosTemplate {
  	
  	public function __construct($cServidor, $cDatabase, $cUsuario, $cPassword) {
		$this->Conectar($cServidor, $cDatabase, $cUsuario, $cPassword);
	}
	
	public function Conectar($cServidor, $cDatabase, $cUsuario, $cPassword) {
	  	$bOk = false;
		//$this->rBase = mssql_connect($cServidor, $cUsuario, $cPassword);
		$this->rBase = pg_connect("host=$cServidor port=5432 dbname=$cDatabase user=$cUsuario password=$cPassword");
		if ($this->rBase === false) {
		  	SRM_Servicios::agregarError("Error conectando al servidor [" . $cServidor . "]");
		} else {
		  	$bOk = $this->CambiarDatabase($cDatabase);
		  	if ($bOk) {
				$this->cServidor = $cServidor;
				$this->cUsuario = $cUsuario;
				$this->cPassword = $cPassword;
				$this->cDatabase = $cDatabase;
				$this->bEstadoConeccion = true;
			}
		}
		return $bOk;
	}
	
	public function CambiarDatabase($cDatabase) {
		//$bOk = mssql_select_db($cDatabase, $this->rBase);
		$this->rBase = pg_connect("host=$this->cServidor port=5432 dbname=$cDatabase user=$this->cUsuario password=$this->cPassword");
		if ($this->rBase === false) {
			SRM_Servicios::agregarError("No se puedo conectar a la base de datos [" . $cDatabase . "]");
		} else {
			$this->cDatabase = $cDatabase;
		}
		return $bOk;
	}
	
	public function Query($cSql, $cIdQuery) {
	  	/*if (isset($_SESSION['rQuery'][$cIdQuery])) {
		$this->rQuery[$cIdQuery] = $_SESSION['rQuery'][$cIdQuery];
		/* si existe mmover el puntero al inicio.
		mssql_data_seek(0);
		} else {
		*/
		//$this->rQuery[$cIdQuery] = mssql_query($cSql, $this->rBase);
		$this->rQuery[$cIdQuery] = pg_query($this->rBase, $cSql);
		
		if ($this->rQuery[$cIdQuery] === false) {
			SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
		}
		/*}*/
		return (!($this->rQuery[$cIdQuery] === false));
	}
	
	
	public function FetchArray($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
			$aFila = pg_fetch_assoc($this->rQuery[$cIdQuery]);
			return $aFila;
		} else {
			return false;
		}
	}

	public function NextResultset($cIdQuery) {
		/*xd*/
		return false;
	}


	public function FreeResultset($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
		  	pg_free_result($this->rQuery[$cIdQuery]);
		  	/*unset($_SESSION['rQuery']);*/
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	
	/*
	public function FreeTempResultsets() {
	  	foreach($_SESSION['rQuery'] AS $nQuerys) {
	  		
	 		unset($_SESSION['rQuery']);
	  	}
		if (!($this->rQuery[$cIdQuery] === false)) {
		  	mssql_free_result($this->rQuery[$cIdQuery]);
		  	
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	*/
	
	public function Desconectar() {
		$bRes = mssql_Close($this->rBase);
		if ($bRes) {
			$this->cServidor = "";
			$this->cUsuario = "";
			$this->cPassword = "";
			$this->cDatabase = "";
			$this->bEstadoConeccion = false;
		}
		return $bRes;
	}
	
	public function EstadoConeccion() {
		return $this->bEstadoConeccion;
	}
	
	public function EscribirArchivo($cFile, $cTabla, $cCampo, $nPrimary, $ncModoCompresion = 1, $nBuffSize = 204800) {
		//COMPRESION:
		switch ($ncModoCompresion) {
		  	case 1:
		  		$oArchivo = fopen($cFile, "r+");
		  		$cFileSize = filesize($cFile);
  				$cMd5 = md5_file($cFile);
				$cSha1 = sha1_file($cFile);
		  		break;
			case 2:
				$cFileZip = $cFile . ".tmp";
				$xd = shell_exec("/usr/bin/zip -j '$cFileZip' '$cFile'");
				$cFileSize = filesize($cFile);
				$cMd5 = md5_file($cFileZip);
				$cSha1 = sha1_file($cFileZip);
				$oArchivo = fopen($cFileZip, "r+");
				break;
		}
		
		$cBaseName = basename($cFile);
		
		//INFORMACION DEL ARCHIVO
		$cSql = "UPDATE $cTabla
				SET cNombreArchivo = '$cBaseName',
					sha1 = '$cSha1',
					md5 = '$cMd5',
					tamano = $cFileSize,
					ncModoCompresion = $ncModoCompresion
				WHERE $cCampo = $nPrimary";
		
		$this->Query($cSql);
		
		$cSql = "	SELECT ISNULL(DATALENGTH(bDatos), 0) AS nSubido
					FROM $cTabla
					WHERE $cCampo = $nPrimary";
					
		$this->Query($cSql, 1);
		
		$aSubido = $this->FetchArray(1);
		
		$nTotalQueda = $cFileSize - $aSubido['nSubido'];
		
		fseek($oArchivo, $aSubido['nSubido'], SEEK_SET);
		$nPasada = 0;
		while ($nTotalQueda > 0) {
		  	if ($nBuffSize < $nTotalQueda) {
		  		$bBuffer = fread($oArchivo, $nBuffSize);
				$nTotalQueda -= $nBuffSize;
			} else {
				$bBuffer = fread($oArchivo, $nTotalQueda);
				$nTotalQueda = 0;
			}
			$hString = bin2hex($bBuffer);
			$cSql = "	DECLARE @ptrval binary(16)
						DECLARE @largo int
						SELECT @ptrval = TEXTPTR(bDatos), @largo = DATALENGTH(bDatos)
						FROM $cTabla
						WHERE $cCampo = $nPrimary
						UPDATETEXT $cTabla.bDatos @ptrval @largo 0 0x" . $hString;
			$oRscFiles = $this->Query($cSql, 2);
		  	$nPasada++;

		}
		fclose($oArchivo);
		
		switch ($ncModoCompresion) {
		  	case 1:
		  		break;
			case 2:
				unlink($cFileZip);
				break;
		}
	}
	
	function LeerArchivo($cFile, $cTabla, $cCampo, $nPrimary, $nBuffSize = 204800) {

	  	$cSql = "SELECT ISNULL(DATALENGTH(bDatos), 0) AS Dato, ncModoCompresion FROM $cTabla WHERE $cCampo = $nPrimary";
		$this->Query($cSql, 1);
		$asd = $this->FetchArray(1);
		$nLargo = $asd['Dato'];
		$ncModoCompresion  = $asd['ncModoCompresion'];

		switch ($ncModoCompresion) {
			case 1:
				$oArchivo = fopen($cFile, "w");
				break;
			case 2:
				$oArchivo = fopen($cFile . ".tmp", "w");
				break;
		}
		
		$nTotalQueda = $nLargo;
		
		$nPasada = 0;
		while ($nTotalQueda > 0) {
		  	if ($nBuffSize < $nTotalQueda) {
		  		$nCantidadLeer = $nBuffSize;
				$nTotalQueda -= $nBuffSize;
			} else {
				$nCantidadLeer = $nTotalQueda;
				$nTotalQueda = 0;
			}
			
			$nPosicionLeer = ($nPasada * $nBuffSize);

			$cSql = "	DECLARE @ptrval binary(16)
						SELECT @ptrval = TEXTPTR(bDatos)
						FROM $cTabla
						WHERE $cCampo = $nPrimary
						IF  NOT (@ptrval IS null)
						READTEXT $cTabla.bDatos @ptrval $nPosicionLeer $nCantidadLeer";
			
			$this->Query($cSql, 1);
			$aRes = $this->FetchArray(1);
			fwrite($oArchivo, $aRes["bDatos"]);
			$nPasada++;
		}
		fclose($oArchivo);
		
		switch ($ncModoCompresion) {
				case 1:
					break;
				case 2:
					shell_exec("/usr/bin/unzip '$cFile.tmp'");
					unlink("$cFile.tmp");
					break;
		}
	}

	function LimpiarArchivo($cTabla, $cCampo, $nPrimary) {
		$cSql = "	DECLARE @ptrval binary(16)
					DECLARE @largo int
					SELECT @ptrval = TEXTPTR(bDatos), @largo = ISNULL(DATALENGTH(bDatos), 0)
					FROM $cTabla
					WHERE $cCampo = $nPrimary
					IF  NOT (@ptrval IS null)
					UPDATETEXT $cTabla.bDatos @ptrval 0 @largo";
		$this->Query($cSql, 1);
	}
	
	function QueryXMLListado($cIdQuery, $aAtributos = array(), $aOcultos = array(), $cEncoding = "") {
		
		$doc = new DOMDocument('1.0', $cEncoding);

		$aXD = $this->FetchArray($cIdQuery);
		
		if (is_array($aXD)) {
		  	$listado = $doc->createElement('listado');
		  	
			while($aXD) {
				$filas = $doc->createElement('filas');
				foreach($aXD AS $cClave => $cValor) {
				  	if (array_search($cClave, $aOcultos) === false) {
						$dato = $doc->createElement('dato', $cValor);
						$filas->appendChild($dato);
					}
				}
				if (is_array($aAtributos) && (count($aAtributos) > 0)) {
				  	foreach($aAtributos AS $cNombreAtributo) {
						$atributo = $doc->createAttribute($cNombreAtributo);
						$textoAtributo = $doc->createTextNode($aXD[$cNombreAtributo]); 
						$atributo->appendChild($textoAtributo);
						$filas->appendChild($atributo);
					}
				}
				$listado->appendChild($filas);
				$aXD = $this->FetchArray($cIdQuery);
			}
		}
		
		if (isset($listado))
			$doc->appendChild($listado);

		return ($doc);
	}
	
	function QuerySelect($cIdQuery) {
	  	$aRes = array();
	  	$i = 0;
		$aXD = pg_Fetch_Row($this->rQuery[$cIdQuery], $i);
		if (is_array($aXD)) {
			while($aXD) {
			  	$i++;
				$aRes[$aXD[0]] = $aXD[1];
				$aXD = pg_Fetch_Row($this->rQuery[$cIdQuery], $i);
			}
		}	
		return ($aRes);
	}
}


class BaseDatosMySQL extends BaseDatosTemplate {
  	
  	public function __construct($cServidor, $cDatabase, $cUsuario, $cPassword) {
		$this->Conectar($cServidor, $cDatabase, $cUsuario, $cPassword);
	}
	
	public function Conectar($cServidor, $cDatabase, $cUsuario, $cPassword) {
	  	$bOk = false;
		$this->rBase = mysql_connect($cServidor, $cUsuario, $cPassword, false);
		if ($this->rBase === false) {
//		  	SRM_Servicios::agregarError("Error conectando al servidor [" . $cServidor . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error conectando al servidor [" . $cServidor . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error conectando al servidor [" . $cServidor . "]", LOG_ERROR);
		} else {
		  	//mysql_set_charset("latin1", $this->rBase); //CAMBIA A LATIN 1 xd
		  	$bOk = $this->CambiarDatabase($cDatabase);
		  	if ($bOk) {
				$this->cServidor = $cServidor;
				$this->cUsuario = $cUsuario;
				$this->cPassword = $cPassword;
				$this->cDatabase = $cDatabase;
				$this->bEstadoConeccion = true;
			}
		}
		return $bOk;
	}
	
	public function CambiarDatabase($cDatabase) {
		$bOk = mysql_select_db($cDatabase, $this->rBase);
		if ($bOk === false) {
			//SRM_Servicios::agregarError("No se puedo conectar a la base de datos [" . $cDatabase . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("No se puedo conectar a la base de datos [" . $cDatabase . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("No se puedo conectar a la base de datos [" . $cDatabase . "]", LOG_ERROR);
		}
		return $bOk;
	}
	
	public function Query($cSql, $cIdQuery) {
		$this->rQuery[$cIdQuery] = mysql_query($cSql, $this->rBase);
		if ($this->rQuery[$cIdQuery] === false) {
			//SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "]", LOG_ERROR);
		}
		return (!($this->rQuery[$cIdQuery] === false));
	}
	
	
	public function FetchArray($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
			$aFila = mysql_fetch_assoc($this->rQuery[$cIdQuery]);
			return $aFila;
		} else {
			return false;
		}
	}

	public function NextResultset($cIdQuery) {
	  	return false;
	  	/*
		if (!($this->rQuery[$cIdQuery] === false)) {
			$bHayProximo = mssql_next_result($this->rQuery[$cIdQuery]);
			if ($bHayProximo === false)
				mssql_free_result($this->rBase);
		} else {
			return false;
		}
		*/
	}


	public function FreeResultset($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
		  	mysql_free_result($this->rQuery[$cIdQuery]);
		  	/*unset($_SESSION['rQuery']);*/
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	
	public function Desconectar() {
		$bRes = mysql_close($this->rBase);
		if ($bRes) {
			$this->cServidor = "";
			$this->cUsuario = "";
			$this->cPassword = "";
			$this->cDatabase = "";
			$this->bEstadoConeccion = false;
		}
		return $bRes;
	}
	
	public function EstadoConeccion() {
		return $this->bEstadoConeccion;
	}
	
	public function EscribirArchivo($cFile, $cTabla, $cCampo, $nPrimary, $ncModoCompresion = 1, $nBuffSize = 204800) {
		//HACER
		return true;
	}
	
	function LeerArchivo($cFile, $cTabla, $cCampo, $nPrimary, $nBuffSize = 204800) {
		//hacer
		return true;
	}

	function LimpiarArchivo($cTabla, $cCampo, $nPrimary) {
	  	//hacer
	  	return true;
	}
	
	function QueryXMLListado($cIdQuery, $aAtributos = array(), $aOcultos = array(), $cEncoding = "") {
		
		$doc = new DOMDocument('1.0', $cEncoding);

		$aXD = $this->FetchArray($cIdQuery);
		
		if (is_array($aXD)) {
		  	$listado = $doc->createElement('listado');
		  	
			while($aXD) {
				$filas = $doc->createElement('filas');
				foreach($aXD AS $cClave => $cValor) {
				  	if (array_search($cClave, $aOcultos) === false) {
						$dato = $doc->createElement('dato',SRM_Servicios::ensuciarVariable($cValor));
						$filas->appendChild($dato);
					}
				}
				if (is_array($aAtributos) && (count($aAtributos) > 0)) {
				  	foreach($aAtributos AS $cNombreAtributo) {
						$atributo = $doc->createAttribute($cNombreAtributo);
						$textoAtributo = $doc->createTextNode($aXD[$cNombreAtributo]); 
						$atributo->appendChild($textoAtributo);
						$filas->appendChild($atributo);
					}
				}
				$listado->appendChild($filas);
				$aXD = $this->FetchArray($cIdQuery);
			}
		}
		
		if (isset($listado))
			$doc->appendChild($listado);

		return ($doc);
	}
	
	function QuerySelect($cIdQuery) {
	  	$aRes = array();
		$aXD = mysql_fetch_row($this->rQuery[$cIdQuery]);
		if (is_array($aXD)) {
			while($aXD) {
				$aRes[$aXD[0]] = $aXD[1];
				$aXD = mysql_fetch_row($this->rQuery[$cIdQuery]);
			}
		}	
		return ($aRes);
	}
}




class BaseDatosMySQLi extends BaseDatosTemplate {
  	
  	public function __construct($cServidor, $cDatabase, $cUsuario, $cPassword) {
		$this->Conectar($cServidor, $cDatabase, $cUsuario, $cPassword);
	}

	public function getLastId() {
		return mysqli_insert_id($this->rBase);
	}
	
	public function Conectar($cServidor, $cDatabase, $cUsuario, $cPassword) {
	  	$bOk = false;
		$this->rBase = mysqli_connect($cServidor, $cUsuario, $cPassword, $cDatabase);
		if ($this->rBase === false) {
//		  	SRM_Servicios::agregarError("Error conectando al servidor [" . $cServidor . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error conectando al servidor [" . $cServidor . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error conectando al servidor [" . $cServidor . "]", LOG_ERROR);
		} else {
		  	//mysql_set_charset("latin1", $this->rBase); //CAMBIA A LATIN 1 xd
		  	$bOk = $this->CambiarDatabase($cDatabase);
		  	if ($bOk) {
				$this->cServidor = $cServidor;
				$this->cUsuario = $cUsuario;
				$this->cPassword = $cPassword;
				$this->cDatabase = $cDatabase;
				$this->bEstadoConeccion = true;
			}
		}
		return $bOk;
	}
	
	public function CambiarDatabase($cDatabase) {
		$bOk = mysqli_select_db($this->rBase, $cDatabase);
		if ($bOk === false) {
			//SRM_Servicios::agregarError("No se puedo conectar a la base de datos [" . $cDatabase . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("No se puedo conectar a la base de datos [" . $cDatabase . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("No se puedo conectar a la base de datos [" . $cDatabase . "]", LOG_ERROR);
		}
		return $bOk;
	}
	
	public function Query($cSql, $cIdQuery) {
		$this->rQuery[$cIdQuery] = mysqli_query($this->rBase, $cSql);
		if ($this->rQuery[$cIdQuery] === false) {
			//SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" . mysqli_error($this->rBase) . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" .  mysqli_error($this->rBase) . "]", LOG_ERROR);
		}
		return (!($this->rQuery[$cIdQuery] === false));
	}
	
	
	public function FetchArray($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
			$aFila = mysqli_fetch_assoc($this->rQuery[$cIdQuery]);
			return $aFila;
		} else {
			return false;
		}
	}

	public function NextResultset($cIdQuery) {
	  	//return false;
		if (!($this->rQuery[$cIdQuery] === false)) {
			$bHayProximo = mysqli_more_results($this->rBase);
			if ($bHayProximo === false) {
				mysqli_free_result($this->rQuery[$cIdQuery]);
			} else {
				mysqli_next_result($this->rBase);
			}
		} else {
			return false;
		}
	}


	public function FreeResultset($cIdQuery) {
		if (!($this->rQuery[$cIdQuery] === false)) {
		  	mysqli_free_result($this->rQuery[$cIdQuery]);
			
		  	/*unset($_SESSION['rQuery']);*/
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	
	public function Desconectar() {
		$bRes = mysqli_close($this->rBase);
		if ($bRes) {
			$this->cServidor = "";
			$this->cUsuario = "";
			$this->cPassword = "";
			$this->cDatabase = "";
			$this->bEstadoConeccion = false;
		}
		return $bRes;
	}
	
	public function EstadoConeccion() {
		return $this->bEstadoConeccion;
	}
	
	public function EscribirArchivo($cFile, $cTabla, $cCampo, $nPrimary, $ncModoCompresion = 1, $nBuffSize = 204800) {
		//HACER
		return true;
	}
	
	function LeerArchivo($cFile, $cTabla, $cCampo, $nPrimary, $nBuffSize = 204800) {
		//hacer
		return true;
	}

	function LimpiarArchivo($cTabla, $cCampo, $nPrimary) {
	  	//hacer
	  	return true;
	}
	
	function QueryXMLListado($cIdQuery, $aAtributos = array(), $aOcultos = array(), $cEncoding = "") {
		
		$doc = new DOMDocument('1.0', $cEncoding);

		$aXD = $this->FetchArray($cIdQuery);
		
		if (is_array($aXD)) {
		  	$listado = $doc->createElement('listado');
		  	
			while($aXD) {
				$filas = $doc->createElement('filas');
				foreach($aXD AS $cClave => $cValor) {
				  	if (array_search($cClave, $aOcultos) === false) {
						$dato = $doc->createElement('dato',SRM_Servicios::ensuciarVariable($cValor));
						$filas->appendChild($dato);
					}
				}
				if (is_array($aAtributos) && (count($aAtributos) > 0)) {
				  	foreach($aAtributos AS $cNombreAtributo) {
						$atributo = $doc->createAttribute($cNombreAtributo);
						$textoAtributo = $doc->createTextNode($aXD[$cNombreAtributo]); 
						$atributo->appendChild($textoAtributo);
						$filas->appendChild($atributo);
					}
				}
				$listado->appendChild($filas);
				$aXD = $this->FetchArray($cIdQuery);
			}
		}
		
		if (isset($listado))
			$doc->appendChild($listado);

		return ($doc);
	}
	
	function QuerySelect($cIdQuery) {
	  	$aRes = array();
		$aXD = mysqli_fetch_row($this->rQuery[$cIdQuery]);
		if (is_array($aXD)) {
			while($aXD) {
				$aRes[$aXD[0]] = $aXD[1];
				$aXD = mysql_fetch_row($this->rQuery[$cIdQuery]);
			}
		}	
		return ($aRes);
	}
}


class BaseDatosOracle extends BaseDatosTemplate {
  	
  	public function __construct($cServidor, $cDatabase, $cUsuario, $cPassword) {

		$this->Conectar($cServidor, $cDatabase, $cUsuario, $cPassword);
	}

	/*public function getLastId() {
		return mysqli_insert_id($this->rBase);
	}*/
	
	public function Conectar($cServidor, $cDatabase, $cUsuario, $cPassword) {
	  	$bOk = false;
		$this->rBase = oci_connect($cUsuario, $cPassword, $cServidor);
                
		if ($this->rBase === false) {
			//SRM_Servicios::agregarError("Error conectando al servidor [" . $cServidor . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error conectando al servidor [" . $cServidor . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error conectando al servidor [" . $cServidor . "]", LOG_ERROR);
		} else {
			$this->cServidor = $cServidor;
			$this->cUsuario = $cUsuario;
			$this->cPassword = $cPassword;
			$this->bEstadoConeccion = true;
		}
		return $bOk;
	}
	
	public function CambiarDatabase($cDatabase) {
		return false;
	}
	
	public function Query($cSql, $cIdQuery) {
		$this->rQuery[$cIdQuery] = oci_parse($this->rBase, $cSql);
		$bOk = oci_execute($this->rQuery[$cIdQuery]);

		if ($bOk === false) {
			//SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" . oci_error($this->rBase) . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" .  oci_error($this->rBase) . "]", LOG_ERROR);
		}
		return ($bOk);
	}

	/*public function crearClob(&$clob) {
		$clob = oci_new_descriptor($this->rBase, OCI_D_LOB);
	}*/
	
	public function EjecutarPackageClob($cSql, $cIdQuery, $txt) {

		$rcursor = oci_new_cursor($this->rBase);
		$clob = oci_new_descriptor($this->rBase, OCI_D_LOB);
		
        $tmprsc = oci_parse($this->rBase, "BEGIN :rcursor := $cSql; END;");

		$bOk2 = oci_bind_by_name($tmprsc, ':rcursor', $rcursor, -1, OCI_B_CURSOR);
		$clobcin = oci_bind_by_name($tmprsc, ':clob', $clob, -1, OCI_B_CLOB);
		//var_dump($clobcin); die();
		
		//var_dump($clob);
		
		$bOk = oci_execute($tmprsc, OCI_DEFAULT);
		if ($clob !== null)
			$clob->write($txt);
		//var_dump($clob);
		
		oci_commit($this->rBase);

		if ($clob !== null)		
			$clob->free();
		
		if (($bOk === false) || ($bOk2 === false) || ($clobcin === false)) {
			//SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" . oci_error($this->rBase) . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" .  oci_error($this->rBase) . "]", LOG_ERROR);
		} else {
			oci_execute($rcursor);
			$this->rQuery[$cIdQuery] = $rcursor;
		}
		return ($rcursor);
	}
	
	public function EjecutarPackageLog($cSql, $cIdQuery, $cDetalle) {

		$rcursor = oci_new_cursor($this->rBase);
		//$clob = oci_new_descriptor($this->rBase, OCI_D_LOB);
		
        $tmprsc = oci_parse($this->rBase, "BEGIN :rcursor := $cSql; END;");

		$bOk2 = oci_bind_by_name($tmprsc, ':rcursor', $rcursor, -1, OCI_B_CURSOR);
		$clobcin = oci_bind_by_name($tmprsc, ':cDetalle', $cDetalle, -1, SQLT_CHR);
		//var_dump($clobcin); die();
		
		//var_dump($clob);
		
		$bOk = oci_execute($tmprsc, OCI_DEFAULT);
		/*if ($clob !== null)
			$clob->write($txt);*/
		//var_dump($clob);
		
		//oci_commit($this->rBase);

		/*if ($clob !== null)		
			$clob->free();*/
		
		if (($bOk === false) || ($bOk2 === false) || ($clobcin === false)) {
			//SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" . oci_error($this->rBase) . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" .  oci_error($this->rBase) . "]", LOG_ERROR);
		} else {
			oci_execute($rcursor);
			$this->rQuery[$cIdQuery] = $rcursor;
		}
		return ($rcursor);
	}

	public function EjecutarPackage($cSql, $cIdQuery) {
		$rcursor = oci_new_cursor($this->rBase);
		
                $tmprsc = oci_parse($this->rBase, "BEGIN :rcursor := $cSql; END;");
		$bOk2 = oci_bind_by_name($tmprsc, ':rcursor', $rcursor, -1, OCI_B_CURSOR);

		$bOk = oci_execute($tmprsc);
                
		if (($bOk === false) || ($bOk2 === false)) {
			//SRM_Servicios::agregarError("Error en la consulta $cIdQuery: [" . $cSql . "]");
			$logM = LogEmail::GetMail();
			$logM->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" . oci_error($this->rBase) . "]", LOG_ERROR);
			$log = LogErrorWeekDay::GetLog();
			$log->AddLog("Error en la consulta $cIdQuery: [" . $cSql . "] [" .  oci_error($this->rBase) . "]", LOG_ERROR);
		} else {
			oci_execute($rcursor);
			$this->rQuery[$cIdQuery] = $rcursor;
		}
		return ($rcursor);
	}

	
	public function FetchArray($cIdQuery) {
		if (isset($this->rQuery[$cIdQuery]) && (!($this->rQuery[$cIdQuery] === false))) {
			$aFila = oci_fetch_assoc($this->rQuery[$cIdQuery]);
			return $aFila;
		} else {
			return false;
		}
	}

	public function NextResultset($cIdQuery) {
	  	return (false);
	}


	public function FreeResultset($cIdQuery) {
		if (isset($this->rQuery[$cIdQuery]) && (!($this->rQuery[$cIdQuery] === false))) {
		  	oci_free_statement($this->rQuery[$cIdQuery]);
		  	/*unset($_SESSION['rQuery']);*/
		  	unset($this->rQuery[$cIdQuery]);
		  	return true;
		}
		return false;
	}
	
	public function Desconectar() {
		$bRes = oci_close($this->rBase);
		if ($bRes) {
			$this->cServidor = "";
			$this->cUsuario = "";
			$this->cPassword = "";
			$this->cDatabase = "";
			$this->bEstadoConeccion = false;
		}
		return $bRes;
	}
	
	public function EstadoConeccion() {
		return $this->bEstadoConeccion;
	}
	
	public function EscribirArchivo($cFile, $cTabla, $cCampo, $nPrimary, $ncModoCompresion = 1, $nBuffSize = 204800) {
		//HACER
		return true;
	}
	
	function LeerArchivo($cFile, $cTabla, $cCampo, $nPrimary, $nBuffSize = 204800) {
		//hacer
		return true;
	}

	function LimpiarArchivo($cTabla, $cCampo, $nPrimary) {
	  	//hacer
	  	return true;
	}
	
	function QueryXMLListado($cIdQuery, $aAtributos = array(), $aOcultos = array(), $cEncoding = "") {
		
		$doc = new DOMDocument('1.0', $cEncoding);

		$aXD = $this->FetchArray($cIdQuery);
		
		if (is_array($aXD)) {
		  	$listado = $doc->createElement('listado');
		  	
			while($aXD) {
				$filas = $doc->createElement('filas');
				foreach($aXD AS $cClave => $cValor) {
				  	if (array_search($cClave, $aOcultos) === false) {
						$dato = $doc->createElement('dato',SRM_Servicios::ensuciarVariable($cValor));
						$filas->appendChild($dato);
					}
				}
				if (is_array($aAtributos) && (count($aAtributos) > 0)) {
				  	foreach($aAtributos AS $cNombreAtributo) {
						$atributo = $doc->createAttribute($cNombreAtributo);
						$textoAtributo = $doc->createTextNode($aXD[$cNombreAtributo]); 
						$atributo->appendChild($textoAtributo);
						$filas->appendChild($atributo);
					}
				}
				$listado->appendChild($filas);
				$aXD = $this->FetchArray($cIdQuery);
			}
		}
		
		if (isset($listado))
			$doc->appendChild($listado);

		return ($doc);
	}
	
	function QuerySelect($cIdQuery) {
	  	$aRes = array();
		$aXD = oci_fetch_row($this->rQuery[$cIdQuery]);
		if (is_array($aXD)) {
			while($aXD) {
				$aRes[$aXD[0]] = $aXD[1];
				$aXD = oci_fetch_row($this->rQuery[$cIdQuery]);
			}
		}	
		return ($aRes);
	}
}


?>