<?php

include('../src_detalleiuni/constantes.php');
session_start();

if(isset($_POST["transa"])) {
	$_SESSION["transa"]=$_POST["transa"];
	unset($_POST);
}

switch(ValidaTransaccion($_SESSION["transa"])) {
	case 'ftp':
		include("../src_detalleiuni/ftp.php");
		break;

	case 'estadistica':
		include("../src_detalleiuni/estadistica.php");
		break;

	case 'cdr':
		include("../src_detalleiuni/adminCdr.php");
		break;

	case 'cdr-rev':
		include("../src_detalleiuni/revendedorCdr.php");
		break;

	case 'inicio':
		include("../src_detalleiuni/consultaCdr.php");
		break;

	case 'lineas':
		include("../src_detalleiuni/lineas.php");
		break;

	case 'precios':
		include("../src_detalleiuni/precios.php");
		break;

	case 'precios_iplan':
		include("../src_detalleiuni/precios_iplan.php");
		break;

	case 'clientes':
		include("../src_detalleiuni/clientes.php");
		break;

	case 'umbrales':
		include("../src_detalleiuni/umbrales.php");
		break;

	case 'usuarios':
		include("../src_detalleiuni/usuarios.php");
		break;

	case 'admin':
		include("../src_detalleiuni/admin.php");
		break;

	case 'logs_web':
		include("../src_detalleiuni/logs_web.php");
		break;

	case 'mails':
		include("../src_detalleiuni/mails.php");
		break;

	/*
	Modificacion Logs Tincho
	case 'logs':
		//include("../src_detalleiuni/webfilebrowser.php");
		include("../src_detalleiuni/logs.php");
		break;*/

	case 'salir':
		session_unset();
		session_destroy();
		include("../src_detalleiuni/salir.php");
	break;

	default:
		switch($_SESSION["id_perfil"]) {
			case ADMINISTRADOR:
				include("../src_detalleiuni/adminCdr.php");
				break;
			case ADMINISTRADOR_REVENDEDOR:
				include("../src_detalleiuni/revendedorCdr.php");
				break;
			case IMPLEMENTACIONES_FULL:
			case IMPLEMENTACIONES_RESTRINGIDO:
				include("../src_detalleiuni/clientes.php");
				break;
			case MARKETING_FULL:
			case MARKETING_RESTRINGIDO:
				include("../src_detalleiuni/precios_iplan.php");
				break;
			case GIT_FULL:
			case GIT_RESTRINGIDO:
				include("../src_detalleiuni/clientes.php");
				break;
			default:
				include("../src_detalleiuni/consultaCdr.php");
				break;
		}
		break;
	}

function ValidaTransaccion($transa)
{
	//echo "[$transa]"; echo "[" . $_SESSION["id_perfil"] . "]";die();
	switch($_SESSION["id_perfil"]) {
		case ADMINISTRADOR:
			switch($transa) {
				case 'estadistica':
				case 'cdr':
				case 'umbrales':
				case 'precios_iplan':
				case 'logs_web':
				case 'usuarios':
				case 'admin':
				case 'clientes':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case ADMINISTRADOR_REVENDEDOR:
			switch($transa) {
				case 'lineas':
				case 'cdr-rev':
				case 'precios':
				case 'ftp':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case IMPLEMENTACIONES_FULL:
			switch($transa) {
				case 'admin':
				case 'usuarios':
				case 'clientes':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case IMPLEMENTACIONES_RESTRINGIDO:
			switch($transa) {
				case 'admin':
				case 'usuarios':
				case 'clientes':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case MARKETING_FULL:
			switch($transa) {
				case 'admin':
				case 'usuarios':
				case 'precios_iplan':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case MARKETING_RESTRINGIDO:
			switch($transa) {
				case 'admin':
				case 'usuarios':
				case 'precios_iplan':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case GIT_FULL:
			switch($transa) {
				case 'admin':
				case 'mails':
				case 'usuarios':
				case 'clientes':
				case 'umbrales':
				case 'precios_iplan':
				case 'logs_web':
				case 'umbrales':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case GIT_RESTRINGIDO:
			switch($transa) {
				case 'admin':
				case 'mails':
				case 'usuarios':
				case 'clientes':
				case 'umbrales':
				case 'precios_iplan':
				case 'umbrales':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;

		case CLIENTE:
			switch($transa) {
				case 'precios':
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;
		default:
			switch($transa) {
				case '':
					break;
				default:
					$transa = 'salir';
					break;
			}
			break;
	}

	/*switch($transa)
	{
		case 'estadistica':
		case 'cdr':
		case 'umbrales':
		case 'precios_iplan':
		case 'logs_web':
			$transa = $_SESSION["id_perfil"]==ADMINISTRADOR?$transa:'salir';
			break;
		case 'precios':
			break;
		case 'lineas':
		case 'cdr-rev':
			$transa = $_SESSION["id_perfil"]==ADMINISTRADOR_REVENDEDOR?$transa:'salir';
			break;
		default:
			break;
	}*/
	
	return $transa;
}
?>
