<?

class BroadsoftXMLUserAddRequest14sp9 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $userId;
	private $lastName;
	private $firstName;
	private $callingLineIdLastName;
	private $callingLineIdFirstName;
	private $hiraganaLastName;
	private $hiraganaFirstName;
	private $phoneNumber;
	private $extension;
	private $callingLineIdPhoneNumber;
	private $password;
	private $department;
	private $language;
	private $timeZone;
	private $alias;
	private $choice0;
	private $title;
	private $pagerPhoneNumber;
	private $mobilePhoneNumber;
	private $emailAddress;
	private $yahooId;
	private $addressLocation;
	private $address;
	private $networkClassOfService;

	/* Conjunto Recibe [Street address information.] 

	Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30]
	callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30]
	callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30]
	hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [minOccurs = 0]
	[minOccurs = 0]callingLineIdPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]department es un compuesto de: 
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	[minOccurs = 0]alias[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
	accessDeviceEndpoint (no tipado) Access device end point used in the context of add.
	tipo especial []
	title[xs:token]: Title. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]pagerPhoneNumber[xs:token]: A no validation DN field.  To be phased out, not for new
        attributes. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]mobilePhoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]emailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]yahooId[xs:token]: Yahoo Id. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]addressLocation[xs:token]: Address Location. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]address es un compuesto de: 
	addressLine1[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	addressLine2[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	city[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvince[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvinceDisplayName[xs:token]:  [minLength = 1] [maxLength = 50] [minOccurs = 0]
	zipOrPostalCode[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	country[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $userId, $lastName, $firstName, $callingLineIdLastName, $callingLineIdFirstName, $hiraganaLastName, $hiraganaFirstName, $phoneNumber, $extension, $callingLineIdPhoneNumber, $password, $department, $language, $timeZone, $alias, $choice0, $title, $pagerPhoneNumber, $mobilePhoneNumber, $emailAddress, $yahooId, $addressLocation, $address, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($lastName) != strlen(trim( str_replace('  ', ' ', $lastName)))) $ret = false;
		if (strlen($lastName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastName)))))) $ret = false;
		if (strlen($lastName) < 1) $ret = false;
		if (strlen($lastName) > 30) $ret = false;
		if (strlen($firstName) != strlen(trim( str_replace('  ', ' ', $firstName)))) $ret = false;
		if (strlen($firstName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstName)))))) $ret = false;
		if (strlen($firstName) < 1) $ret = false;
		if (strlen($firstName) > 30) $ret = false;
		if (strlen($callingLineIdLastName) != strlen(trim( str_replace('  ', ' ', $callingLineIdLastName)))) $ret = false;
		if (strlen($callingLineIdLastName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdLastName)))))) $ret = false;
		if (strlen($callingLineIdLastName) < 1) $ret = false;
		if (strlen($callingLineIdLastName) > 30) $ret = false;
		if (strlen($callingLineIdFirstName) != strlen(trim( str_replace('  ', ' ', $callingLineIdFirstName)))) $ret = false;
		if (strlen($callingLineIdFirstName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdFirstName)))))) $ret = false;
		if (strlen($callingLineIdFirstName) < 1) $ret = false;
		if (strlen($callingLineIdFirstName) > 30) $ret = false;
		if (is_array($hiraganaLastName) && (count($hiraganaLastName) > 0)) {
			foreach ($hiraganaLastName as $hiraganaLastNamexd ) {
				if ($hiraganaLastNamexd != null) {
					if (strlen($hiraganaLastNamexd) != strlen(trim( str_replace('  ', ' ', $hiraganaLastNamexd)))) $ret = false;
					if (strlen($hiraganaLastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $hiraganaLastNamexd)))))) $ret = false;
					if (strlen($hiraganaLastNamexd) < 1) $ret = false;
					if (strlen($hiraganaLastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($hiraganaLastName) < 0) $ret = false;
		if (is_array($hiraganaFirstName) && (count($hiraganaFirstName) > 0)) {
			foreach ($hiraganaFirstName as $hiraganaFirstNamexd ) {
				if ($hiraganaFirstNamexd != null) {
					if (strlen($hiraganaFirstNamexd) != strlen(trim( str_replace('  ', ' ', $hiraganaFirstNamexd)))) $ret = false;
					if (strlen($hiraganaFirstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $hiraganaFirstNamexd)))))) $ret = false;
					if (strlen($hiraganaFirstNamexd) < 1) $ret = false;
					if (strlen($hiraganaFirstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($hiraganaFirstName) < 0) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ($phoneNumberxd != null) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($extension) && (count($extension) > 0)) {
			foreach ($extension as $extensionxd ) {
				if ($extensionxd != null) {
					if (strlen($extensionxd) != strlen(trim( str_replace('  ', ' ', $extensionxd)))) $ret = false;
					if (strlen($extensionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $extensionxd)))))) $ret = false;
					if (strlen($extensionxd) < 2) $ret = false;
					if (strlen($extensionxd) > 6) $ret = false;
				}
			}
		}
		if (count($extension) < 0) $ret = false;
		if (is_array($callingLineIdPhoneNumber) && (count($callingLineIdPhoneNumber) > 0)) {
			foreach ($callingLineIdPhoneNumber as $callingLineIdPhoneNumberxd ) {
				if ($callingLineIdPhoneNumberxd != null) {
					if (strlen($callingLineIdPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $callingLineIdPhoneNumberxd)))) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdPhoneNumberxd)))))) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) < 1) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($callingLineIdPhoneNumber) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ($passwordxd != null) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ($languagexd != null) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if (is_array($timeZone) && (count($timeZone) > 0)) {
			foreach ($timeZone as $timeZonexd ) {
				if ($timeZonexd != null) {
					if (strlen($timeZonexd) != strlen(trim( str_replace('  ', ' ', $timeZonexd)))) $ret = false;
					if (strlen($timeZonexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeZonexd)))))) $ret = false;
					if (strlen($timeZonexd) < 1) $ret = false;
					if (strlen($timeZonexd) > 127) $ret = false;
				}
			}
		}
		if (count($timeZone) < 0) $ret = false;
		if (is_array($alias) && (count($alias) > 0)) {
			foreach ($alias as $aliasxd ) {
				if ($aliasxd != null) {
					if (strlen($aliasxd) != strlen(trim( str_replace('  ', ' ', $aliasxd)))) $ret = false;
					if (strlen($aliasxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $aliasxd)))))) $ret = false;
					if (strlen($aliasxd) < 1) $ret = false;
					if (strlen($aliasxd) > 161) $ret = false;
				}
			}
		}
		if (count($alias) < 0) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
				if (isset($choice0xd['accessDeviceEndpoint'])) {
					if (!isset($choice0xd['accessDeviceEndpoint']['accessDevice'])) {
						$ret = false;
					} else {
						if (!isset($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceLevel'])) {
							$ret = false;
						} else {
							if ( ($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceLevel'] != "System") && ($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceLevel'] != "Service Provider") && ($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceLevel'] != "Group") ) {
								$ret = false;
							}
						}
						if (!isset($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName'])) {
							$ret = false;
						} else {
							if (strlen($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName']) != strlen(trim( str_replace('  ', ' ', $choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName'])))) $ret = false;
							if (strlen($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName'])))))) $ret = false;
							if (strlen($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName']) < 1) $ret = false;
							if (strlen($choice0xd['accessDeviceEndpoint']['accessDevice']['deviceName']) > 40) $ret = false;
						}
					}
					if (!isset($choice0xd['accessDeviceEndpoint']['linePort'])) {
						$ret = false;
					} else {
						if (strlen($choice0xd['accessDeviceEndpoint']['linePort']) != strlen(trim( str_replace('  ', ' ', $choice0xd['accessDeviceEndpoint']['linePort'])))) $ret = false;
						if (strlen($choice0xd['accessDeviceEndpoint']['linePort']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['accessDeviceEndpoint']['linePort'])))))) $ret = false;
						if (strlen($choice0xd['accessDeviceEndpoint']['linePort']) < 1) $ret = false;
						if (strlen($choice0xd['accessDeviceEndpoint']['linePort']) > 40) $ret = false;
					}
				}
				if (isset($choice0xd['trunkAddressing'] )) {
					$ret = false;
				}
			}
		}
		if (is_array($title) && (count($title) > 0)) {
			foreach ($title as $titlexd ) {
				if ($titlexd != null) {
					if (strlen($titlexd) != strlen(trim( str_replace('  ', ' ', $titlexd)))) $ret = false;
					if (strlen($titlexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $titlexd)))))) $ret = false;
					if (strlen($titlexd) < 1) $ret = false;
					if (strlen($titlexd) > 50) $ret = false;
				}
			}
		}
		if (count($title) < 0) $ret = false;
		if (is_array($pagerPhoneNumber) && (count($pagerPhoneNumber) > 0)) {
			foreach ($pagerPhoneNumber as $pagerPhoneNumberxd ) {
				if ($pagerPhoneNumberxd != null) {
					if (strlen($pagerPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $pagerPhoneNumberxd)))) $ret = false;
					if (strlen($pagerPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $pagerPhoneNumberxd)))))) $ret = false;
					if (strlen($pagerPhoneNumberxd) < 1) $ret = false;
					if (strlen($pagerPhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($pagerPhoneNumber) < 0) $ret = false;
		if (is_array($mobilePhoneNumber) && (count($mobilePhoneNumber) > 0)) {
			foreach ($mobilePhoneNumber as $mobilePhoneNumberxd ) {
				if ($mobilePhoneNumberxd != null) {
					if (strlen($mobilePhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $mobilePhoneNumberxd)))) $ret = false;
					if (strlen($mobilePhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilePhoneNumberxd)))))) $ret = false;
					if (strlen($mobilePhoneNumberxd) < 1) $ret = false;
					if (strlen($mobilePhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($mobilePhoneNumber) < 0) $ret = false;
		if (is_array($emailAddress) && (count($emailAddress) > 0)) {
			foreach ($emailAddress as $emailAddressxd ) {
				if ($emailAddressxd != null) {
					if (strlen($emailAddressxd) != strlen(trim( str_replace('  ', ' ', $emailAddressxd)))) $ret = false;
					if (strlen($emailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $emailAddressxd)))))) $ret = false;
					if (strlen($emailAddressxd) < 1) $ret = false;
					if (strlen($emailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($emailAddress) < 0) $ret = false;
		if (is_array($yahooId) && (count($yahooId) > 0)) {
			foreach ($yahooId as $yahooIdxd ) {
				if ($yahooIdxd != null) {
					if (strlen($yahooIdxd) != strlen(trim( str_replace('  ', ' ', $yahooIdxd)))) $ret = false;
					if (strlen($yahooIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $yahooIdxd)))))) $ret = false;
					if (strlen($yahooIdxd) < 1) $ret = false;
					if (strlen($yahooIdxd) > 50) $ret = false;
				}
			}
		}
		if (count($yahooId) < 0) $ret = false;
		if (is_array($addressLocation) && (count($addressLocation) > 0)) {
			foreach ($addressLocation as $addressLocationxd ) {
				if ($addressLocationxd != null) {
					if (strlen($addressLocationxd) != strlen(trim( str_replace('  ', ' ', $addressLocationxd)))) $ret = false;
					if (strlen($addressLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressLocationxd)))))) $ret = false;
					if (strlen($addressLocationxd) < 1) $ret = false;
					if (strlen($addressLocationxd) > 80) $ret = false;
				}
			}
		}
		if (count($addressLocation) < 0) $ret = false;
		if (is_array($address) && (count($address) > 0)) {
			foreach ($address as $addressxd ) {
				if ($addressxd['addressLine1'] != null) {
					if (strlen($addressxd['addressLine1']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine1'])))) $ret = false;
					if (strlen($addressxd['addressLine1']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine1'])))))) $ret = false;
					if (strlen($addressxd['addressLine1']) < 1) $ret = false;
					if (strlen($addressxd['addressLine1']) > 80) $ret = false;
				}
				if ($addressxd['addressLine2'] != null) {
					if (strlen($addressxd['addressLine2']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine2'])))) $ret = false;
					if (strlen($addressxd['addressLine2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine2'])))))) $ret = false;
					if (strlen($addressxd['addressLine2']) < 1) $ret = false;
					if (strlen($addressxd['addressLine2']) > 80) $ret = false;
				}
				if ($addressxd['city'] != null) {
					if (strlen($addressxd['city']) != strlen(trim( str_replace('  ', ' ', $addressxd['city'])))) $ret = false;
					if (strlen($addressxd['city']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['city'])))))) $ret = false;
					if (strlen($addressxd['city']) < 1) $ret = false;
					if (strlen($addressxd['city']) > 50) $ret = false;
				}
				if ($addressxd['stateOrProvince'] != null) {
					if (strlen($addressxd['stateOrProvince']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvince'])))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvince'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvince']) > 50) $ret = false;
				}
				if ($addressxd['stateOrProvinceDisplayName'] != null) {
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvinceDisplayName'])))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvinceDisplayName'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) > 50) $ret = false;
				}
				if ($addressxd['zipOrPostalCode'] != null) {
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim( str_replace('  ', ' ', $addressxd['zipOrPostalCode'])))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['zipOrPostalCode'])))))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) < 1) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) > 50) $ret = false;
				}
				if ($addressxd['country'] != null) {
					if (strlen($addressxd['country']) != strlen(trim( str_replace('  ', ' ', $addressxd['country'])))) $ret = false;
					if (strlen($addressxd['country']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['country'])))))) $ret = false;
					if (strlen($addressxd['country']) < 1) $ret = false;
					if (strlen($addressxd['country']) > 50) $ret = false;
				}
			}
		}
		if (count($address) < 0) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if ($networkClassOfServicexd != null) {
					if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
					if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
					if (strlen($networkClassOfServicexd) < 1) $ret = false;
					if (strlen($networkClassOfServicexd) > 40) $ret = false;
				}
			}
		}
		if (count($networkClassOfService) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->userId = $userId;
			$this->lastName = $lastName;
			$this->firstName = $firstName;
			$this->callingLineIdLastName = $callingLineIdLastName;
			$this->callingLineIdFirstName = $callingLineIdFirstName;
			$this->hiraganaLastName = $hiraganaLastName;
			$this->hiraganaFirstName = $hiraganaFirstName;
			$this->phoneNumber = $phoneNumber;
			$this->extension = $extension;
			$this->callingLineIdPhoneNumber = $callingLineIdPhoneNumber;
			$this->password = $password;
			$this->department = $department;
			$this->language = $language;
			$this->timeZone = $timeZone;
			$this->alias = $alias;
			$this->choice0 = $choice0;
			$this->title = $title;
			$this->pagerPhoneNumber = $pagerPhoneNumber;
			$this->mobilePhoneNumber = $mobilePhoneNumber;
			$this->emailAddress = $emailAddress;
			$this->yahooId = $yahooId;
			$this->addressLocation = $addressLocation;
			$this->address = $address;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserAddRequest14sp9");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", $this->groupId);
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("lastName", $this->lastName);
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("firstName", $this->firstName);
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("callingLineIdLastName", $this->callingLineIdLastName);
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("callingLineIdFirstName", $this->callingLineIdFirstName);
		$this->comando->appendChild($elem7);

		if (is_array($this->hiraganaLastName) && count($this->hiraganaLastName) > 0) {
			foreach ($this->hiraganaLastName as $hiraganaLastNamexd) {
				$elem3 = new DOMElement("hiraganaLastName", $hiraganaLastNamexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->hiraganaFirstName) && count($this->hiraganaFirstName) > 0) {
			foreach ($this->hiraganaFirstName as $hiraganaFirstNamexd) {
				$elem3 = new DOMElement("hiraganaFirstName", $hiraganaFirstNamexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem3 = new DOMElement("phoneNumber", $phoneNumberxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->extension) && count($this->extension) > 0) {
			foreach ($this->extension as $extensionxd) {
				$elem3 = new DOMElement("extension", $extensionxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->callingLineIdPhoneNumber) && count($this->callingLineIdPhoneNumber) > 0) {
			foreach ($this->callingLineIdPhoneNumber as $callingLineIdPhoneNumberxd) {
				$elem3 = new DOMElement("callingLineIdPhoneNumber", $callingLineIdPhoneNumberxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem3 = new DOMElement("password", $passwordxd);
				$this->comando->appendChild($elem3);

			}
		}

		//$elem14 = new DOMElement("department", $this->department);
		//$this->comando->appendChild($elem14);

		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem3 = new DOMElement("language", $languagexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->timeZone) && count($this->timeZone) > 0) {
			foreach ($this->timeZone as $timeZonexd) {
				$elem3 = new DOMElement("timeZone", $timeZonexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->alias) && count($this->alias) > 0) {
			foreach ($this->alias as $aliasxd) {
				$elem3 = new DOMElement("alias", $aliasxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (isset($this->choice0['accessDeviceEndpoint'])) {
			$elemxd1 = new DOMElement("accessDeviceEndpoint");
			$this->comando->appendChild($elemxd1);
			//, $this->choice0['accessDeviceEndpoint']
			
			$elementin1 = new DOMElement("accessDevice");
			$elemxd1->appendChild($elementin1);

			$elementitin1 = new DOMElement("deviceLevel", $this->choice0['accessDeviceEndpoint']['accessDevice']['deviceLevel']);
			$elementin1->appendChild($elementitin1);

			$elementitin2 = new DOMElement("deviceName", $this->choice0['accessDeviceEndpoint']['accessDevice']['deviceName']);
			$elementin1->appendChild($elementitin2);

			$elementin2 = new DOMElement("linePort", $this->choice0['accessDeviceEndpoint']['linePort']);
			$elemxd1->appendChild($elementin2);


		}
		/*if (isset($this->choice0[''])) {
			$elemxd2 = new DOMElement("", $this->choice0['']);
			$this->comando->appendChild($elemxd2);

		}*/
		if (is_array($this->title) && count($this->title) > 0) {
			foreach ($this->title as $titlexd) {
				$elem3 = new DOMElement("title", $titlexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->pagerPhoneNumber) && count($this->pagerPhoneNumber) > 0) {
			foreach ($this->pagerPhoneNumber as $pagerPhoneNumberxd) {
				$elem3 = new DOMElement("pagerPhoneNumber", $pagerPhoneNumberxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->mobilePhoneNumber) && count($this->mobilePhoneNumber) > 0) {
			foreach ($this->mobilePhoneNumber as $mobilePhoneNumberxd) {
				$elem3 = new DOMElement("mobilePhoneNumber", $mobilePhoneNumberxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->emailAddress) && count($this->emailAddress) > 0) {
			foreach ($this->emailAddress as $emailAddressxd) {
				$elem3 = new DOMElement("emailAddress", $emailAddressxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->yahooId) && count($this->yahooId) > 0) {
			foreach ($this->yahooId as $yahooIdxd) {
				$elem3 = new DOMElement("yahooId", $yahooIdxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->addressLocation) && count($this->addressLocation) > 0) {
			foreach ($this->addressLocation as $addressLocationxd) {
				$elem3 = new DOMElement("addressLocation", $addressLocationxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->address) && count($this->address) > 0) {
			$elem25 = new DOMElement("address");
			$this->comando->appendChild($elem25);

			foreach ($this->address as $addressxd) {
				if (isset($addressxd['addressLine1'])) {
					$elemtin1 = new DOMElement("addressLine1", $addressxd['addressLine1']);
					$elem25->appendChild($elemtin1);

				}
				if (isset($addressxd['addressLine2'])) {
					$elemtin2 = new DOMElement("addressLine2", $addressxd['addressLine2']);
					$elem25->appendChild($elemtin2);

				}
				if (isset($addressxd['city'])) {
					$elemtin3 = new DOMElement("city", $addressxd['city']);
					$elem25->appendChild($elemtin3);

				}
				if (isset($addressxd['stateOrProvince'])) {
					$elemtin4 = new DOMElement("stateOrProvince", $addressxd['stateOrProvince']);
					$elem25->appendChild($elemtin4);

				}
				if (isset($addressxd['stateOrProvinceDisplayName'])) {
					$elemtin5 = new DOMElement("stateOrProvinceDisplayName", $addressxd['stateOrProvinceDisplayName']);
					$elem25->appendChild($elemtin5);

				}
				if (isset($addressxd['zipOrPostalCode'])) {
					$elemtin6 = new DOMElement("zipOrPostalCode", $addressxd['zipOrPostalCode']);
					$elem25->appendChild($elemtin6);

				}
				if (isset($addressxd['country'])) {
					$elemtin7 = new DOMElement("country", $addressxd['country']);
					$elem25->appendChild($elemtin7);

				}
			}
		}
		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem8 = new DOMElement("networkClassOfService", $networkClassOfServicexd);
				$this->comando->appendChild($elem8);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserDnGetActivationListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserDnGetActivationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserAssignedServicesGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId) {
		$ret = true;
		if (is_array($userId) && (count($userId) > 0)) {
			foreach ($userId as $userIdxd ) {
				if ($userIdxd != null) {
					if (strlen($userIdxd) != strlen(trim( str_replace('  ', ' ', $userIdxd)))) $ret = false;
					if (strlen($userIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userIdxd)))))) $ret = false;
					if (strlen($userIdxd) < 1) $ret = false;
					if (strlen($userIdxd) > 161) $ret = false;
				}
			}
		}
		if (count($userId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserAssignedServicesGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->userId) && count($this->userId) > 0) {
			foreach ($this->userId as $userIdxd) {
				$elem8 = new DOMElement("userId", $userIdxd);
				$this->comando->appendChild($elem8);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserGetRequest15sp2 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserGetRequest15sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserGetRegistrationListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserGetRegistrationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserModifyRequest14sp9 extends BroadsoftXMLCommand { 

	private $userId;
	private $lastName;
	private $firstName;
	private $callingLineIdLastName;
	private $callingLineIdFirstName;
	private $hiraganaLastName;
	private $hiraganaFirstName;
	private $phoneNumber;
	private $extension;
	private $callingLineIdPhoneNumber;
	private $oldPassword;
	private $newPassword;
	private $department;
	private $language;
	private $timeZone;
	private $sipAliasList;
	private $endpoint;
	private $title;
	private $pagerPhoneNumber;
	private $mobilePhoneNumber;
	private $emailAddress;
	private $yahooId;
	private $addressLocation;
	private $address;
	private $networkClassOfService;

	/* Conjunto Recibe [Street address information.] 

	Conjunto Recibe [A list of SIP aliases that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]callingLineIdPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]oldPassword[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]newPassword[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]department es un compuesto de: 
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	[minOccurs = 0]sipAliasList es un compuesto de: 
	sipAlias[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]endpoint []
	title[xs:token]: Title. [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]pagerPhoneNumber[xs:token]: A no validation DN field.  To be phased out, not for new
        attributes. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]mobilePhoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]emailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]yahooId[xs:token]: Yahoo Id. [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]addressLocation[xs:token]: Address Location. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]address es un compuesto de: 
	addressLine1[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	addressLine2[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	city[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvince[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvinceDisplayName[xs:token]:  [minLength = 1] [maxLength = 50] [minOccurs = 0]
	zipOrPostalCode[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	country[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $lastName, $firstName, $callingLineIdLastName, $callingLineIdFirstName, $hiraganaLastName, $hiraganaFirstName, $phoneNumber, $extension, $callingLineIdPhoneNumber, $oldPassword, $newPassword, $department, $language, $timeZone, $sipAliasList, $endpoint, $title, $pagerPhoneNumber, $mobilePhoneNumber, $emailAddress, $yahooId, $addressLocation, $address, $networkClassOfService) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ($lastNamexd != null) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ($firstNamexd != null) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($callingLineIdLastName) && (count($callingLineIdLastName) > 0)) {
			foreach ($callingLineIdLastName as $callingLineIdLastNamexd ) {
				if ($callingLineIdLastNamexd != null) {
					if (strlen($callingLineIdLastNamexd) != strlen(trim( str_replace('  ', ' ', $callingLineIdLastNamexd)))) $ret = false;
					if (strlen($callingLineIdLastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdLastNamexd)))))) $ret = false;
					if (strlen($callingLineIdLastNamexd) < 1) $ret = false;
					if (strlen($callingLineIdLastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($callingLineIdLastName) < 0) $ret = false;
		if (is_array($callingLineIdFirstName) && (count($callingLineIdFirstName) > 0)) {
			foreach ($callingLineIdFirstName as $callingLineIdFirstNamexd ) {
				if ($callingLineIdFirstNamexd != null) {
					if (strlen($callingLineIdFirstNamexd) != strlen(trim( str_replace('  ', ' ', $callingLineIdFirstNamexd)))) $ret = false;
					if (strlen($callingLineIdFirstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdFirstNamexd)))))) $ret = false;
					if (strlen($callingLineIdFirstNamexd) < 1) $ret = false;
					if (strlen($callingLineIdFirstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($callingLineIdFirstName) < 0) $ret = false;
		if (is_array($hiraganaLastName) && (count($hiraganaLastName) > 0)) {
			foreach ($hiraganaLastName as $hiraganaLastNamexd ) {
				if ($hiraganaLastNamexd != null) {
					if (strlen($hiraganaLastNamexd) != strlen(trim( str_replace('  ', ' ', $hiraganaLastNamexd)))) $ret = false;
					if (strlen($hiraganaLastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $hiraganaLastNamexd)))))) $ret = false;
					if (strlen($hiraganaLastNamexd) < 1) $ret = false;
					if (strlen($hiraganaLastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($hiraganaLastName) < 0) $ret = false;
		if (is_array($hiraganaFirstName) && (count($hiraganaFirstName) > 0)) {
			foreach ($hiraganaFirstName as $hiraganaFirstNamexd ) {
				if ($hiraganaFirstNamexd != null) {
					if (strlen($hiraganaFirstNamexd) != strlen(trim( str_replace('  ', ' ', $hiraganaFirstNamexd)))) $ret = false;
					if (strlen($hiraganaFirstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $hiraganaFirstNamexd)))))) $ret = false;
					if (strlen($hiraganaFirstNamexd) < 1) $ret = false;
					if (strlen($hiraganaFirstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($hiraganaFirstName) < 0) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ($phoneNumberxd != null) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($extension) && (count($extension) > 0)) {
			foreach ($extension as $extensionxd ) {
				if ($extensionxd != null) {
					if (strlen($extensionxd) != strlen(trim( str_replace('  ', ' ', $extensionxd)))) $ret = false;
					if (strlen($extensionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $extensionxd)))))) $ret = false;
					if (strlen($extensionxd) < 2) $ret = false;
					if (strlen($extensionxd) > 6) $ret = false;
				}
			}
		}
		if (count($extension) < 0) $ret = false;
		if (is_array($callingLineIdPhoneNumber) && (count($callingLineIdPhoneNumber) > 0)) {
			foreach ($callingLineIdPhoneNumber as $callingLineIdPhoneNumberxd ) {
				if ($callingLineIdPhoneNumberxd != null) {
					if (strlen($callingLineIdPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $callingLineIdPhoneNumberxd)))) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdPhoneNumberxd)))))) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) < 1) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($callingLineIdPhoneNumber) < 0) $ret = false;
		if (is_array($oldPassword) && (count($oldPassword) > 0)) {
			foreach ($oldPassword as $oldPasswordxd ) {
				if ($oldPasswordxd != null) {
					if (strlen($oldPasswordxd) != strlen(trim( str_replace('  ', ' ', $oldPasswordxd)))) $ret = false;
					if (strlen($oldPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $oldPasswordxd)))))) $ret = false;
					if (strlen($oldPasswordxd) < 1) $ret = false;
					if (strlen($oldPasswordxd) > 60) $ret = false;
				}
			}
		}
		if (count($oldPassword) < 0) $ret = false;
		if (is_array($newPassword) && (count($newPassword) > 0)) {
			foreach ($newPassword as $newPasswordxd ) {
				if ($newPasswordxd != null) {
					if (strlen($newPasswordxd) != strlen(trim( str_replace('  ', ' ', $newPasswordxd)))) $ret = false;
					if (strlen($newPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newPasswordxd)))))) $ret = false;
					if (strlen($newPasswordxd) < 1) $ret = false;
					if (strlen($newPasswordxd) > 60) $ret = false;
				}
			}
		}
		if (count($newPassword) < 0) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ($languagexd != null) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if (is_array($timeZone) && (count($timeZone) > 0)) {
			foreach ($timeZone as $timeZonexd ) {
				if ($timeZonexd != null) {
					if (strlen($timeZonexd) != strlen(trim( str_replace('  ', ' ', $timeZonexd)))) $ret = false;
					if (strlen($timeZonexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeZonexd)))))) $ret = false;
					if (strlen($timeZonexd) < 1) $ret = false;
					if (strlen($timeZonexd) > 127) $ret = false;
				}
			}
		}
		if (count($timeZone) < 0) $ret = false;
		if (is_array($sipAliasList) && (count($sipAliasList) > 0)) {
			foreach ($sipAliasList as $sipAliasListxd ) {
				if ($sipAliasListxd['sipAlias'] != null) {
					if (strlen($sipAliasListxd['sipAlias']) != strlen(trim( str_replace('  ', ' ', $sipAliasListxd['sipAlias'])))) $ret = false;
					if (strlen($sipAliasListxd['sipAlias']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $sipAliasListxd['sipAlias'])))))) $ret = false;
					if (strlen($sipAliasListxd['sipAlias']) < 1) $ret = false;
					if (strlen($sipAliasListxd['sipAlias']) > 161) $ret = false;
				}
			}
		}
		if (count($sipAliasList) < 0) $ret = false;
		if (is_array($title) && (count($title) > 0)) {
			foreach ($title as $titlexd ) {
				if ($titlexd != null) {
					if (strlen($titlexd) != strlen(trim( str_replace('  ', ' ', $titlexd)))) $ret = false;
					if (strlen($titlexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $titlexd)))))) $ret = false;
					if (strlen($titlexd) < 1) $ret = false;
					if (strlen($titlexd) > 50) $ret = false;
				}
			}
		}
		if (count($title) < 0) $ret = false;
		if (is_array($pagerPhoneNumber) && (count($pagerPhoneNumber) > 0)) {
			foreach ($pagerPhoneNumber as $pagerPhoneNumberxd ) {
				if ($pagerPhoneNumberxd != null) {
					if (strlen($pagerPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $pagerPhoneNumberxd)))) $ret = false;
					if (strlen($pagerPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $pagerPhoneNumberxd)))))) $ret = false;
					if (strlen($pagerPhoneNumberxd) < 1) $ret = false;
					if (strlen($pagerPhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($pagerPhoneNumber) < 0) $ret = false;
		if (is_array($mobilePhoneNumber) && (count($mobilePhoneNumber) > 0)) {
			foreach ($mobilePhoneNumber as $mobilePhoneNumberxd ) {
				if ($mobilePhoneNumberxd != null) {
					if (strlen($mobilePhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $mobilePhoneNumberxd)))) $ret = false;
					if (strlen($mobilePhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilePhoneNumberxd)))))) $ret = false;
					if (strlen($mobilePhoneNumberxd) < 1) $ret = false;
					if (strlen($mobilePhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($mobilePhoneNumber) < 0) $ret = false;
		if (is_array($emailAddress) && (count($emailAddress) > 0)) {
			foreach ($emailAddress as $emailAddressxd ) {
				if ($emailAddressxd != null) {
					if (strlen($emailAddressxd) != strlen(trim( str_replace('  ', ' ', $emailAddressxd)))) $ret = false;
					if (strlen($emailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $emailAddressxd)))))) $ret = false;
					if (strlen($emailAddressxd) < 1) $ret = false;
					if (strlen($emailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($emailAddress) < 0) $ret = false;
		if (is_array($yahooId) && (count($yahooId) > 0)) {
			foreach ($yahooId as $yahooIdxd ) {
				if ($yahooIdxd != null) {
					if (strlen($yahooIdxd) != strlen(trim( str_replace('  ', ' ', $yahooIdxd)))) $ret = false;
					if (strlen($yahooIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $yahooIdxd)))))) $ret = false;
					if (strlen($yahooIdxd) < 1) $ret = false;
					if (strlen($yahooIdxd) > 50) $ret = false;
				}
			}
		}
		if (count($yahooId) < 0) $ret = false;
		if (is_array($addressLocation) && (count($addressLocation) > 0)) {
			foreach ($addressLocation as $addressLocationxd ) {
				if ($addressLocationxd != null) {
					if (strlen($addressLocationxd) != strlen(trim( str_replace('  ', ' ', $addressLocationxd)))) $ret = false;
					if (strlen($addressLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressLocationxd)))))) $ret = false;
					if (strlen($addressLocationxd) < 1) $ret = false;
					if (strlen($addressLocationxd) > 80) $ret = false;
				}
			}
		}
		if (count($addressLocation) < 0) $ret = false;
		if (is_array($address) && (count($address) > 0)) {
			foreach ($address as $addressxd ) {
				if ($addressxd['addressLine1'] != null) {
					if (strlen($addressxd['addressLine1']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine1'])))) $ret = false;
					if (strlen($addressxd['addressLine1']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine1'])))))) $ret = false;
					if (strlen($addressxd['addressLine1']) < 1) $ret = false;
					if (strlen($addressxd['addressLine1']) > 80) $ret = false;
				}
				if ($addressxd['addressLine2'] != null) {
					if (strlen($addressxd['addressLine2']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine2'])))) $ret = false;
					if (strlen($addressxd['addressLine2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine2'])))))) $ret = false;
					if (strlen($addressxd['addressLine2']) < 1) $ret = false;
					if (strlen($addressxd['addressLine2']) > 80) $ret = false;
				}
				if ($addressxd['city'] != null) {
					if (strlen($addressxd['city']) != strlen(trim( str_replace('  ', ' ', $addressxd['city'])))) $ret = false;
					if (strlen($addressxd['city']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['city'])))))) $ret = false;
					if (strlen($addressxd['city']) < 1) $ret = false;
					if (strlen($addressxd['city']) > 50) $ret = false;
				}
				if ($addressxd['stateOrProvince'] != null) {
					if (strlen($addressxd['stateOrProvince']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvince'])))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvince'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvince']) > 50) $ret = false;
				}
				if ($addressxd['stateOrProvinceDisplayName'] != null) {
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvinceDisplayName'])))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvinceDisplayName'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) > 50) $ret = false;
				}
				if ($addressxd['zipOrPostalCode'] != null) {
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim( str_replace('  ', ' ', $addressxd['zipOrPostalCode'])))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['zipOrPostalCode'])))))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) < 1) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) > 50) $ret = false;
				}
				if ($addressxd['country'] != null) {
					if (strlen($addressxd['country']) != strlen(trim( str_replace('  ', ' ', $addressxd['country'])))) $ret = false;
					if (strlen($addressxd['country']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['country'])))))) $ret = false;
					if (strlen($addressxd['country']) < 1) $ret = false;
					if (strlen($addressxd['country']) > 50) $ret = false;
				}
			}
		}
		if (count($address) < 0) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if ($networkClassOfServicexd != null) {
					if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
					if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
					if (strlen($networkClassOfServicexd) < 1) $ret = false;
					if (strlen($networkClassOfServicexd) > 40) $ret = false;
				}
			}
		}
		if (count($networkClassOfService) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->lastName = $lastName;
			$this->firstName = $firstName;
			$this->callingLineIdLastName = $callingLineIdLastName;
			$this->callingLineIdFirstName = $callingLineIdFirstName;
			$this->hiraganaLastName = $hiraganaLastName;
			$this->hiraganaFirstName = $hiraganaFirstName;
			$this->phoneNumber = $phoneNumber;
			$this->extension = $extension;
			$this->callingLineIdPhoneNumber = $callingLineIdPhoneNumber;
			$this->oldPassword = $oldPassword;
			$this->newPassword = $newPassword;
			$this->department = $department;
			$this->language = $language;
			$this->timeZone = $timeZone;
			$this->sipAliasList = $sipAliasList;
			$this->endpoint = $endpoint;
			$this->title = $title;
			$this->pagerPhoneNumber = $pagerPhoneNumber;
			$this->mobilePhoneNumber = $mobilePhoneNumber;
			$this->emailAddress = $emailAddress;
			$this->yahooId = $yahooId;
			$this->addressLocation = $addressLocation;
			$this->address = $address;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserModifyRequest14sp9");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem8 = new DOMElement("lastName", $lastNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem8 = new DOMElement("firstName", $firstNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->callingLineIdLastName) && count($this->callingLineIdLastName) > 0) {
			foreach ($this->callingLineIdLastName as $callingLineIdLastNamexd) {
				$elem8 = new DOMElement("callingLineIdLastName", $callingLineIdLastNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->callingLineIdFirstName) && count($this->callingLineIdFirstName) > 0) {
			foreach ($this->callingLineIdFirstName as $callingLineIdFirstNamexd) {
				$elem8 = new DOMElement("callingLineIdFirstName", $callingLineIdFirstNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->hiraganaLastName) && count($this->hiraganaLastName) > 0) {
			foreach ($this->hiraganaLastName as $hiraganaLastNamexd) {
				$elem8 = new DOMElement("hiraganaLastName", $hiraganaLastNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->hiraganaFirstName) && count($this->hiraganaFirstName) > 0) {
			foreach ($this->hiraganaFirstName as $hiraganaFirstNamexd) {
				$elem8 = new DOMElement("hiraganaFirstName", $hiraganaFirstNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem8 = new DOMElement("phoneNumber", $phoneNumberxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->extension) && count($this->extension) > 0) {
			foreach ($this->extension as $extensionxd) {
				$elem8 = new DOMElement("extension", $extensionxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->callingLineIdPhoneNumber) && count($this->callingLineIdPhoneNumber) > 0) {
			foreach ($this->callingLineIdPhoneNumber as $callingLineIdPhoneNumberxd) {
				$elem8 = new DOMElement("callingLineIdPhoneNumber", $callingLineIdPhoneNumberxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->oldPassword) && count($this->oldPassword) > 0) {
			foreach ($this->oldPassword as $oldPasswordxd) {
				$elem8 = new DOMElement("oldPassword", $oldPasswordxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->newPassword) && count($this->newPassword) > 0) {
			foreach ($this->newPassword as $newPasswordxd) {
				$elem8 = new DOMElement("newPassword", $newPasswordxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem13 = new DOMElement("department", $this->department);
		$this->comando->appendChild($elem13);

		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem8 = new DOMElement("language", $languagexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->timeZone) && count($this->timeZone) > 0) {
			foreach ($this->timeZone as $timeZonexd) {
				$elem8 = new DOMElement("timeZone", $timeZonexd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->sipAliasList) && count($this->sipAliasList) > 0) {
			$elem16 = new DOMElement("sipAliasList");
			$this->comando->appendChild($elem16);

			foreach ($this->sipAliasList as $sipAliasListxd) {
				if (isset($sipAliasListxd['sipAlias'])) {
					$elemtin1 = new DOMElement("sipAlias", $sipAliasListxd['sipAlias']);
					$elem16->appendChild($elemtin1);

				}
			}
		}
		$elem17 = new DOMElement("endpoint", $this->endpoint);
		$this->comando->appendChild($elem17);

		if (is_array($this->title) && count($this->title) > 0) {
			foreach ($this->title as $titlexd) {
				$elem2 = new DOMElement("title", $titlexd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->pagerPhoneNumber) && count($this->pagerPhoneNumber) > 0) {
			foreach ($this->pagerPhoneNumber as $pagerPhoneNumberxd) {
				$elem2 = new DOMElement("pagerPhoneNumber", $pagerPhoneNumberxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->mobilePhoneNumber) && count($this->mobilePhoneNumber) > 0) {
			foreach ($this->mobilePhoneNumber as $mobilePhoneNumberxd) {
				$elem2 = new DOMElement("mobilePhoneNumber", $mobilePhoneNumberxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->emailAddress) && count($this->emailAddress) > 0) {
			foreach ($this->emailAddress as $emailAddressxd) {
				$elem2 = new DOMElement("emailAddress", $emailAddressxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->yahooId) && count($this->yahooId) > 0) {
			foreach ($this->yahooId as $yahooIdxd) {
				$elem2 = new DOMElement("yahooId", $yahooIdxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->addressLocation) && count($this->addressLocation) > 0) {
			foreach ($this->addressLocation as $addressLocationxd) {
				$elem2 = new DOMElement("addressLocation", $addressLocationxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->address) && count($this->address) > 0) {
			$elem24 = new DOMElement("address");
			$this->comando->appendChild($elem24);

			foreach ($this->address as $addressxd) {
				if (isset($addressxd['addressLine1'])) {
					$elemtin1 = new DOMElement("addressLine1", $addressxd['addressLine1']);
					$elem24->appendChild($elemtin1);

				}
				if (isset($addressxd['addressLine2'])) {
					$elemtin2 = new DOMElement("addressLine2", $addressxd['addressLine2']);
					$elem24->appendChild($elemtin2);

				}
				if (isset($addressxd['city'])) {
					$elemtin3 = new DOMElement("city", $addressxd['city']);
					$elem24->appendChild($elemtin3);

				}
				if (isset($addressxd['stateOrProvince'])) {
					$elemtin4 = new DOMElement("stateOrProvince", $addressxd['stateOrProvince']);
					$elem24->appendChild($elemtin4);

				}
				if (isset($addressxd['stateOrProvinceDisplayName'])) {
					$elemtin5 = new DOMElement("stateOrProvinceDisplayName", $addressxd['stateOrProvinceDisplayName']);
					$elem24->appendChild($elemtin5);

				}
				if (isset($addressxd['zipOrPostalCode'])) {
					$elemtin6 = new DOMElement("zipOrPostalCode", $addressxd['zipOrPostalCode']);
					$elem24->appendChild($elemtin6);

				}
				if (isset($addressxd['country'])) {
					$elemtin7 = new DOMElement("country", $addressxd['country']);
					$elem24->appendChild($elemtin7);

				}
			}
		}
		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem8 = new DOMElement("networkClassOfService", $networkClassOfServicexd);
				$this->comando->appendChild($elem8);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCallLogsClearRequest14sp4 extends BroadsoftXMLCommand { 

	private $userId;
	private $x;
	private $choice0;

	/* Conjunto Recibe [Array] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x] 
	*/
	public function setData($userId, $x, $choice0) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($x) && (count($x) > 0)) {
			foreach ($x as $xxd ) {
			}
		}
		if (count($x) < x) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->x = $x;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCallLogsClearRequest14sp4");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if ($this->x != null) {
			$elem2 = new DOMElement("x", $this->x);
			$this->comando->appendChild($elem2);

		}
		$elem3 = new DOMElement("choice0", $this->choice0);
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCallPoliciesGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCallPoliciesGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCallPoliciesModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $redirectedCallsCOLPPrivacy;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	redirectedCallsCOLPPrivacy[xs:token (enumeration)]: Choices for Connected Line Identification Privacy on Redirected Calls valores [No Privacy, Privacy For External Calls, Privacy For All Calls] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $redirectedCallsCOLPPrivacy) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($redirectedCallsCOLPPrivacy) && (count($redirectedCallsCOLPPrivacy) > 0)) {
			foreach ($redirectedCallsCOLPPrivacy as $redirectedCallsCOLPPrivacyxd ) {
				if ($redirectedCallsCOLPPrivacyxd != null) {
					if (($redirectedCallsCOLPPrivacyxd != "No Privacy") && ($redirectedCallsCOLPPrivacyxd != "Privacy For External Calls") && ($redirectedCallsCOLPPrivacyxd != "Privacy For All Calls")) $ret = false;
				}
			}
		}
		if (count($redirectedCallsCOLPPrivacy) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->redirectedCallsCOLPPrivacy = $redirectedCallsCOLPPrivacy;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCallPoliciesModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->redirectedCallsCOLPPrivacy) && count($this->redirectedCallsCOLPPrivacy) > 0) {
			foreach ($this->redirectedCallsCOLPPrivacy as $redirectedCallsCOLPPrivacyxd) {
				$elem8 = new DOMElement("redirectedCallsCOLPPrivacy", $redirectedCallsCOLPPrivacyxd);
				$this->comando->appendChild($elem8);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCallProcessingGetPolicyRequest16 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCallProcessingGetPolicyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCallProcessingModifyPolicyRequest14sp7 extends BroadsoftXMLCommand { 

	private $userId;
	private $useUserCLIDSetting;
	private $useUserMediaSetting;
	private $useUserCallLimitsSetting;
	private $useMaxSimultaneousCalls;
	private $maxSimultaneousCalls;
	private $useMaxSimultaneousVideoCalls;
	private $maxSimultaneousVideoCalls;
	private $useMaxCallTimeForAnsweredCalls;
	private $maxCallTimeForAnsweredCallsMinutes;
	private $useMaxCallTimeForUnansweredCalls;
	private $maxCallTimeForUnansweredCallsMinutes;
	private $mediaPolicySelection;
	private $supportedMediaSetName;
	private $useMaxConcurrentRedirectedCalls;
	private $maxConcurrentRedirectedCalls;
	private $useMaxFindMeFollowMeDepth;
	private $maxFindMeFollowMeDepth;
	private $maxRedirectionDepth;
	private $useMaxConcurrentFindMeFollowMeInvocations;
	private $maxConcurrentFindMeFollowMeInvocations;
	private $clidPolicy;
	private $emergencyClidPolicy;
	private $allowAlternateNumbersForRedirectingIdentity;
	private $useGroupName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useUserCLIDSetting [xs:boolean]
	useUserMediaSetting [xs:boolean]
	useUserCallLimitsSetting [xs:boolean]
	useMaxSimultaneousCalls [xs:boolean]
	maxSimultaneousCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxSimultaneousVideoCalls [xs:boolean]
	maxSimultaneousVideoCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForAnsweredCalls [xs:boolean]
	maxCallTimeForAnsweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Answered Calls [maxInclusive = 2880]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForUnansweredCalls [xs:boolean]
	maxCallTimeForUnansweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Unanswered Calls [maxInclusive = 60]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]mediaPolicySelection[xs:token (enumeration)]: Media Policy Selections. valores [Use Uncompressed Codec, Use Supported Media Set, No Restrictions] [minOccurs = 0]
	[minOccurs = 0]supportedMediaSetName[xs:token]: Media Set name [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentRedirectedCalls [xs:boolean]
	maxConcurrentRedirectedCalls[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Redirected Calls [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxFindMeFollowMeDepth [xs:boolean]
	maxFindMeFollowMeDepth[xs:int - A signed 32-bit integer]: Maximum Number of Find Me Follow Me Depth [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]maxRedirectionDepth[xs:int - A signed 32-bit integer]: Maximum Number of Redirections Depth [maxInclusive = 15]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentFindMeFollowMeInvocations [xs:boolean]
	maxConcurrentFindMeFollowMeInvocations[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Find Me/Follow Me Invocations [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]clidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID, Use Group CLID] [minOccurs = 0]
	[minOccurs = 0]emergencyClidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID, Use Group CLID] [minOccurs = 0]
	[minOccurs = 0]allowAlternateNumbersForRedirectingIdentity [xs:boolean]
	useGroupName [xs:boolean]
	 
	*/
	public function setData($userId, $useUserCLIDSetting, $useUserMediaSetting, $useUserCallLimitsSetting, $useMaxSimultaneousCalls, $maxSimultaneousCalls, $useMaxSimultaneousVideoCalls, $maxSimultaneousVideoCalls, $useMaxCallTimeForAnsweredCalls, $maxCallTimeForAnsweredCallsMinutes, $useMaxCallTimeForUnansweredCalls, $maxCallTimeForUnansweredCallsMinutes, $mediaPolicySelection, $supportedMediaSetName, $useMaxConcurrentRedirectedCalls, $maxConcurrentRedirectedCalls, $useMaxFindMeFollowMeDepth, $maxFindMeFollowMeDepth, $maxRedirectionDepth, $useMaxConcurrentFindMeFollowMeInvocations, $maxConcurrentFindMeFollowMeInvocations, $clidPolicy, $emergencyClidPolicy, $allowAlternateNumbersForRedirectingIdentity, $useGroupName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($maxSimultaneousCalls) && (count($maxSimultaneousCalls) > 0)) {
			foreach ($maxSimultaneousCalls as $maxSimultaneousCallsxd ) {
				if ($maxSimultaneousCallsxd != null) {
					if (!is_numeric($maxSimultaneousCallsxd)) $ret = false;
					if (($maxSimultaneousCallsxd < -2147483648) || ($maxSimultaneousCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousCallsxd > 500) $ret = false;
					if ($maxSimultaneousCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousCalls) < 0) $ret = false;
		if (is_array($maxSimultaneousVideoCalls) && (count($maxSimultaneousVideoCalls) > 0)) {
			foreach ($maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd ) {
				if ($maxSimultaneousVideoCallsxd != null) {
					if (!is_numeric($maxSimultaneousVideoCallsxd)) $ret = false;
					if (($maxSimultaneousVideoCallsxd < -2147483648) || ($maxSimultaneousVideoCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousVideoCallsxd > 500) $ret = false;
					if ($maxSimultaneousVideoCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousVideoCalls) < 0) $ret = false;
		if (is_array($maxCallTimeForAnsweredCallsMinutes) && (count($maxCallTimeForAnsweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd ) {
				if ($maxCallTimeForAnsweredCallsMinutesxd != null) {
					if (!is_numeric($maxCallTimeForAnsweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForAnsweredCallsMinutesxd < -2147483648) || ($maxCallTimeForAnsweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd > 2880) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForAnsweredCallsMinutes) < 0) $ret = false;
		if (is_array($maxCallTimeForUnansweredCallsMinutes) && (count($maxCallTimeForUnansweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd ) {
				if ($maxCallTimeForUnansweredCallsMinutesxd != null) {
					if (!is_numeric($maxCallTimeForUnansweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForUnansweredCallsMinutesxd < -2147483648) || ($maxCallTimeForUnansweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd > 60) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForUnansweredCallsMinutes) < 0) $ret = false;
		if (is_array($mediaPolicySelection) && (count($mediaPolicySelection) > 0)) {
			foreach ($mediaPolicySelection as $mediaPolicySelectionxd ) {
				if ($mediaPolicySelectionxd != null) {
					if (($mediaPolicySelectionxd != "Use Uncompressed Codec") && ($mediaPolicySelectionxd != "Use Supported Media Set") && ($mediaPolicySelectionxd != "No Restrictions")) $ret = false;
				}
			}
		}
		if (count($mediaPolicySelection) < 0) $ret = false;
		if (is_array($supportedMediaSetName) && (count($supportedMediaSetName) > 0)) {
			foreach ($supportedMediaSetName as $supportedMediaSetNamexd ) {
				if ($supportedMediaSetNamexd != null) {
					if (strlen($supportedMediaSetNamexd) != strlen(trim( str_replace('  ', ' ', $supportedMediaSetNamexd)))) $ret = false;
					if (strlen($supportedMediaSetNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $supportedMediaSetNamexd)))))) $ret = false;
					if (strlen($supportedMediaSetNamexd) < 1) $ret = false;
					if (strlen($supportedMediaSetNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($supportedMediaSetName) < 0) $ret = false;
		if (is_array($maxConcurrentRedirectedCalls) && (count($maxConcurrentRedirectedCalls) > 0)) {
			foreach ($maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd ) {
				if ($maxConcurrentRedirectedCallsxd != null) {
					if (!is_numeric($maxConcurrentRedirectedCallsxd)) $ret = false;
					if (($maxConcurrentRedirectedCallsxd < -2147483648) || ($maxConcurrentRedirectedCallsxd > 2147483647)) $ret = false;
					if ($maxConcurrentRedirectedCallsxd > 32) $ret = false;
					if ($maxConcurrentRedirectedCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentRedirectedCalls) < 0) $ret = false;
		if (is_array($maxFindMeFollowMeDepth) && (count($maxFindMeFollowMeDepth) > 0)) {
			foreach ($maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd ) {
				if ($maxFindMeFollowMeDepthxd != null) {
					if (!is_numeric($maxFindMeFollowMeDepthxd)) $ret = false;
					if (($maxFindMeFollowMeDepthxd < -2147483648) || ($maxFindMeFollowMeDepthxd > 2147483647)) $ret = false;
					if ($maxFindMeFollowMeDepthxd > 10) $ret = false;
					if ($maxFindMeFollowMeDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxFindMeFollowMeDepth) < 0) $ret = false;
		if (is_array($maxRedirectionDepth) && (count($maxRedirectionDepth) > 0)) {
			foreach ($maxRedirectionDepth as $maxRedirectionDepthxd ) {
				if ($maxRedirectionDepthxd != null) {
					if (!is_numeric($maxRedirectionDepthxd)) $ret = false;
					if (($maxRedirectionDepthxd < -2147483648) || ($maxRedirectionDepthxd > 2147483647)) $ret = false;
					if ($maxRedirectionDepthxd > 15) $ret = false;
					if ($maxRedirectionDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxRedirectionDepth) < 0) $ret = false;
		if (is_array($maxConcurrentFindMeFollowMeInvocations) && (count($maxConcurrentFindMeFollowMeInvocations) > 0)) {
			foreach ($maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd ) {
				if ($maxConcurrentFindMeFollowMeInvocationsxd != null) {
					if (!is_numeric($maxConcurrentFindMeFollowMeInvocationsxd)) $ret = false;
					if (($maxConcurrentFindMeFollowMeInvocationsxd < -2147483648) || ($maxConcurrentFindMeFollowMeInvocationsxd > 2147483647)) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd > 32) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentFindMeFollowMeInvocations) < 0) $ret = false;
		if (is_array($clidPolicy) && (count($clidPolicy) > 0)) {
			foreach ($clidPolicy as $clidPolicyxd ) {
				if ($clidPolicyxd != null) {
					if (($clidPolicyxd != "Use DN") && ($clidPolicyxd != "Use Configurable CLID") && ($clidPolicyxd != "Use Group CLID")) $ret = false;
				}
			}
		}
		if (count($clidPolicy) < 0) $ret = false;
		if (is_array($emergencyClidPolicy) && (count($emergencyClidPolicy) > 0)) {
			foreach ($emergencyClidPolicy as $emergencyClidPolicyxd ) {
				if ($emergencyClidPolicyxd != null) {
					if (($emergencyClidPolicyxd != "Use DN") && ($emergencyClidPolicyxd != "Use Configurable CLID") && ($emergencyClidPolicyxd != "Use Group CLID")) $ret = false;
				}
			}
		}
		if (count($emergencyClidPolicy) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useUserCLIDSetting = $useUserCLIDSetting;
			$this->useUserMediaSetting = $useUserMediaSetting;
			$this->useUserCallLimitsSetting = $useUserCallLimitsSetting;
			$this->useMaxSimultaneousCalls = $useMaxSimultaneousCalls;
			$this->maxSimultaneousCalls = $maxSimultaneousCalls;
			$this->useMaxSimultaneousVideoCalls = $useMaxSimultaneousVideoCalls;
			$this->maxSimultaneousVideoCalls = $maxSimultaneousVideoCalls;
			$this->useMaxCallTimeForAnsweredCalls = $useMaxCallTimeForAnsweredCalls;
			$this->maxCallTimeForAnsweredCallsMinutes = $maxCallTimeForAnsweredCallsMinutes;
			$this->useMaxCallTimeForUnansweredCalls = $useMaxCallTimeForUnansweredCalls;
			$this->maxCallTimeForUnansweredCallsMinutes = $maxCallTimeForUnansweredCallsMinutes;
			$this->mediaPolicySelection = $mediaPolicySelection;
			$this->supportedMediaSetName = $supportedMediaSetName;
			$this->useMaxConcurrentRedirectedCalls = $useMaxConcurrentRedirectedCalls;
			$this->maxConcurrentRedirectedCalls = $maxConcurrentRedirectedCalls;
			$this->useMaxFindMeFollowMeDepth = $useMaxFindMeFollowMeDepth;
			$this->maxFindMeFollowMeDepth = $maxFindMeFollowMeDepth;
			$this->maxRedirectionDepth = $maxRedirectionDepth;
			$this->useMaxConcurrentFindMeFollowMeInvocations = $useMaxConcurrentFindMeFollowMeInvocations;
			$this->maxConcurrentFindMeFollowMeInvocations = $maxConcurrentFindMeFollowMeInvocations;
			$this->clidPolicy = $clidPolicy;
			$this->emergencyClidPolicy = $emergencyClidPolicy;
			$this->allowAlternateNumbersForRedirectingIdentity = $allowAlternateNumbersForRedirectingIdentity;
			$this->useGroupName = $useGroupName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCallProcessingModifyPolicyRequest14sp7");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useUserCLIDSetting", $this->useUserCLIDSetting);
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("useUserMediaSetting", $this->useUserMediaSetting);
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("useUserCallLimitsSetting", $this->useUserCallLimitsSetting);
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("useMaxSimultaneousCalls", $this->useMaxSimultaneousCalls);
		$this->comando->appendChild($elem5);

		if (is_array($this->maxSimultaneousCalls) && count($this->maxSimultaneousCalls) > 0) {
			foreach ($this->maxSimultaneousCalls as $maxSimultaneousCallsxd) {
				$elem8 = new DOMElement("maxSimultaneousCalls", $maxSimultaneousCallsxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem7 = new DOMElement("useMaxSimultaneousVideoCalls", $this->useMaxSimultaneousVideoCalls);
		$this->comando->appendChild($elem7);

		if (is_array($this->maxSimultaneousVideoCalls) && count($this->maxSimultaneousVideoCalls) > 0) {
			foreach ($this->maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd) {
				$elem8 = new DOMElement("maxSimultaneousVideoCalls", $maxSimultaneousVideoCallsxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem9 = new DOMElement("useMaxCallTimeForAnsweredCalls", $this->useMaxCallTimeForAnsweredCalls);
		$this->comando->appendChild($elem9);

		if (is_array($this->maxCallTimeForAnsweredCallsMinutes) && count($this->maxCallTimeForAnsweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd) {
				$elem8 = new DOMElement("maxCallTimeForAnsweredCallsMinutes", $maxCallTimeForAnsweredCallsMinutesxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem11 = new DOMElement("useMaxCallTimeForUnansweredCalls", $this->useMaxCallTimeForUnansweredCalls);
		$this->comando->appendChild($elem11);

		if (is_array($this->maxCallTimeForUnansweredCallsMinutes) && count($this->maxCallTimeForUnansweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd) {
				$elem8 = new DOMElement("maxCallTimeForUnansweredCallsMinutes", $maxCallTimeForUnansweredCallsMinutesxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->mediaPolicySelection) && count($this->mediaPolicySelection) > 0) {
			foreach ($this->mediaPolicySelection as $mediaPolicySelectionxd) {
				$elem8 = new DOMElement("mediaPolicySelection", $mediaPolicySelectionxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->supportedMediaSetName) && count($this->supportedMediaSetName) > 0) {
			foreach ($this->supportedMediaSetName as $supportedMediaSetNamexd) {
				$elem8 = new DOMElement("supportedMediaSetName", $supportedMediaSetNamexd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem15 = new DOMElement("useMaxConcurrentRedirectedCalls", $this->useMaxConcurrentRedirectedCalls);
		$this->comando->appendChild($elem15);

		if (is_array($this->maxConcurrentRedirectedCalls) && count($this->maxConcurrentRedirectedCalls) > 0) {
			foreach ($this->maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd) {
				$elem8 = new DOMElement("maxConcurrentRedirectedCalls", $maxConcurrentRedirectedCallsxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem17 = new DOMElement("useMaxFindMeFollowMeDepth", $this->useMaxFindMeFollowMeDepth);
		$this->comando->appendChild($elem17);

		if (is_array($this->maxFindMeFollowMeDepth) && count($this->maxFindMeFollowMeDepth) > 0) {
			foreach ($this->maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd) {
				$elem8 = new DOMElement("maxFindMeFollowMeDepth", $maxFindMeFollowMeDepthxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->maxRedirectionDepth) && count($this->maxRedirectionDepth) > 0) {
			foreach ($this->maxRedirectionDepth as $maxRedirectionDepthxd) {
				$elem8 = new DOMElement("maxRedirectionDepth", $maxRedirectionDepthxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem20 = new DOMElement("useMaxConcurrentFindMeFollowMeInvocations", $this->useMaxConcurrentFindMeFollowMeInvocations);
		$this->comando->appendChild($elem20);

		if (is_array($this->maxConcurrentFindMeFollowMeInvocations) && count($this->maxConcurrentFindMeFollowMeInvocations) > 0) {
			foreach ($this->maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd) {
				$elem8 = new DOMElement("maxConcurrentFindMeFollowMeInvocations", $maxConcurrentFindMeFollowMeInvocationsxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->clidPolicy) && count($this->clidPolicy) > 0) {
			foreach ($this->clidPolicy as $clidPolicyxd) {
				$elem8 = new DOMElement("clidPolicy", $clidPolicyxd);
				$this->comando->appendChild($elem8);

			}
		}
		if (is_array($this->emergencyClidPolicy) && count($this->emergencyClidPolicy) > 0) {
			foreach ($this->emergencyClidPolicy as $emergencyClidPolicyxd) {
				$elem8 = new DOMElement("emergencyClidPolicy", $emergencyClidPolicyxd);
				$this->comando->appendChild($elem8);

			}
		}
		$elem24 = new DOMElement("allowAlternateNumbersForRedirectingIdentity", $this->allowAlternateNumbersForRedirectingIdentity);
		$this->comando->appendChild($elem24);

		$elem25 = new DOMElement("useGroupName", $this->useGroupName);
		$this->comando->appendChild($elem25);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCommunicationBarringAuthorizationCodeAddListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $code;

	/* Conjunto Recibe [Communication Barring Authorization Code entry.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	code es un compuesto de: 
	code[xs:token]: Communication Barring Authorization Code. [minLength = 2] [maxLength = 14]
	description[xs:token]: Communication Barring Authorization Code Description. [minLength = 1] [maxLength = 80]
	[minOccurs = 1] 
	*/
	public function setData($userId, $code) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if (strlen($codexd['code']) != strlen(trim( str_replace('  ', ' ', $codexd['code'])))) $ret = false;
				if (strlen($codexd['code']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd['code'])))))) $ret = false;
				if (strlen($codexd['code']) < 2) $ret = false;
				if (strlen($codexd['code']) > 14) $ret = false;
				if (strlen($codexd['description']) != strlen(trim( str_replace('  ', ' ', $codexd['description'])))) $ret = false;
				if (strlen($codexd['description']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd['description'])))))) $ret = false;
				if (strlen($codexd['description']) < 1) $ret = false;
				if (strlen($codexd['description']) > 80) $ret = false;
			}
		}
		if (count($code) == 0) $ret = false;
		if (count($code) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCommunicationBarringAuthorizationCodeAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->code) && count($this->code) > 0) {
			$elem2 = new DOMElement("code");
			$this->comando->appendChild($elem2);

			foreach ($this->code as $codexd) {
				if (isset($codexd['code'])) {
					$elemtin1 = new DOMElement("code", $codexd['code']);
					$elem2->appendChild($elemtin1);

				}
				if (isset($codexd['description'])) {
					$elemtin2 = new DOMElement("description", $codexd['description']);
					$elem2->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCommunicationBarringAuthorizationCodeDeleteListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $code;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	code[xs:token]: Communication Barring Authorization Code. [minLength = 2] [maxLength = 14]
	[minOccurs = 1] 
	*/
	public function setData($userId, $code) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if (strlen($codexd) != strlen(trim( str_replace('  ', ' ', $codexd)))) $ret = false;
				if (strlen($codexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd)))))) $ret = false;
				if (strlen($codexd) < 2) $ret = false;
				if (strlen($codexd) > 14) $ret = false;
			}
		}
		if (count($code) == 0) $ret = false;
		if (count($code) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCommunicationBarringAuthorizationCodeDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->code) && count($this->code) > 0) {
			foreach ($this->code as $codexd) {
				$elem3 = new DOMElement("code", $codexd);
				$this->comando->appendChild($elem3);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserCommunicationBarringAuthorizationCodeGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserCommunicationBarringAuthorizationCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserFeatureAccessCodeGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserFeatureAccessCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserGetListInGroupRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $GroupId;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaExactUserDepartment;
	private $searchCriteriaExactUserInTrunkGroup;

	/* Conjunto Recibe [Criteria for searching for user in/not in a trunk group.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	GroupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	searchCriteriaExactUserInTrunkGroup es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $GroupId, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaEmailAddress, $searchCriteriaExactUserDepartment, $searchCriteriaExactUserInTrunkGroup) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($GroupId) != strlen(trim( str_replace('  ', ' ', $GroupId)))) $ret = false;
		if (strlen($GroupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $GroupId)))))) $ret = false;
		if (strlen($GroupId) < 1) $ret = false;
		if (strlen($GroupId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ($responseSizeLimitxd != null) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ($searchCriteriaUserLastNamexd['mode'] != null) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserLastNamexd['value'] != null) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ($searchCriteriaUserFirstNamexd['mode'] != null) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserFirstNamexd['value'] != null) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ($searchCriteriaDnxd['mode'] != null) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaDnxd['value'] != null) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ($searchCriteriaEmailAddressxd['mode'] != null) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaEmailAddressxd['value'] != null) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if (is_array($searchCriteriaExactUserInTrunkGroup) && (count($searchCriteriaExactUserInTrunkGroup) > 0)) {
			foreach ($searchCriteriaExactUserInTrunkGroup as $searchCriteriaExactUserInTrunkGroupxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->GroupId = $GroupId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			$this->searchCriteriaExactUserInTrunkGroup = $searchCriteriaExactUserInTrunkGroup;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserGetListInGroupRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("GroupId", $this->GroupId);
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem3 = new DOMElement("responseSizeLimit", $responseSizeLimitxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserLastNamexd['mode']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserLastNamexd['value']);
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserFirstNamexd['mode']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserFirstNamexd['value']);
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem6 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaDnxd['mode']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaDnxd['value']);
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem7 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaEmailAddressxd['mode']);
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaEmailAddressxd['value']);
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem8 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", $searchCriteriaExactUserDepartmentxd['']);
					$elem8->appendChild($elemtin1);

				}
			}
		}
		$elem9 = new DOMElement("searchCriteriaExactUserInTrunkGroup", $this->searchCriteriaExactUserInTrunkGroup);
		$this->comando->appendChild($elem9);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserGetListInServiceProviderRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaExactUserInTrunkGroup;

	/* Conjunto Recibe [Criteria for searching for user in/not in a trunk group.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserInTrunkGroup es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaEmailAddress, $searchCriteriaExactUserInTrunkGroup) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ($responseSizeLimitxd != null) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ($searchCriteriaUserLastNamexd['mode'] != null) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserLastNamexd['value'] != null) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ($searchCriteriaUserFirstNamexd['mode'] != null) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserFirstNamexd['value'] != null) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ($searchCriteriaDnxd['mode'] != null) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaDnxd['value'] != null) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ($searchCriteriaEmailAddressxd['mode'] != null) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaEmailAddressxd['value'] != null) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserInTrunkGroup) && (count($searchCriteriaExactUserInTrunkGroup) > 0)) {
			foreach ($searchCriteriaExactUserInTrunkGroup as $searchCriteriaExactUserInTrunkGroupxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaExactUserInTrunkGroup = $searchCriteriaExactUserInTrunkGroup;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserGetListInServiceProviderRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem2 = new DOMElement("responseSizeLimit", $responseSizeLimitxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem3 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserLastNamexd['mode']);
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserLastNamexd['value']);
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserFirstNamexd['mode']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserFirstNamexd['value']);
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem5 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaDnxd['mode']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaDnxd['value']);
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem6 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaEmailAddressxd['mode']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaEmailAddressxd['value']);
					$elem6->appendChild($elemtin2);

				}
			}
		}
		$elem7 = new DOMElement("searchCriteriaExactUserInTrunkGroup", $this->searchCriteriaExactUserInTrunkGroup);
		$this->comando->appendChild($elem7);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserGetListInSystemRequest extends BroadsoftXMLCommand { 

	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaGroupId;
	private $searchCriteriaExactServiceProvider;
	private $searchCriteriaExactUserInTrunkGroup;
	private $searchCriteriaExactUserNetworkClassOfService;

	/* Conjunto Recibe [Criteria for searching for users with a specified network class of service.] 

	Conjunto Recibe [Criteria for searching for user in/not in a trunk group.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified service provider.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactServiceProvider es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserInTrunkGroup es un compuesto de: 
	searchCriteriaExactUserNetworkClassOfService es un compuesto de: 
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaEmailAddress, $searchCriteriaGroupId, $searchCriteriaExactServiceProvider, $searchCriteriaExactUserInTrunkGroup, $searchCriteriaExactUserNetworkClassOfService) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ($responseSizeLimitxd != null) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ($searchCriteriaUserLastNamexd['mode'] != null) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserLastNamexd['value'] != null) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ($searchCriteriaUserFirstNamexd['mode'] != null) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserFirstNamexd['value'] != null) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ($searchCriteriaDnxd['mode'] != null) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaDnxd['value'] != null) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ($searchCriteriaEmailAddressxd['mode'] != null) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaEmailAddressxd['value'] != null) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ($searchCriteriaGroupIdxd['mode'] != null) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaGroupIdxd['value'] != null) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaExactServiceProvider) && (count($searchCriteriaExactServiceProvider) > 0)) {
			foreach ($searchCriteriaExactServiceProvider as $searchCriteriaExactServiceProviderxd ) {
				if ($searchCriteriaExactServiceProviderxd['serviceProviderId'] != null) {
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactServiceProviderxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactServiceProviderxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactServiceProvider) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserInTrunkGroup) && (count($searchCriteriaExactUserInTrunkGroup) > 0)) {
			foreach ($searchCriteriaExactUserInTrunkGroup as $searchCriteriaExactUserInTrunkGroupxd ) {
			}
		}
		if (is_array($searchCriteriaExactUserNetworkClassOfService) && (count($searchCriteriaExactUserNetworkClassOfService) > 0)) {
			foreach ($searchCriteriaExactUserNetworkClassOfService as $searchCriteriaExactUserNetworkClassOfServicexd ) {
				if ($searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService'] != null) {
					if (strlen($searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService'])))) $ret = false;
					if (strlen($searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService']) > 40) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserNetworkClassOfService) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaExactServiceProvider = $searchCriteriaExactServiceProvider;
			$this->searchCriteriaExactUserInTrunkGroup = $searchCriteriaExactUserInTrunkGroup;
			$this->searchCriteriaExactUserNetworkClassOfService = $searchCriteriaExactUserNetworkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserGetListInSystemRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem3 = new DOMElement("responseSizeLimit", $responseSizeLimitxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem2 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem2);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserLastNamexd['mode']);
					$elem2->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserLastNamexd['value']);
					$elem2->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem3 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserFirstNamexd['mode']);
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserFirstNamexd['value']);
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem4 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaDnxd['mode']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaDnxd['value']);
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem5 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaEmailAddressxd['mode']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaEmailAddressxd['value']);
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem6 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaGroupIdxd['mode']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaGroupIdxd['value']);
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactServiceProvider) && count($this->searchCriteriaExactServiceProvider) > 0) {
			$elem7 = new DOMElement("searchCriteriaExactServiceProvider");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExactServiceProvider as $searchCriteriaExactServiceProviderxd) {
				if (isset($searchCriteriaExactServiceProviderxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", $searchCriteriaExactServiceProviderxd['serviceProviderId']);
					$elem7->appendChild($elemtin1);

				}
			}
		}
		$elem8 = new DOMElement("searchCriteriaExactUserInTrunkGroup", $this->searchCriteriaExactUserInTrunkGroup);
		$this->comando->appendChild($elem8);

		if (is_array($this->searchCriteriaExactUserNetworkClassOfService) && count($this->searchCriteriaExactUserNetworkClassOfService) > 0) {
			$elem9 = new DOMElement("searchCriteriaExactUserNetworkClassOfService");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaExactUserNetworkClassOfService as $searchCriteriaExactUserNetworkClassOfServicexd) {
				if (isset($searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService'])) {
					$elemtin1 = new DOMElement("networkClassOfService", $searchCriteriaExactUserNetworkClassOfServicexd['networkClassOfService']);
					$elem9->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserHolidayScheduleAddRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $holidayScheduleName;
	private $holiday01;
	private $holiday02;
	private $holiday03;
	private $holiday04;
	private $holiday05;
	private $holiday06;
	private $holiday07;
	private $holiday08;
	private $holiday09;
	private $holiday10;
	private $holiday11;
	private $holiday12;
	private $holiday13;
	private $holiday14;
	private $holiday15;
	private $holiday16;
	private $holiday17;
	private $holiday18;
	private $holiday19;
	private $holiday20;

	/* Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	holiday01 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday02 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday03 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday04 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday05 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday06 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday07 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday08 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday09 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday10 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday11 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday12 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday13 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday14 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday15 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday16 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday17 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday18 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday19 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday20 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $holidayScheduleName, $holiday01, $holiday02, $holiday03, $holiday04, $holiday05, $holiday06, $holiday07, $holiday08, $holiday09, $holiday10, $holiday11, $holiday12, $holiday13, $holiday14, $holiday15, $holiday16, $holiday17, $holiday18, $holiday19, $holiday20) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if (is_array($holiday01) && (count($holiday01) > 0)) {
			foreach ($holiday01 as $holiday01xd ) {
				if ($holiday01xd['holidayName'] != null) {
					if (strlen($holiday01xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday01xd['holidayName'])))) $ret = false;
					if (strlen($holiday01xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday01xd['holidayName'])))))) $ret = false;
					if (strlen($holiday01xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday01xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday01) < 0) $ret = false;
		if (is_array($holiday02) && (count($holiday02) > 0)) {
			foreach ($holiday02 as $holiday02xd ) {
				if ($holiday02xd['holidayName'] != null) {
					if (strlen($holiday02xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday02xd['holidayName'])))) $ret = false;
					if (strlen($holiday02xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday02xd['holidayName'])))))) $ret = false;
					if (strlen($holiday02xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday02xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday02) < 0) $ret = false;
		if (is_array($holiday03) && (count($holiday03) > 0)) {
			foreach ($holiday03 as $holiday03xd ) {
				if ($holiday03xd['holidayName'] != null) {
					if (strlen($holiday03xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday03xd['holidayName'])))) $ret = false;
					if (strlen($holiday03xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday03xd['holidayName'])))))) $ret = false;
					if (strlen($holiday03xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday03xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday03) < 0) $ret = false;
		if (is_array($holiday04) && (count($holiday04) > 0)) {
			foreach ($holiday04 as $holiday04xd ) {
				if ($holiday04xd['holidayName'] != null) {
					if (strlen($holiday04xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday04xd['holidayName'])))) $ret = false;
					if (strlen($holiday04xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday04xd['holidayName'])))))) $ret = false;
					if (strlen($holiday04xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday04xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday04) < 0) $ret = false;
		if (is_array($holiday05) && (count($holiday05) > 0)) {
			foreach ($holiday05 as $holiday05xd ) {
				if ($holiday05xd['holidayName'] != null) {
					if (strlen($holiday05xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday05xd['holidayName'])))) $ret = false;
					if (strlen($holiday05xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday05xd['holidayName'])))))) $ret = false;
					if (strlen($holiday05xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday05xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday05) < 0) $ret = false;
		if (is_array($holiday06) && (count($holiday06) > 0)) {
			foreach ($holiday06 as $holiday06xd ) {
				if ($holiday06xd['holidayName'] != null) {
					if (strlen($holiday06xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday06xd['holidayName'])))) $ret = false;
					if (strlen($holiday06xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday06xd['holidayName'])))))) $ret = false;
					if (strlen($holiday06xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday06xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday06) < 0) $ret = false;
		if (is_array($holiday07) && (count($holiday07) > 0)) {
			foreach ($holiday07 as $holiday07xd ) {
				if ($holiday07xd['holidayName'] != null) {
					if (strlen($holiday07xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday07xd['holidayName'])))) $ret = false;
					if (strlen($holiday07xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday07xd['holidayName'])))))) $ret = false;
					if (strlen($holiday07xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday07xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday07) < 0) $ret = false;
		if (is_array($holiday08) && (count($holiday08) > 0)) {
			foreach ($holiday08 as $holiday08xd ) {
				if ($holiday08xd['holidayName'] != null) {
					if (strlen($holiday08xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday08xd['holidayName'])))) $ret = false;
					if (strlen($holiday08xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday08xd['holidayName'])))))) $ret = false;
					if (strlen($holiday08xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday08xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday08) < 0) $ret = false;
		if (is_array($holiday09) && (count($holiday09) > 0)) {
			foreach ($holiday09 as $holiday09xd ) {
				if ($holiday09xd['holidayName'] != null) {
					if (strlen($holiday09xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday09xd['holidayName'])))) $ret = false;
					if (strlen($holiday09xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday09xd['holidayName'])))))) $ret = false;
					if (strlen($holiday09xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday09xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday09) < 0) $ret = false;
		if (is_array($holiday10) && (count($holiday10) > 0)) {
			foreach ($holiday10 as $holiday10xd ) {
				if ($holiday10xd['holidayName'] != null) {
					if (strlen($holiday10xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday10xd['holidayName'])))) $ret = false;
					if (strlen($holiday10xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday10xd['holidayName'])))))) $ret = false;
					if (strlen($holiday10xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday10xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday10) < 0) $ret = false;
		if (is_array($holiday11) && (count($holiday11) > 0)) {
			foreach ($holiday11 as $holiday11xd ) {
				if ($holiday11xd['holidayName'] != null) {
					if (strlen($holiday11xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday11xd['holidayName'])))) $ret = false;
					if (strlen($holiday11xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday11xd['holidayName'])))))) $ret = false;
					if (strlen($holiday11xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday11xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday11) < 0) $ret = false;
		if (is_array($holiday12) && (count($holiday12) > 0)) {
			foreach ($holiday12 as $holiday12xd ) {
				if ($holiday12xd['holidayName'] != null) {
					if (strlen($holiday12xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday12xd['holidayName'])))) $ret = false;
					if (strlen($holiday12xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday12xd['holidayName'])))))) $ret = false;
					if (strlen($holiday12xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday12xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday12) < 0) $ret = false;
		if (is_array($holiday13) && (count($holiday13) > 0)) {
			foreach ($holiday13 as $holiday13xd ) {
				if ($holiday13xd['holidayName'] != null) {
					if (strlen($holiday13xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday13xd['holidayName'])))) $ret = false;
					if (strlen($holiday13xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday13xd['holidayName'])))))) $ret = false;
					if (strlen($holiday13xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday13xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday13) < 0) $ret = false;
		if (is_array($holiday14) && (count($holiday14) > 0)) {
			foreach ($holiday14 as $holiday14xd ) {
				if ($holiday14xd['holidayName'] != null) {
					if (strlen($holiday14xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday14xd['holidayName'])))) $ret = false;
					if (strlen($holiday14xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday14xd['holidayName'])))))) $ret = false;
					if (strlen($holiday14xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday14xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday14) < 0) $ret = false;
		if (is_array($holiday15) && (count($holiday15) > 0)) {
			foreach ($holiday15 as $holiday15xd ) {
				if ($holiday15xd['holidayName'] != null) {
					if (strlen($holiday15xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday15xd['holidayName'])))) $ret = false;
					if (strlen($holiday15xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday15xd['holidayName'])))))) $ret = false;
					if (strlen($holiday15xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday15xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday15) < 0) $ret = false;
		if (is_array($holiday16) && (count($holiday16) > 0)) {
			foreach ($holiday16 as $holiday16xd ) {
				if ($holiday16xd['holidayName'] != null) {
					if (strlen($holiday16xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday16xd['holidayName'])))) $ret = false;
					if (strlen($holiday16xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday16xd['holidayName'])))))) $ret = false;
					if (strlen($holiday16xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday16xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday16) < 0) $ret = false;
		if (is_array($holiday17) && (count($holiday17) > 0)) {
			foreach ($holiday17 as $holiday17xd ) {
				if ($holiday17xd['holidayName'] != null) {
					if (strlen($holiday17xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday17xd['holidayName'])))) $ret = false;
					if (strlen($holiday17xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday17xd['holidayName'])))))) $ret = false;
					if (strlen($holiday17xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday17xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday17) < 0) $ret = false;
		if (is_array($holiday18) && (count($holiday18) > 0)) {
			foreach ($holiday18 as $holiday18xd ) {
				if ($holiday18xd['holidayName'] != null) {
					if (strlen($holiday18xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday18xd['holidayName'])))) $ret = false;
					if (strlen($holiday18xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday18xd['holidayName'])))))) $ret = false;
					if (strlen($holiday18xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday18xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday18) < 0) $ret = false;
		if (is_array($holiday19) && (count($holiday19) > 0)) {
			foreach ($holiday19 as $holiday19xd ) {
				if ($holiday19xd['holidayName'] != null) {
					if (strlen($holiday19xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday19xd['holidayName'])))) $ret = false;
					if (strlen($holiday19xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday19xd['holidayName'])))))) $ret = false;
					if (strlen($holiday19xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday19xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday19) < 0) $ret = false;
		if (is_array($holiday20) && (count($holiday20) > 0)) {
			foreach ($holiday20 as $holiday20xd ) {
				if ($holiday20xd['holidayName'] != null) {
					if (strlen($holiday20xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday20xd['holidayName'])))) $ret = false;
					if (strlen($holiday20xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday20xd['holidayName'])))))) $ret = false;
					if (strlen($holiday20xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday20xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->holidayScheduleName = $holidayScheduleName;
			$this->holiday01 = $holiday01;
			$this->holiday02 = $holiday02;
			$this->holiday03 = $holiday03;
			$this->holiday04 = $holiday04;
			$this->holiday05 = $holiday05;
			$this->holiday06 = $holiday06;
			$this->holiday07 = $holiday07;
			$this->holiday08 = $holiday08;
			$this->holiday09 = $holiday09;
			$this->holiday10 = $holiday10;
			$this->holiday11 = $holiday11;
			$this->holiday12 = $holiday12;
			$this->holiday13 = $holiday13;
			$this->holiday14 = $holiday14;
			$this->holiday15 = $holiday15;
			$this->holiday16 = $holiday16;
			$this->holiday17 = $holiday17;
			$this->holiday18 = $holiday18;
			$this->holiday19 = $holiday19;
			$this->holiday20 = $holiday20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserHolidayScheduleAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("holidayScheduleName", $this->holidayScheduleName);
		$this->comando->appendChild($elem2);

		if (is_array($this->holiday01) && count($this->holiday01) > 0) {
			$elem3 = new DOMElement("holiday01");
			$this->comando->appendChild($elem3);

			foreach ($this->holiday01 as $holiday01xd) {
				if (isset($holiday01xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday01xd['holidayName']);
					$elem3->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday02) && count($this->holiday02) > 0) {
			$elem4 = new DOMElement("holiday02");
			$this->comando->appendChild($elem4);

			foreach ($this->holiday02 as $holiday02xd) {
				if (isset($holiday02xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday02xd['holidayName']);
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday03) && count($this->holiday03) > 0) {
			$elem5 = new DOMElement("holiday03");
			$this->comando->appendChild($elem5);

			foreach ($this->holiday03 as $holiday03xd) {
				if (isset($holiday03xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday03xd['holidayName']);
					$elem5->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday04) && count($this->holiday04) > 0) {
			$elem6 = new DOMElement("holiday04");
			$this->comando->appendChild($elem6);

			foreach ($this->holiday04 as $holiday04xd) {
				if (isset($holiday04xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday04xd['holidayName']);
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday05) && count($this->holiday05) > 0) {
			$elem7 = new DOMElement("holiday05");
			$this->comando->appendChild($elem7);

			foreach ($this->holiday05 as $holiday05xd) {
				if (isset($holiday05xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday05xd['holidayName']);
					$elem7->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday06) && count($this->holiday06) > 0) {
			$elem8 = new DOMElement("holiday06");
			$this->comando->appendChild($elem8);

			foreach ($this->holiday06 as $holiday06xd) {
				if (isset($holiday06xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday06xd['holidayName']);
					$elem8->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday07) && count($this->holiday07) > 0) {
			$elem9 = new DOMElement("holiday07");
			$this->comando->appendChild($elem9);

			foreach ($this->holiday07 as $holiday07xd) {
				if (isset($holiday07xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday07xd['holidayName']);
					$elem9->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday08) && count($this->holiday08) > 0) {
			$elem10 = new DOMElement("holiday08");
			$this->comando->appendChild($elem10);

			foreach ($this->holiday08 as $holiday08xd) {
				if (isset($holiday08xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday08xd['holidayName']);
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday09) && count($this->holiday09) > 0) {
			$elem11 = new DOMElement("holiday09");
			$this->comando->appendChild($elem11);

			foreach ($this->holiday09 as $holiday09xd) {
				if (isset($holiday09xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday09xd['holidayName']);
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday10) && count($this->holiday10) > 0) {
			$elem12 = new DOMElement("holiday10");
			$this->comando->appendChild($elem12);

			foreach ($this->holiday10 as $holiday10xd) {
				if (isset($holiday10xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday10xd['holidayName']);
					$elem12->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday11) && count($this->holiday11) > 0) {
			$elem13 = new DOMElement("holiday11");
			$this->comando->appendChild($elem13);

			foreach ($this->holiday11 as $holiday11xd) {
				if (isset($holiday11xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday11xd['holidayName']);
					$elem13->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday12) && count($this->holiday12) > 0) {
			$elem14 = new DOMElement("holiday12");
			$this->comando->appendChild($elem14);

			foreach ($this->holiday12 as $holiday12xd) {
				if (isset($holiday12xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday12xd['holidayName']);
					$elem14->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday13) && count($this->holiday13) > 0) {
			$elem15 = new DOMElement("holiday13");
			$this->comando->appendChild($elem15);

			foreach ($this->holiday13 as $holiday13xd) {
				if (isset($holiday13xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday13xd['holidayName']);
					$elem15->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday14) && count($this->holiday14) > 0) {
			$elem16 = new DOMElement("holiday14");
			$this->comando->appendChild($elem16);

			foreach ($this->holiday14 as $holiday14xd) {
				if (isset($holiday14xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday14xd['holidayName']);
					$elem16->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday15) && count($this->holiday15) > 0) {
			$elem17 = new DOMElement("holiday15");
			$this->comando->appendChild($elem17);

			foreach ($this->holiday15 as $holiday15xd) {
				if (isset($holiday15xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday15xd['holidayName']);
					$elem17->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday16) && count($this->holiday16) > 0) {
			$elem18 = new DOMElement("holiday16");
			$this->comando->appendChild($elem18);

			foreach ($this->holiday16 as $holiday16xd) {
				if (isset($holiday16xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday16xd['holidayName']);
					$elem18->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday17) && count($this->holiday17) > 0) {
			$elem19 = new DOMElement("holiday17");
			$this->comando->appendChild($elem19);

			foreach ($this->holiday17 as $holiday17xd) {
				if (isset($holiday17xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday17xd['holidayName']);
					$elem19->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday18) && count($this->holiday18) > 0) {
			$elem20 = new DOMElement("holiday18");
			$this->comando->appendChild($elem20);

			foreach ($this->holiday18 as $holiday18xd) {
				if (isset($holiday18xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday18xd['holidayName']);
					$elem20->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday19) && count($this->holiday19) > 0) {
			$elem21 = new DOMElement("holiday19");
			$this->comando->appendChild($elem21);

			foreach ($this->holiday19 as $holiday19xd) {
				if (isset($holiday19xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday19xd['holidayName']);
					$elem21->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday20) && count($this->holiday20) > 0) {
			$elem22 = new DOMElement("holiday20");
			$this->comando->appendChild($elem22);

			foreach ($this->holiday20 as $holiday20xd) {
				if (isset($holiday20xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday20xd['holidayName']);
					$elem22->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserHolidayScheduleDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $holidayScheduleName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($userId, $holidayScheduleName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->holidayScheduleName = $holidayScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserHolidayScheduleDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("holidayScheduleName", $this->holidayScheduleName);
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserHolidayScheduleGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserHolidayScheduleGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserHolidayScheduleGetRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $holidayScheduleName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($userId, $holidayScheduleName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->holidayScheduleName = $holidayScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserHolidayScheduleGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("holidayScheduleName", $this->holidayScheduleName);
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserHolidayScheduleModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $holidayScheduleName;
	private $newHolidayScheduleName;
	private $holiday01;
	private $holiday02;
	private $holiday03;
	private $holiday04;
	private $holiday05;
	private $holiday06;
	private $holiday07;
	private $holiday08;
	private $holiday09;
	private $holiday10;
	private $holiday11;
	private $holiday12;
	private $holiday13;
	private $holiday14;
	private $holiday15;
	private $holiday16;
	private $holiday17;
	private $holiday18;
	private $holiday19;
	private $holiday20;

	/* Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	newHolidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday01 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday02 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday03 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday04 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday05 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday06 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday07 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday08 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday09 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday10 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday11 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday12 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday13 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday14 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday15 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday16 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday17 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday18 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday19 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday20 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $holidayScheduleName, $newHolidayScheduleName, $holiday01, $holiday02, $holiday03, $holiday04, $holiday05, $holiday06, $holiday07, $holiday08, $holiday09, $holiday10, $holiday11, $holiday12, $holiday13, $holiday14, $holiday15, $holiday16, $holiday17, $holiday18, $holiday19, $holiday20) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if (is_array($newHolidayScheduleName) && (count($newHolidayScheduleName) > 0)) {
			foreach ($newHolidayScheduleName as $newHolidayScheduleNamexd ) {
				if ($newHolidayScheduleNamexd != null) {
					if (strlen($newHolidayScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $newHolidayScheduleNamexd)))) $ret = false;
					if (strlen($newHolidayScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newHolidayScheduleNamexd)))))) $ret = false;
					if (strlen($newHolidayScheduleNamexd) < 1) $ret = false;
					if (strlen($newHolidayScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newHolidayScheduleName) < 0) $ret = false;
		if (is_array($holiday01) && (count($holiday01) > 0)) {
			foreach ($holiday01 as $holiday01xd ) {
				if ($holiday01xd['holidayName'] != null) {
					if (strlen($holiday01xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday01xd['holidayName'])))) $ret = false;
					if (strlen($holiday01xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday01xd['holidayName'])))))) $ret = false;
					if (strlen($holiday01xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday01xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday01) < 0) $ret = false;
		if (is_array($holiday02) && (count($holiday02) > 0)) {
			foreach ($holiday02 as $holiday02xd ) {
				if ($holiday02xd['holidayName'] != null) {
					if (strlen($holiday02xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday02xd['holidayName'])))) $ret = false;
					if (strlen($holiday02xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday02xd['holidayName'])))))) $ret = false;
					if (strlen($holiday02xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday02xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday02) < 0) $ret = false;
		if (is_array($holiday03) && (count($holiday03) > 0)) {
			foreach ($holiday03 as $holiday03xd ) {
				if ($holiday03xd['holidayName'] != null) {
					if (strlen($holiday03xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday03xd['holidayName'])))) $ret = false;
					if (strlen($holiday03xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday03xd['holidayName'])))))) $ret = false;
					if (strlen($holiday03xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday03xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday03) < 0) $ret = false;
		if (is_array($holiday04) && (count($holiday04) > 0)) {
			foreach ($holiday04 as $holiday04xd ) {
				if ($holiday04xd['holidayName'] != null) {
					if (strlen($holiday04xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday04xd['holidayName'])))) $ret = false;
					if (strlen($holiday04xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday04xd['holidayName'])))))) $ret = false;
					if (strlen($holiday04xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday04xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday04) < 0) $ret = false;
		if (is_array($holiday05) && (count($holiday05) > 0)) {
			foreach ($holiday05 as $holiday05xd ) {
				if ($holiday05xd['holidayName'] != null) {
					if (strlen($holiday05xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday05xd['holidayName'])))) $ret = false;
					if (strlen($holiday05xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday05xd['holidayName'])))))) $ret = false;
					if (strlen($holiday05xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday05xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday05) < 0) $ret = false;
		if (is_array($holiday06) && (count($holiday06) > 0)) {
			foreach ($holiday06 as $holiday06xd ) {
				if ($holiday06xd['holidayName'] != null) {
					if (strlen($holiday06xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday06xd['holidayName'])))) $ret = false;
					if (strlen($holiday06xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday06xd['holidayName'])))))) $ret = false;
					if (strlen($holiday06xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday06xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday06) < 0) $ret = false;
		if (is_array($holiday07) && (count($holiday07) > 0)) {
			foreach ($holiday07 as $holiday07xd ) {
				if ($holiday07xd['holidayName'] != null) {
					if (strlen($holiday07xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday07xd['holidayName'])))) $ret = false;
					if (strlen($holiday07xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday07xd['holidayName'])))))) $ret = false;
					if (strlen($holiday07xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday07xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday07) < 0) $ret = false;
		if (is_array($holiday08) && (count($holiday08) > 0)) {
			foreach ($holiday08 as $holiday08xd ) {
				if ($holiday08xd['holidayName'] != null) {
					if (strlen($holiday08xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday08xd['holidayName'])))) $ret = false;
					if (strlen($holiday08xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday08xd['holidayName'])))))) $ret = false;
					if (strlen($holiday08xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday08xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday08) < 0) $ret = false;
		if (is_array($holiday09) && (count($holiday09) > 0)) {
			foreach ($holiday09 as $holiday09xd ) {
				if ($holiday09xd['holidayName'] != null) {
					if (strlen($holiday09xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday09xd['holidayName'])))) $ret = false;
					if (strlen($holiday09xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday09xd['holidayName'])))))) $ret = false;
					if (strlen($holiday09xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday09xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday09) < 0) $ret = false;
		if (is_array($holiday10) && (count($holiday10) > 0)) {
			foreach ($holiday10 as $holiday10xd ) {
				if ($holiday10xd['holidayName'] != null) {
					if (strlen($holiday10xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday10xd['holidayName'])))) $ret = false;
					if (strlen($holiday10xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday10xd['holidayName'])))))) $ret = false;
					if (strlen($holiday10xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday10xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday10) < 0) $ret = false;
		if (is_array($holiday11) && (count($holiday11) > 0)) {
			foreach ($holiday11 as $holiday11xd ) {
				if ($holiday11xd['holidayName'] != null) {
					if (strlen($holiday11xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday11xd['holidayName'])))) $ret = false;
					if (strlen($holiday11xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday11xd['holidayName'])))))) $ret = false;
					if (strlen($holiday11xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday11xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday11) < 0) $ret = false;
		if (is_array($holiday12) && (count($holiday12) > 0)) {
			foreach ($holiday12 as $holiday12xd ) {
				if ($holiday12xd['holidayName'] != null) {
					if (strlen($holiday12xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday12xd['holidayName'])))) $ret = false;
					if (strlen($holiday12xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday12xd['holidayName'])))))) $ret = false;
					if (strlen($holiday12xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday12xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday12) < 0) $ret = false;
		if (is_array($holiday13) && (count($holiday13) > 0)) {
			foreach ($holiday13 as $holiday13xd ) {
				if ($holiday13xd['holidayName'] != null) {
					if (strlen($holiday13xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday13xd['holidayName'])))) $ret = false;
					if (strlen($holiday13xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday13xd['holidayName'])))))) $ret = false;
					if (strlen($holiday13xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday13xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday13) < 0) $ret = false;
		if (is_array($holiday14) && (count($holiday14) > 0)) {
			foreach ($holiday14 as $holiday14xd ) {
				if ($holiday14xd['holidayName'] != null) {
					if (strlen($holiday14xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday14xd['holidayName'])))) $ret = false;
					if (strlen($holiday14xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday14xd['holidayName'])))))) $ret = false;
					if (strlen($holiday14xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday14xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday14) < 0) $ret = false;
		if (is_array($holiday15) && (count($holiday15) > 0)) {
			foreach ($holiday15 as $holiday15xd ) {
				if ($holiday15xd['holidayName'] != null) {
					if (strlen($holiday15xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday15xd['holidayName'])))) $ret = false;
					if (strlen($holiday15xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday15xd['holidayName'])))))) $ret = false;
					if (strlen($holiday15xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday15xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday15) < 0) $ret = false;
		if (is_array($holiday16) && (count($holiday16) > 0)) {
			foreach ($holiday16 as $holiday16xd ) {
				if ($holiday16xd['holidayName'] != null) {
					if (strlen($holiday16xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday16xd['holidayName'])))) $ret = false;
					if (strlen($holiday16xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday16xd['holidayName'])))))) $ret = false;
					if (strlen($holiday16xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday16xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday16) < 0) $ret = false;
		if (is_array($holiday17) && (count($holiday17) > 0)) {
			foreach ($holiday17 as $holiday17xd ) {
				if ($holiday17xd['holidayName'] != null) {
					if (strlen($holiday17xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday17xd['holidayName'])))) $ret = false;
					if (strlen($holiday17xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday17xd['holidayName'])))))) $ret = false;
					if (strlen($holiday17xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday17xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday17) < 0) $ret = false;
		if (is_array($holiday18) && (count($holiday18) > 0)) {
			foreach ($holiday18 as $holiday18xd ) {
				if ($holiday18xd['holidayName'] != null) {
					if (strlen($holiday18xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday18xd['holidayName'])))) $ret = false;
					if (strlen($holiday18xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday18xd['holidayName'])))))) $ret = false;
					if (strlen($holiday18xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday18xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday18) < 0) $ret = false;
		if (is_array($holiday19) && (count($holiday19) > 0)) {
			foreach ($holiday19 as $holiday19xd ) {
				if ($holiday19xd['holidayName'] != null) {
					if (strlen($holiday19xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday19xd['holidayName'])))) $ret = false;
					if (strlen($holiday19xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday19xd['holidayName'])))))) $ret = false;
					if (strlen($holiday19xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday19xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday19) < 0) $ret = false;
		if (is_array($holiday20) && (count($holiday20) > 0)) {
			foreach ($holiday20 as $holiday20xd ) {
				if ($holiday20xd['holidayName'] != null) {
					if (strlen($holiday20xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday20xd['holidayName'])))) $ret = false;
					if (strlen($holiday20xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday20xd['holidayName'])))))) $ret = false;
					if (strlen($holiday20xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday20xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->holidayScheduleName = $holidayScheduleName;
			$this->newHolidayScheduleName = $newHolidayScheduleName;
			$this->holiday01 = $holiday01;
			$this->holiday02 = $holiday02;
			$this->holiday03 = $holiday03;
			$this->holiday04 = $holiday04;
			$this->holiday05 = $holiday05;
			$this->holiday06 = $holiday06;
			$this->holiday07 = $holiday07;
			$this->holiday08 = $holiday08;
			$this->holiday09 = $holiday09;
			$this->holiday10 = $holiday10;
			$this->holiday11 = $holiday11;
			$this->holiday12 = $holiday12;
			$this->holiday13 = $holiday13;
			$this->holiday14 = $holiday14;
			$this->holiday15 = $holiday15;
			$this->holiday16 = $holiday16;
			$this->holiday17 = $holiday17;
			$this->holiday18 = $holiday18;
			$this->holiday19 = $holiday19;
			$this->holiday20 = $holiday20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserHolidayScheduleModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("holidayScheduleName", $this->holidayScheduleName);
		$this->comando->appendChild($elem2);

		if (is_array($this->newHolidayScheduleName) && count($this->newHolidayScheduleName) > 0) {
			foreach ($this->newHolidayScheduleName as $newHolidayScheduleNamexd) {
				$elem2 = new DOMElement("newHolidayScheduleName", $newHolidayScheduleNamexd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->holiday01) && count($this->holiday01) > 0) {
			$elem4 = new DOMElement("holiday01");
			$this->comando->appendChild($elem4);

			foreach ($this->holiday01 as $holiday01xd) {
				if (isset($holiday01xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday01xd['holidayName']);
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday02) && count($this->holiday02) > 0) {
			$elem5 = new DOMElement("holiday02");
			$this->comando->appendChild($elem5);

			foreach ($this->holiday02 as $holiday02xd) {
				if (isset($holiday02xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday02xd['holidayName']);
					$elem5->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday03) && count($this->holiday03) > 0) {
			$elem6 = new DOMElement("holiday03");
			$this->comando->appendChild($elem6);

			foreach ($this->holiday03 as $holiday03xd) {
				if (isset($holiday03xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday03xd['holidayName']);
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday04) && count($this->holiday04) > 0) {
			$elem7 = new DOMElement("holiday04");
			$this->comando->appendChild($elem7);

			foreach ($this->holiday04 as $holiday04xd) {
				if (isset($holiday04xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday04xd['holidayName']);
					$elem7->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday05) && count($this->holiday05) > 0) {
			$elem8 = new DOMElement("holiday05");
			$this->comando->appendChild($elem8);

			foreach ($this->holiday05 as $holiday05xd) {
				if (isset($holiday05xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday05xd['holidayName']);
					$elem8->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday06) && count($this->holiday06) > 0) {
			$elem9 = new DOMElement("holiday06");
			$this->comando->appendChild($elem9);

			foreach ($this->holiday06 as $holiday06xd) {
				if (isset($holiday06xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday06xd['holidayName']);
					$elem9->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday07) && count($this->holiday07) > 0) {
			$elem10 = new DOMElement("holiday07");
			$this->comando->appendChild($elem10);

			foreach ($this->holiday07 as $holiday07xd) {
				if (isset($holiday07xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday07xd['holidayName']);
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday08) && count($this->holiday08) > 0) {
			$elem11 = new DOMElement("holiday08");
			$this->comando->appendChild($elem11);

			foreach ($this->holiday08 as $holiday08xd) {
				if (isset($holiday08xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday08xd['holidayName']);
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday09) && count($this->holiday09) > 0) {
			$elem12 = new DOMElement("holiday09");
			$this->comando->appendChild($elem12);

			foreach ($this->holiday09 as $holiday09xd) {
				if (isset($holiday09xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday09xd['holidayName']);
					$elem12->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday10) && count($this->holiday10) > 0) {
			$elem13 = new DOMElement("holiday10");
			$this->comando->appendChild($elem13);

			foreach ($this->holiday10 as $holiday10xd) {
				if (isset($holiday10xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday10xd['holidayName']);
					$elem13->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday11) && count($this->holiday11) > 0) {
			$elem14 = new DOMElement("holiday11");
			$this->comando->appendChild($elem14);

			foreach ($this->holiday11 as $holiday11xd) {
				if (isset($holiday11xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday11xd['holidayName']);
					$elem14->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday12) && count($this->holiday12) > 0) {
			$elem15 = new DOMElement("holiday12");
			$this->comando->appendChild($elem15);

			foreach ($this->holiday12 as $holiday12xd) {
				if (isset($holiday12xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday12xd['holidayName']);
					$elem15->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday13) && count($this->holiday13) > 0) {
			$elem16 = new DOMElement("holiday13");
			$this->comando->appendChild($elem16);

			foreach ($this->holiday13 as $holiday13xd) {
				if (isset($holiday13xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday13xd['holidayName']);
					$elem16->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday14) && count($this->holiday14) > 0) {
			$elem17 = new DOMElement("holiday14");
			$this->comando->appendChild($elem17);

			foreach ($this->holiday14 as $holiday14xd) {
				if (isset($holiday14xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday14xd['holidayName']);
					$elem17->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday15) && count($this->holiday15) > 0) {
			$elem18 = new DOMElement("holiday15");
			$this->comando->appendChild($elem18);

			foreach ($this->holiday15 as $holiday15xd) {
				if (isset($holiday15xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday15xd['holidayName']);
					$elem18->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday16) && count($this->holiday16) > 0) {
			$elem19 = new DOMElement("holiday16");
			$this->comando->appendChild($elem19);

			foreach ($this->holiday16 as $holiday16xd) {
				if (isset($holiday16xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday16xd['holidayName']);
					$elem19->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday17) && count($this->holiday17) > 0) {
			$elem20 = new DOMElement("holiday17");
			$this->comando->appendChild($elem20);

			foreach ($this->holiday17 as $holiday17xd) {
				if (isset($holiday17xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday17xd['holidayName']);
					$elem20->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday18) && count($this->holiday18) > 0) {
			$elem21 = new DOMElement("holiday18");
			$this->comando->appendChild($elem21);

			foreach ($this->holiday18 as $holiday18xd) {
				if (isset($holiday18xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday18xd['holidayName']);
					$elem21->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday19) && count($this->holiday19) > 0) {
			$elem22 = new DOMElement("holiday19");
			$this->comando->appendChild($elem22);

			foreach ($this->holiday19 as $holiday19xd) {
				if (isset($holiday19xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday19xd['holidayName']);
					$elem22->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday20) && count($this->holiday20) > 0) {
			$elem23 = new DOMElement("holiday20");
			$this->comando->appendChild($elem23);

			foreach ($this->holiday20 as $holiday20xd) {
				if (isset($holiday20xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", $holiday20xd['holidayName']);
					$elem23->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserLinePortGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserLinePortGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserModifyUserIdRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $newUserId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	newUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId, $newUserId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($newUserId) != strlen(trim( str_replace('  ', ' ', $newUserId)))) $ret = false;
		if (strlen($newUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newUserId)))))) $ret = false;
		if (strlen($newUserId) < 1) $ret = false;
		if (strlen($newUserId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->newUserId = $newUserId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserModifyUserIdRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("newUserId", $this->newUserId);
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserNetworkConferencingGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserNetworkConferencingGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOCICallControlApplicationGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOCICallControlApplicationGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOCICallControlApplicationModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $applicationIdList;

	/* Conjunto Recibe [A list of applicationIds that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	applicationIdList es un compuesto de: 
	applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $applicationIdList) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($applicationIdList) && (count($applicationIdList) > 0)) {
			foreach ($applicationIdList as $applicationIdListxd ) {
				if ($applicationIdListxd['applicationId'] != null) {
					if (strlen($applicationIdListxd['applicationId']) != strlen(trim( str_replace('  ', ' ', $applicationIdListxd['applicationId'])))) $ret = false;
					if (strlen($applicationIdListxd['applicationId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationIdListxd['applicationId'])))))) $ret = false;
					if (strlen($applicationIdListxd['applicationId']) < 1) $ret = false;
					if (strlen($applicationIdListxd['applicationId']) > 80) $ret = false;
				}
			}
		}
		if (count($applicationIdList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->applicationIdList = $applicationIdList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOCICallControlApplicationModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->applicationIdList) && count($this->applicationIdList) > 0) {
			$elem2 = new DOMElement("applicationIdList");
			$this->comando->appendChild($elem2);

			foreach ($this->applicationIdList as $applicationIdListxd) {
				if (isset($applicationIdListxd['applicationId'])) {
					$elemtin1 = new DOMElement("applicationId", $applicationIdListxd['applicationId']);
					$elem2->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPasswordInfoGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPasswordInfoGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPersonalPhoneListAddListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $entry;

	/* Conjunto Recibe [Phone list entry.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	entry es un compuesto de: 
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($userId, $entry) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($entry) && (count($entry) > 0)) {
			foreach ($entry as $entryxd ) {
				if (strlen($entryxd['entryName']) != strlen(trim( str_replace('  ', ' ', $entryxd['entryName'])))) $ret = false;
				if (strlen($entryxd['entryName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryxd['entryName'])))))) $ret = false;
				if (strlen($entryxd['entryName']) < 1) $ret = false;
				if (strlen($entryxd['entryName']) > 50) $ret = false;
				if (strlen($entryxd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $entryxd['phoneNumber'])))) $ret = false;
				if (strlen($entryxd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryxd['phoneNumber'])))))) $ret = false;
				if (strlen($entryxd['phoneNumber']) < 1) $ret = false;
				if (strlen($entryxd['phoneNumber']) > 30) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->entry = $entry;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPersonalPhoneListAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->entry) && count($this->entry) > 0) {
			$elem2 = new DOMElement("entry");
			$this->comando->appendChild($elem2);

			foreach ($this->entry as $entryxd) {
				if (isset($entryxd['entryName'])) {
					$elemtin1 = new DOMElement("entryName", $entryxd['entryName']);
					$elem2->appendChild($elemtin1);

				}
				if (isset($entryxd['phoneNumber'])) {
					$elemtin2 = new DOMElement("phoneNumber", $entryxd['phoneNumber']);
					$elem2->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPersonalPhoneListDeleteListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $entryName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	[maxOccurs = unbounded] 
	*/
	public function setData($userId, $entryName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($entryName) && (count($entryName) > 0)) {
			foreach ($entryName as $entryNamexd ) {
				if (strlen($entryNamexd) != strlen(trim( str_replace('  ', ' ', $entryNamexd)))) $ret = false;
				if (strlen($entryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryNamexd)))))) $ret = false;
				if (strlen($entryNamexd) < 1) $ret = false;
				if (strlen($entryNamexd) > 50) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->entryName = $entryName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPersonalPhoneListDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->entryName) && count($this->entryName) > 0) {
			foreach ($this->entryName as $entryNamexd) {
				$elem3 = new DOMElement("entryName", $entryNamexd);
				$this->comando->appendChild($elem3);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPersonalPhoneListGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPersonalPhoneListGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPersonalPhoneListModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $entryName;
	private $newEntryName;
	private $phoneNumber;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	newEntryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $entryName, $newEntryName, $phoneNumber) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($entryName) != strlen(trim( str_replace('  ', ' ', $entryName)))) $ret = false;
		if (strlen($entryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryName)))))) $ret = false;
		if (strlen($entryName) < 1) $ret = false;
		if (strlen($entryName) > 50) $ret = false;
		if (is_array($newEntryName) && (count($newEntryName) > 0)) {
			foreach ($newEntryName as $newEntryNamexd ) {
				if ($newEntryNamexd != null) {
					if (strlen($newEntryNamexd) != strlen(trim( str_replace('  ', ' ', $newEntryNamexd)))) $ret = false;
					if (strlen($newEntryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newEntryNamexd)))))) $ret = false;
					if (strlen($newEntryNamexd) < 1) $ret = false;
					if (strlen($newEntryNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($newEntryName) < 0) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ($phoneNumberxd != null) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->entryName = $entryName;
			$this->newEntryName = $newEntryName;
			$this->phoneNumber = $phoneNumber;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPersonalPhoneListModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("entryName", $this->entryName);
		$this->comando->appendChild($elem2);

		if (is_array($this->newEntryName) && count($this->newEntryName) > 0) {
			foreach ($this->newEntryName as $newEntryNamexd) {
				$elem3 = new DOMElement("newEntryName", $newEntryNamexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem3 = new DOMElement("phoneNumber", $phoneNumberxd);
				$this->comando->appendChild($elem3);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPhoneDirectoryGetListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $includeCommonPhoneList;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaExtension;
	private $searchCriteriaMobilePhoneNumber;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaExactUserDepartment;
	private $searchCriteriaExactUserGroup;
	private $searchCriteriaExactCustomContactDirectory;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified custom contact directory.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's group.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a user's mobile phone number.] 

	Conjunto Recibe [Criteria for searching for an extension.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	includeCommonPhoneList [xs:boolean]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExtension es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaMobilePhoneNumber es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	searchCriteriaExactUserGroup es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactCustomContactDirectory es un compuesto de: 
	customContactDirectoryName[xs:token]: Custom Contact Directory name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $includeCommonPhoneList, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaExtension, $searchCriteriaMobilePhoneNumber, $searchCriteriaEmailAddress, $searchCriteriaExactUserDepartment, $searchCriteriaExactUserGroup, $searchCriteriaExactCustomContactDirectory) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ($responseSizeLimitxd != null) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ($searchCriteriaUserLastNamexd['mode'] != null) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserLastNamexd['value'] != null) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ($searchCriteriaUserFirstNamexd['mode'] != null) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserFirstNamexd['value'] != null) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ($searchCriteriaDnxd['mode'] != null) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaDnxd['value'] != null) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaExtension) && (count($searchCriteriaExtension) > 0)) {
			foreach ($searchCriteriaExtension as $searchCriteriaExtensionxd ) {
				if ($searchCriteriaExtensionxd['mode'] != null) {
					if (($searchCriteriaExtensionxd['mode'] != "Starts With") && ($searchCriteriaExtensionxd['mode'] != "Contains") && ($searchCriteriaExtensionxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaExtensionxd['value'] != null) {
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExtensionxd['value'])))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExtensionxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExtension) < 0) $ret = false;
		if (is_array($searchCriteriaMobilePhoneNumber) && (count($searchCriteriaMobilePhoneNumber) > 0)) {
			foreach ($searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd ) {
				if ($searchCriteriaMobilePhoneNumberxd['mode'] != null) {
					if (($searchCriteriaMobilePhoneNumberxd['mode'] != "Starts With") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Contains") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaMobilePhoneNumberxd['value'] != null) {
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaMobilePhoneNumberxd['value'])))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaMobilePhoneNumberxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaMobilePhoneNumber) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ($searchCriteriaEmailAddressxd['mode'] != null) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaEmailAddressxd['value'] != null) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if (is_array($searchCriteriaExactUserGroup) && (count($searchCriteriaExactUserGroup) > 0)) {
			foreach ($searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd ) {
				if ($searchCriteriaExactUserGroupxd['serviceProviderId'] != null) {
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) > 30) $ret = false;
				}
				if ($searchCriteriaExactUserGroupxd['groupId'] != null) {
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['groupId'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['groupId'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserGroup) < 0) $ret = false;
		if (is_array($searchCriteriaExactCustomContactDirectory) && (count($searchCriteriaExactCustomContactDirectory) > 0)) {
			foreach ($searchCriteriaExactCustomContactDirectory as $searchCriteriaExactCustomContactDirectoryxd ) {
				if ($searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName'] != null) {
					if (strlen($searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName'])))) $ret = false;
					if (strlen($searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName'])))))) $ret = false;
					if (strlen($searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName']) < 1) $ret = false;
					if (strlen($searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName']) > 40) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactCustomContactDirectory) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->includeCommonPhoneList = $includeCommonPhoneList;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaExtension = $searchCriteriaExtension;
			$this->searchCriteriaMobilePhoneNumber = $searchCriteriaMobilePhoneNumber;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			$this->searchCriteriaExactUserGroup = $searchCriteriaExactUserGroup;
			$this->searchCriteriaExactCustomContactDirectory = $searchCriteriaExactCustomContactDirectory;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPhoneDirectoryGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("includeCommonPhoneList", $this->includeCommonPhoneList);
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem3 = new DOMElement("responseSizeLimit", $responseSizeLimitxd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserLastNamexd['mode']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserLastNamexd['value']);
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserFirstNamexd['mode']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserFirstNamexd['value']);
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem6 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaDnxd['mode']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaDnxd['value']);
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExtension) && count($this->searchCriteriaExtension) > 0) {
			$elem7 = new DOMElement("searchCriteriaExtension");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExtension as $searchCriteriaExtensionxd) {
				if (isset($searchCriteriaExtensionxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaExtensionxd['mode']);
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExtensionxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaExtensionxd['value']);
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaMobilePhoneNumber) && count($this->searchCriteriaMobilePhoneNumber) > 0) {
			$elem8 = new DOMElement("searchCriteriaMobilePhoneNumber");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd) {
				if (isset($searchCriteriaMobilePhoneNumberxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaMobilePhoneNumberxd['mode']);
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaMobilePhoneNumberxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaMobilePhoneNumberxd['value']);
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem9 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaEmailAddressxd['mode']);
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaEmailAddressxd['value']);
					$elem9->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem10 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", $searchCriteriaExactUserDepartmentxd['']);
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserGroup) && count($this->searchCriteriaExactUserGroup) > 0) {
			$elem11 = new DOMElement("searchCriteriaExactUserGroup");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd) {
				if (isset($searchCriteriaExactUserGroupxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", $searchCriteriaExactUserGroupxd['serviceProviderId']);
					$elem11->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExactUserGroupxd['groupId'])) {
					$elemtin2 = new DOMElement("groupId", $searchCriteriaExactUserGroupxd['groupId']);
					$elem11->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactCustomContactDirectory) && count($this->searchCriteriaExactCustomContactDirectory) > 0) {
			$elem12 = new DOMElement("searchCriteriaExactCustomContactDirectory");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaExactCustomContactDirectory as $searchCriteriaExactCustomContactDirectoryxd) {
				if (isset($searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName'])) {
					$elemtin1 = new DOMElement("customContactDirectoryName", $searchCriteriaExactCustomContactDirectoryxd['customContactDirectoryName']);
					$elem12->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPhoneDirectoryGetPagedListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $isEnterpriseInfoRequested;
	private $responsePagingControl;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaGroupLocationCode;
	private $searchCriteriaExtension;
	private $searchCriteriaMobilePhoneNumber;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaYahooId;
	private $searchCriteriaExactUserGroup;
	private $searchCriteriaExactUserDepartment;
	private $searchCriteriaUserId;

	/* Conjunto Recibe [Criteria for searching for a user's userId.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's group.] 

	Conjunto Recibe [Criteria for searching for a user's yahoo id.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a user's mobile phone number.] 

	Conjunto Recibe [Criteria for searching for an extension.] 

	Conjunto Recibe [Criteria for searching for a group location dialing code.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	Conjunto Recibe [Used in queries to restrict the set of result rows when making a request that can result in
        a large dataset. The client specifies the starting row and the number of rows requested. 
        The server only provides those rows in results, if available.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	isEnterpriseInfoRequested [xs:boolean]
	responsePagingControl es un compuesto de: 
	responseStartIndex[xs:int - A signed 32-bit integer]: The starting row number to return in a response.
        The first row is numbered starting at 1, not 0. [minInclusive = 1] 
	responsePageSize[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a paging request for data [maxInclusive = 100]  [minInclusive = 1] 
	searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupLocationCode es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExtension es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaMobilePhoneNumber es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaYahooId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserGroup es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	searchCriteriaUserId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $isEnterpriseInfoRequested, $responsePagingControl, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaGroupLocationCode, $searchCriteriaExtension, $searchCriteriaMobilePhoneNumber, $searchCriteriaEmailAddress, $searchCriteriaYahooId, $searchCriteriaExactUserGroup, $searchCriteriaExactUserDepartment, $searchCriteriaUserId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($responsePagingControl) && (count($responsePagingControl) > 0)) {
			foreach ($responsePagingControl as $responsePagingControlxd ) {
				if (!is_numeric($responsePagingControlxd['responseStartIndex'])) $ret = false;
				if (($responsePagingControlxd['responseStartIndex'] < -2147483648) || ($responsePagingControlxd['responseStartIndex'] > 2147483647)) $ret = false;
				if ($responsePagingControlxd['responseStartIndex'] < 1) $ret = false;
				if (!is_numeric($responsePagingControlxd['responsePageSize'])) $ret = false;
				if (($responsePagingControlxd['responsePageSize'] < -2147483648) || ($responsePagingControlxd['responsePageSize'] > 2147483647)) $ret = false;
				if ($responsePagingControlxd['responsePageSize'] > 100) $ret = false;
				if ($responsePagingControlxd['responsePageSize'] < 1) $ret = false;
			}
		}
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ($searchCriteriaUserLastNamexd['mode'] != null) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserLastNamexd['value'] != null) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ($searchCriteriaUserFirstNamexd['mode'] != null) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserFirstNamexd['value'] != null) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ($searchCriteriaDnxd['mode'] != null) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaDnxd['value'] != null) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaGroupLocationCode) && (count($searchCriteriaGroupLocationCode) > 0)) {
			foreach ($searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd ) {
				if ($searchCriteriaGroupLocationCodexd['mode'] != null) {
					if (($searchCriteriaGroupLocationCodexd['mode'] != "Starts With") && ($searchCriteriaGroupLocationCodexd['mode'] != "Contains") && ($searchCriteriaGroupLocationCodexd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaGroupLocationCodexd['value'] != null) {
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupLocationCodexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupLocationCodexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupLocationCode) < 0) $ret = false;
		if (is_array($searchCriteriaExtension) && (count($searchCriteriaExtension) > 0)) {
			foreach ($searchCriteriaExtension as $searchCriteriaExtensionxd ) {
				if ($searchCriteriaExtensionxd['mode'] != null) {
					if (($searchCriteriaExtensionxd['mode'] != "Starts With") && ($searchCriteriaExtensionxd['mode'] != "Contains") && ($searchCriteriaExtensionxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaExtensionxd['value'] != null) {
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExtensionxd['value'])))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExtensionxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExtension) < 0) $ret = false;
		if (is_array($searchCriteriaMobilePhoneNumber) && (count($searchCriteriaMobilePhoneNumber) > 0)) {
			foreach ($searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd ) {
				if ($searchCriteriaMobilePhoneNumberxd['mode'] != null) {
					if (($searchCriteriaMobilePhoneNumberxd['mode'] != "Starts With") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Contains") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaMobilePhoneNumberxd['value'] != null) {
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaMobilePhoneNumberxd['value'])))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaMobilePhoneNumberxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaMobilePhoneNumber) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ($searchCriteriaEmailAddressxd['mode'] != null) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaEmailAddressxd['value'] != null) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaYahooId) && (count($searchCriteriaYahooId) > 0)) {
			foreach ($searchCriteriaYahooId as $searchCriteriaYahooIdxd ) {
				if ($searchCriteriaYahooIdxd['mode'] != null) {
					if (($searchCriteriaYahooIdxd['mode'] != "Starts With") && ($searchCriteriaYahooIdxd['mode'] != "Contains") && ($searchCriteriaYahooIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaYahooIdxd['value'] != null) {
					if (strlen($searchCriteriaYahooIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaYahooIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaYahooIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaYahooIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaYahooIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaYahooId) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserGroup) && (count($searchCriteriaExactUserGroup) > 0)) {
			foreach ($searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd ) {
				if ($searchCriteriaExactUserGroupxd['serviceProviderId'] != null) {
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) > 30) $ret = false;
				}
				if ($searchCriteriaExactUserGroupxd['groupId'] != null) {
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['groupId'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['groupId'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserGroup) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if (is_array($searchCriteriaUserId) && (count($searchCriteriaUserId) > 0)) {
			foreach ($searchCriteriaUserId as $searchCriteriaUserIdxd ) {
				if ($searchCriteriaUserIdxd['mode'] != null) {
					if (($searchCriteriaUserIdxd['mode'] != "Starts With") && ($searchCriteriaUserIdxd['mode'] != "Contains") && ($searchCriteriaUserIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ($searchCriteriaUserIdxd['value'] != null) {
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->isEnterpriseInfoRequested = $isEnterpriseInfoRequested;
			$this->responsePagingControl = $responsePagingControl;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaGroupLocationCode = $searchCriteriaGroupLocationCode;
			$this->searchCriteriaExtension = $searchCriteriaExtension;
			$this->searchCriteriaMobilePhoneNumber = $searchCriteriaMobilePhoneNumber;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaYahooId = $searchCriteriaYahooId;
			$this->searchCriteriaExactUserGroup = $searchCriteriaExactUserGroup;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			$this->searchCriteriaUserId = $searchCriteriaUserId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPhoneDirectoryGetPagedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isEnterpriseInfoRequested", $this->isEnterpriseInfoRequested);
		$this->comando->appendChild($elem2);

		if (is_array($this->responsePagingControl) && count($this->responsePagingControl) > 0) {
			$elem3 = new DOMElement("responsePagingControl");
			$this->comando->appendChild($elem3);

			foreach ($this->responsePagingControl as $responsePagingControlxd) {
				if (isset($responsePagingControlxd['responseStartIndex'])) {
					$elemtin1 = new DOMElement("responseStartIndex", $responsePagingControlxd['responseStartIndex']);
					$elem3->appendChild($elemtin1);

				}
				if (isset($responsePagingControlxd['responsePageSize'])) {
					$elemtin2 = new DOMElement("responsePageSize", $responsePagingControlxd['responsePageSize']);
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserLastNamexd['mode']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserLastNamexd['value']);
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserFirstNamexd['mode']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserFirstNamexd['value']);
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem6 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaDnxd['mode']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaDnxd['value']);
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupLocationCode) && count($this->searchCriteriaGroupLocationCode) > 0) {
			$elem7 = new DOMElement("searchCriteriaGroupLocationCode");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd) {
				if (isset($searchCriteriaGroupLocationCodexd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaGroupLocationCodexd['mode']);
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupLocationCodexd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaGroupLocationCodexd['value']);
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExtension) && count($this->searchCriteriaExtension) > 0) {
			$elem8 = new DOMElement("searchCriteriaExtension");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaExtension as $searchCriteriaExtensionxd) {
				if (isset($searchCriteriaExtensionxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaExtensionxd['mode']);
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExtensionxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaExtensionxd['value']);
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaMobilePhoneNumber) && count($this->searchCriteriaMobilePhoneNumber) > 0) {
			$elem9 = new DOMElement("searchCriteriaMobilePhoneNumber");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd) {
				if (isset($searchCriteriaMobilePhoneNumberxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaMobilePhoneNumberxd['mode']);
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaMobilePhoneNumberxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaMobilePhoneNumberxd['value']);
					$elem9->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem10 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaEmailAddressxd['mode']);
					$elem10->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaEmailAddressxd['value']);
					$elem10->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaYahooId) && count($this->searchCriteriaYahooId) > 0) {
			$elem11 = new DOMElement("searchCriteriaYahooId");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaYahooId as $searchCriteriaYahooIdxd) {
				if (isset($searchCriteriaYahooIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaYahooIdxd['mode']);
					$elem11->appendChild($elemtin1);

				}
				if (isset($searchCriteriaYahooIdxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaYahooIdxd['value']);
					$elem11->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserGroup) && count($this->searchCriteriaExactUserGroup) > 0) {
			$elem12 = new DOMElement("searchCriteriaExactUserGroup");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd) {
				if (isset($searchCriteriaExactUserGroupxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", $searchCriteriaExactUserGroupxd['serviceProviderId']);
					$elem12->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExactUserGroupxd['groupId'])) {
					$elemtin2 = new DOMElement("groupId", $searchCriteriaExactUserGroupxd['groupId']);
					$elem12->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem13 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem13);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", $searchCriteriaExactUserDepartmentxd['']);
					$elem13->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaUserId) && count($this->searchCriteriaUserId) > 0) {
			$elem14 = new DOMElement("searchCriteriaUserId");
			$this->comando->appendChild($elem14);

			foreach ($this->searchCriteriaUserId as $searchCriteriaUserIdxd) {
				if (isset($searchCriteriaUserIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", $searchCriteriaUserIdxd['mode']);
					$elem14->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserIdxd['value'])) {
					$elemtin2 = new DOMElement("value", $searchCriteriaUserIdxd['value']);
					$elem14->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPhoneDirectoryGetSearchedListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $nameSearchString;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	nameSearchString[xs:token]: Phone Directory Name Search String. [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $nameSearchString) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($nameSearchString) && (count($nameSearchString) > 0)) {
			foreach ($nameSearchString as $nameSearchStringxd ) {
				if ($nameSearchStringxd != null) {
					if (strlen($nameSearchStringxd) != strlen(trim( str_replace('  ', ' ', $nameSearchStringxd)))) $ret = false;
					if (strlen($nameSearchStringxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $nameSearchStringxd)))))) $ret = false;
					if (strlen($nameSearchStringxd) < 1) $ret = false;
				}
			}
		}
		if (count($nameSearchString) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->nameSearchString = $nameSearchString;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPhoneDirectoryGetSearchedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->nameSearchString) && count($this->nameSearchString) > 0) {
			foreach ($this->nameSearchString as $nameSearchStringxd) {
				$elem3 = new DOMElement("nameSearchString", $nameSearchStringxd);
				$this->comando->appendChild($elem3);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPortalPasscodeGetInfoRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPortalPasscodeGetInfoRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserPortalPasscodeModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $oldPasscode;
	private $newPasscode;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	oldPasscode[xs:token]: Portal passcode [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]newPasscode[xs:token]: Portal passcode [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($userId, $oldPasscode, $newPasscode) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($oldPasscode) && (count($oldPasscode) > 0)) {
			foreach ($oldPasscode as $oldPasscodexd ) {
				if ($oldPasscodexd != null) {
					if (strlen($oldPasscodexd) != strlen(trim( str_replace('  ', ' ', $oldPasscodexd)))) $ret = false;
					if (strlen($oldPasscodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $oldPasscodexd)))))) $ret = false;
					if (strlen($oldPasscodexd) < 1) $ret = false;
					if (strlen($oldPasscodexd) > 30) $ret = false;
				}
			}
		}
		if (count($oldPasscode) < 0) $ret = false;
		if (strlen($newPasscode) != strlen(trim( str_replace('  ', ' ', $newPasscode)))) $ret = false;
		if (strlen($newPasscode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newPasscode)))))) $ret = false;
		if (strlen($newPasscode) < 1) $ret = false;
		if (strlen($newPasscode) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->oldPasscode = $oldPasscode;
			$this->newPasscode = $newPasscode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserPortalPasscodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->oldPasscode) && count($this->oldPasscode) > 0) {
			foreach ($this->oldPasscode as $oldPasscodexd) {
				$elem3 = new DOMElement("oldPasscode", $oldPasscodexd);
				$this->comando->appendChild($elem3);

			}
		}
		$elem3 = new DOMElement("newPasscode", $this->newPasscode);
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserServiceAssignListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $serviceName;
	private $servicePackName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0]servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $serviceName, $servicePackName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ($serviceNamexd != null) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if (is_array($servicePackName) && (count($servicePackName) > 0)) {
			foreach ($servicePackName as $servicePackNamexd ) {
				if ($servicePackNamexd != null) {
					if (strlen($servicePackNamexd) != strlen(trim( str_replace('  ', ' ', $servicePackNamexd)))) $ret = false;
					if (strlen($servicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNamexd)))))) $ret = false;
					if (strlen($servicePackNamexd) < 1) $ret = false;
					if (strlen($servicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->serviceName = $serviceName;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserServiceAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem3 = new DOMElement("serviceName", $serviceNamexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->servicePackName) && count($this->servicePackName) > 0) {
			foreach ($this->servicePackName as $servicePackNamexd) {
				$elem3 = new DOMElement("servicePackName", $servicePackNamexd);
				$this->comando->appendChild($elem3);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserServiceGetAssignmentListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserServiceGetAssignmentListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserServiceIsAssignedRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $choice0;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	[choice0] es un Opcional Compuesto
	serviceName (no tipado) User level services.
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($userId, $choice0) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
				if (isset($choice0xd['servicePackName'] )) {
					if (strlen($choice0xd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $choice0xd['servicePackName'])))) $ret = false;
					if (strlen($choice0xd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['servicePackName'])))))) $ret = false;
					if (strlen($choice0xd['servicePackName']) < 1) $ret = false;
					if (strlen($choice0xd['servicePackName']) > 80) $ret = false;
				}
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserServiceIsAssignedRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (isset($this->choice0['serviceName'])) {
			$elemxd1 = new DOMElement("serviceName", $this->choice0['serviceName']);
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choice0['servicePackName'])) {
			$elemxd2 = new DOMElement("servicePackName", $this->choice0['servicePackName']);
			$this->comando->appendChild($elemxd2);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserServiceUnassignListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $serviceName;
	private $servicePackName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0]servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $serviceName, $servicePackName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ($serviceNamexd != null) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if (is_array($servicePackName) && (count($servicePackName) > 0)) {
			foreach ($servicePackName as $servicePackNamexd ) {
				if ($servicePackNamexd != null) {
					if (strlen($servicePackNamexd) != strlen(trim( str_replace('  ', ' ', $servicePackNamexd)))) $ret = false;
					if (strlen($servicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNamexd)))))) $ret = false;
					if (strlen($servicePackNamexd) < 1) $ret = false;
					if (strlen($servicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->serviceName = $serviceName;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserServiceUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem3 = new DOMElement("serviceName", $serviceNamexd);
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->servicePackName) && count($this->servicePackName) > 0) {
			foreach ($this->servicePackName as $servicePackNamexd) {
				$elem3 = new DOMElement("servicePackName", $servicePackNamexd);
				$this->comando->appendChild($elem3);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserShInterfaceGetPublicIdDataRequest extends BroadsoftXMLCommand { 

	private $choicepublicUserIdentity;
	private $publicUserIdentity;

	/* Conjunto Recibe [Public User Identity] 

	Conjunto Recibe [Public User Identity] 

	[choicepublicUserIdentity] es un Opcional Compuesto
sipURI[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161]
	telURI[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23]
	publicUserIdentity es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($choicepublicUserIdentity, $publicUserIdentity) {
		$ret = true;
		if (is_array($choicepublicUserIdentity) && (count($choicepublicUserIdentity) > 0)) {
			foreach ($choicepublicUserIdentity as $choicepublicUserIdentityxd ) {
				if (isset($choicepublicUserIdentityxd['SIPURI'] )) {
					if (strlen($choicepublicUserIdentityxd['sipURI']) != strlen(trim( str_replace('  ', ' ', $choicepublicUserIdentityxd['sipURI'])))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepublicUserIdentityxd['sipURI'])))))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) < 1) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) > 161) $ret = false;
				}
				if (isset($choicepublicUserIdentityxd['DN'] )) {
					if (strlen($choicepublicUserIdentityxd['telURI']) != strlen(trim( str_replace('  ', ' ', $choicepublicUserIdentityxd['telURI'])))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepublicUserIdentityxd['telURI'])))))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) < 1) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) > 23) $ret = false;
				}
			}
		} else { $ret = false; }
		if (is_array($publicUserIdentity) && (count($publicUserIdentity) > 0)) {
			foreach ($publicUserIdentity as $publicUserIdentityxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->choicepublicUserIdentity = $choicepublicUserIdentity;
			$this->publicUserIdentity = $publicUserIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserShInterfaceGetPublicIdDataRequest");
		$this->comando->setAttribute("xmlns", "");

		if (isset($this->choicepublicUserIdentity['sipURI'])) {
			$elemxd1 = new DOMElement("sipURI", $this->choicepublicUserIdentity['sipURI']);
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicepublicUserIdentity['telURI'])) {
			$elemxd2 = new DOMElement("telURI", $this->choicepublicUserIdentity['telURI']);
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->publicUserIdentity) && count($this->publicUserIdentity) > 0) {
			$elem2 = new DOMElement("publicUserIdentity");
			$this->comando->appendChild($elem2);

			foreach ($this->publicUserIdentity as $publicUserIdentityxd) {
				if (isset($publicUserIdentityxd[''])) {
					$elemtin1 = new DOMElement("", $publicUserIdentityxd['']);
					$elem2->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserShInterfaceGetUserIdDataRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserShInterfaceGetUserIdDataRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserShInterfaceModifyRequest extends BroadsoftXMLCommand { 

	private $choicepublicUserIdentity;
	private $publicUserIdentity;
	private $SCSCFName;
	private $IMSUserState;

	/* Conjunto Recibe [Public User Identity] 

	Conjunto Recibe [Public User Identity] 

	[choicepublicUserIdentity] es un Opcional Compuesto
sipURI[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161]
	telURI[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23]
	publicUserIdentity es un compuesto de: 
	tipo especial []
	SCSCFName[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]IMSUserState[xs:token (enumeration)]: IMS User State per the 3GPP TS 29.328 V6.3.0 spec. valores [Not Registered, Registered, Registered UnReg Services, Authentication Pending] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($choicepublicUserIdentity, $publicUserIdentity, $SCSCFName, $IMSUserState) {
		$ret = true;
		if (is_array($choicepublicUserIdentity) && (count($choicepublicUserIdentity) > 0)) {
			foreach ($choicepublicUserIdentity as $choicepublicUserIdentityxd ) {
				if (isset($choicepublicUserIdentityxd['SIPURI'] )) {
					if (strlen($choicepublicUserIdentityxd['sipURI']) != strlen(trim( str_replace('  ', ' ', $choicepublicUserIdentityxd['sipURI'])))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepublicUserIdentityxd['sipURI'])))))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) < 1) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) > 161) $ret = false;
				}
				if (isset($choicepublicUserIdentityxd['DN'] )) {
					if (strlen($choicepublicUserIdentityxd['telURI']) != strlen(trim( str_replace('  ', ' ', $choicepublicUserIdentityxd['telURI'])))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepublicUserIdentityxd['telURI'])))))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) < 1) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) > 23) $ret = false;
				}
			}
		} else { $ret = false; }
		if (is_array($publicUserIdentity) && (count($publicUserIdentity) > 0)) {
			foreach ($publicUserIdentity as $publicUserIdentityxd ) {
			}
		}
		if (is_array($SCSCFName) && (count($SCSCFName) > 0)) {
			foreach ($SCSCFName as $SCSCFNamexd ) {
				if ($SCSCFNamexd != null) {
					if (strlen($SCSCFNamexd) != strlen(trim( str_replace('  ', ' ', $SCSCFNamexd)))) $ret = false;
					if (strlen($SCSCFNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $SCSCFNamexd)))))) $ret = false;
					if (strlen($SCSCFNamexd) < 1) $ret = false;
					if (strlen($SCSCFNamexd) > 161) $ret = false;
				}
			}
		}
		if (count($SCSCFName) < 0) $ret = false;
		if (is_array($IMSUserState) && (count($IMSUserState) > 0)) {
			foreach ($IMSUserState as $IMSUserStatexd ) {
				if ($IMSUserStatexd != null) {
					if (($IMSUserStatexd != "Not Registered") && ($IMSUserStatexd != "Registered") && ($IMSUserStatexd != "Registered UnReg Services") && ($IMSUserStatexd != "Authentication Pending")) $ret = false;
				}
			}
		}
		if (count($IMSUserState) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->choicepublicUserIdentity = $choicepublicUserIdentity;
			$this->publicUserIdentity = $publicUserIdentity;
			$this->SCSCFName = $SCSCFName;
			$this->IMSUserState = $IMSUserState;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserShInterfaceModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (isset($this->choicepublicUserIdentity['sipURI'])) {
			$elemxd1 = new DOMElement("sipURI", $this->choicepublicUserIdentity['sipURI']);
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicepublicUserIdentity['telURI'])) {
			$elemxd2 = new DOMElement("telURI", $this->choicepublicUserIdentity['telURI']);
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->publicUserIdentity) && count($this->publicUserIdentity) > 0) {
			$elem2 = new DOMElement("publicUserIdentity");
			$this->comando->appendChild($elem2);

			foreach ($this->publicUserIdentity as $publicUserIdentityxd) {
				if (isset($publicUserIdentityxd[''])) {
					$elemtin1 = new DOMElement("", $publicUserIdentityxd['']);
					$elem2->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->SCSCFName) && count($this->SCSCFName) > 0) {
			foreach ($this->SCSCFName as $SCSCFNamexd) {
				$elem2 = new DOMElement("SCSCFName", $SCSCFNamexd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->IMSUserState) && count($this->IMSUserState) > 0) {
			foreach ($this->IMSUserState as $IMSUserStatexd) {
				$elem2 = new DOMElement("IMSUserState", $IMSUserStatexd);
				$this->comando->appendChild($elem2);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserShInterfacePublicIdentityRefreshTaskStartRequest extends BroadsoftXMLCommand { 

	private $choicepublicUserIdentity;
	private $publicUserIdentity;

	/* Conjunto Recibe [Public User Identity] 

	Conjunto Recibe [Public User Identity] 

	[choicepublicUserIdentity] es un Opcional Compuesto
sipURI[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161]
	telURI[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23]
	publicUserIdentity es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($choicepublicUserIdentity, $publicUserIdentity) {
		$ret = true;
		if (is_array($choicepublicUserIdentity) && (count($choicepublicUserIdentity) > 0)) {
			foreach ($choicepublicUserIdentity as $choicepublicUserIdentityxd ) {
				if (isset($choicepublicUserIdentityxd['SIPURI'] )) {
					if (strlen($choicepublicUserIdentityxd['sipURI']) != strlen(trim( str_replace('  ', ' ', $choicepublicUserIdentityxd['sipURI'])))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepublicUserIdentityxd['sipURI'])))))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) < 1) $ret = false;
					if (strlen($choicepublicUserIdentityxd['sipURI']) > 161) $ret = false;
				}
				if (isset($choicepublicUserIdentityxd['DN'] )) {
					if (strlen($choicepublicUserIdentityxd['telURI']) != strlen(trim( str_replace('  ', ' ', $choicepublicUserIdentityxd['telURI'])))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepublicUserIdentityxd['telURI'])))))) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) < 1) $ret = false;
					if (strlen($choicepublicUserIdentityxd['telURI']) > 23) $ret = false;
				}
			}
		} else { $ret = false; }
		if (is_array($publicUserIdentity) && (count($publicUserIdentity) > 0)) {
			foreach ($publicUserIdentity as $publicUserIdentityxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->choicepublicUserIdentity = $choicepublicUserIdentity;
			$this->publicUserIdentity = $publicUserIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserShInterfacePublicIdentityRefreshTaskStartRequest");
		$this->comando->setAttribute("xmlns", "");

		if (isset($this->choicepublicUserIdentity['sipURI'])) {
			$elemxd1 = new DOMElement("sipURI", $this->choicepublicUserIdentity['sipURI']);
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicepublicUserIdentity['telURI'])) {
			$elemxd2 = new DOMElement("telURI", $this->choicepublicUserIdentity['telURI']);
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->publicUserIdentity) && count($this->publicUserIdentity) > 0) {
			$elem2 = new DOMElement("publicUserIdentity");
			$this->comando->appendChild($elem2);

			foreach ($this->publicUserIdentity as $publicUserIdentityxd) {
				if (isset($publicUserIdentityxd[''])) {
					$elemtin1 = new DOMElement("", $publicUserIdentityxd['']);
					$elem2->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserTimeScheduleAddRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $timeScheduleName;
	private $timeInterval01;
	private $timeInterval02;
	private $timeInterval03;
	private $timeInterval04;
	private $timeInterval05;
	private $timeInterval06;
	private $timeInterval07;
	private $timeInterval08;
	private $timeInterval09;
	private $timeInterval10;
	private $timeInterval11;
	private $timeInterval12;
	private $timeInterval13;
	private $timeInterval14;
	private $timeInterval15;
	private $timeInterval16;
	private $timeInterval17;
	private $timeInterval18;
	private $timeInterval19;
	private $timeInterval20;

	/* Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	timeInterval01 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval02 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval03 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval04 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval05 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval06 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval07 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval08 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval09 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval10 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval11 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval12 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval13 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval14 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval15 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval16 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval17 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval18 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval19 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval20 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $timeScheduleName, $timeInterval01, $timeInterval02, $timeInterval03, $timeInterval04, $timeInterval05, $timeInterval06, $timeInterval07, $timeInterval08, $timeInterval09, $timeInterval10, $timeInterval11, $timeInterval12, $timeInterval13, $timeInterval14, $timeInterval15, $timeInterval16, $timeInterval17, $timeInterval18, $timeInterval19, $timeInterval20) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if (is_array($timeInterval01) && (count($timeInterval01) > 0)) {
			foreach ($timeInterval01 as $timeInterval01xd ) {
				if ($timeInterval01xd['endHour'] != null) {
					if (!is_numeric($timeInterval01xd['endHour'])) $ret = false;
					if (($timeInterval01xd['endHour'] < -2147483648) || ($timeInterval01xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endHour'] > 23) $ret = false;
					if ($timeInterval01xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval01xd['endMinute'] != null) {
					if (!is_numeric($timeInterval01xd['endMinute'])) $ret = false;
					if (($timeInterval01xd['endMinute'] < -2147483648) || ($timeInterval01xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endMinute'] > 59) $ret = false;
					if ($timeInterval01xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval01) < 0) $ret = false;
		if (is_array($timeInterval02) && (count($timeInterval02) > 0)) {
			foreach ($timeInterval02 as $timeInterval02xd ) {
				if ($timeInterval02xd['endHour'] != null) {
					if (!is_numeric($timeInterval02xd['endHour'])) $ret = false;
					if (($timeInterval02xd['endHour'] < -2147483648) || ($timeInterval02xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endHour'] > 23) $ret = false;
					if ($timeInterval02xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval02xd['endMinute'] != null) {
					if (!is_numeric($timeInterval02xd['endMinute'])) $ret = false;
					if (($timeInterval02xd['endMinute'] < -2147483648) || ($timeInterval02xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endMinute'] > 59) $ret = false;
					if ($timeInterval02xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval02) < 0) $ret = false;
		if (is_array($timeInterval03) && (count($timeInterval03) > 0)) {
			foreach ($timeInterval03 as $timeInterval03xd ) {
				if ($timeInterval03xd['endHour'] != null) {
					if (!is_numeric($timeInterval03xd['endHour'])) $ret = false;
					if (($timeInterval03xd['endHour'] < -2147483648) || ($timeInterval03xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endHour'] > 23) $ret = false;
					if ($timeInterval03xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval03xd['endMinute'] != null) {
					if (!is_numeric($timeInterval03xd['endMinute'])) $ret = false;
					if (($timeInterval03xd['endMinute'] < -2147483648) || ($timeInterval03xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endMinute'] > 59) $ret = false;
					if ($timeInterval03xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval03) < 0) $ret = false;
		if (is_array($timeInterval04) && (count($timeInterval04) > 0)) {
			foreach ($timeInterval04 as $timeInterval04xd ) {
				if ($timeInterval04xd['endHour'] != null) {
					if (!is_numeric($timeInterval04xd['endHour'])) $ret = false;
					if (($timeInterval04xd['endHour'] < -2147483648) || ($timeInterval04xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endHour'] > 23) $ret = false;
					if ($timeInterval04xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval04xd['endMinute'] != null) {
					if (!is_numeric($timeInterval04xd['endMinute'])) $ret = false;
					if (($timeInterval04xd['endMinute'] < -2147483648) || ($timeInterval04xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endMinute'] > 59) $ret = false;
					if ($timeInterval04xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval04) < 0) $ret = false;
		if (is_array($timeInterval05) && (count($timeInterval05) > 0)) {
			foreach ($timeInterval05 as $timeInterval05xd ) {
				if ($timeInterval05xd['endHour'] != null) {
					if (!is_numeric($timeInterval05xd['endHour'])) $ret = false;
					if (($timeInterval05xd['endHour'] < -2147483648) || ($timeInterval05xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endHour'] > 23) $ret = false;
					if ($timeInterval05xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval05xd['endMinute'] != null) {
					if (!is_numeric($timeInterval05xd['endMinute'])) $ret = false;
					if (($timeInterval05xd['endMinute'] < -2147483648) || ($timeInterval05xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endMinute'] > 59) $ret = false;
					if ($timeInterval05xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval05) < 0) $ret = false;
		if (is_array($timeInterval06) && (count($timeInterval06) > 0)) {
			foreach ($timeInterval06 as $timeInterval06xd ) {
				if ($timeInterval06xd['endHour'] != null) {
					if (!is_numeric($timeInterval06xd['endHour'])) $ret = false;
					if (($timeInterval06xd['endHour'] < -2147483648) || ($timeInterval06xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endHour'] > 23) $ret = false;
					if ($timeInterval06xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval06xd['endMinute'] != null) {
					if (!is_numeric($timeInterval06xd['endMinute'])) $ret = false;
					if (($timeInterval06xd['endMinute'] < -2147483648) || ($timeInterval06xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endMinute'] > 59) $ret = false;
					if ($timeInterval06xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval06) < 0) $ret = false;
		if (is_array($timeInterval07) && (count($timeInterval07) > 0)) {
			foreach ($timeInterval07 as $timeInterval07xd ) {
				if ($timeInterval07xd['endHour'] != null) {
					if (!is_numeric($timeInterval07xd['endHour'])) $ret = false;
					if (($timeInterval07xd['endHour'] < -2147483648) || ($timeInterval07xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endHour'] > 23) $ret = false;
					if ($timeInterval07xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval07xd['endMinute'] != null) {
					if (!is_numeric($timeInterval07xd['endMinute'])) $ret = false;
					if (($timeInterval07xd['endMinute'] < -2147483648) || ($timeInterval07xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endMinute'] > 59) $ret = false;
					if ($timeInterval07xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval07) < 0) $ret = false;
		if (is_array($timeInterval08) && (count($timeInterval08) > 0)) {
			foreach ($timeInterval08 as $timeInterval08xd ) {
				if ($timeInterval08xd['endHour'] != null) {
					if (!is_numeric($timeInterval08xd['endHour'])) $ret = false;
					if (($timeInterval08xd['endHour'] < -2147483648) || ($timeInterval08xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endHour'] > 23) $ret = false;
					if ($timeInterval08xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval08xd['endMinute'] != null) {
					if (!is_numeric($timeInterval08xd['endMinute'])) $ret = false;
					if (($timeInterval08xd['endMinute'] < -2147483648) || ($timeInterval08xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endMinute'] > 59) $ret = false;
					if ($timeInterval08xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval08) < 0) $ret = false;
		if (is_array($timeInterval09) && (count($timeInterval09) > 0)) {
			foreach ($timeInterval09 as $timeInterval09xd ) {
				if ($timeInterval09xd['endHour'] != null) {
					if (!is_numeric($timeInterval09xd['endHour'])) $ret = false;
					if (($timeInterval09xd['endHour'] < -2147483648) || ($timeInterval09xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endHour'] > 23) $ret = false;
					if ($timeInterval09xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval09xd['endMinute'] != null) {
					if (!is_numeric($timeInterval09xd['endMinute'])) $ret = false;
					if (($timeInterval09xd['endMinute'] < -2147483648) || ($timeInterval09xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endMinute'] > 59) $ret = false;
					if ($timeInterval09xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval09) < 0) $ret = false;
		if (is_array($timeInterval10) && (count($timeInterval10) > 0)) {
			foreach ($timeInterval10 as $timeInterval10xd ) {
				if ($timeInterval10xd['endHour'] != null) {
					if (!is_numeric($timeInterval10xd['endHour'])) $ret = false;
					if (($timeInterval10xd['endHour'] < -2147483648) || ($timeInterval10xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endHour'] > 23) $ret = false;
					if ($timeInterval10xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval10xd['endMinute'] != null) {
					if (!is_numeric($timeInterval10xd['endMinute'])) $ret = false;
					if (($timeInterval10xd['endMinute'] < -2147483648) || ($timeInterval10xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endMinute'] > 59) $ret = false;
					if ($timeInterval10xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval10) < 0) $ret = false;
		if (is_array($timeInterval11) && (count($timeInterval11) > 0)) {
			foreach ($timeInterval11 as $timeInterval11xd ) {
				if ($timeInterval11xd['endHour'] != null) {
					if (!is_numeric($timeInterval11xd['endHour'])) $ret = false;
					if (($timeInterval11xd['endHour'] < -2147483648) || ($timeInterval11xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endHour'] > 23) $ret = false;
					if ($timeInterval11xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval11xd['endMinute'] != null) {
					if (!is_numeric($timeInterval11xd['endMinute'])) $ret = false;
					if (($timeInterval11xd['endMinute'] < -2147483648) || ($timeInterval11xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endMinute'] > 59) $ret = false;
					if ($timeInterval11xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval11) < 0) $ret = false;
		if (is_array($timeInterval12) && (count($timeInterval12) > 0)) {
			foreach ($timeInterval12 as $timeInterval12xd ) {
				if ($timeInterval12xd['endHour'] != null) {
					if (!is_numeric($timeInterval12xd['endHour'])) $ret = false;
					if (($timeInterval12xd['endHour'] < -2147483648) || ($timeInterval12xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endHour'] > 23) $ret = false;
					if ($timeInterval12xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval12xd['endMinute'] != null) {
					if (!is_numeric($timeInterval12xd['endMinute'])) $ret = false;
					if (($timeInterval12xd['endMinute'] < -2147483648) || ($timeInterval12xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endMinute'] > 59) $ret = false;
					if ($timeInterval12xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval12) < 0) $ret = false;
		if (is_array($timeInterval13) && (count($timeInterval13) > 0)) {
			foreach ($timeInterval13 as $timeInterval13xd ) {
				if ($timeInterval13xd['endHour'] != null) {
					if (!is_numeric($timeInterval13xd['endHour'])) $ret = false;
					if (($timeInterval13xd['endHour'] < -2147483648) || ($timeInterval13xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endHour'] > 23) $ret = false;
					if ($timeInterval13xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval13xd['endMinute'] != null) {
					if (!is_numeric($timeInterval13xd['endMinute'])) $ret = false;
					if (($timeInterval13xd['endMinute'] < -2147483648) || ($timeInterval13xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endMinute'] > 59) $ret = false;
					if ($timeInterval13xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval13) < 0) $ret = false;
		if (is_array($timeInterval14) && (count($timeInterval14) > 0)) {
			foreach ($timeInterval14 as $timeInterval14xd ) {
				if ($timeInterval14xd['endHour'] != null) {
					if (!is_numeric($timeInterval14xd['endHour'])) $ret = false;
					if (($timeInterval14xd['endHour'] < -2147483648) || ($timeInterval14xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endHour'] > 23) $ret = false;
					if ($timeInterval14xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval14xd['endMinute'] != null) {
					if (!is_numeric($timeInterval14xd['endMinute'])) $ret = false;
					if (($timeInterval14xd['endMinute'] < -2147483648) || ($timeInterval14xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endMinute'] > 59) $ret = false;
					if ($timeInterval14xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval14) < 0) $ret = false;
		if (is_array($timeInterval15) && (count($timeInterval15) > 0)) {
			foreach ($timeInterval15 as $timeInterval15xd ) {
				if ($timeInterval15xd['endHour'] != null) {
					if (!is_numeric($timeInterval15xd['endHour'])) $ret = false;
					if (($timeInterval15xd['endHour'] < -2147483648) || ($timeInterval15xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endHour'] > 23) $ret = false;
					if ($timeInterval15xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval15xd['endMinute'] != null) {
					if (!is_numeric($timeInterval15xd['endMinute'])) $ret = false;
					if (($timeInterval15xd['endMinute'] < -2147483648) || ($timeInterval15xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endMinute'] > 59) $ret = false;
					if ($timeInterval15xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval15) < 0) $ret = false;
		if (is_array($timeInterval16) && (count($timeInterval16) > 0)) {
			foreach ($timeInterval16 as $timeInterval16xd ) {
				if ($timeInterval16xd['endHour'] != null) {
					if (!is_numeric($timeInterval16xd['endHour'])) $ret = false;
					if (($timeInterval16xd['endHour'] < -2147483648) || ($timeInterval16xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endHour'] > 23) $ret = false;
					if ($timeInterval16xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval16xd['endMinute'] != null) {
					if (!is_numeric($timeInterval16xd['endMinute'])) $ret = false;
					if (($timeInterval16xd['endMinute'] < -2147483648) || ($timeInterval16xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endMinute'] > 59) $ret = false;
					if ($timeInterval16xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval16) < 0) $ret = false;
		if (is_array($timeInterval17) && (count($timeInterval17) > 0)) {
			foreach ($timeInterval17 as $timeInterval17xd ) {
				if ($timeInterval17xd['endHour'] != null) {
					if (!is_numeric($timeInterval17xd['endHour'])) $ret = false;
					if (($timeInterval17xd['endHour'] < -2147483648) || ($timeInterval17xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endHour'] > 23) $ret = false;
					if ($timeInterval17xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval17xd['endMinute'] != null) {
					if (!is_numeric($timeInterval17xd['endMinute'])) $ret = false;
					if (($timeInterval17xd['endMinute'] < -2147483648) || ($timeInterval17xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endMinute'] > 59) $ret = false;
					if ($timeInterval17xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval17) < 0) $ret = false;
		if (is_array($timeInterval18) && (count($timeInterval18) > 0)) {
			foreach ($timeInterval18 as $timeInterval18xd ) {
				if ($timeInterval18xd['endHour'] != null) {
					if (!is_numeric($timeInterval18xd['endHour'])) $ret = false;
					if (($timeInterval18xd['endHour'] < -2147483648) || ($timeInterval18xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endHour'] > 23) $ret = false;
					if ($timeInterval18xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval18xd['endMinute'] != null) {
					if (!is_numeric($timeInterval18xd['endMinute'])) $ret = false;
					if (($timeInterval18xd['endMinute'] < -2147483648) || ($timeInterval18xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endMinute'] > 59) $ret = false;
					if ($timeInterval18xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval18) < 0) $ret = false;
		if (is_array($timeInterval19) && (count($timeInterval19) > 0)) {
			foreach ($timeInterval19 as $timeInterval19xd ) {
				if ($timeInterval19xd['endHour'] != null) {
					if (!is_numeric($timeInterval19xd['endHour'])) $ret = false;
					if (($timeInterval19xd['endHour'] < -2147483648) || ($timeInterval19xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endHour'] > 23) $ret = false;
					if ($timeInterval19xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval19xd['endMinute'] != null) {
					if (!is_numeric($timeInterval19xd['endMinute'])) $ret = false;
					if (($timeInterval19xd['endMinute'] < -2147483648) || ($timeInterval19xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endMinute'] > 59) $ret = false;
					if ($timeInterval19xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval19) < 0) $ret = false;
		if (is_array($timeInterval20) && (count($timeInterval20) > 0)) {
			foreach ($timeInterval20 as $timeInterval20xd ) {
				if ($timeInterval20xd['endHour'] != null) {
					if (!is_numeric($timeInterval20xd['endHour'])) $ret = false;
					if (($timeInterval20xd['endHour'] < -2147483648) || ($timeInterval20xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endHour'] > 23) $ret = false;
					if ($timeInterval20xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval20xd['endMinute'] != null) {
					if (!is_numeric($timeInterval20xd['endMinute'])) $ret = false;
					if (($timeInterval20xd['endMinute'] < -2147483648) || ($timeInterval20xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endMinute'] > 59) $ret = false;
					if ($timeInterval20xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->timeScheduleName = $timeScheduleName;
			$this->timeInterval01 = $timeInterval01;
			$this->timeInterval02 = $timeInterval02;
			$this->timeInterval03 = $timeInterval03;
			$this->timeInterval04 = $timeInterval04;
			$this->timeInterval05 = $timeInterval05;
			$this->timeInterval06 = $timeInterval06;
			$this->timeInterval07 = $timeInterval07;
			$this->timeInterval08 = $timeInterval08;
			$this->timeInterval09 = $timeInterval09;
			$this->timeInterval10 = $timeInterval10;
			$this->timeInterval11 = $timeInterval11;
			$this->timeInterval12 = $timeInterval12;
			$this->timeInterval13 = $timeInterval13;
			$this->timeInterval14 = $timeInterval14;
			$this->timeInterval15 = $timeInterval15;
			$this->timeInterval16 = $timeInterval16;
			$this->timeInterval17 = $timeInterval17;
			$this->timeInterval18 = $timeInterval18;
			$this->timeInterval19 = $timeInterval19;
			$this->timeInterval20 = $timeInterval20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserTimeScheduleAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("timeScheduleName", $this->timeScheduleName);
		$this->comando->appendChild($elem2);

		if (is_array($this->timeInterval01) && count($this->timeInterval01) > 0) {
			$elem3 = new DOMElement("timeInterval01");
			$this->comando->appendChild($elem3);

			foreach ($this->timeInterval01 as $timeInterval01xd) {
				if (isset($timeInterval01xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval01xd['endDayOfWeek']);
					$elem3->appendChild($elemtin1);

				}
				if (isset($timeInterval01xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval01xd['endHour']);
					$elem3->appendChild($elemtin2);

				}
				if (isset($timeInterval01xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval01xd['endMinute']);
					$elem3->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval02) && count($this->timeInterval02) > 0) {
			$elem4 = new DOMElement("timeInterval02");
			$this->comando->appendChild($elem4);

			foreach ($this->timeInterval02 as $timeInterval02xd) {
				if (isset($timeInterval02xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval02xd['endDayOfWeek']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($timeInterval02xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval02xd['endHour']);
					$elem4->appendChild($elemtin2);

				}
				if (isset($timeInterval02xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval02xd['endMinute']);
					$elem4->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval03) && count($this->timeInterval03) > 0) {
			$elem5 = new DOMElement("timeInterval03");
			$this->comando->appendChild($elem5);

			foreach ($this->timeInterval03 as $timeInterval03xd) {
				if (isset($timeInterval03xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval03xd['endDayOfWeek']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($timeInterval03xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval03xd['endHour']);
					$elem5->appendChild($elemtin2);

				}
				if (isset($timeInterval03xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval03xd['endMinute']);
					$elem5->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval04) && count($this->timeInterval04) > 0) {
			$elem6 = new DOMElement("timeInterval04");
			$this->comando->appendChild($elem6);

			foreach ($this->timeInterval04 as $timeInterval04xd) {
				if (isset($timeInterval04xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval04xd['endDayOfWeek']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($timeInterval04xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval04xd['endHour']);
					$elem6->appendChild($elemtin2);

				}
				if (isset($timeInterval04xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval04xd['endMinute']);
					$elem6->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval05) && count($this->timeInterval05) > 0) {
			$elem7 = new DOMElement("timeInterval05");
			$this->comando->appendChild($elem7);

			foreach ($this->timeInterval05 as $timeInterval05xd) {
				if (isset($timeInterval05xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval05xd['endDayOfWeek']);
					$elem7->appendChild($elemtin1);

				}
				if (isset($timeInterval05xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval05xd['endHour']);
					$elem7->appendChild($elemtin2);

				}
				if (isset($timeInterval05xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval05xd['endMinute']);
					$elem7->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval06) && count($this->timeInterval06) > 0) {
			$elem8 = new DOMElement("timeInterval06");
			$this->comando->appendChild($elem8);

			foreach ($this->timeInterval06 as $timeInterval06xd) {
				if (isset($timeInterval06xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval06xd['endDayOfWeek']);
					$elem8->appendChild($elemtin1);

				}
				if (isset($timeInterval06xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval06xd['endHour']);
					$elem8->appendChild($elemtin2);

				}
				if (isset($timeInterval06xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval06xd['endMinute']);
					$elem8->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval07) && count($this->timeInterval07) > 0) {
			$elem9 = new DOMElement("timeInterval07");
			$this->comando->appendChild($elem9);

			foreach ($this->timeInterval07 as $timeInterval07xd) {
				if (isset($timeInterval07xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval07xd['endDayOfWeek']);
					$elem9->appendChild($elemtin1);

				}
				if (isset($timeInterval07xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval07xd['endHour']);
					$elem9->appendChild($elemtin2);

				}
				if (isset($timeInterval07xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval07xd['endMinute']);
					$elem9->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval08) && count($this->timeInterval08) > 0) {
			$elem10 = new DOMElement("timeInterval08");
			$this->comando->appendChild($elem10);

			foreach ($this->timeInterval08 as $timeInterval08xd) {
				if (isset($timeInterval08xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval08xd['endDayOfWeek']);
					$elem10->appendChild($elemtin1);

				}
				if (isset($timeInterval08xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval08xd['endHour']);
					$elem10->appendChild($elemtin2);

				}
				if (isset($timeInterval08xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval08xd['endMinute']);
					$elem10->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval09) && count($this->timeInterval09) > 0) {
			$elem11 = new DOMElement("timeInterval09");
			$this->comando->appendChild($elem11);

			foreach ($this->timeInterval09 as $timeInterval09xd) {
				if (isset($timeInterval09xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval09xd['endDayOfWeek']);
					$elem11->appendChild($elemtin1);

				}
				if (isset($timeInterval09xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval09xd['endHour']);
					$elem11->appendChild($elemtin2);

				}
				if (isset($timeInterval09xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval09xd['endMinute']);
					$elem11->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval10) && count($this->timeInterval10) > 0) {
			$elem12 = new DOMElement("timeInterval10");
			$this->comando->appendChild($elem12);

			foreach ($this->timeInterval10 as $timeInterval10xd) {
				if (isset($timeInterval10xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval10xd['endDayOfWeek']);
					$elem12->appendChild($elemtin1);

				}
				if (isset($timeInterval10xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval10xd['endHour']);
					$elem12->appendChild($elemtin2);

				}
				if (isset($timeInterval10xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval10xd['endMinute']);
					$elem12->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval11) && count($this->timeInterval11) > 0) {
			$elem13 = new DOMElement("timeInterval11");
			$this->comando->appendChild($elem13);

			foreach ($this->timeInterval11 as $timeInterval11xd) {
				if (isset($timeInterval11xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval11xd['endDayOfWeek']);
					$elem13->appendChild($elemtin1);

				}
				if (isset($timeInterval11xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval11xd['endHour']);
					$elem13->appendChild($elemtin2);

				}
				if (isset($timeInterval11xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval11xd['endMinute']);
					$elem13->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval12) && count($this->timeInterval12) > 0) {
			$elem14 = new DOMElement("timeInterval12");
			$this->comando->appendChild($elem14);

			foreach ($this->timeInterval12 as $timeInterval12xd) {
				if (isset($timeInterval12xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval12xd['endDayOfWeek']);
					$elem14->appendChild($elemtin1);

				}
				if (isset($timeInterval12xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval12xd['endHour']);
					$elem14->appendChild($elemtin2);

				}
				if (isset($timeInterval12xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval12xd['endMinute']);
					$elem14->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval13) && count($this->timeInterval13) > 0) {
			$elem15 = new DOMElement("timeInterval13");
			$this->comando->appendChild($elem15);

			foreach ($this->timeInterval13 as $timeInterval13xd) {
				if (isset($timeInterval13xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval13xd['endDayOfWeek']);
					$elem15->appendChild($elemtin1);

				}
				if (isset($timeInterval13xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval13xd['endHour']);
					$elem15->appendChild($elemtin2);

				}
				if (isset($timeInterval13xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval13xd['endMinute']);
					$elem15->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval14) && count($this->timeInterval14) > 0) {
			$elem16 = new DOMElement("timeInterval14");
			$this->comando->appendChild($elem16);

			foreach ($this->timeInterval14 as $timeInterval14xd) {
				if (isset($timeInterval14xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval14xd['endDayOfWeek']);
					$elem16->appendChild($elemtin1);

				}
				if (isset($timeInterval14xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval14xd['endHour']);
					$elem16->appendChild($elemtin2);

				}
				if (isset($timeInterval14xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval14xd['endMinute']);
					$elem16->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval15) && count($this->timeInterval15) > 0) {
			$elem17 = new DOMElement("timeInterval15");
			$this->comando->appendChild($elem17);

			foreach ($this->timeInterval15 as $timeInterval15xd) {
				if (isset($timeInterval15xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval15xd['endDayOfWeek']);
					$elem17->appendChild($elemtin1);

				}
				if (isset($timeInterval15xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval15xd['endHour']);
					$elem17->appendChild($elemtin2);

				}
				if (isset($timeInterval15xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval15xd['endMinute']);
					$elem17->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval16) && count($this->timeInterval16) > 0) {
			$elem18 = new DOMElement("timeInterval16");
			$this->comando->appendChild($elem18);

			foreach ($this->timeInterval16 as $timeInterval16xd) {
				if (isset($timeInterval16xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval16xd['endDayOfWeek']);
					$elem18->appendChild($elemtin1);

				}
				if (isset($timeInterval16xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval16xd['endHour']);
					$elem18->appendChild($elemtin2);

				}
				if (isset($timeInterval16xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval16xd['endMinute']);
					$elem18->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval17) && count($this->timeInterval17) > 0) {
			$elem19 = new DOMElement("timeInterval17");
			$this->comando->appendChild($elem19);

			foreach ($this->timeInterval17 as $timeInterval17xd) {
				if (isset($timeInterval17xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval17xd['endDayOfWeek']);
					$elem19->appendChild($elemtin1);

				}
				if (isset($timeInterval17xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval17xd['endHour']);
					$elem19->appendChild($elemtin2);

				}
				if (isset($timeInterval17xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval17xd['endMinute']);
					$elem19->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval18) && count($this->timeInterval18) > 0) {
			$elem20 = new DOMElement("timeInterval18");
			$this->comando->appendChild($elem20);

			foreach ($this->timeInterval18 as $timeInterval18xd) {
				if (isset($timeInterval18xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval18xd['endDayOfWeek']);
					$elem20->appendChild($elemtin1);

				}
				if (isset($timeInterval18xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval18xd['endHour']);
					$elem20->appendChild($elemtin2);

				}
				if (isset($timeInterval18xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval18xd['endMinute']);
					$elem20->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval19) && count($this->timeInterval19) > 0) {
			$elem21 = new DOMElement("timeInterval19");
			$this->comando->appendChild($elem21);

			foreach ($this->timeInterval19 as $timeInterval19xd) {
				if (isset($timeInterval19xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval19xd['endDayOfWeek']);
					$elem21->appendChild($elemtin1);

				}
				if (isset($timeInterval19xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval19xd['endHour']);
					$elem21->appendChild($elemtin2);

				}
				if (isset($timeInterval19xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval19xd['endMinute']);
					$elem21->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval20) && count($this->timeInterval20) > 0) {
			$elem22 = new DOMElement("timeInterval20");
			$this->comando->appendChild($elem22);

			foreach ($this->timeInterval20 as $timeInterval20xd) {
				if (isset($timeInterval20xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval20xd['endDayOfWeek']);
					$elem22->appendChild($elemtin1);

				}
				if (isset($timeInterval20xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval20xd['endHour']);
					$elem22->appendChild($elemtin2);

				}
				if (isset($timeInterval20xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval20xd['endMinute']);
					$elem22->appendChild($elemtin3);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserTimeScheduleDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $timeScheduleName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($userId, $timeScheduleName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->timeScheduleName = $timeScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserTimeScheduleDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("timeScheduleName", $this->timeScheduleName);
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserTimeScheduleGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserTimeScheduleGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserTimeScheduleGetRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $timeScheduleName;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($userId, $timeScheduleName) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->timeScheduleName = $timeScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserTimeScheduleGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("timeScheduleName", $this->timeScheduleName);
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserTimeScheduleModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $timeScheduleName;
	private $newTimeScheduleName;
	private $timeInterval01;
	private $timeInterval02;
	private $timeInterval03;
	private $timeInterval04;
	private $timeInterval05;
	private $timeInterval06;
	private $timeInterval07;
	private $timeInterval08;
	private $timeInterval09;
	private $timeInterval10;
	private $timeInterval11;
	private $timeInterval12;
	private $timeInterval13;
	private $timeInterval14;
	private $timeInterval15;
	private $timeInterval16;
	private $timeInterval17;
	private $timeInterval18;
	private $timeInterval19;
	private $timeInterval20;

	/* Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	newTimeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]timeInterval01 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval02 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval03 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval04 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval05 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval06 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval07 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval08 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval09 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval10 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval11 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval12 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval13 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval14 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval15 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval16 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval17 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval18 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval19 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval20 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $timeScheduleName, $newTimeScheduleName, $timeInterval01, $timeInterval02, $timeInterval03, $timeInterval04, $timeInterval05, $timeInterval06, $timeInterval07, $timeInterval08, $timeInterval09, $timeInterval10, $timeInterval11, $timeInterval12, $timeInterval13, $timeInterval14, $timeInterval15, $timeInterval16, $timeInterval17, $timeInterval18, $timeInterval19, $timeInterval20) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if (is_array($newTimeScheduleName) && (count($newTimeScheduleName) > 0)) {
			foreach ($newTimeScheduleName as $newTimeScheduleNamexd ) {
				if ($newTimeScheduleNamexd != null) {
					if (strlen($newTimeScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $newTimeScheduleNamexd)))) $ret = false;
					if (strlen($newTimeScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newTimeScheduleNamexd)))))) $ret = false;
					if (strlen($newTimeScheduleNamexd) < 1) $ret = false;
					if (strlen($newTimeScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newTimeScheduleName) < 0) $ret = false;
		if (is_array($timeInterval01) && (count($timeInterval01) > 0)) {
			foreach ($timeInterval01 as $timeInterval01xd ) {
				if ($timeInterval01xd['endHour'] != null) {
					if (!is_numeric($timeInterval01xd['endHour'])) $ret = false;
					if (($timeInterval01xd['endHour'] < -2147483648) || ($timeInterval01xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endHour'] > 23) $ret = false;
					if ($timeInterval01xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval01xd['endMinute'] != null) {
					if (!is_numeric($timeInterval01xd['endMinute'])) $ret = false;
					if (($timeInterval01xd['endMinute'] < -2147483648) || ($timeInterval01xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endMinute'] > 59) $ret = false;
					if ($timeInterval01xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval01) < 0) $ret = false;
		if (is_array($timeInterval02) && (count($timeInterval02) > 0)) {
			foreach ($timeInterval02 as $timeInterval02xd ) {
				if ($timeInterval02xd['endHour'] != null) {
					if (!is_numeric($timeInterval02xd['endHour'])) $ret = false;
					if (($timeInterval02xd['endHour'] < -2147483648) || ($timeInterval02xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endHour'] > 23) $ret = false;
					if ($timeInterval02xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval02xd['endMinute'] != null) {
					if (!is_numeric($timeInterval02xd['endMinute'])) $ret = false;
					if (($timeInterval02xd['endMinute'] < -2147483648) || ($timeInterval02xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endMinute'] > 59) $ret = false;
					if ($timeInterval02xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval02) < 0) $ret = false;
		if (is_array($timeInterval03) && (count($timeInterval03) > 0)) {
			foreach ($timeInterval03 as $timeInterval03xd ) {
				if ($timeInterval03xd['endHour'] != null) {
					if (!is_numeric($timeInterval03xd['endHour'])) $ret = false;
					if (($timeInterval03xd['endHour'] < -2147483648) || ($timeInterval03xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endHour'] > 23) $ret = false;
					if ($timeInterval03xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval03xd['endMinute'] != null) {
					if (!is_numeric($timeInterval03xd['endMinute'])) $ret = false;
					if (($timeInterval03xd['endMinute'] < -2147483648) || ($timeInterval03xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endMinute'] > 59) $ret = false;
					if ($timeInterval03xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval03) < 0) $ret = false;
		if (is_array($timeInterval04) && (count($timeInterval04) > 0)) {
			foreach ($timeInterval04 as $timeInterval04xd ) {
				if ($timeInterval04xd['endHour'] != null) {
					if (!is_numeric($timeInterval04xd['endHour'])) $ret = false;
					if (($timeInterval04xd['endHour'] < -2147483648) || ($timeInterval04xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endHour'] > 23) $ret = false;
					if ($timeInterval04xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval04xd['endMinute'] != null) {
					if (!is_numeric($timeInterval04xd['endMinute'])) $ret = false;
					if (($timeInterval04xd['endMinute'] < -2147483648) || ($timeInterval04xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endMinute'] > 59) $ret = false;
					if ($timeInterval04xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval04) < 0) $ret = false;
		if (is_array($timeInterval05) && (count($timeInterval05) > 0)) {
			foreach ($timeInterval05 as $timeInterval05xd ) {
				if ($timeInterval05xd['endHour'] != null) {
					if (!is_numeric($timeInterval05xd['endHour'])) $ret = false;
					if (($timeInterval05xd['endHour'] < -2147483648) || ($timeInterval05xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endHour'] > 23) $ret = false;
					if ($timeInterval05xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval05xd['endMinute'] != null) {
					if (!is_numeric($timeInterval05xd['endMinute'])) $ret = false;
					if (($timeInterval05xd['endMinute'] < -2147483648) || ($timeInterval05xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endMinute'] > 59) $ret = false;
					if ($timeInterval05xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval05) < 0) $ret = false;
		if (is_array($timeInterval06) && (count($timeInterval06) > 0)) {
			foreach ($timeInterval06 as $timeInterval06xd ) {
				if ($timeInterval06xd['endHour'] != null) {
					if (!is_numeric($timeInterval06xd['endHour'])) $ret = false;
					if (($timeInterval06xd['endHour'] < -2147483648) || ($timeInterval06xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endHour'] > 23) $ret = false;
					if ($timeInterval06xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval06xd['endMinute'] != null) {
					if (!is_numeric($timeInterval06xd['endMinute'])) $ret = false;
					if (($timeInterval06xd['endMinute'] < -2147483648) || ($timeInterval06xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endMinute'] > 59) $ret = false;
					if ($timeInterval06xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval06) < 0) $ret = false;
		if (is_array($timeInterval07) && (count($timeInterval07) > 0)) {
			foreach ($timeInterval07 as $timeInterval07xd ) {
				if ($timeInterval07xd['endHour'] != null) {
					if (!is_numeric($timeInterval07xd['endHour'])) $ret = false;
					if (($timeInterval07xd['endHour'] < -2147483648) || ($timeInterval07xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endHour'] > 23) $ret = false;
					if ($timeInterval07xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval07xd['endMinute'] != null) {
					if (!is_numeric($timeInterval07xd['endMinute'])) $ret = false;
					if (($timeInterval07xd['endMinute'] < -2147483648) || ($timeInterval07xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endMinute'] > 59) $ret = false;
					if ($timeInterval07xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval07) < 0) $ret = false;
		if (is_array($timeInterval08) && (count($timeInterval08) > 0)) {
			foreach ($timeInterval08 as $timeInterval08xd ) {
				if ($timeInterval08xd['endHour'] != null) {
					if (!is_numeric($timeInterval08xd['endHour'])) $ret = false;
					if (($timeInterval08xd['endHour'] < -2147483648) || ($timeInterval08xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endHour'] > 23) $ret = false;
					if ($timeInterval08xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval08xd['endMinute'] != null) {
					if (!is_numeric($timeInterval08xd['endMinute'])) $ret = false;
					if (($timeInterval08xd['endMinute'] < -2147483648) || ($timeInterval08xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endMinute'] > 59) $ret = false;
					if ($timeInterval08xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval08) < 0) $ret = false;
		if (is_array($timeInterval09) && (count($timeInterval09) > 0)) {
			foreach ($timeInterval09 as $timeInterval09xd ) {
				if ($timeInterval09xd['endHour'] != null) {
					if (!is_numeric($timeInterval09xd['endHour'])) $ret = false;
					if (($timeInterval09xd['endHour'] < -2147483648) || ($timeInterval09xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endHour'] > 23) $ret = false;
					if ($timeInterval09xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval09xd['endMinute'] != null) {
					if (!is_numeric($timeInterval09xd['endMinute'])) $ret = false;
					if (($timeInterval09xd['endMinute'] < -2147483648) || ($timeInterval09xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endMinute'] > 59) $ret = false;
					if ($timeInterval09xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval09) < 0) $ret = false;
		if (is_array($timeInterval10) && (count($timeInterval10) > 0)) {
			foreach ($timeInterval10 as $timeInterval10xd ) {
				if ($timeInterval10xd['endHour'] != null) {
					if (!is_numeric($timeInterval10xd['endHour'])) $ret = false;
					if (($timeInterval10xd['endHour'] < -2147483648) || ($timeInterval10xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endHour'] > 23) $ret = false;
					if ($timeInterval10xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval10xd['endMinute'] != null) {
					if (!is_numeric($timeInterval10xd['endMinute'])) $ret = false;
					if (($timeInterval10xd['endMinute'] < -2147483648) || ($timeInterval10xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endMinute'] > 59) $ret = false;
					if ($timeInterval10xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval10) < 0) $ret = false;
		if (is_array($timeInterval11) && (count($timeInterval11) > 0)) {
			foreach ($timeInterval11 as $timeInterval11xd ) {
				if ($timeInterval11xd['endHour'] != null) {
					if (!is_numeric($timeInterval11xd['endHour'])) $ret = false;
					if (($timeInterval11xd['endHour'] < -2147483648) || ($timeInterval11xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endHour'] > 23) $ret = false;
					if ($timeInterval11xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval11xd['endMinute'] != null) {
					if (!is_numeric($timeInterval11xd['endMinute'])) $ret = false;
					if (($timeInterval11xd['endMinute'] < -2147483648) || ($timeInterval11xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endMinute'] > 59) $ret = false;
					if ($timeInterval11xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval11) < 0) $ret = false;
		if (is_array($timeInterval12) && (count($timeInterval12) > 0)) {
			foreach ($timeInterval12 as $timeInterval12xd ) {
				if ($timeInterval12xd['endHour'] != null) {
					if (!is_numeric($timeInterval12xd['endHour'])) $ret = false;
					if (($timeInterval12xd['endHour'] < -2147483648) || ($timeInterval12xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endHour'] > 23) $ret = false;
					if ($timeInterval12xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval12xd['endMinute'] != null) {
					if (!is_numeric($timeInterval12xd['endMinute'])) $ret = false;
					if (($timeInterval12xd['endMinute'] < -2147483648) || ($timeInterval12xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endMinute'] > 59) $ret = false;
					if ($timeInterval12xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval12) < 0) $ret = false;
		if (is_array($timeInterval13) && (count($timeInterval13) > 0)) {
			foreach ($timeInterval13 as $timeInterval13xd ) {
				if ($timeInterval13xd['endHour'] != null) {
					if (!is_numeric($timeInterval13xd['endHour'])) $ret = false;
					if (($timeInterval13xd['endHour'] < -2147483648) || ($timeInterval13xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endHour'] > 23) $ret = false;
					if ($timeInterval13xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval13xd['endMinute'] != null) {
					if (!is_numeric($timeInterval13xd['endMinute'])) $ret = false;
					if (($timeInterval13xd['endMinute'] < -2147483648) || ($timeInterval13xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endMinute'] > 59) $ret = false;
					if ($timeInterval13xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval13) < 0) $ret = false;
		if (is_array($timeInterval14) && (count($timeInterval14) > 0)) {
			foreach ($timeInterval14 as $timeInterval14xd ) {
				if ($timeInterval14xd['endHour'] != null) {
					if (!is_numeric($timeInterval14xd['endHour'])) $ret = false;
					if (($timeInterval14xd['endHour'] < -2147483648) || ($timeInterval14xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endHour'] > 23) $ret = false;
					if ($timeInterval14xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval14xd['endMinute'] != null) {
					if (!is_numeric($timeInterval14xd['endMinute'])) $ret = false;
					if (($timeInterval14xd['endMinute'] < -2147483648) || ($timeInterval14xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endMinute'] > 59) $ret = false;
					if ($timeInterval14xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval14) < 0) $ret = false;
		if (is_array($timeInterval15) && (count($timeInterval15) > 0)) {
			foreach ($timeInterval15 as $timeInterval15xd ) {
				if ($timeInterval15xd['endHour'] != null) {
					if (!is_numeric($timeInterval15xd['endHour'])) $ret = false;
					if (($timeInterval15xd['endHour'] < -2147483648) || ($timeInterval15xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endHour'] > 23) $ret = false;
					if ($timeInterval15xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval15xd['endMinute'] != null) {
					if (!is_numeric($timeInterval15xd['endMinute'])) $ret = false;
					if (($timeInterval15xd['endMinute'] < -2147483648) || ($timeInterval15xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endMinute'] > 59) $ret = false;
					if ($timeInterval15xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval15) < 0) $ret = false;
		if (is_array($timeInterval16) && (count($timeInterval16) > 0)) {
			foreach ($timeInterval16 as $timeInterval16xd ) {
				if ($timeInterval16xd['endHour'] != null) {
					if (!is_numeric($timeInterval16xd['endHour'])) $ret = false;
					if (($timeInterval16xd['endHour'] < -2147483648) || ($timeInterval16xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endHour'] > 23) $ret = false;
					if ($timeInterval16xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval16xd['endMinute'] != null) {
					if (!is_numeric($timeInterval16xd['endMinute'])) $ret = false;
					if (($timeInterval16xd['endMinute'] < -2147483648) || ($timeInterval16xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endMinute'] > 59) $ret = false;
					if ($timeInterval16xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval16) < 0) $ret = false;
		if (is_array($timeInterval17) && (count($timeInterval17) > 0)) {
			foreach ($timeInterval17 as $timeInterval17xd ) {
				if ($timeInterval17xd['endHour'] != null) {
					if (!is_numeric($timeInterval17xd['endHour'])) $ret = false;
					if (($timeInterval17xd['endHour'] < -2147483648) || ($timeInterval17xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endHour'] > 23) $ret = false;
					if ($timeInterval17xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval17xd['endMinute'] != null) {
					if (!is_numeric($timeInterval17xd['endMinute'])) $ret = false;
					if (($timeInterval17xd['endMinute'] < -2147483648) || ($timeInterval17xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endMinute'] > 59) $ret = false;
					if ($timeInterval17xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval17) < 0) $ret = false;
		if (is_array($timeInterval18) && (count($timeInterval18) > 0)) {
			foreach ($timeInterval18 as $timeInterval18xd ) {
				if ($timeInterval18xd['endHour'] != null) {
					if (!is_numeric($timeInterval18xd['endHour'])) $ret = false;
					if (($timeInterval18xd['endHour'] < -2147483648) || ($timeInterval18xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endHour'] > 23) $ret = false;
					if ($timeInterval18xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval18xd['endMinute'] != null) {
					if (!is_numeric($timeInterval18xd['endMinute'])) $ret = false;
					if (($timeInterval18xd['endMinute'] < -2147483648) || ($timeInterval18xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endMinute'] > 59) $ret = false;
					if ($timeInterval18xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval18) < 0) $ret = false;
		if (is_array($timeInterval19) && (count($timeInterval19) > 0)) {
			foreach ($timeInterval19 as $timeInterval19xd ) {
				if ($timeInterval19xd['endHour'] != null) {
					if (!is_numeric($timeInterval19xd['endHour'])) $ret = false;
					if (($timeInterval19xd['endHour'] < -2147483648) || ($timeInterval19xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endHour'] > 23) $ret = false;
					if ($timeInterval19xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval19xd['endMinute'] != null) {
					if (!is_numeric($timeInterval19xd['endMinute'])) $ret = false;
					if (($timeInterval19xd['endMinute'] < -2147483648) || ($timeInterval19xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endMinute'] > 59) $ret = false;
					if ($timeInterval19xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval19) < 0) $ret = false;
		if (is_array($timeInterval20) && (count($timeInterval20) > 0)) {
			foreach ($timeInterval20 as $timeInterval20xd ) {
				if ($timeInterval20xd['endHour'] != null) {
					if (!is_numeric($timeInterval20xd['endHour'])) $ret = false;
					if (($timeInterval20xd['endHour'] < -2147483648) || ($timeInterval20xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endHour'] > 23) $ret = false;
					if ($timeInterval20xd['endHour'] < 0) $ret = false;
				}
				if ($timeInterval20xd['endMinute'] != null) {
					if (!is_numeric($timeInterval20xd['endMinute'])) $ret = false;
					if (($timeInterval20xd['endMinute'] < -2147483648) || ($timeInterval20xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endMinute'] > 59) $ret = false;
					if ($timeInterval20xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->timeScheduleName = $timeScheduleName;
			$this->newTimeScheduleName = $newTimeScheduleName;
			$this->timeInterval01 = $timeInterval01;
			$this->timeInterval02 = $timeInterval02;
			$this->timeInterval03 = $timeInterval03;
			$this->timeInterval04 = $timeInterval04;
			$this->timeInterval05 = $timeInterval05;
			$this->timeInterval06 = $timeInterval06;
			$this->timeInterval07 = $timeInterval07;
			$this->timeInterval08 = $timeInterval08;
			$this->timeInterval09 = $timeInterval09;
			$this->timeInterval10 = $timeInterval10;
			$this->timeInterval11 = $timeInterval11;
			$this->timeInterval12 = $timeInterval12;
			$this->timeInterval13 = $timeInterval13;
			$this->timeInterval14 = $timeInterval14;
			$this->timeInterval15 = $timeInterval15;
			$this->timeInterval16 = $timeInterval16;
			$this->timeInterval17 = $timeInterval17;
			$this->timeInterval18 = $timeInterval18;
			$this->timeInterval19 = $timeInterval19;
			$this->timeInterval20 = $timeInterval20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserTimeScheduleModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", $this->userId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("timeScheduleName", $this->timeScheduleName);
		$this->comando->appendChild($elem2);

		if (is_array($this->newTimeScheduleName) && count($this->newTimeScheduleName) > 0) {
			foreach ($this->newTimeScheduleName as $newTimeScheduleNamexd) {
				$elem4 = new DOMElement("newTimeScheduleName", $newTimeScheduleNamexd);
				$this->comando->appendChild($elem4);

			}
		}
		if (is_array($this->timeInterval01) && count($this->timeInterval01) > 0) {
			$elem4 = new DOMElement("timeInterval01");
			$this->comando->appendChild($elem4);

			foreach ($this->timeInterval01 as $timeInterval01xd) {
				if (isset($timeInterval01xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval01xd['endDayOfWeek']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($timeInterval01xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval01xd['endHour']);
					$elem4->appendChild($elemtin2);

				}
				if (isset($timeInterval01xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval01xd['endMinute']);
					$elem4->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval02) && count($this->timeInterval02) > 0) {
			$elem5 = new DOMElement("timeInterval02");
			$this->comando->appendChild($elem5);

			foreach ($this->timeInterval02 as $timeInterval02xd) {
				if (isset($timeInterval02xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval02xd['endDayOfWeek']);
					$elem5->appendChild($elemtin1);

				}
				if (isset($timeInterval02xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval02xd['endHour']);
					$elem5->appendChild($elemtin2);

				}
				if (isset($timeInterval02xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval02xd['endMinute']);
					$elem5->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval03) && count($this->timeInterval03) > 0) {
			$elem6 = new DOMElement("timeInterval03");
			$this->comando->appendChild($elem6);

			foreach ($this->timeInterval03 as $timeInterval03xd) {
				if (isset($timeInterval03xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval03xd['endDayOfWeek']);
					$elem6->appendChild($elemtin1);

				}
				if (isset($timeInterval03xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval03xd['endHour']);
					$elem6->appendChild($elemtin2);

				}
				if (isset($timeInterval03xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval03xd['endMinute']);
					$elem6->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval04) && count($this->timeInterval04) > 0) {
			$elem7 = new DOMElement("timeInterval04");
			$this->comando->appendChild($elem7);

			foreach ($this->timeInterval04 as $timeInterval04xd) {
				if (isset($timeInterval04xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval04xd['endDayOfWeek']);
					$elem7->appendChild($elemtin1);

				}
				if (isset($timeInterval04xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval04xd['endHour']);
					$elem7->appendChild($elemtin2);

				}
				if (isset($timeInterval04xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval04xd['endMinute']);
					$elem7->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval05) && count($this->timeInterval05) > 0) {
			$elem8 = new DOMElement("timeInterval05");
			$this->comando->appendChild($elem8);

			foreach ($this->timeInterval05 as $timeInterval05xd) {
				if (isset($timeInterval05xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval05xd['endDayOfWeek']);
					$elem8->appendChild($elemtin1);

				}
				if (isset($timeInterval05xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval05xd['endHour']);
					$elem8->appendChild($elemtin2);

				}
				if (isset($timeInterval05xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval05xd['endMinute']);
					$elem8->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval06) && count($this->timeInterval06) > 0) {
			$elem9 = new DOMElement("timeInterval06");
			$this->comando->appendChild($elem9);

			foreach ($this->timeInterval06 as $timeInterval06xd) {
				if (isset($timeInterval06xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval06xd['endDayOfWeek']);
					$elem9->appendChild($elemtin1);

				}
				if (isset($timeInterval06xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval06xd['endHour']);
					$elem9->appendChild($elemtin2);

				}
				if (isset($timeInterval06xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval06xd['endMinute']);
					$elem9->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval07) && count($this->timeInterval07) > 0) {
			$elem10 = new DOMElement("timeInterval07");
			$this->comando->appendChild($elem10);

			foreach ($this->timeInterval07 as $timeInterval07xd) {
				if (isset($timeInterval07xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval07xd['endDayOfWeek']);
					$elem10->appendChild($elemtin1);

				}
				if (isset($timeInterval07xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval07xd['endHour']);
					$elem10->appendChild($elemtin2);

				}
				if (isset($timeInterval07xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval07xd['endMinute']);
					$elem10->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval08) && count($this->timeInterval08) > 0) {
			$elem11 = new DOMElement("timeInterval08");
			$this->comando->appendChild($elem11);

			foreach ($this->timeInterval08 as $timeInterval08xd) {
				if (isset($timeInterval08xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval08xd['endDayOfWeek']);
					$elem11->appendChild($elemtin1);

				}
				if (isset($timeInterval08xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval08xd['endHour']);
					$elem11->appendChild($elemtin2);

				}
				if (isset($timeInterval08xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval08xd['endMinute']);
					$elem11->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval09) && count($this->timeInterval09) > 0) {
			$elem12 = new DOMElement("timeInterval09");
			$this->comando->appendChild($elem12);

			foreach ($this->timeInterval09 as $timeInterval09xd) {
				if (isset($timeInterval09xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval09xd['endDayOfWeek']);
					$elem12->appendChild($elemtin1);

				}
				if (isset($timeInterval09xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval09xd['endHour']);
					$elem12->appendChild($elemtin2);

				}
				if (isset($timeInterval09xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval09xd['endMinute']);
					$elem12->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval10) && count($this->timeInterval10) > 0) {
			$elem13 = new DOMElement("timeInterval10");
			$this->comando->appendChild($elem13);

			foreach ($this->timeInterval10 as $timeInterval10xd) {
				if (isset($timeInterval10xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval10xd['endDayOfWeek']);
					$elem13->appendChild($elemtin1);

				}
				if (isset($timeInterval10xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval10xd['endHour']);
					$elem13->appendChild($elemtin2);

				}
				if (isset($timeInterval10xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval10xd['endMinute']);
					$elem13->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval11) && count($this->timeInterval11) > 0) {
			$elem14 = new DOMElement("timeInterval11");
			$this->comando->appendChild($elem14);

			foreach ($this->timeInterval11 as $timeInterval11xd) {
				if (isset($timeInterval11xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval11xd['endDayOfWeek']);
					$elem14->appendChild($elemtin1);

				}
				if (isset($timeInterval11xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval11xd['endHour']);
					$elem14->appendChild($elemtin2);

				}
				if (isset($timeInterval11xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval11xd['endMinute']);
					$elem14->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval12) && count($this->timeInterval12) > 0) {
			$elem15 = new DOMElement("timeInterval12");
			$this->comando->appendChild($elem15);

			foreach ($this->timeInterval12 as $timeInterval12xd) {
				if (isset($timeInterval12xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval12xd['endDayOfWeek']);
					$elem15->appendChild($elemtin1);

				}
				if (isset($timeInterval12xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval12xd['endHour']);
					$elem15->appendChild($elemtin2);

				}
				if (isset($timeInterval12xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval12xd['endMinute']);
					$elem15->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval13) && count($this->timeInterval13) > 0) {
			$elem16 = new DOMElement("timeInterval13");
			$this->comando->appendChild($elem16);

			foreach ($this->timeInterval13 as $timeInterval13xd) {
				if (isset($timeInterval13xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval13xd['endDayOfWeek']);
					$elem16->appendChild($elemtin1);

				}
				if (isset($timeInterval13xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval13xd['endHour']);
					$elem16->appendChild($elemtin2);

				}
				if (isset($timeInterval13xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval13xd['endMinute']);
					$elem16->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval14) && count($this->timeInterval14) > 0) {
			$elem17 = new DOMElement("timeInterval14");
			$this->comando->appendChild($elem17);

			foreach ($this->timeInterval14 as $timeInterval14xd) {
				if (isset($timeInterval14xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval14xd['endDayOfWeek']);
					$elem17->appendChild($elemtin1);

				}
				if (isset($timeInterval14xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval14xd['endHour']);
					$elem17->appendChild($elemtin2);

				}
				if (isset($timeInterval14xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval14xd['endMinute']);
					$elem17->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval15) && count($this->timeInterval15) > 0) {
			$elem18 = new DOMElement("timeInterval15");
			$this->comando->appendChild($elem18);

			foreach ($this->timeInterval15 as $timeInterval15xd) {
				if (isset($timeInterval15xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval15xd['endDayOfWeek']);
					$elem18->appendChild($elemtin1);

				}
				if (isset($timeInterval15xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval15xd['endHour']);
					$elem18->appendChild($elemtin2);

				}
				if (isset($timeInterval15xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval15xd['endMinute']);
					$elem18->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval16) && count($this->timeInterval16) > 0) {
			$elem19 = new DOMElement("timeInterval16");
			$this->comando->appendChild($elem19);

			foreach ($this->timeInterval16 as $timeInterval16xd) {
				if (isset($timeInterval16xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval16xd['endDayOfWeek']);
					$elem19->appendChild($elemtin1);

				}
				if (isset($timeInterval16xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval16xd['endHour']);
					$elem19->appendChild($elemtin2);

				}
				if (isset($timeInterval16xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval16xd['endMinute']);
					$elem19->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval17) && count($this->timeInterval17) > 0) {
			$elem20 = new DOMElement("timeInterval17");
			$this->comando->appendChild($elem20);

			foreach ($this->timeInterval17 as $timeInterval17xd) {
				if (isset($timeInterval17xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval17xd['endDayOfWeek']);
					$elem20->appendChild($elemtin1);

				}
				if (isset($timeInterval17xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval17xd['endHour']);
					$elem20->appendChild($elemtin2);

				}
				if (isset($timeInterval17xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval17xd['endMinute']);
					$elem20->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval18) && count($this->timeInterval18) > 0) {
			$elem21 = new DOMElement("timeInterval18");
			$this->comando->appendChild($elem21);

			foreach ($this->timeInterval18 as $timeInterval18xd) {
				if (isset($timeInterval18xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval18xd['endDayOfWeek']);
					$elem21->appendChild($elemtin1);

				}
				if (isset($timeInterval18xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval18xd['endHour']);
					$elem21->appendChild($elemtin2);

				}
				if (isset($timeInterval18xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval18xd['endMinute']);
					$elem21->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval19) && count($this->timeInterval19) > 0) {
			$elem22 = new DOMElement("timeInterval19");
			$this->comando->appendChild($elem22);

			foreach ($this->timeInterval19 as $timeInterval19xd) {
				if (isset($timeInterval19xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval19xd['endDayOfWeek']);
					$elem22->appendChild($elemtin1);

				}
				if (isset($timeInterval19xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval19xd['endHour']);
					$elem22->appendChild($elemtin2);

				}
				if (isset($timeInterval19xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval19xd['endMinute']);
					$elem22->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval20) && count($this->timeInterval20) > 0) {
			$elem23 = new DOMElement("timeInterval20");
			$this->comando->appendChild($elem23);

			foreach ($this->timeInterval20 as $timeInterval20xd) {
				if (isset($timeInterval20xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", $timeInterval20xd['endDayOfWeek']);
					$elem23->appendChild($elemtin1);

				}
				if (isset($timeInterval20xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", $timeInterval20xd['endHour']);
					$elem23->appendChild($elemtin2);

				}
				if (isset($timeInterval20xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", $timeInterval20xd['endMinute']);
					$elem23->appendChild($elemtin3);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>
