<?
class BroadsoftXMLWS {

	private $dom;
	private $root;

	private $wsdl;
	//private $user;
	//private $passwd;

	private $ssid;
	private $jssid;
	private $soap_client;

	private $time_retry = 1;
	private $cant_retry = 10;

	private static $instance;

	private static $user;
	private static $passwd;

	private $lastRequest;
	private $lastResponse;

	private $lastRequestHeaders;
	private $lastResponseHeaders;

	public static function getInstance($wsdl = null, $user = null, $passwd = null) {
		if (!isset(self::$instance)) {
			$c = __CLASS__;
			//creo la clase
			self::$instance = new $c($wsdl);
			self::$user = $user;
			self::$passwd = $passwd;
		}
		return self::$instance;
	}

	public static function closeInstance() {
		//self::$instance->logout();
		self::$instance->__destruct();
		/*if (!isset(self::$instance)) {
			$c = __CLASS__;
			//creo la clase
			self::$instance = new $c($wsdl);
			//pido login
			self::$instance->login($user, $passwd);
		}
		return self::$instance;*/
	}

	private function __construct($wsdl) {
		$this->wsdl = $wsdl;
		$this->soap_client = new SoapClient($wsdl, array('trace' => 1, "exceptions" => "true", "connection_timeout" => "3", "user_agent" => "PHP Provisioning"));
		$this->prepareDOM();
	}

	private function prepareDOM() {
		$this->dom = new  DOMDocument("1.0");
		$this->root = new DOMElement("processOCIMessage");
		$this->dom->appendChild($this->root);
		$this->root->setAttribute("SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
		$this->root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
	}

	private function addXML($datosXML) {
		$eleme_arg0 = new DOMElement("arg0", $datosXML);
		$this->root->appendChild($eleme_arg0);

		$eleme_arg0->setAttribute("xsi:type", "soapenc:string");
		$eleme_arg0->setAttribute("xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
	}

	public function getXML() {
		return ($this->dom->saveXML($this->root));
	}

	public function login(/*$user, $passwd*/) {
		//$this->wsdl = $wsdl;
		//$this->user = $user;
		$this->soap_client = new SoapClient($this->wsdl, array('trace' => 1, "exceptions" => "true", "connection_timeout" => "3", "user_agent" => "PHP Provisioning"));
		$this->prepareDOM();
		//echo "LOGIN";
		$base = new BroadsoftXMLBase();

		$cmdAuthRequest = new BroadsoftXMLCommandAuthenticationRequest();

		$base->addCommand($cmdAuthRequest->getCommand());
		$cmdAuthRequest->setUser(self::$user);
		$cmdAuthRequest->setCommand();


		$this->ssid = $base->getsessionId();
		$this->addXML($base->getXML());


		$reintentos = 0;
		$ejecuto = false;
		while ($reintentos < $this->cant_retry) {
			$reintentos++;
			try {
				//sleep($this->time_retry*2);
				$this->soap_client->processOCIMessage(new SoapVar($this->getXML(), XSD_ANYXML));
				$reintentos = $this->cant_retry;
				$ejecuto = true;
			}catch (SoapFault $fault){
				/*echo "<pre>";
				var_dump($fault);
				echo "</pre>";*/
				$fdetail = (isset($fault->detail)) ? $fault->detail->string : "";
				sleep($this->time_retry);
				echo(myLogDate()."INTENTO CONECTAR NUEVAMENTE: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "] detail: [" . $fdetail . "]\n");
				$this->soap_client = new SoapClient($this->wsdl, array('trace' => 1, "exceptions" => "true", "connection_timeout" => "3", "user_agent" => "PHP Provisioning"));
				/*if ($reintentos == $this->cant_retry)
					echo $e->getMessage();*/
			}
		}


		//$this->soap_client->processOCIMessage(new SoapVar($this->getXML(), XSD_ANYXML));


		$lastRequest = $this->soap_client->__getLastRequest();
		$lastResponse = $this->soap_client->__getLastResponse();

		$lastRequestHeaders = $this->soap_client->__getLastRequestHeaders();
		$lastResponseHeaders = $this->soap_client->__getLastResponseHeaders();
		/*echo "<pre>";
		echo "<br>";
		
		var_dump($this->soap_client->__getLastRequestHeaders());
		var_dump($this->soap_client->__getLastRequest());
		echo "<br>\r\n\r\n\r\n";
		var_dump($this->soap_client->__getLastResponseHeaders());
		var_dump($this->soap_client->__getLastResponse());
		echo "\r\n\r\n\r\n";*/
		//echo "LOGIN PARTE 2";
		$respuesta = new BroadsoftXMLAuthenticationRequestResponse($this->soap_client->__getLastResponse(), $this->soap_client->__getLastResponseHeaders());
		
		$this->jssid = $respuesta->getJSESSIONID();

		$bs_rt1		= new BroadsoftXMLBase($this->ssid);
		$bs_rt2		= new BroadsoftXMLCommandLoginRequest();
		unset($this->dom);
		unset($this->root);
		$this->prepareDOM();


		$bs_rt1->addCommand($bs_rt2->getCommand());
		$bs_rt2->setData(USER_WS, PASSWORD_WS, $respuesta->getnonce());
		$bs_rt2->setCommand();

		//$asdasd = new BroadsoftXMLWS($bs_rt1->getXML());
		$this->addXML($bs_rt1->getXML());
		$this->soap_client->__setCookie($this->jssid);
		$this->soap_client->processOCIMessage(new SoapVar($this->getXML(), XSD_ANYXML));
		$this->lastRequest = $this->soap_client->__getLastRequest();
		$this->lastResponse = $this->soap_client->__getLastResponse();

		$this->lastRequestHeaders = $this->soap_client->__getLastRequestHeaders();
		$this->lastResponseHeaders = $this->soap_client->__getLastResponseHeaders();

		//$this->soap_client->__soapCall("processOCIMessage", array(new SoapVar($this->getXML(), XSD_ANYXML)));
		/*echo "<br>";
		var_dump($this->soap_client->__getLastRequestHeaders());
		var_dump($this->soap_client->__getLastRequest());
		echo "<br>\r\n\r\n\r\n";
		var_dump($this->soap_client->__getLastResponseHeaders());
		var_dump($this->soap_client->__getLastResponse());
		echo "\r\n\r\n\r\n";
		echo "</pre>";
		die();*/
		//echo "FIN LOGIN";
	}

	public function logout() {
		//$this->wsdl = $wsdl;
		//$this->user = $user;
		//$this->passwd = $passwd;
		//echo "LOGOUT";
		$base = new BroadsoftXMLBase($this->ssid);

		$cmdLogOut = new BroadsoftXMLCommandLogoutRequest();
		unset($this->dom);
		unset($this->root);
		$this->prepareDOM();
		$base->addCommand($cmdLogOut->getCommand());
		$cmdLogOut->setUser(self::$user);
		$cmdLogOut->setCommand();


		//$this->ssid = $base->getsessionId();
		$this->addXML($base->getXML());
		$this->soap_client->processOCIMessage(new SoapVar($this->getXML(), XSD_ANYXML));

	}



	public function execute($xml) {
		//pido login
		//self::$instance->login($user, $passwd);

		$reintentos = 0;
		$ejecuto = false;

		while ($reintentos < $this->cant_retry) {
			$this->login(self::$user, self::$passwd);
			$this->prepareDOM();
                        $pos = strpos($xml, "?>") ;
                        $domDocumentito = new DOMDocument('1.0', 'ISO-8859-1');
                        $domDocumentito->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xml, $pos + 2)));
                        /*$comandos = $domDocumentito->getElementsByTagName("arg0");
                        $dom2 = new DOMDocument('1.0', 'ISO-8859-1');
                        $dom2->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", $comandos->item(0)->nodeValue));*/
                        $comandos = $domDocumentito->getElementsByTagName("command");
                        $xd = new BroadsoftXMLBase($this->ssid);

                        for ($i = 0; $i < $comandos->length; $i++) {
                                $elem1 = $comandos->item($i);
                                $nodin = cloneNode($elem1, $xd->dom);

                                $nodin->setAttribute("xmlns", "");

                                $xd->addCommand($nodin);
                        }


                        $this->addXML($xd->getXML());
			$this->soap_client->__setCookie($this->jssid);


			$reintentos++;
			try {
				//sleep($this->time_retry*2);
				$this->soap_client->processOCIMessage(new SoapVar($this->getXML(), XSD_ANYXML));
				$reintentos = $this->cant_retry;
				$ejecuto = true;

			}catch (SoapFault $fault){
				/*echo "<pre>";
				var_dump($fault);
				echo "</pre>";*/
				$fdetail = (isset($fault->detail)) ? $fault->detail->string : "";
				echo(myLogDate()."Error al ejecutar algun comando - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "] detail: [" . $fdetail . "]\n");
				sleep($this->time_retry);
				/*if ($reintentos == $this->cant_retry)
					echo $e->getMessage();*/
			}
			$this->lastRequest = $this->soap_client->__getLastRequest();
			$this->lastResponse = $this->soap_client->__getLastResponse();

			$this->lastRequestHeaders = $this->soap_client->__getLastRequestHeaders();
			$this->lastResponseHeaders = $this->soap_client->__getLastResponseHeaders();
			$this->logout();
		}

		//private $lastRequestHeaders;
		//private $lastResponseHeaders;

		//$this->logout();
		return ($ejecuto);
	}

	public function getLastResponse() {
		return($this->lastResponse);
	}

	public function getLastResponseHeaders() {
		return($this->lastResponseHeaders);
	}

	public function getLastRequestHeaders() {
		return($this->lastRequestHeaders);
	}

	public function getLastRequest() {
		return($this->lastRequest);
	}


	public function getResultados() {
		//$respuesta = 
		$respuestaXML = new DOMDocument("1.0");
		$respuestaXML->loadXML($this->getLastResponse());

		$res = array();

		$processOCIMessageReturn = $respuestaXML->getElementsByTagName("processOCIMessageReturn");

		if ($processOCIMessageReturn->length > 0) {
			$xmlBS = htmlspecialchars_decode($processOCIMessageReturn->item(0)->nodeValue);
			$respuestaXMLBS = new DOMDocument("1.0");
			$respuestaXMLBS->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", $xmlBS));

			$respuestaComandos = $respuestaXMLBS->getElementsByTagName("command");
			//var_dump($respuestaComandos->length); die();
			for ($i = 0; $i < $respuestaComandos->length; $i++) {
				$item = $respuestaComandos->item($i);
				$resComando = $item->getAttributeNode("xsi:type")->value;
				//$attrs = $item->attributes;
				//var_dump($resComando); die();
				$cmdErrores = 0;
				switch ($resComando) {
					case "c:SuccessResponse";
						break;
					case "c:ErrorResponse";
						$hijos = $item->childNodes;
						$cmdErrores++;
						$msgError = "";
						for ($j = 0; $j < $hijos->length; $j++) {
							if (($hijos->item($j)->nodeName == "summary") || ($hijos->item($j)->nodeName == "detail")) {
								$msgError .= "|" . $hijos->item($j)->nodeValue . "|";
							}
						}
						break;
				}
				if ($cmdErrores > 0) {
					$res[] = $msgError;
				} else {
					$res[] = 1;
				}
			}
		} else {
			$Fault = $respuestaXML->getElementsByTagName("Fault");
			if ($Fault->length > 0) {
				$hijosDeFault = $Fault->item(0)->childNodes;
				$cFaultCode = "";
				$cFaultString = "";
				$cDetailString = "";
				for ($i = 0; $i < $hijosDeFault->length; $i++) {
					switch ($hijosDeFault->item($i)->nodeName) {
						case "faultcode":
							$cFaultCode = $hijosDeFault->item($i)->nodeValue;
							break;
						case "faultstring":
							$cFaultString = $hijosDeFault->item($i)->nodeValue;
							break;
						case "detail":
							$hijosDeDetail = $hijosDeFault->item($i)->childNodes;
							for ($j = 0; $j < $hijosDeDetail->length; $j++) {
								switch ($hijosDeDetail->item($j)->nodeName) {
									case "string":
										$cDetailString = $hijosDeDetail->item($j)->nodeValue;
									break;
								}
							}
							break;
					}
				}
				/*$xmlBS = htmlspecialchars_decode($Fault->item(0)->nodeValue);
				$respuestaXMLBS = new DOMDocument("1.0");
				$respuestaXMLBS->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", $xmlBS));*/
				//$respuestaComandos = $respuestaXMLBS->getElementsByTagName("command");
				$res[] = "SoapFault: faultcode[" . $cFaultCode . "] faultstring [" . $cFaultString . "] detail[" . $cDetailString . "]";
			} else {
				$res[] = "Error-> No hubo una respuesta success, failure o fault";
			}
		}
		return ($res);
	}

}

class BroadsoftXMLBase {

	private $comandos = array();
	public $dom;
	private $root;
	private $id_session;

	public function __construct($id_session = null) {

		$this->id_session = ($id_session) ? $id_session : "172.16.213.10," . substr(md5(time()), 0, 10) ;

		$this->dom = new DOMDocument('1.0', 'ISO-8859-1');
		$this->root = new DOMElement("BroadsoftDocument");
		$this->dom->appendChild($this->root);
		$this->root->setAttribute("protocol", "OCI");
		$this->root->setAttribute("xmlns", "C");
		$this->root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
		$elem2 = new DOMElement("sessionId", $this->id_session);
		$this->root->appendChild($elem2);
		$elem2->setAttribute("xmlns", "");
	}

	public function getXML() {
		return $this->dom->saveXML(); /* <?xml version="1.0" encoding="iso-8859-1"?> */
	}

	public function getsessionId() {
		return $this->id_session;
	}
	
	public function getHTML() {

		$elem2 = new DOMElement("sessionId", $this->id_session);
		$this->root->appendChild($elem2);
		$elem2->setAttribute("xmlns", "");

		
		return $this->dom->saveHTML(); /* <?xml version="1.0" encoding="iso-8859-1"?> */
	}

	public function addCommand($comando) {
		$this->root->appendChild($comando);
	}

	public function getDom() {
		return $this->dom;
	}

}

define("GRUPO_AGREGAR", "1");
define("GRUPO_CONSULTA", "2");

class BroadsoftXMLCommand {

	protected $comando;
	protected $type;

/*	public function __construct($type) {
		$this->comando = new DOMElement("command");
		$this->type = $type;
	}
*/
	public function __construct() {
		$this->comando = new DOMElement("command");
		//$this->type = $type;
	}


	public function getCommand() {
		return $this->comando;
	}

}

class BroadsoftXMLResponse {
	protected $dom_response;
	protected $headers_response;
	protected $xml_response;
	
	public function __construct($response, $headers) {
		$this->dom_response = new DOMDocument();
		$this->dom_response->loadXML($response);
		
		/*echo "VARDUMP1<br><br>";
		var_dump($this->dom_response->saveXML());
		echo "<br>FIN VARDUMP<br><br>";*/

		$asd = $this->dom_response->getElementsByTagName("processOCIMessageReturn");
		$this->xml_response = new DOMDocument();
		/*echo "VARDUMP2<br><br>";
		var_dump($asd->item(0)->nodeValue);
		echo "<br>FIN VARDUMP<br><br>";*/
		$this->xml_response->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", $asd->item(0)->nodeValue));
		//var_dump($this->xml_response->saveXML());
		$headers = explode("\r\n", $headers);
		/*echo "HEADERS: [";
		var_dump($headers);
		echo "]";*/
		foreach($headers as $xd1 => $xd2) {
			if ($xd2 == "") {
				unset($headers[$xd1]);
			} else {
				$axd2 = explode(":", $xd2);
				$axd2[1] = (!isset($axd2[1])) ? "" : $axd2[1];
				//list($a, $b) = explode(":", $xd2);
				list($a, $b) = $axd2;
				$headers[trim($a)] = trim($b);
				unset($headers[$xd1]);
				if (count(explode(";", $headers[trim($a)])) > 1) {
					$headers[trim($a)][1] = (!isset($headers[trim($a)][1])) ? "" : $headers[trim($a)][1];
					$headers[trim($a)] = explode(";", $headers[trim($a)]);
					foreach($headers[trim($a)] as $l => $v) {
						if ($v == "") {
							unset($headers[trim($a)][$l]);
						} else {
							$aasd = explode("=", $headers[trim($a)][$l]);
							$aasd[1] = (!isset($aasd[1])) ? "" : $aasd[1];
							list($c, $d) = $aasd;
							unset($headers[trim($a)][$l]);
							$headers[trim($a)][trim($c)] = $d;
						}
					}
				}
			}
		}

		$this->headers_response = $headers;
	}

	public function getHeadersRespose() {
		return ($this->headers_response);
	}

	public function getResponseXML() {
		return ($this->dom_response->saveXML());
	}

	public function getContenidoXML() {
		return ($this->xml_response->saveXML());
	}

}

class BroadsoftXMLUserGetRequestResponse extends BroadsoftXMLResponse {
	protected $serviceProviderId;
	protected $groupId;

        public function __construct($response, $headers) {

                parent::__construct($response, $headers);

                $asd = $this->xml_response->getElementsByTagName("serviceProviderId");
                $this->serviceProviderId = $asd->item(0)->textContent;

                $asd = $this->xml_response->getElementsByTagName("groupId");
                $this->groupId = $asd->item(0)->textContent;
	
	}

        public function getGroupId(){
		return ($this->groupId);
	}

	public function getServiceProviderId(){
		return ($this->serviceProviderId);
	}
}

class BroadsoftXMLGroupRoutingProfileGetRequestResponse extends BroadsoftXMLResponse {
	protected $routingProfile;

	public function __construct($response, $headers) {
		parent::__construct($response, $headers);

		$asd = $this->xml_response->getElementsByTagName("routingProfile");
		if ($asd->length > 0) {
			$this->routingProfile = $asd->item(0)->textContent;
		} else {
			$this->routingProfile = null;
		}
	}

	public function getRoutingProfile() {
		return ($this->routingProfile);
	}
}

class BroadsoftXMLAuthenticationRequestResponse extends BroadsoftXMLResponse {

	protected $JSESSIONID;
	protected $sessionId;
	protected $userId;
	protected $passwordAlgorithm;
	protected $nonce;

	public function __construct($response, $headers) {

		parent::__construct($response, $headers);

		$this->JSESSIONID = $this->headers_response["Set-Cookie"]["JSESSIONID"];

		$asd = $this->xml_response->getElementsByTagName("nonce");
		$this->nonce = $asd->item(0)->textContent;

		$asd = $this->xml_response->getElementsByTagName("sessionId");
		$this->sessionId = $asd->item(0)->textContent;

		$asd = $this->xml_response->getElementsByTagName("passwordAlgorithm");
		$this->passwordAlgorithm = $asd->item(0)->textContent;

		$asd = $this->xml_response->getElementsByTagName("userId");
		$this->userId = $asd->item(0)->textContent;


	}

	public function getJSESSIONID() {
		return ($this->JSESSIONID);
	}
	
	public function getnonce() {
		return ($this->nonce);
	}

	public function getpasswordAlgorithm() {
		return ($this->passwordAlgorithm);
	}

	public function getuserId() {
		return ($this->userId);
	}

	public function getsessionId() {
		return ($this->sessionId);
	}


}

class BroadsoftXMLCommandAuthenticationRequest extends BroadsoftXMLCommand {

	private $user;
	private $passwordAlgorithm;
	private $nonce;

	public function __construct() {
		$this->comando = new DOMElement("command");
	}

	public function setUser($user) {
		$this->user = $user;

		$elem = new DOMElement("userId", $this->user);
		$this->comando->appendChild($elem);
	}

	public function setCommand() {
		$this->comando->setAttribute("xsi:type", "AuthenticationRequest");
		$this->comando->setAttribute("xmlns", "");
	}

}

class BroadsoftXMLCommandLogoutRequest extends BroadsoftXMLCommand {

	private $user;

	public function __construct() {
		$this->comando = new DOMElement("command");
	}

	public function setUser($user) {
		$this->$user = $user;

		$elem = new DOMElement("userId", $this->user);
		$this->comando->appendChild($elem);
	}

	public function setCommand() {
		$this->comando->setAttribute("xsi:type", "LogoutRequest");
		$this->comando->setAttribute("xmlns", "");
	}

}

class BroadsoftXMLCommandLoginRequest extends BroadsoftXMLCommand {

	private $user;
	private $passwd;

	private $passwordAlgorithm;
	private $nonce;


	public function __construct() {
		$this->comando = new DOMElement("command");
	}

	public function setData($user, $passwd, $nonce) {
		$this->$user = $user;
		$this->$passwd = $passwd;
		$this->nonce = $nonce;

		$passLoco = md5($nonce . ":" . sha1($passwd));

		$elem = new DOMElement("userId", $this->$user);
		$this->comando->appendChild($elem);

		$elem2 = new DOMElement("signedPassword", $passLoco);
		$this->comando->appendChild($elem2);

	}

	public function setCommand() {
		$this->comando->setAttribute("xsi:type", "LoginRequest14sp4");
		$this->comando->setAttribute("xmlns", "");
	}

}


class BroadsoftXMLCommandGrupo extends BroadsoftXMLCommand {

	private $serviceProviderId;
	private $groupId;
	private $defaultDomain;
	private $userLimit;
	private $groupName;
	private $callingLineIdName;
	private $timeZone;
	private $contact;

	private $responseSizeLimit;
	private $criterios;

	public function setDataAdd($serviceProviderId, $groupId, $defaultDomain, $userLimit, $groupName, $callingLineIdName, $timeZone, $contact) {
		$this->serviceProviderId = $serviceProviderId;
		$this->groupId = $groupId;
		$this->defaultDomain = $defaultDomain;
		$this->userLimit = $userLimit;
		$this->groupName = $groupName;
		$this->callingLineIdName = $callingLineIdName;
		$this->timeZone = $timeZone;
		$this->contact = $contact;
	}

	public function setDataRequest($serviceProviderId, $responseSizeLimit, $criterios) {

		$this->serviceProviderId = $serviceProviderId;
		$this->responseSizeLimit = $responseSizeLimit;
		//$this->aCriterios = $aCriterios;
		$this->comando->appendChild($criterios);
	}

	public function setContact($contact) {
		$this->comando->appendChild($contact);
	}


	public function setCommand() {
		switch ($this->type) {
			case GRUPO_AGREGAR:
				$this->setAddCommand();
				break;
			case GRUPO_CONSULTAR:
				$this->setRequestCommand();
				break;
		}
	}

	protected function setAddCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem);

		$elem2 = new DOMElement("groupId", $this->groupId);
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("defaultDomain", $this->defaultDomain);
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("userLimit", $this->userLimit);
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("groupName", $this->groupName);
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("callingLineIdName", $this->callingLineIdName);
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("timeZone", $this->timeZone);
		$this->comando->appendChild($elem7);

		$this->comando->appendChild($this->contact);

	}

	protected function setRequestCommand() {

		$this->comando->setAttribute("xsi:type", "GroupGetListInServiceProviderRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem);

		$elem2 = new DOMElement("responseSizeLimit", $this->responseSizeLimit);
		$this->comando->appendChild($elem2);

	}

	public function getCommand() {
		return $this->comando;
	}

}

class BroadsoftXMLContact {

	private $contacto;
	private $contactName;
	private $contactNumber;
	private $contactEmail;

	public function __construct() {
		$this->contacto = new DOMElement("contact");
	}

	public function setData($contactName, $contactNumber, $contactEmail) {
		$this->contactName = $contactName;
		$this->contactNumber = $contactNumber;
		$this->contactEmail = $contactEmail;
		$elem2 = new DOMElement("contactName", $this->getContactName());
		$elem3 = new DOMElement("contactNumber", $this->getContactNumber());
		$elem4 = new DOMElement("contactEmail", $this->getContactEmail());
		$this->contacto->appendChild($elem2);
		$this->contacto->appendChild($elem3);
		$this->contacto->appendChild($elem4);
	}
	
	public function getContactName() {
		return $this->contactName;
	}

	public function getContactNumber() {
		return $this->contactNumber;
	}

	public function getContactEmail() {
		return $this->contactEmail;
	}

	public function getContacto() {
		return $this->contacto;
	}
}


class BroadsoftXMLCriterios {

	private $aCriterios;
	private $criterio;

	public function __construct() {
		$this->criterio = new DOMElement("searchCriteriaGroupId");
	}

	public function addCriterio($mode, $value, $isCaseInsensitive) {
		$elem2 = new DOMElement("mode", $mode);
		$elem3 = new DOMElement("value", $value);
		$elem4 = new DOMElement("isCaseInsensitive", $isCaseInsensitive);
		$this->criterio->appendChild($elem2);
		$this->criterio->appendChild($elem3);
		$this->criterio->appendChild($elem4);
	}

	public function getCriterio() {
		return $this->criterio;
	}
}

function cloneNode($node, $doc) {
    $nd = $doc->createElement($node->nodeName);

    foreach($node->attributes as $value)
        $nd->setAttribute($value->nodeName, $value->value);

    if(!$node->childNodes)
        return $nd;

    foreach($node->childNodes as $child) {
        if($child->nodeName=="#text")
            $nd->appendChild($doc->createTextNode($child->nodeValue));
        else
            $nd->appendChild(cloneNode($child,$doc));
    }

    return $nd;
}

?>
