/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int VALUE_LABELS_OUTSIDE_POINT = 1;
    public static final int VALUE_LABELS_AT_POINT = 0;
    private int bZ;
    private boolean b3;
    private int[] bW;
    private boolean bV;
    private boolean[][] b2;
    private boolean[] bY;
    private int[] b6;
    private int[] b8;
    private boolean[] b4;
    private boolean[] b0;
    private String[] b7;
    private int[][][] b1;
    private int[] bX;
    private int b5;

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int n, int n2, double d) {
        this(n, n2, d, 0.0);
    }

    public LineChart(int n, int n2, double d, double d2) {
        super(n2);
        this.setAutomaticRepaintOn(false);
        this.U = "line";
        this.b2 = new boolean[n][n2];
        this.bY = new boolean[n];
        this.b6 = new int[n];
        this.b8 = new int[n];
        this.b4 = new boolean[n];
        this.bW = new int[n];
        int n3 = 0;
        while (n3 < this.b8.length) {
            this.b8[n3] = 6;
            this.b4[n3] = true;
            this.bW[n3] = 2;
            ++n3;
        }
        this.b0 = new boolean[n];
        this.bX = new int[n2];
        this.setSeriesCount(n);
        this.setRange(0, d);
        this.setLowerRange(0, d2);
        this.setSampleColors(null);
        this.b5 = -1;
        this.bZ = 1;
        this.a3 = 2;
        this.aj = 3;
        this.b3 = false;
        this.aZ = true;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.bZ = 1;
        this.a3 = 2;
        this.aj = 3;
        this.b3 = false;
        this.aZ = true;
    }

    public String[] getLegendLabels() {
        if (this.aH != null) {
            return this.aH;
        }
        return this.getSeriesLabels();
    }

    double a(int n) {
        if (this.bV) {
            return Math.max(super.a(n), this.getMaxValue(-2));
        }
        return super.a(n);
    }

    public double getMaxValue(int n) {
        if (n >= -1 || !this.bV) {
            return super.getMaxValue(n);
        }
        double d = 0.0;
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value > 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.max(d, d2);
            ++n4;
        }
        return d;
    }

    public void setSampleColors(Color[] colorArray) {
        super.setSampleColors(colorArray);
        if (colorArray == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.autoRepaint();
    }

    public int getValuePosition(double d) {
        return this.a(0, d, this.getGraphBounds());
    }

    public void setValueLabelStyle(int n) {
        if (this.bZ != n) {
            this.bZ = n;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getValueLabelStyle() {
        return this.bZ;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (this.b3 != bl) {
            this.b3 = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.b3;
    }

    public void setStackedOn(boolean bl) {
        if (this.bV != bl) {
            this.bV = bl;
            this.goto = true;
            this.an = true;
            this.autoRepaint();
        }
    }

    public boolean isStackedOn() {
        return this.bV;
    }

    public void setLineWidth(int n) {
        this.setLineWidth(-1, n);
    }

    public void setLineWidth(int n, int n2) {
        if (n >= 0 && n < this.bW.length) {
            this.bW[n] = n2;
        } else if (n < 0) {
            int n3 = 0;
            while (n3 < this.bW.length) {
                this.bW[n3] = n2;
                ++n3;
            }
        }
        this.goto = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int n) {
        if (n >= 0 && n < this.bW.length) {
            return this.bW[n];
        }
        return this.bW[0];
    }

    public void setSampleHighlightOn(boolean bl) {
        int n = 0;
        while (n < this.b2.length) {
            this.bY[n] = bl;
            int n2 = 0;
            while (n2 < this.b2[n].length) {
                this.b2[n][n2] = bl;
                ++n2;
            }
            ++n;
        }
        this.goto = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, boolean bl) {
        try {
            this.bY[n] = bl;
            int n2 = 0;
            while (n2 < this.b2[n].length) {
                this.b2[n][n2] = bl;
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.goto = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, int n2, boolean bl) {
        try {
            this.b2[n][n2] = bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
        this.goto = true;
        this.autoRepaint();
    }

    public boolean isSampleHighlightOn(int n, int n2) {
        try {
            return this.bY[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
    }

    public void setSampleHighlightStyle(int n, int n2) {
        int n3 = 0;
        while (n3 < this.b6.length) {
            this.setSampleHighlightStyle(n3, n, n2);
            ++n3;
        }
    }

    public void setSampleHighlightStyle(int n, int n2, int n3) {
        this.b8[n] = Math.max(0, n3);
        this.b6[n] = n2;
        this.goto = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int n) {
        try {
            return this.b6[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public int getSampleHighlightSize(int n) {
        try {
            return this.b8[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public void setLegendImage(int n, String string) {
        if (n >= 0 && n < 1000) {
            super.setLegendImage(n, string);
            if (this.b7 == null) {
                this.b7 = new String[n + 1];
            }
            if (n >= this.b7.length) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.b7, 0, stringArray, 0, this.b7.length);
                this.b7 = stringArray;
            }
            this.b7[n] = string;
            this.goto = true;
            this.ab = true;
            this.an = true;
            this.autoRepaint();
        }
    }

    public void setSeriesLineOn(boolean bl) {
        int n = 0;
        while (n < this.b4.length) {
            this.b4[n] = bl;
            ++n;
        }
        this.goto = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int n, boolean bl) {
        if (this.b4[n] != bl) {
            this.b4[n] = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLineOn(int n) {
        return this.b4[n];
    }

    public void setConnectedLinesOn(int n, boolean bl) {
        if (n >= 0 && n < this.b0.length) {
            this.b0[n] = bl;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.b0.length) {
                this.b0[n2] = bl;
                ++n2;
            }
        }
        this.goto = true;
        this.autoRepaint();
    }

    public boolean isConnectedLinesOn(int n) {
        if (n >= 0 && n < this.b0.length) {
            return this.b0[n];
        }
        if (n == -1) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.b0.length) {
                if (this.b0[n2]) {
                    bl = true;
                }
                ++n2;
            }
            return bl;
        }
        return false;
    }

    public void setRightToLeftScrollingOn(boolean bl) {
        this.B = bl;
        this.setVisibleSamples(this.visibleSamples[0], this.visibleSamples[1]);
        this.an = true;
        this.goto = true;
        this.autoRepaint();
    }

    public boolean isRightToLeftScrollingOn() {
        return this.B;
    }

    public ChartSample checkSelection(Point point) {
        Serializable serializable;
        int n;
        int n2;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = null;
        if (this.overlayCharts != null) {
            n2 = this.overlayCharts.size();
            n = n2 - 1;
            while (n >= 0 && chartSample == null) {
                Chart chart = (Chart)this.overlayCharts.elementAt(n);
                if (chart != null) {
                    chartSample = chart.checkSelection(point);
                }
                --n;
            }
        }
        if (chartSample != null) {
            this.T = -1;
            this.bq = -1;
            return chartSample;
        }
        if (this.isLegendOn() && this.M != null) {
            n2 = 0;
            while (n2 < this.M.length) {
                if (this.M[n2] != null && this.M[n2].contains(point)) {
                    chartSample = new ChartSample(-1);
                    chartSample.if(n2);
                    break;
                }
                ++n2;
            }
            if (chartSample != null && this.overlayCharts != null) {
                n = this.overlayCharts.size();
                int n3 = n - 1;
                while (n3 >= 0) {
                    serializable = (Chart)this.overlayCharts.elementAt(n3);
                    if (serializable != null) {
                        serializable.T = chartSample.getIndex();
                        serializable.bq = chartSample.getSeries();
                        if (this.ak == 1) {
                            serializable.aA.x = this.aA.x;
                            serializable.aA.y = -1;
                        } else {
                            serializable.aA.x = -1;
                            serializable.aA.y = this.aA.y;
                        }
                    }
                    --n3;
                }
            }
        }
        if (chartSample == null && this.b1 != null) {
            n2 = 3;
            n = 0;
            while (chartSample == null && n < this.b1.length) {
                int n4 = 0;
                while (chartSample == null && n4 < this.b1[n].length) {
                    serializable = new Point(this.b1[n][n4][0], this.b1[n][n4][1]);
                    if (this.is3DModeOn()) {
                        ((Point)serializable).x -= this.m.x;
                        if (!this.bV) {
                            double d = (double)this.m.x / (double)this.getSeriesCount();
                            int n5 = (int)Math.round(d * (double)n);
                            ((Point)serializable).x += n5;
                        }
                    }
                    boolean bl = point.x >= ((Point)serializable).x - n2 && point.x <= ((Point)serializable).x + n2;
                    if (bl &= point.y >= ((Point)serializable).y - n2 && point.y <= ((Point)serializable).y + n2) {
                        chartSample = this.getSample(n, n4);
                    }
                    ++n4;
                }
                ++n;
            }
        }
        if (chartSample != null) {
            this.T = chartSample.getIndex();
            this.bq = chartSample.getSeries();
            this.aA = point;
        } else {
            this.T = -1;
            this.bq = -1;
        }
        return chartSample;
    }

    public void render(Graphics graphics) {
        this.a(graphics, !this.isServletModeOn());
    }

    void a(Graphics graphics, boolean bl) {
        Serializable serializable;
        Object object;
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getGraphBounds();
        Rectangle rectangle2 = this.getDataBounds(rectangle);
        this.calculateChartData(rectangle, rectangle2);
        this.lastCalculationTime = System.currentTimeMillis();
        int n = 0;
        while (n < this.overlayCharts.size()) {
            object = (Chart)this.overlayCharts.elementAt(n);
            if (object != null) {
                Rectangle rectangle3 = new Rectangle(rectangle);
                serializable = new Rectangle(rectangle2);
                if (this.is3DModeOn()) {
                    rectangle3.x -= this.m.x;
                    rectangle3.y -= this.m.y;
                    ((Rectangle)serializable).x -= this.m.x;
                    ((Rectangle)serializable).y -= this.m.y;
                }
                ((Chart)object).calculateChartData(rectangle3, (Rectangle)serializable);
            }
            ++n;
        }
        if (bl && (this.else == null || this.else.getWidth(this) < dimension.width || this.else.getHeight(this) < dimension.height)) {
            try {
                this.else = this.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            }
            catch (Throwable throwable) {
                Chart.do();
            }
            this.goto = true;
        }
        if (!bl || this.goto || this.else == null) {
            object = graphics;
            if (this.else != null && bl && !this.a1) {
                object = this.else.getGraphics();
            } else if (this.a1 && this.aW != null && this.else != null) {
                object = this.aW;
            }
            ((Graphics)object).setColor(this.getBackground());
            ((Graphics)object).fillRect(0, 0, dimension.width, dimension.height);
            this.do((Graphics)object, rectangle);
            this.a((Graphics)object, rectangle, rectangle2);
            this.a((Graphics)object, dimension);
            if (this.isLegendOn()) {
                this.a((Graphics)object, rectangle, this.getLegendLabels());
            }
            this.renderData((Graphics)object, rectangle, rectangle2);
            int n2 = 0;
            while (n2 < this.overlayCharts.size()) {
                serializable = (Chart)this.overlayCharts.elementAt(n2);
                if (serializable != null && this.isOverlayChartOn(n2)) {
                    Rectangle rectangle4 = new Rectangle(rectangle);
                    Rectangle rectangle5 = new Rectangle(rectangle2);
                    rectangle4.x -= this.m.x;
                    rectangle4.y -= this.m.y;
                    rectangle5.x -= this.m.x;
                    rectangle5.y -= this.m.y;
                    if (serializable instanceof LineChart || serializable instanceof PieChart) {
                        ((Chart)serializable).renderData((Graphics)object, rectangle4, rectangle5);
                    } else {
                        ((Chart)serializable).renderData((Graphics)object, rectangle, rectangle2);
                    }
                }
                ++n2;
            }
            if (this.is3DModeOn()) {
                int n3 = this.aF.length - 1;
                while (n3 >= 0) {
                    this.for((Graphics)object, rectangle, n3);
                    --n3;
                }
            }
            if (!this.a1 && object != graphics) {
                ((Graphics)object).dispose();
            }
            if (!this.chartData.hasChangedSince(this.lastCalculationTime)) {
                this.goto = false;
            }
        }
        if ((bl || this.a1) && this.else != null) {
            graphics.drawImage(this.else, 0, 0, this);
        }
        this.a(graphics, rectangle);
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        int n2;
        double d;
        if (!this.an && !this.isServletModeOn()) {
            return;
        }
        int n3 = this.getSampleCount();
        int n4 = this.getSeriesCount();
        this.a(rectangle);
        boolean bl = this.is3DModeOn();
        if (bl) {
            if (this.a > -1) {
                this.m.x = this.a;
                this.m.y = -this.a;
            } else {
                int n5 = Math.max(n3, 20);
                if (n4 > 1 && !this.bV) {
                    n5 /= n4;
                    n5 = Math.max(n5, 4);
                }
                d = (double)rectangle.width / (double)n5;
                this.m.x = (int)Math.round(d * 1.25);
                this.m.y = (int)Math.round(-d / 1.25);
            }
        }
        if (this.b1 == null || this.b1.length != n4 || this.b1.length == 0 || this.b1[0] == null || this.b1[0].length != n3) {
            this.b1 = new int[n4][n3][2];
        }
        int[] nArray = new int[n4];
        if (this.B) {
            int n6 = 0;
            while (n6 < nArray.length) {
                ChartSample[] chartSampleArray = null;
                try {
                    chartSampleArray = this.getSamples(n6);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (chartSampleArray != null) {
                    int n7 = chartSampleArray.length - 1;
                    while (n7 >= 0) {
                        if (chartSampleArray[n7] != null && chartSampleArray[n7].hasValue()) {
                            nArray[n6] = Math.max(nArray[n6], n7);
                            break;
                        }
                        --n7;
                    }
                }
                ++n6;
            }
        }
        d = rectangle2.width;
        double d2 = this.m.x;
        if (n3 > 2) {
            d = (double)rectangle2.width / (double)(n3 - 1);
        }
        if (this.bX == null || this.bX.length < n3) {
            int[] nArray2 = new int[n3];
            if (this.bX != null) {
                System.arraycopy(this.bX, 0, nArray2, 0, Math.min(this.bX.length, nArray2.length));
            }
            this.bX = nArray2;
        }
        double d3 = rectangle2.x;
        if (this.B) {
            n2 = 0;
            String[] stringArray = this.getSampleLabels();
            if (stringArray != null) {
                n = stringArray.length - 1;
                while (n >= 0) {
                    if (stringArray[n] != null) {
                        n2 = Math.max(n2, n);
                        break;
                    }
                    --n;
                }
            }
            d3 = d3 + (double)rectangle2.width - d * (double)n2;
        }
        n2 = 0;
        while (n2 < n3 && n2 < this.bX.length) {
            int n8 = 0;
            n8 = d3 >= 0.0 ? (int)(d3 + 0.5) : (int)(d3 - 0.5);
            this.bX[n2] = n8;
            d3 += d;
            ++n2;
        }
        int n9 = 0;
        while (n9 < n4 && this.b1 != null && n9 < this.b1.length) {
            d3 = rectangle2.x;
            if (this.B) {
                d3 = d3 + (double)rectangle2.width - d * (double)nArray[n9];
            }
            n = 0;
            while (n < n3 && this.b1[n9] != null && n < this.b1[n9].length) {
                int n10;
                int n11 = 0;
                n11 = d3 >= 0.0 ? (int)(d3 + 0.5) : (int)(d3 - 0.5);
                try {
                    this.b1[n9][n][0] = n11;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl && !this.bV) {
                    d2 = (double)this.m.x / (double)n4 * (double)n9;
                    try {
                        int[] nArray3 = this.b1[n9][n];
                        nArray3[0] = (int)((double)nArray3[0] + d2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                double d4 = 0.0;
                if (n9 >= 0 && this.bV) {
                    n10 = 0;
                    while (n10 <= n9) {
                        try {
                            d4 += this.getSampleValue(n10, n);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        ++n10;
                    }
                } else if (n9 >= 0) {
                    try {
                        d4 = this.getSampleValue(n9, n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                n10 = this.getSeriesRange(n9);
                double d5 = 0.0;
                try {
                    d5 = (d4 - this.aw[n10]) / (this.aP[n10] - this.aw[n10]);
                }
                catch (Exception exception) {
                    d5 = Double.NaN;
                }
                double d6 = (double)(rectangle.y + rectangle.height) - d5 * (double)rectangle.height;
                try {
                    this.b1[n9][n][1] = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (bl && this.bV) {
                        int[] nArray4 = this.b1[n9][n];
                        nArray4[1] = nArray4[1] - this.m.y;
                    } else if (bl) {
                        int[] nArray5 = this.b1[n9][n];
                        nArray5[1] = nArray5[1] - this.m.y;
                        double d7 = (double)this.m.y / (double)this.getSeriesCount() * (double)n9;
                        int[] nArray6 = this.b1[n9][n];
                        nArray6[1] = nArray6[1] + (int)Math.round(d7);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                d3 += d;
                ++n;
            }
            ++n9;
        }
        this.an = false;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.do(graphics, rectangle, rectangle2);
    }

    protected void checkDataIntegrity() {
        Object object;
        Object object2;
        int n;
        super.checkDataIntegrity();
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = this.b2 != null ? this.b2.length : 1;
        int n5 = n = n4 > 0 && this.b2 != null ? this.b2[0].length : 0;
        if (this.b1 == null || this.b1.length != n2 || this.b1.length == 0 || this.b1[0].length != n3) {
            this.b1 = new int[n2][n3][2];
            object2 = this.getGraphBounds();
            object = this.getDataBounds((Rectangle)object2);
            this.an = true;
            this.calculateChartData((Rectangle)object2, (Rectangle)object);
        }
        if (n2 != n4 || n3 != n) {
            object2 = new boolean[n2][n3];
            object = new boolean[n2];
            int n6 = 0;
            while (n6 < n2) {
                if (n6 < n4 && this.bY != null) {
                    try {
                        object[n6] = this.bY[n6];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int n7 = 0;
                    while (n7 < n3) {
                        try {
                            object2[n6][n7] = n7 < n ? (Object)this.b2[n6][n7] : (Object)this.bY[n6];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n7;
                    }
                }
                ++n6;
            }
            this.b2 = (boolean[][])object2;
            this.bY = (boolean[])object;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            int[] nArray3 = new int[n2];
            int n8 = 0;
            while (n8 < n2) {
                if (n8 < n4 && this.b6 != null && this.b8 != null && this.b4 != null && this.b0 != null && this.bW != null) {
                    nArray[n8] = this.b6[n8];
                    nArray2[n8] = this.b8[n8];
                    blArray[n8] = this.b4[n8];
                    blArray2[n8] = this.b0[n8];
                    nArray3[n8] = this.bW[n8];
                } else {
                    nArray2[n8] = 6;
                    blArray[n8] = true;
                    nArray3[n8] = 2;
                }
                ++n8;
            }
            this.b6 = nArray;
            this.b8 = nArray2;
            this.b4 = blArray;
            this.b0 = blArray2;
            this.bW = nArray3;
            this.an = true;
        }
        if (this.b5 >= n2) {
            this.b5 = -1;
        }
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        String string;
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        if (!this.ab && this.aY != null) {
            return this.aY;
        }
        Rectangle rectangle = super.a(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int n3 = rectangle.x;
        int n4 = dimension.width - rectangle.width - rectangle.x;
        int n5 = rectangle.y;
        int n6 = dimension.height - rectangle.height - rectangle.y;
        int n7 = 0;
        while (n7 < this.aD.length) {
            if (this.aD[n7]) {
                if (this.aT[n7] == 0) {
                    n3 += 6;
                } else {
                    n4 += 6;
                }
            }
            ++n7;
        }
        if (this.s && this.getSampleCount() > 0 && (this.a3 == 2 || this.a3 == 4)) {
            Font font = this.getFont("sampleLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n8 = 0;
            int n9 = this.getLabelAngle("sampleLabelAngle");
            object3 = this.getSampleLabels();
            int n10 = 0;
            while (n10 < ((String[])object3).length) {
                object2 = this.a(object3[n10], fontMetrics);
                Dimension dimension2 = this.a((Dimension)object2, n9);
                n8 = Math.max(dimension2.height, n8);
                ++n10;
            }
            n6 += n8 + 6;
            if (n9 % 180 == 0) {
                n6 -= fontMetrics.getMaxDescent();
            }
            object2 = null;
            try {
                object2 = this.getSampleLabel(this.getSampleCount() - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            n2 = 0;
            if (object2 != null) {
                Dimension dimension3 = this.a((String)object2, fontMetrics);
                object = this.a(dimension3, n9);
                n2 = ((Dimension)object).width / 2 - 5;
            }
            n = 0;
            if (this.isLegendOn() && this.getLegendPosition() == 1) {
                n = this.b.width;
            }
            if (n2 > n) {
                n4 += n2 - n;
            }
        }
        boolean bl = false;
        int n11 = 0;
        while (n11 < this.aF.length) {
            bl = this.aF[n11] ? true : bl;
            ++n11;
        }
        if (bl || this.int.size() > 0) {
            String string2;
            String string3;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            String string4 = this.getLabel("rangeLabelPrefix");
            object3 = this.getLabel("rangeLabelPostfix");
            String string5 = this.getLabel("rangeLabelPrefix_2");
            object2 = this.getLabel("rangeLabelPostfix_2");
            n2 = 0;
            n = 0;
            object = this.int.keys();
            while (object.hasMoreElements()) {
                String string6 = (String)object.nextElement();
                string3 = this.for(string6);
                if (string3 == null || string3.length() <= 0) continue;
                if (this.a0[0] == 0) {
                    n2 = Math.max(n2, fontMetrics.stringWidth(string3));
                    continue;
                }
                n = Math.max(n, fontMetrics.stringWidth(string3));
            }
            if (this.ap[0] && this.aF[0]) {
                int n12 = this.getRangeDecimalCount(0);
                string3 = this.formatNumber(this.r[0], n12);
                string2 = this.formatNumber(this.void[0], n12);
                string3 = string4 != null ? string4 + string3 : string3;
                string2 = string4 != null ? string4 + string2 : string2;
                string3 = object3 != null ? string3 + (String)object3 : string3;
                String string7 = string2 = object3 != null ? string2 + (String)object3 : string2;
                if (this.a0[0] == 0) {
                    n2 = Math.max(n2, fontMetrics.stringWidth(string3));
                    n2 = Math.max(n2, fontMetrics.stringWidth(string2));
                } else {
                    n = Math.max(n, fontMetrics.stringWidth(string3));
                    n = Math.max(n, fontMetrics.stringWidth(string2));
                }
            }
            if (this.ap[1] && this.aF[1]) {
                int n13 = this.getRangeDecimalCount(1);
                string3 = this.formatNumber(this.r[1], n13);
                string2 = this.formatNumber(this.void[1], n13);
                string3 = string5 != null ? string5 + string3 : string3;
                string2 = string5 != null ? string5 + string2 : string2;
                string3 = object2 != null ? string3 + (String)object2 : string3;
                String string8 = string2 = object2 != null ? string2 + (String)object2 : string2;
                if (this.a0[1] == 0) {
                    n2 = Math.max(n2, fontMetrics.stringWidth(string3));
                    n2 = Math.max(n2, fontMetrics.stringWidth(string2));
                } else {
                    n = Math.max(n, fontMetrics.stringWidth(string3));
                    n = Math.max(n, fontMetrics.stringWidth(string2));
                }
            }
            n3 += n2 + 2;
            n4 += n > 0 ? n + 2 : 0;
        }
        if ((string = this.getLabel("sampleAxisLabel")) != null) {
            Font font = this.getFont("sampleAxisLabelFont");
            object3 = this.getFontMetrics(font);
            int n14 = this.getLabelAngle("sampleAxisLabelAngle");
            object2 = this.a(string, (FontMetrics)object3);
            Dimension dimension4 = this.a((Dimension)object2, n14);
            n6 += dimension4.height + 3;
            if (n14 % 180 == 0) {
                n6 -= ((FontMetrics)object3).getDescent();
            }
        }
        int n15 = 0;
        while (n15 < 2) {
            Object object4 = object3 = n15 == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
            if (object3 != null) {
                Font font = this.getFont("rangeAxisLabelFont");
                object2 = this.getFontMetrics(font);
                int n16 = n15 == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
                Dimension dimension5 = this.a((String)object3, (FontMetrics)object2);
                object = this.a(dimension5, n16);
                if (this.a0[n15] == 0) {
                    n3 += ((Dimension)object).width + 20;
                } else {
                    n4 += ((Dimension)object).width + 20;
                }
            }
            ++n15;
        }
        if (this.is3DModeOn()) {
            if (this.a > -1) {
                n3 += this.m.x;
                n6 -= this.m.y;
            } else {
                int n17 = Math.max(20, this.getSampleCount());
                int n18 = this.getSeriesCount();
                if (n18 > 1 && !this.bV) {
                    n17 /= n18;
                    n17 = Math.max(n17, 4);
                }
                int n19 = (int)((float)rectangle.width * 1.25f / ((float)n17 + 1.25f));
                rectangle.width = dimension.width - (n3 += n19) - n4;
                double d = rectangle.width / n17;
                n6 += (int)Math.round(d / 1.25);
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            n5 = insets.top == -1 ? n5 : insets.top;
            n3 = insets.left == -1 ? n3 : insets.left;
            n6 = insets.bottom == -1 ? n6 : insets.bottom;
            n4 = insets.right == -1 ? n4 : insets.right;
        }
        rectangle.x = n3;
        rectangle.width = dimension.width - n3 - n4 - 1;
        rectangle.y = n5;
        rectangle.height = dimension.height - n5 - n6 - 1;
        this.ab = false;
        this.aY = rectangle;
        return rectangle;
    }

    private void do(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSeriesCount();
        if (n > 0) {
            int n2;
            int n3 = n - 1;
            while (n3 >= 0) {
                n2 = this.getSeriesRange(n3);
                if (this.aP[n2] != this.aw[n2]) {
                    this.a(graphics, n3, rectangle, rectangle2, this.getSampleColor(n3), this.isSelected(n3, -1));
                }
                --n3;
            }
            if (!this.is3DModeOn() && this.b5 >= 0) {
                n2 = this.b5;
                this.a(graphics, n2, rectangle, rectangle2, this.getSampleColor(n2), this.isSelected(n2, -1));
            }
            if (this.isValueLabelsOn(-1) || this.s || this.aL) {
                this.if(graphics, rectangle, rectangle2);
            }
        }
    }

    private void a(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        ChartSample[] chartSampleArray;
        int n2 = this.getSeriesCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (bl) {
            this.b5 = n;
        }
        if ((chartSampleArray = this.getSamples(n)) == null || chartSampleArray.length == 0) {
            return;
        }
        Color color2 = this.bV || bl ? color.darker() : color;
        boolean bl2 = this.is3DModeOn();
        Graphics graphics2 = graphics;
        if (bl2) {
            graphics2.setClip(rectangle.x - this.m.x + 1, rectangle.y + 1, rectangle.width + this.m.x - 1, rectangle.height - this.m.y - 1);
        } else {
            graphics2.setClip(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height + 1);
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        try {
            n3 = this.b1[n][0][0];
            n4 = this.b1[n][0][1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int n5 = 0;
        while (n5 < chartSampleArray.length - 1) {
            boolean bl4 = chartSampleArray[n5] != null && chartSampleArray[n5].value != null && !chartSampleArray[n5].value.isNaN();
            boolean bl5 = chartSampleArray[n5 + 1] != null && chartSampleArray[n5 + 1].value != null && !chartSampleArray[n5 + 1].value.isNaN();
            boolean bl6 = bl4 && bl5;
            bl6 |= bl5 && this.b0[n];
            bl6 &= this.getLineWidth(n) > 0;
            try {
                if (bl6 && n5 > 0 && n5 < this.b1[n].length - 1) {
                    bl6 = this.b1[n][n5][0] != n3;
                    bl6 |= this.b1[n][n5 + 1][1] != n4;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (bl4) {
                try {
                    n3 = this.b1[n][n5][0];
                    n4 = this.b1[n][n5][1];
                    bl3 = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (bl6 &= bl3) {
                if (this.b0 != null && n < this.b0.length && this.b0[n]) {
                    nArray[0] = n3;
                    nArray2[0] = n4;
                } else {
                    try {
                        nArray[0] = this.b1[n][n5][0];
                        nArray2[0] = this.b1[n][n5][1];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.b1 != null && n < this.b1.length && n5 + 1 < this.b1[n].length) {
                    nArray[1] = this.b1[n][n5 + 1][0];
                    nArray2[1] = this.b1[n][n5 + 1][1];
                }
                if (bl2) {
                    nArray[0] = nArray[0] - this.m.x;
                    nArray[1] = nArray[1] - this.m.x;
                    nArray[2] = nArray[2] - this.m.x;
                    nArray[3] = nArray[3] - this.m.x;
                }
                if (this.bV) {
                    nArray[2] = nArray[1];
                    if (n > 0) {
                        try {
                            nArray2[2] = this.b1[n - 1][n5 + 1][1];
                        }
                        catch (Exception exception) {}
                    } else {
                        nArray2[2] = rectangle.y + rectangle.height;
                    }
                    if (bl2) {
                        nArray2[2] = nArray2[2] - this.m.y;
                    }
                    nArray[3] = nArray[0];
                    if (n > 0) {
                        try {
                            nArray2[3] = this.b1[n - 1][n5][1];
                        }
                        catch (Exception exception) {}
                    } else {
                        nArray2[3] = rectangle.y + rectangle.height;
                    }
                    if (bl2) {
                        nArray2[3] = nArray2[3] - this.m.y;
                    }
                }
                boolean bl7 = false;
                int n6 = rectangle.x - (bl2 ? this.m.x * 2 : 0);
                int n7 = rectangle.x + rectangle.width;
                bl7 |= nArray[0] >= n6 && nArray[0] <= n7;
                bl7 |= nArray[1] >= n6 && nArray[1] <= n7;
                if (bl7 |= nArray[0] <= n6 && nArray[1] >= n7) {
                    int n8;
                    nArray[0] = Math.max(nArray[0], -10000);
                    nArray[1] = Math.max(nArray[1], -10000);
                    nArray[0] = Math.min(nArray[0], 11000);
                    nArray[1] = Math.min(nArray[1], 11000);
                    nArray2[0] = Math.max(nArray2[0], -10000);
                    nArray2[1] = Math.max(nArray2[1], -10000);
                    nArray2[0] = Math.min(nArray2[0], 11000);
                    nArray2[1] = Math.min(nArray2[1], 11000);
                    if (this.b4 != null && n < this.b4.length && this.b4[n]) {
                        if (bl2 && this.bV) {
                            boolean bl8;
                            boolean bl9 = n == n2 - 1;
                            boolean bl10 = bl8 = n5 == chartSampleArray.length - 2;
                            if (n5 < chartSampleArray.length - 2) {
                                bl8 |= chartSampleArray[n5 + 2] == null || chartSampleArray[n5 + 2].value == null || chartSampleArray[n5 + 2].value.isNaN();
                                bl8 &= !this.b0[n];
                            }
                            this.a(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, bl9, bl8);
                        } else if (bl2) {
                            this.a(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, true, false);
                        }
                    }
                    if (this.bV && this.b4[n]) {
                        graphics2.setColor(bl ? color.darker() : color);
                        graphics2.fillPolygon(nArray, nArray2, 4);
                        graphics2.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    }
                    graphics2.setColor(color);
                    if (bl2 && this.bV) {
                        graphics2.setColor(color.darker().darker());
                    } else if (bl2 || this.bV) {
                        graphics2.setColor(color.darker());
                    }
                    if (this.b4 != null && n < this.b4.length && this.b4[n] || bl) {
                        graphics2.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                        if (!bl2 && !this.bV && this.bW[n] > 1 && (this.b4[n] || bl)) {
                            double d = 0.0;
                            if (nArray[1] - nArray[0] != 0) {
                                d = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                            }
                            n8 = 1;
                            int n9 = 2;
                            while (n9 <= this.bW[n]) {
                                int n10 = n9 / 2 * n8;
                                if (d <= 1.0) {
                                    graphics2.drawLine(nArray[0], nArray2[0] + n10, nArray[1], nArray2[1] + n10);
                                } else {
                                    graphics2.drawLine(nArray[0] - n10, nArray2[0], nArray[1] - n10, nArray2[1]);
                                }
                                n8 = -n8;
                                ++n9;
                            }
                        }
                    }
                    if (bl && this.b4 != null && n < this.b4.length && this.b4[n] && !bl2 && !this.bV) {
                        double d = 0.0;
                        if (nArray[1] - nArray[0] != 0) {
                            d = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                        }
                        n8 = this.bW[n] / 2 + 1;
                        graphics2.setColor(color.darker().darker());
                        if (d <= 1.0) {
                            graphics2.drawLine(nArray[0], nArray2[0] + n8, nArray[1], nArray2[1] + n8);
                        } else {
                            graphics2.drawLine(nArray[0] - n8, nArray2[0], nArray[1] - n8, nArray2[1]);
                        }
                    }
                }
            }
            ++n5;
        }
        if (!bl2) {
            int n11 = 0;
            while (chartSampleArray != null && n11 < chartSampleArray.length && this.b2 != null && n < this.b2.length && n11 < this.b2[n].length) {
                ChartSample chartSample = chartSampleArray[n11];
                if (this.b2[n][n11] && chartSample != null && chartSample.hasValue()) {
                    try {
                        int n12 = this.b1[n][n11][0];
                        int n13 = this.b1[n][n11][1];
                        if (n13 >= rectangle.y && n13 <= rectangle.y + rectangle.height && n12 >= rectangle.x && n12 <= rectangle.x + rectangle.width + 1) {
                            this.a(graphics, n, Math.round(n12), n13, color);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n11;
            }
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void a(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n6 = this.bV ? 1 : Math.max(1, this.getSeriesCount());
        int n7 = (int)Math.round((double)this.m.x / (double)n6);
        int n8 = (int)Math.round((double)this.m.y / (double)n6);
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = n + n7;
        nArray2[1] = n2 + n8;
        nArray[2] = nArray[1] + (n3 - n);
        nArray2[2] = n4 + n8;
        nArray[3] = n3;
        nArray2[3] = n4;
        Color color2 = color.darker();
        if (bl) {
            double d = 0.0;
            if (nArray[1] - nArray[0] != 0) {
                d = (double)(n2 - n4) / (double)(n3 - n);
            }
            if (d > 0.69) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
        }
        if (bl2) {
            nArray[0] = nArray[3];
            nArray2[0] = nArray2[3];
            nArray[1] = nArray[2];
            nArray2[1] = nArray2[2];
            nArray[2] = nArray[2];
            nArray2[2] = n5 + n8;
            nArray[3] = nArray[0];
            nArray2[3] = n5;
            graphics.setColor(color);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
            graphics.drawLine(nArray[3], nArray2[3], nArray[0], nArray2[0]);
        }
    }

    private boolean a(double d, double d2, double d3, Rectangle rectangle) {
        boolean bl = true;
        if (this.is3DModeOn()) {
            if (d2 <= d3) {
                bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2 - this.m.y) && d >= (double)(rectangle.x - 2) && d <= (double)(rectangle.x + rectangle.width + this.m.x + 2);
            } else {
                double d4 = (double)this.m.x / (double)this.getSeriesCount();
                double d5 = (double)this.m.y / (double)this.getSeriesCount();
                bl = d2 >= (double)rectangle.y - d5 - 2.0 && d2 <= (double)(rectangle.y + rectangle.height - this.m.y) - d5 && d >= (double)rectangle.x - d4 - 2.0 && d <= (double)(rectangle.x + rectangle.width) - d4 + (double)this.m.x + 2.0;
            }
        } else {
            bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2) && d >= (double)(rectangle.x - 4) && d <= (double)(rectangle.x + rectangle.width + 2);
        }
        return bl;
    }

    private void if(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        boolean bl = this.is3DModeOn();
        double d = rectangle2.width;
        if (n > 2) {
            d = (double)rectangle2.width / (double)(n - 1);
        }
        Font font = this.getFont("valueLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n3 = this.getLabelAngle("valueLabelAngle");
        Font font2 = this.getFont("sampleLabelFont");
        FontMetrics fontMetrics2 = this.getFontMetrics(font2);
        int n4 = this.getLabelAngle("sampleLabelAngle");
        int n5 = 0;
        while (n5 < n2) {
            String string;
            String string2;
            if (this.bV) {
                if (n5 != 0) break;
                n5 = n2 - 1;
            }
            if ((string2 = this.getLabel("valueLabelPrefix_" + n5)) == null) {
                string2 = this.getLabel("valueLabelPrefix");
            }
            if ((string = this.getLabel("valueLabelPostfix_" + n5)) == null) {
                string = this.getLabel("valueLabelPostfix");
            }
            int n6 = this.getSampleDecimalCount(n5);
            ChartSample[] chartSampleArray = this.getSamples(n5);
            int n7 = Math.max(this.visibleSamples[0] - 1, 0);
            int n8 = Math.min(n7 + this.visibleSamples[1] + 1, n);
            if (this.B) {
                n7 = 0;
                n8 = this.getSampleCount();
            }
            int n9 = n7;
            while (n9 < n8) {
                block35: {
                    double d2;
                    block37: {
                        block36: {
                            if (!this.bV && (chartSampleArray[n9] == null || chartSampleArray[n9].value == null || chartSampleArray[n9].value.isNaN())) break block35;
                            d2 = 0.0;
                            if (!this.bV) break block36;
                            boolean bl2 = false;
                            int n10 = 0;
                            while (n10 < n2) {
                                ChartSample chartSample = this.getSample(n10, n9);
                                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                                    d2 += chartSample.value.doubleValue();
                                    bl2 = true;
                                }
                                ++n10;
                            }
                            if (bl2) break block37;
                            break block35;
                        }
                        ChartSample chartSample = this.getSample(n5, n9);
                        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) break block35;
                        d2 = chartSampleArray[n9].getFloatValue();
                    }
                    double d3 = d2;
                    if (n9 >= 1 && chartSampleArray[n9 - 1] != null) {
                        d3 = chartSampleArray[n9 - 1].getFloatValue();
                    }
                    double d4 = d2;
                    if (n9 < chartSampleArray.length - 1 && chartSampleArray[n9 + 1] != null) {
                        d4 = chartSampleArray[n9 + 1].getFloatValue();
                    }
                    double d5 = (d2 - d3) / d;
                    double d6 = (d4 - d2) / d;
                    Dimension dimension = new Dimension();
                    int n11 = Integer.MIN_VALUE;
                    int n12 = Integer.MIN_VALUE;
                    if (n9 < this.b1[n5].length) {
                        n11 = this.b1[n5][n9][0];
                        n12 = this.b1[n5][n9][1] - 1;
                    }
                    if (this.bZ == 0 && this.isValueLabelsOn(n5)) {
                        String string3 = this.formatNumber(d2, n6);
                        string3 = string2 != null ? string2 + string3 : string3;
                        string3 = string != null ? string3 + string : string3;
                        Dimension dimension2 = this.a(string3, fontMetrics);
                        dimension = this.a(dimension2, n3);
                        int n13 = Math.round(n11 - dimension.width / 2) + 1;
                        int n14 = n12;
                        n14 = n3 % 180 == 0 ? (n14 += fontMetrics.getAscent() / 2) : n12 - dimension.height / 2;
                        if (bl && !this.bV) {
                            n13 -= this.m.x;
                            if (d5 >= d6) {
                                n14 = (int)((double)n14 + (double)this.m.y / (double)n2);
                                n13 = (int)((double)n13 + (double)this.m.x / (double)n2);
                            }
                        }
                        graphics.setColor(this.getChartForeground());
                        if (this.a(n11, n12, n14 + dimension.height, rectangle)) {
                            graphics.setFont(font);
                            this.a(graphics, string3, n13, n14, dimension2, 0, n3);
                        }
                    }
                    if (this.bZ == 1 && this.isValueLabelsOn(n5) || this.a3 == 1 && this.s || this.aj == 1 && this.aL) {
                        int n15 = 0;
                        int n16 = fontMetrics2.getAscent();
                        Color color = null;
                        if (this.a3 == 1 && this.s) {
                            graphics.setFont(font2);
                            color = this.getSampleLabelColor(n9);
                            n15 = n4;
                            n16 = fontMetrics2.getAscent();
                        } else if (this.bZ == 1 && this.isValueLabelsOn(n5)) {
                            graphics.setFont(font);
                            n15 = n3;
                            n16 = fontMetrics.getAscent();
                        } else if (this.aj == 1 && this.aL) {
                            graphics.setFont(font2);
                            color = this.getSeriesLabelColor(n5);
                        }
                        if (color == null) {
                            color = this.getChartForeground();
                        }
                        String string4 = this.constructLabel(n5, n9, this.aL, 5);
                        Dimension dimension3 = this.a(string4, graphics.getFontMetrics());
                        Dimension dimension4 = this.a(dimension3, n15);
                        int n17 = Math.round(n11 - dimension4.width / 2) + 1;
                        if (bl && !this.bV) {
                            n17 -= this.m.x;
                        }
                        int n18 = n12;
                        if (bl && d5 >= d6) {
                            n18 = (int)((double)n18 + (double)this.m.y / (double)n2);
                        }
                        int n19 = n18;
                        n19 = n15 % 180 == 0 ? (n19 += n16) : (n19 += 6);
                        int n20 = n18;
                        if (n15 % 180 != 0) {
                            n20 -= dimension4.height;
                        }
                        boolean bl3 = false;
                        int n21 = 0;
                        try {
                            bl3 = this.b2[n5][n9];
                            n21 = this.b8[n5];
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            System.out.println("Internal error with value labels");
                            indexOutOfBoundsException.printStackTrace();
                        }
                        if (bl3 || this.bZ == 0 && this.isValueLabelsOn(n5)) {
                            if (n21 >= dimension.height) {
                                n19 += n21 / 2;
                                n20 -= n21 / 2;
                            } else {
                                n19 += dimension.height / 2 - 3;
                                n20 -= dimension.height / 2 - 1;
                            }
                        }
                        if ((n18 = d5 < d6 ? n19 : n20) != n19 && bl && !this.bV) {
                            double d7 = (double)this.m.x / (double)n2;
                            n17 = (int)((double)n17 + d7);
                        }
                        n17 = bl ? Math.max(rectangle.x - this.m.x + 2, n17) : Math.max(rectangle.x + 2, n17);
                        n17 = Math.min(n17, rectangle.x + rectangle.width - dimension4.width - 1);
                        if (this.a(n11, n12, n18 + dimension4.height, rectangle)) {
                            graphics.setColor(color);
                            this.a(graphics, string4, n17, n18, dimension3, 0, n15);
                        }
                    }
                }
                ++n9;
            }
            ++n5;
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        String[] stringArray = this.getSampleLabels();
        if (stringArray == null) {
            return;
        }
        Font font = this.getFont("sampleLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getLabelAngle("sampleLabelAngle");
        int n2 = Math.max(this.visibleSamples[0] - 1, 0);
        int n3 = Math.min(n2 + this.visibleSamples[1] + 1, this.getSampleCount());
        if (this.B) {
            n2 = 0;
            n3 = this.getSampleCount();
        }
        double d = 0.0;
        int n4 = n2;
        while (n4 < n3 && n4 < stringArray.length) {
            String string = stringArray[n4];
            Dimension dimension = this.a(string, fontMetrics);
            Dimension dimension2 = this.a(dimension, n);
            if (this.s && (this.a3 == 2 || this.a3 == 4)) {
                int n5 = rectangle.y + rectangle.height;
                int n6 = rectangle.x;
                int n7 = rectangle.x + rectangle.width;
                if (this.is3DModeOn()) {
                    n5 -= this.m.y;
                    n7 -= this.m.x;
                    n6 -= this.m.x;
                }
                if (this.V) {
                    n5 += 10;
                }
                int n8 = 0;
                if (this.bX != null && n4 < this.bX.length) {
                    n8 = this.bX[n4];
                }
                if (string != null && string.length() > 0 && (n8 -= this.is3DModeOn() ? this.m.x : 0) >= n6 && n8 <= n7 + 1) {
                    int n9 = n5 + 8;
                    if (n % 180 == 0) {
                        n9 += fontMetrics.getMaxAscent() - 4;
                    }
                    int n10 = 0;
                    n10 = n % 180 == 0 ? n8 - dimension2.width / 2 : (n % 360 > 90 && n % 360 < 180 || n % 360 > 270 ? n8 - dimension2.width + fontMetrics.getAscent() / 2 : n8 - fontMetrics.getAscent() / 2);
                    graphics.setFont(font);
                    Color color = this.getForeground();
                    Color color2 = this.getSampleLabelColor(n4);
                    if (color2 == null) {
                        color2 = color;
                    }
                    graphics.setColor(color);
                    if (this.b3) {
                        if (string != null && string.trim().length() > 0 && ((double)n10 > d || n4 == 0)) {
                            graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                            graphics.setColor(color2);
                            this.a(graphics, string, n10, n9, dimension, 0, n);
                            d = n10 + dimension2.width;
                        }
                    } else if (string != null && string.trim().length() > 0) {
                        graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                        graphics.setColor(color2);
                        this.a(graphics, string, n10, n9, dimension, 0, n);
                    }
                }
            }
            ++n4;
        }
    }

    boolean a(Graphics graphics, Rectangle rectangle) {
        int n = this.overlayCharts.size();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n2);
            if (chart != null && this.isOverlayChartOn(n2) && !bl) {
                bl = chart.a(graphics, rectangle);
            }
            --n2;
        }
        boolean bl2 = this.isValueLabelsOn(-1) && this.bZ == 3;
        bl2 |= this.s && (this.a3 == 3 || this.a3 == 4);
        if (bl2 |= this.aL && this.aj == 3) {
            Font font = this.getFont("floatingLabelFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.T >= 0 && this.bq >= 0) {
                ChartSample chartSample = this.getSample(this.bq, this.T);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    String string = this.constructLabel(this.bq, this.T, this.aL, 3);
                    this.if(graphics, rectangle, this.bq, this.T, string, font, fontMetrics);
                }
                return true;
            }
            if (this.bq >= 0 && this.bq < this.getSeriesCount() && this.isFloatingOnLegendOn()) {
                int n3 = this.getSampleCount();
                int n4 = 0;
                while (n4 < n3) {
                    try {
                        ChartSample chartSample = this.getSample(this.bq, n4);
                        if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                            String string = this.constructLabel(this.bq, n4, false, 3);
                            this.if(graphics, rectangle, this.bq, n4, string, font, fontMetrics);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ++n4;
                }
                return true;
            }
        }
        return false;
    }

    protected String constructLabel(int n, int n2, boolean bl, int n3) {
        String string;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        String string2 = "";
        boolean bl2 = n3 == 5 && this.aj == 1;
        bl2 |= n3 == 3 && this.aj == 3;
        boolean bl3 = n3 == 5 && this.a3 == 1;
        bl3 |= n3 == 3 && (this.a3 == 3 || this.a3 == 4);
        boolean bl4 = n3 == 5 && this.bZ == 1;
        bl4 |= n3 == 3 && this.bZ == 3;
        if (bl && bl2 && (string = this.getSeriesLabel(n)) != null) {
            string2 = string2 + string;
            if (!string.endsWith("\n") && this.s && bl3 && this.getSampleLabel(n2) != null) {
                string2 = n3 == 3 ? string2 + " : " : string2 + ":";
            }
        }
        if (this.s && bl3 && this.getSampleLabel(n2) != null) {
            string2 = string2 + this.getSampleLabel(n2);
        }
        if (this.isValueLabelsOn(n) && bl4) {
            String string3;
            string = this.getLabel("valueLabelPrefix_" + n);
            if (string == null) {
                string = this.getLabel("valueLabelPrefix");
            }
            if ((string3 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string3 = this.getLabel("valueLabelPostfix");
            }
            if (string2.length() > 0) {
                String string4 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string4 = string != null ? string + string4 : string4;
                String string5 = string4 = string3 != null ? string4 + string3 : string4;
                string2 = string2.endsWith("\n") || string4.startsWith("\n") ? string2 + string4 : (n3 == 3 ? string2 + " : " + string4 : string2 + ":" + string4);
            } else {
                string2 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string2 = string != null ? string + string2 : string2;
                string2 = string3 != null ? string2 + string3 : string2;
            }
        }
        return string2;
    }

    private void if(Graphics graphics, Rectangle rectangle, int n, int n2, String string, Font font, FontMetrics fontMetrics) {
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount() || fontMetrics == null) {
            return;
        }
        int n3 = 0;
        if (this.is3DModeOn()) {
            if (this.bV) {
                n3 = -this.a;
            } else {
                double d = (double)this.m.x / (double)this.getSeriesCount();
                n3 = (int)Math.round(d * (double)n) - this.m.x;
            }
        }
        int n4 = this.b1[n][n2][0];
        int n5 = this.b1[n][n2][1];
        if (n4 < rectangle.x || n4 > rectangle.x + rectangle.width - n3) {
            return;
        }
        if (n5 < rectangle.y || n5 > (this.is3DModeOn() ? rectangle.y + rectangle.height - this.m.y : rectangle.y + rectangle.height)) {
            return;
        }
        Dimension dimension = this.a(string, fontMetrics);
        int n6 = n4 - dimension.width / 2 + n3;
        int n7 = n5 - dimension.height + fontMetrics.getAscent() - 3;
        Dimension dimension2 = this.getSize();
        n6 = Math.max(n6, 3);
        n6 = Math.min(n6, dimension2.width - dimension.width - 3);
        n7 = Math.max(n7, fontMetrics.getAscent());
        n7 = Math.min(n7, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n6 - 2, n7 - n8 + n9 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(this.getChartForeground());
        graphics.setColor(this.getSampleColor(n).darker());
        graphics.drawRect(n6 - 3, n7 - n8 + n9 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.a(graphics, string, n6, n7, dimension, 0, 0);
    }

    private void a(Graphics graphics, int n, int n2, int n3, Color color) {
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        String string = this.getLegendImage(n);
        Dimension dimension = this.a(string);
        if (string != null && dimension.width > 0 && dimension.height > 0) {
            Image image = (Image)this.ai.get(string);
            if (image != null) {
                graphics.drawImage(image, n2 - dimension.width / 2, n3 - dimension.height / 2, this);
            }
        } else {
            int n4 = 6;
            if (n >= 0 && n < this.b8.length) {
                n4 = this.b8[n];
            }
            int n5 = 0;
            if (n >= 0 && n < this.b6.length) {
                n5 = this.b6[n];
            }
            Color color2 = this.getChartBackground();
            graphics.setColor(color);
            switch (n5) {
                case 0: {
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 2: {
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 1: {
                    graphics.setColor(color2);
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 3: {
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 5: {
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 4: {
                    graphics.setColor(color2);
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int[] nArray = new int[4];
                    nArray[0] = nArray[2] = n2;
                    nArray[1] = n2 + n4 / 2;
                    nArray[3] = n2 - n4 / 2;
                    int[] nArray2 = new int[4];
                    nArray2[0] = n3 - n4 / 2;
                    nArray2[2] = n3 + n4 / 2;
                    nArray2[1] = nArray2[3] = n3;
                    if (n5 == 7) {
                        graphics.setColor(color2);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    } else if (n5 == 8) {
                        graphics.setColor(color);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    graphics.setColor(color);
                    graphics.drawPolygon(nArray, nArray2, 4);
                }
            }
        }
        graphics.setClip(shape);
    }

    private void for(Graphics graphics, Rectangle rectangle, int n) {
        if (this.aF[n = Math.min(this.aF.length - 1, Math.max(0, n))]) {
            int n2 = Math.max(this.Y[n], rectangle.y);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
            int n3 = rectangle.x - this.m.x;
            int n4 = n2 - this.m.y;
            graphics.setColor(n == 0 ? this.getChartForeground() : this.getRangeColor(n));
            graphics.drawLine(n3, n4, n3 + rectangle.width, n4);
            graphics.drawLine(n3 + rectangle.width, n4, rectangle.x + rectangle.width, n2);
        }
    }

    boolean a() {
        return this.isValueLabelsOn() && this.bZ == 3 || this.s && (this.a3 == 3 || this.a3 == 4) || this.aL;
    }
}

