/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BarChart
extends Chart {
    public static final int SIDE_BY_SIDE_BARS = 0;
    public static final int STACKED_BARS = 1;
    public static final int VALUE_LABELS_OUTSIDE = 1;
    public static final int VALUE_LABELS_INSIDE = 0;
    public static final int VALUE_LABELS_FLOATING = 3;
    public static final int BAR_LABELS_BELOW = 2;
    public static final int BAR_LABELS_FLOATING = 3;
    public static final int BAR_LABELS_BELOW_AND_FLOATING = 4;
    private boolean bt;
    private int bu;
    private boolean bv;
    private Color by;
    private boolean bw;
    private double bz;
    private int bx;
    private Rectangle[][] bs;

    public BarChart() {
        this(1);
    }

    public BarChart(int n) {
        this(n, 100.0);
    }

    public BarChart(int n, double d) {
        this(n, d, 0.0);
    }

    public BarChart(int n, double d, double d2) {
        this(1, n, d, d2);
    }

    public BarChart(int n, int n2, double d, double d2) {
        super(n2);
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(n);
        this.U = "bar";
        this.r[0] = this.aP[0] = d;
        this.void[0] = this.aw[0] = d2;
        this.bt = false;
        this.ag = 2;
        this.bu = 1;
        this.aj = 1;
        this.a3 = 1;
        this.bv = true;
        this.bw = false;
        this.bz = 0.4;
        this.bx = 0;
        this.aZ = false;
        this.bz = 0.4;
        this.by = null;
        this.aL = false;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.bt = false;
        this.ag = 2;
        this.bu = 1;
        this.aj = 1;
        this.a3 = 1;
        this.bv = true;
        this.bw = false;
        this.bz = 0.4;
        this.bx = 0;
        this.aZ = false;
        this.by = null;
        this.aL = false;
    }

    double a(int n) {
        if (this.bx == 0 || this.getSeriesRange(0) != n) {
            return super.a(n);
        }
        double d = super.a(n);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value > 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.max(d, d2);
            ++n4;
        }
        return d;
    }

    double if(int n) {
        if (this.bx == 0) {
            return super.if(n);
        }
        double d = super.if(n);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value < 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.min(d, d2);
            ++n4;
        }
        return d;
    }

    private Rectangle do(Rectangle rectangle) {
        boolean bl = this.isValueLabelsOn(0) && this.bu == 1;
        bl |= this.s && this.a3 == 1;
        if (!(bl |= this.aL && this.aj == 1) || this.bx == 1 && !this.isValueLabelsOn()) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = 0;
        Font font = this.getFont("seriesLabelFont");
        if (this.bu == 1 && this.isValueLabelsOn(0)) {
            n = this.getLabelAngle("valueLabelAngle");
            font = this.getFont("seriesLabelFont");
        }
        if (this.a3 == 1 && this.s) {
            n = this.getLabelAngle("sampleLabelAngle");
            font = this.getFont("sampleLabelFont");
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                String string = this.a(n6, n7, 1, this.aL, null);
                if (this.bx == 1) {
                    double d3 = this.getSampleValue(n6, n7);
                    String string2 = this.formatNumber(d3, this.getSampleDecimalCount(0));
                    String string3 = this.getLabel("valueLabelPrefix");
                    String string4 = this.getLabel("valueLabelPostfix");
                    string2 = string3 != null ? string3 + string2 : string2;
                    string2 = string4 != null ? string2 + string4 : string2;
                    String string5 = "";
                    if (this.s && this.a3 == 1 && (string5 = this.getSampleLabel(n7)) != null && !string5.endsWith("\n") && string2 != null && this.bu == 1) {
                        string5 = string5 + " : ";
                    }
                    string = this.bu == 1 ? string5 + string2 : string5;
                }
                Dimension dimension = this.a(string, fontMetrics);
                Dimension dimension2 = this.a(dimension, n);
                double d4 = this.getSampleValue(n6, n7);
                if (d4 == d) {
                    n4 = this.ak == 1 ? Math.max(n4, dimension2.height) : Math.max(n4, fontMetrics.stringWidth(string));
                }
                if (d4 > d) {
                    d = d4;
                    n4 = this.ak == 1 ? dimension2.height : fontMetrics.stringWidth(string);
                }
                if (this.getSampleValue(n6, n7) < d2) {
                    d2 = this.getSampleValue(n6, n7);
                    n5 = this.ak == 1 ? dimension2.height : fontMetrics.stringWidth(string);
                }
                ++n7;
            }
            ++n6;
        }
        if (n % 180 == 0 && this.ak == 1) {
            n5 -= fontMetrics.getDescent();
        }
        if (this.ak == 1) {
            rectangle2.y += n4;
            rectangle2.height -= n4 + n5;
        } else {
            rectangle2.x += n5;
            rectangle2.width -= n4 + n5;
        }
        return rectangle2;
    }

    public int getValuePosition(double d) {
        return this.a(0, d, this.getGraphBounds());
    }

    public void setMultiColorOn(boolean bl) {
        if (bl != this.bt) {
            this.bt = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiColorOn() {
        return this.bt;
    }

    public void setBarLabels(String[] stringArray) {
        this.av = stringArray;
        this.goto = true;
        this.ab = true;
        this.an = true;
        this.autoRepaint();
    }

    public String[] getBarLabels() {
        if (this.av != null) {
            return this.av;
        }
        return this.getSampleLabels();
    }

    public void setBarLabelsOn(boolean bl) {
        this.bk = bl;
        this.goto = true;
        this.ab = true;
        this.an = true;
        this.autoRepaint();
    }

    public boolean isBarLabelsOn() {
        return this.bk;
    }

    public void setBarLabelStyle(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                if (n == this.ag) break;
                this.ag = n;
                this.goto = true;
                this.ab = true;
                this.an = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid barLabelStyle: " + n);
            }
        }
    }

    public int getBarLabelStyle() {
        return this.ag;
    }

    public void setValueLabelStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                if (n == this.bu) break;
                this.bu = n;
                this.goto = true;
                this.ab = true;
                this.an = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueLabelStyle: " + n);
            }
        }
    }

    public int getValueLabelStyle() {
        return this.bu;
    }

    public void setBarOutlineOn(boolean bl) {
        if (this.bv != bl) {
            this.bv = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isBarOutlineOn() {
        return this.bv;
    }

    public void setBarOutlineColor(Color color) {
        if (color != this.by) {
            this.by = color;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public void setBarAlignment(int n) {
        if (n != this.ak) {
            if (n == 0 || n == 1) {
                this.ak = n;
                this.goto = true;
                this.ab = true;
                this.an = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Alignment must be HORIZONTAL or VERTICAL");
            }
        }
    }

    public int getgridAlignment() {
        return this.ak;
    }

    public void setBarType(int n) {
        if (n != this.bx) {
            if (n == 0 || n == 1) {
                this.bx = n;
                this.goto = true;
                this.an = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar type: " + n);
            }
        }
    }

    public int getBarType() {
        return this.bx;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (bl != this.bw) {
            this.bw = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.bw;
    }

    public void setBarWidth(double d) {
        if (d != this.bz) {
            d = Math.max(0.0, d);
            this.bz = d = Math.min(1.0, d);
            this.goto = true;
            this.an = true;
            this.autoRepaint();
        }
    }

    public double getBarWidth() {
        return this.bz;
    }

    public void setMultiSeriesOn(boolean bl) {
        if (bl != this.aZ) {
            this.aZ = bl;
            this.goto = true;
            this.ab = true;
            this.an = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiSeriesOn() {
        return this.aZ;
    }

    public ChartSample checkSelection(Point point) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = null;
        if (this.overlayCharts != null) {
            n5 = this.overlayCharts.size();
            n4 = n5 - 1;
            while (n4 >= 0 && chartSample == null) {
                Chart chart = (Chart)this.overlayCharts.elementAt(n4);
                if (chart != null) {
                    chartSample = chart.checkSelection(point);
                }
                --n4;
            }
        }
        if (chartSample != null) {
            this.T = -1;
            this.bq = -1;
            return chartSample;
        }
        n5 = this.getSeriesCount();
        n4 = this.getSampleCount();
        boolean bl = false;
        if (this.isLegendOn() && this.M != null) {
            n3 = 0;
            while (n3 < this.M.length) {
                if (this.M[n3] != null && this.M[n3].contains(point)) {
                    if (n5 > 1 || this.bx == 1 || this.aZ) {
                        chartSample = new ChartSample(-1);
                        chartSample.if(n3);
                    } else if (n3 < n4) {
                        chartSample = this.getSample(0, n3);
                    }
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (chartSample != null && this.overlayCharts != null) {
                n2 = this.overlayCharts.size();
                n = n2 - 1;
                while (n >= 0) {
                    Chart chart = (Chart)this.overlayCharts.elementAt(n);
                    if (chart != null) {
                        chart.T = chartSample.getIndex();
                        chart.bq = chartSample.getSeries();
                        if (this.ak == 1) {
                            chart.aA.x = this.aA.x;
                            chart.aA.y = -1;
                        } else {
                            chart.aA.x = -1;
                            chart.aA.y = this.aA.y;
                        }
                    }
                    --n;
                }
            }
        }
        if (this.bs != null) {
            n3 = this.getSampleCount();
            while (chartSample == null && n3 != 0) {
                n2 = this.ak == 0 ? this.getSampleCount() - n3 : n3 - 1;
                --n3;
                n = this.getSeriesCount();
                while (chartSample == null && n != 0) {
                    Polygon polygon;
                    int n6 = 0;
                    n6 = this.bx == 1 ? n - 1 : (this.ak == 0 ? this.getSeriesCount() - n : n - 1);
                    --n;
                    Rectangle rectangle = null;
                    try {
                        rectangle = this.bs[n6][n2];
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (rectangle == null) continue;
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    if (this.bx != 1 || this.getSeriesCount() <= 1) {
                        if (this.ak == 1 && rectangle2.height < 3) {
                            rectangle2.y -= 3 - rectangle2.height;
                            rectangle2.height = 6;
                        } else if (this.ak == 0 && rectangle2.width < 3) {
                            rectangle2.x -= 3 - rectangle2.width;
                            rectangle2.width = 6;
                        }
                    }
                    if (rectangle2.contains(point)) {
                        chartSample = this.getSample(n6, n2);
                    }
                    if (chartSample != null || !this.is3DModeOn()) continue;
                    if (this.ak != 1 || this.bx != 1 || this.getSampleValues(n6)[n2] > 0.0 || n6 == 0) {
                        polygon = new Polygon();
                        polygon.addPoint(rectangle.x, rectangle.y);
                        polygon.addPoint(polygon.xpoints[0] + this.m.x, polygon.ypoints[0] + this.m.y);
                        polygon.addPoint(polygon.xpoints[1] + rectangle.width, polygon.ypoints[1]);
                        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                        if (polygon.contains(point)) {
                            chartSample = this.getSample(n6, n2);
                        }
                    }
                    if (this.ak == 0 && this.bx == 1 && !(this.getSampleValues(n6)[n2] > 0.0) && n6 != 0) continue;
                    polygon = new Polygon();
                    polygon.addPoint(rectangle.x + rectangle.width - 1, rectangle.y);
                    polygon.addPoint(rectangle.x + this.m.x + rectangle.width, rectangle.y + this.m.y);
                    polygon.addPoint(rectangle.x + this.m.x + rectangle.width, rectangle.y + this.m.y + rectangle.height);
                    polygon.addPoint(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
                    if (!polygon.contains(point)) continue;
                    chartSample = this.getSample(n6, n2);
                }
            }
        }
        if (chartSample != null) {
            this.T = chartSample.getIndex();
            this.bq = chartSample.getSeries();
            this.aA = point;
            if (bl) {
                if (this.ak == 1) {
                    this.aA.y = -1;
                } else {
                    this.aA.x = -1;
                }
            }
        } else {
            this.T = -1;
            this.bq = -1;
        }
        return chartSample;
    }

    public String[] getLegendLabels() {
        if (this.aH != null) {
            return this.aH;
        }
        if (this.getSeriesCount() > 1 || this.bx == 1 || this.aZ) {
            return this.getSeriesLabels();
        }
        return this.getSampleLabels();
    }

    public void render(Graphics graphics) {
        this.a(graphics, !this.isServletModeOn());
    }

    void a(Graphics graphics, boolean bl) {
        Object object;
        Serializable serializable;
        Rectangle rectangle = this.getGraphBounds();
        Rectangle rectangle2 = this.getDataBounds(rectangle);
        this.calculateChartData(rectangle, rectangle2);
        this.lastCalculationTime = System.currentTimeMillis();
        int n = 0;
        while (n < this.overlayCharts.size()) {
            serializable = (Chart)this.overlayCharts.elementAt(n);
            if (serializable != null && this.isOverlayChartOn(n)) {
                object = new Rectangle(rectangle);
                Rectangle rectangle3 = new Rectangle(rectangle2);
                if (this.is3DModeOn()) {
                    ((Rectangle)object).x -= this.m.x;
                    ((Rectangle)object).y -= this.m.y;
                    rectangle3.x -= this.m.x;
                    rectangle3.y -= this.m.y;
                }
                if (serializable instanceof LineChart) {
                    ((Chart)serializable).calculateChartData((Rectangle)object, this.if(rectangle3));
                } else {
                    ((Chart)serializable).calculateChartData((Rectangle)object, rectangle3);
                }
            }
            ++n;
        }
        serializable = this.getSize();
        if (bl && (this.else == null || this.else.getWidth(this) < ((Dimension)serializable).width || this.else.getHeight(this) < ((Dimension)serializable).height)) {
            try {
                this.else = this.createImage(Math.max(1, ((Dimension)serializable).width), Math.max(1, ((Dimension)serializable).height));
            }
            catch (Throwable throwable) {
                System.out.println("BarChart.offscreen security exception");
                Chart.do();
            }
            this.goto = true;
        }
        if (!bl || this.goto || this.else == null) {
            object = graphics;
            if (this.else != null && bl && !this.a1) {
                object = this.else.getGraphics();
            } else if (this.a1 && this.aW != null && this.else != null) {
                object = this.aW;
            }
            ((Graphics)object).setColor(this.getBackground());
            ((Graphics)object).fillRect(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
            this.a((Graphics)object, (Dimension)serializable);
            if (this.isLegendOn()) {
                this.a((Graphics)object, rectangle, this.getLegendLabels());
            }
            this.do((Graphics)object, rectangle);
            this.for((Graphics)object, rectangle);
            if (this.r != this.void) {
                this.renderData((Graphics)object, rectangle, rectangle2);
                int n2 = 0;
                while (n2 < this.overlayCharts.size()) {
                    Chart chart = (Chart)this.overlayCharts.elementAt(n2);
                    if (chart != null && this.isOverlayChartOn(n2)) {
                        Rectangle rectangle4 = new Rectangle(rectangle);
                        Rectangle rectangle5 = new Rectangle(rectangle2);
                        rectangle4.x -= this.m.x;
                        rectangle4.y -= this.m.y;
                        rectangle5.x -= this.m.x;
                        rectangle5.y -= this.m.y;
                        if (chart instanceof LineChart) {
                            chart.renderData((Graphics)object, rectangle4, this.if(rectangle5));
                        } else if (chart instanceof PieChart) {
                            chart.renderData((Graphics)object, rectangle4, rectangle5);
                        } else {
                            chart.renderData((Graphics)object, rectangle, rectangle2);
                        }
                    }
                    ++n2;
                }
            }
            if (!this.a1 && object != graphics) {
                ((Graphics)object).dispose();
            }
            if (!this.chartData.hasChangedSince(this.lastCalculationTime)) {
                this.goto = false;
            }
        }
        if ((bl || this.a1) && this.else != null) {
            graphics.drawImage(this.else, 0, 0, this);
        }
        this.a(graphics, rectangle);
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.new(graphics, rectangle);
        if (this.is3DModeOn()) {
            int n = this.aF.length - 1;
            while (n >= 0) {
                this.do(graphics, rectangle, n);
                --n;
            }
        }
        this.int(graphics, rectangle);
    }

    private Rectangle if(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = 1;
        if (this.bx != 1) {
            n = this.getSeriesCount();
        }
        if (this.getSampleCount() > 1 && this.bs != null && this.bs.length > 0 && this.bs[0] != null && this.bs[0].length > 0) {
            int n2 = this.bs[0][0].x + this.bs[0][0].width * n / 2 - rectangle.x;
            rectangle2.x += n2;
            rectangle2.width -= n2 * 2;
        }
        return rectangle2;
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        if (!this.ab && this.aY != null) {
            return this.aY;
        }
        Rectangle rectangle = super.a(this.getLegendLabels());
        if (rectangle == null) {
            return new Rectangle(0, 0);
        }
        Dimension dimension = this.getSize();
        int n2 = rectangle.x;
        int n3 = dimension.width - rectangle.width - rectangle.x;
        int n4 = rectangle.y;
        int n5 = dimension.height - rectangle.height - rectangle.y;
        int n6 = 0;
        while (this.aD != null && n6 < this.aD.length) {
            if (this.aD[n6]) {
                if (this.ak == 1) {
                    if (this.aT != null && n6 < this.aT.length && this.aT[n6] == 0) {
                        n2 += 6;
                    } else {
                        n3 += 6;
                    }
                } else if (this.aT != null && n6 < this.aT.length && this.aT[n6] == 0) {
                    n5 += 6;
                } else {
                    n4 += 6;
                }
            }
            ++n6;
        }
        if (this.bk && (this.ag == 2 || this.ag == 4)) {
            int n7;
            Font font = this.getFont("barLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n8 = this.getLabelAngle("barLabelAngle");
            if (this.ak == 1) {
                n = 0;
                object6 = this.getBarLabels();
                n7 = 0;
                while (object6 != null && n7 < ((String[])object6).length) {
                    object5 = this.a(object6[n7], fontMetrics);
                    object4 = this.a((Dimension)object5, n8);
                    if (object4 != null) {
                        n = Math.max(((Dimension)object4).height, n);
                    }
                    ++n7;
                }
                n5 += n;
                if (n8 % 180 == 0) {
                    n5 -= fontMetrics.getMaxDescent();
                }
            } else {
                n = 0;
                object6 = this.getBarLabels();
                n7 = 0;
                while (object6 != null && n7 < ((String[])object6).length) {
                    object5 = this.a(object6[n7], fontMetrics);
                    object4 = this.a((Dimension)object5, n8);
                    if (object4 != null) {
                        n = Math.max(n, ((Dimension)object4).width);
                    }
                    ++n7;
                }
                n2 += n;
            }
        }
        boolean bl = false;
        int n9 = 0;
        while (this.aF != null && n9 < this.aF.length) {
            bl = this.aF[n9] ? true : bl;
            ++n9;
        }
        if (bl || this.int.size() > 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            if (this.ak == 1) {
                n = 0;
                int n10 = 0;
                Enumeration enumeration = this.int.keys();
                while (enumeration.hasMoreElements()) {
                    object5 = (String)enumeration.nextElement();
                    object4 = this.for((String)object5);
                    if (object4 == null || ((String)object4).length() <= 0) continue;
                    if (this.a0 != null && this.a0[0] == 0) {
                        n = Math.max(n, fontMetrics.stringWidth((String)object4));
                        continue;
                    }
                    n10 = Math.max(n10, fontMetrics.stringWidth((String)object4));
                }
                if (this.ap != null && this.ap[0] && this.aF != null && this.aF[0]) {
                    int n11 = this.getRangeDecimalCount(0);
                    object4 = this.formatNumber(this.r[0], n11);
                    object3 = this.formatNumber(this.void[0], n11);
                    object2 = this.getLabel("rangeLabelPrefix");
                    object = this.getLabel("rangeLabelPostfix");
                    object4 = object2 != null ? (String)object2 + (String)object4 : object4;
                    object3 = object2 != null ? (String)object2 + (String)object3 : object3;
                    object4 = object != null ? (String)object4 + (String)object : object4;
                    Object object7 = object3 = object != null ? (String)object3 + (String)object : object3;
                    if (this.a0 != null && this.a0[0] == 0) {
                        n = Math.max(n, fontMetrics.stringWidth((String)object4));
                        n = Math.max(n, fontMetrics.stringWidth((String)object3));
                    } else {
                        n10 = Math.max(n10, fontMetrics.stringWidth((String)object4));
                        n10 = Math.max(n10, fontMetrics.stringWidth((String)object3));
                    }
                }
                if (this.ap[1] && this.aF[1]) {
                    int n12 = this.getRangeDecimalCount(1);
                    object4 = this.formatNumber(this.r[1], n12);
                    object3 = this.formatNumber(this.void[1], n12);
                    object2 = this.getLabel("rangeLabelPrefix_2");
                    object = this.getLabel("rangeLabelPostfix_2");
                    object4 = object2 != null ? (String)object2 + (String)object4 : object4;
                    object3 = object2 != null ? (String)object2 + (String)object3 : object3;
                    object4 = object != null ? (String)object4 + (String)object : object4;
                    Object object8 = object3 = object != null ? (String)object3 + (String)object : object3;
                    if (this.a0 != null && this.a0.length >= 2 && this.a0[1] == 0) {
                        n = Math.max(n, fontMetrics.stringWidth((String)object4));
                        n = Math.max(n, fontMetrics.stringWidth((String)object3));
                    } else {
                        n10 = Math.max(n10, fontMetrics.stringWidth((String)object4));
                        n10 = Math.max(n10, fontMetrics.stringWidth((String)object3));
                    }
                }
                n2 += n + 2;
                n3 += n10 > 0 ? n10 + 2 : 0;
            } else {
                if (this.a7.size() > 0) {
                    n4 += fontMetrics.getMaxAscent();
                }
                if (this.ap != null && this.ap[0] && this.aF != null && this.aF[0]) {
                    if (this.a0 != null && this.a0[0] == 0) {
                        n5 += fontMetrics.getMaxAscent();
                        if (this.int.size() > 0) {
                            n5 += fontMetrics.getHeight();
                        }
                    } else {
                        n4 += fontMetrics.getMaxAscent();
                        if (this.int.size() > 0) {
                            n4 += fontMetrics.getHeight();
                        }
                    }
                    n = this.getRangeDecimalCount(0);
                    object6 = this.formatNumber(this.r[0], n);
                    String string = this.getLabel("rangeLabelPrefix");
                    object5 = this.getLabel("rangeLabelPostfix");
                    object6 = string != null ? string + (String)object6 : object6;
                    object6 = object5 != null ? (String)object6 + (String)object5 : object6;
                    n3 = Math.max(n3, fontMetrics.stringWidth((String)object6) / 2 + 5);
                    object4 = this.formatNumber(this.void[0], n);
                    object4 = string != null ? string + (String)object4 : object4;
                    object4 = object5 != null ? (String)object4 + (String)object5 : object4;
                    n2 = Math.max(n2, fontMetrics.stringWidth((String)object4) / 2 + 5);
                }
                if (this.ap[1] && this.aF[1]) {
                    if (this.a0 != null && this.a0.length >= 2 && this.a0[1] == 0) {
                        n5 += fontMetrics.getMaxAscent();
                    } else {
                        n4 += fontMetrics.getMaxAscent();
                    }
                    n = this.getRangeDecimalCount(1);
                    object6 = this.formatNumber(this.r[1], n);
                    String string = this.getLabel("rangeLabelPrefix_2");
                    object5 = this.getLabel("rangeLabelPostfix_2");
                    object6 = string != null ? string + (String)object6 : object6;
                    object6 = object5 != null ? (String)object6 + (String)object5 : object6;
                    n3 = Math.max(n3, fontMetrics.stringWidth((String)object6) / 2 + 5);
                    object4 = this.formatNumber(this.void[1], n);
                    object4 = string != null ? string + (String)object4 : object4;
                    object4 = object5 != null ? (String)object4 + (String)object5 : object4;
                    n2 = Math.max(n2, fontMetrics.stringWidth((String)object4) / 2 + 5);
                }
            }
        }
        Rectangle rectangle2 = new Rectangle(n2, n4, dimension.width - n2 - n3, dimension.height - n4 - n5);
        rectangle2 = this.do(rectangle2);
        n2 = rectangle2.x;
        n3 = dimension.width - rectangle2.width - rectangle2.x;
        n4 = rectangle2.y;
        n5 = dimension.height - rectangle2.height - rectangle2.y;
        String string = this.getLabel("sampleAxisLabel");
        if (string != null) {
            int n13 = this.getLabelAngle("sampleAxisLabelAngle");
            n13 = this.ak == 0 ? n13 : 0;
            Font font = this.getFont("sampleAxisLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            object4 = this.a(string, fontMetrics);
            object3 = this.a((Dimension)object4, n13);
            if (this.ak == 1) {
                n5 += ((Dimension)object3).height + 3;
            } else {
                n2 += ((Dimension)object3).width + 5;
            }
        }
        int n14 = 0;
        while (n14 < 2) {
            String string2;
            String string3 = string2 = n14 == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
            if (string2 != null && this.aF != null && n14 < this.aF.length && this.aF[n14]) {
                int n15 = n14 == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
                n15 = this.ak == 1 ? n15 : 0;
                object4 = this.getFont("rangeAxisLabelFont");
                object3 = this.getFontMetrics((Font)object4);
                object2 = this.a(string2, (FontMetrics)object3);
                object = this.a((Dimension)object2, n15);
                if (object != null) {
                    if (this.ak == 1) {
                        if (this.a0 != null && n14 < this.a0.length && this.a0[n14] == 0) {
                            n2 += ((Dimension)object).width + 20;
                        } else {
                            n3 += ((Dimension)object).width + 20;
                        }
                    } else if (this.a0 != null && n14 < this.a0.length && this.a0[n14] == 0) {
                        n5 += ((Dimension)object).height + 5 - (n15 % 360 == 0 ? ((FontMetrics)object3).getDescent() : 0);
                    } else {
                        n4 += ((Dimension)object).height + 5;
                    }
                }
            }
            ++n14;
        }
        if (this.is3DModeOn()) {
            if (this.a >= 0) {
                n5 += this.a;
                n2 += this.a;
            } else {
                int n16 = Math.max(1, this.getSampleCount());
                if (this.bx == 0) {
                    n16 *= Math.max(1, this.getSeriesCount());
                }
                if (this.ak == 1) {
                    int n17 = 0;
                    if ((double)n16 + this.bz * 1.25 > 0.0) {
                        n17 = (int)((double)rectangle.width * this.bz * 1.25 / ((double)n16 + this.bz * 1.25));
                    }
                    rectangle.width = dimension.width - (n2 += n17) - n3;
                    double d = 0.0;
                    if (n16 > 0) {
                        d = (double)(rectangle.width / n16) * this.bz;
                    }
                    n5 += (int)Math.round(d / 1.25);
                } else {
                    int n18 = 0;
                    if ((double)(1.25f * (float)n16) + this.bz * 0.75 > 0.0) {
                        n18 = (int)((double)rectangle.height * this.bz * 0.75 / ((double)(1.25f * (float)n16) + this.bz * 0.75));
                    }
                    rectangle.height = dimension.height - n4 - (n5 += n18);
                    double d = (double)(rectangle.height / n16) * this.bz;
                    n2 += (int)Math.round(d * 1.25 * 0.75);
                }
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            n4 = insets.top == -1 ? n4 : insets.top;
            n2 = insets.left == -1 ? n2 : insets.left;
            n5 = insets.bottom == -1 ? n5 : insets.bottom;
            n3 = insets.right == -1 ? n3 : insets.right;
        }
        rectangle.x = n2;
        rectangle.width = dimension.width - n2 - n3 - 1;
        rectangle.y = n4;
        rectangle.height = dimension.height - n4 - n5 - 1;
        this.ab = false;
        this.aY = rectangle;
        return rectangle;
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        if (rectangle == null || rectangle2 == null) {
            return;
        }
        if (!this.an && !this.isServletModeOn()) {
            return;
        }
        this.a(rectangle);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        if (this.is3DModeOn() && n2 > 0 && n3 > 0) {
            double d;
            double d2;
            if (this.a >= 0) {
                this.m.x = this.a;
                this.m.y = -this.a;
            } else if (this.ak == 1) {
                d2 = (double)rectangle.width / (double)n2;
                d = d2 * this.bz;
                if (this.bx == 0) {
                    d /= (double)n3;
                }
                this.m.x = (int)Math.round(d * 1.25);
                this.m.y = (int)Math.round(-d / 1.25);
            } else {
                d2 = (double)rectangle.height / (double)n2;
                d = d2 * this.bz;
                if (this.bx == 0) {
                    d /= (double)n3;
                }
                this.m.x = (int)Math.round(d * 1.25 * 0.75);
                this.m.y = (int)Math.round(-(d / 1.25 * 0.75));
            }
        }
        if (this.bs == null || this.bs.length != n3 || this.bs[0].length != n2) {
            Rectangle[][] rectangleArray = new Rectangle[n3][n2];
            n = 0;
            while (n < n3) {
                int n4 = 0;
                while (n4 < n2) {
                    if (this.bs != null && n < this.bs.length && n4 < this.bs[0].length && this.bs[n][n4] != null) {
                        rectangleArray[n][n4] = this.bs[n][n4];
                    }
                    ++n4;
                }
                ++n;
            }
            this.bs = rectangleArray;
        }
        try {
            int n5 = 0;
            while (n5 < n2) {
                n = 0;
                while (n < n3) {
                    if (this.bs[n][n5] == null) {
                        this.bs[n][n5] = new Rectangle();
                    }
                    ++n;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d = 0.0;
        double d3 = rectangle2.width;
        if (n2 > 0 && n3 > 0) {
            d = this.ak == 1 ? (double)rectangle2.width / (double)n2 : (double)rectangle2.height / (double)n2;
            d3 = d * this.bz;
            if (this.bx == 0) {
                d3 /= (double)n3;
            }
        }
        double d4 = d * (1.0 - this.bz);
        double d5 = 0.0;
        boolean bl = this.is3DModeOn();
        if (this.ak == 1) {
            d5 = (double)rectangle2.x + d4 / 2.0;
            if (bl) {
                d5 -= (double)this.m.x;
            }
        } else {
            d5 = (double)rectangle2.y + d4 / 2.0;
            if (bl) {
                d5 -= (double)this.m.y;
            }
        }
        if (this.ak == 1) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n3) {
                    Rectangle rectangle3 = null;
                    try {
                        rectangle3 = this.bs[n7][n6];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rectangle3 != null) {
                        double d6;
                        double d7;
                        double d8;
                        int n8;
                        double d9;
                        if (d5 >= 0.0) {
                            rectangle3.x = (int)(d5 + 0.5);
                            rectangle3.width = (int)(d5 + d3 + 0.5) - rectangle3.x;
                        } else {
                            rectangle3.x = (int)(d5 - 0.5);
                            rectangle3.width = (int)(d5 + d3 - 0.5) - rectangle3.x;
                        }
                        boolean bl2 = this.bx == 1;
                        int n9 = this.getSeriesRange(n7);
                        double d10 = 0.0;
                        try {
                            d10 = this.getSampleValue(n7, n6);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (d10 >= 0.0) {
                            int n10;
                            int n11;
                            d9 = 0.0;
                            if (this.aP[n9] != 0.0) {
                                d9 = d10 / this.aP[n9] * (double)(this.Y[n9] - rectangle2.y);
                            }
                            rectangle3.height = (int)(d9 + 0.5);
                            rectangle3.y = this.Y[n9] - rectangle3.height;
                            rectangle3.height = Math.max(0, rectangle3.height);
                            if (bl2 && n7 > 0) {
                                double d11 = 0.0;
                                n8 = 0;
                                while (n8 < n7) {
                                    try {
                                        d8 = this.getSampleValue(n8, n6);
                                        if (d8 >= 0.0) {
                                            d11 += d8;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++n8;
                                }
                                d8 = 0.0;
                                if (this.aP[n9] != 0.0) {
                                    d8 = d11 / this.aP[n9] * (double)(this.Y[n9] - rectangle2.y);
                                }
                                rectangle3.y = (d7 = (double)this.Y[n9] - d8 - d9) >= 0.0 ? (int)(d7 + 0.5) : (int)(d7 - 0.5);
                                d6 = d9 + d7 - (double)rectangle3.y;
                                rectangle3.height = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                            }
                            if ((n11 = rectangle3.y + rectangle3.height) > (n10 = rectangle2.y + rectangle2.height)) {
                                rectangle3.height -= n11 - n10;
                            }
                        } else {
                            d9 = 0.0;
                            if (this.aw[n9] != 0.0) {
                                d9 = d10 / this.aw[n9] * (double)(rectangle2.y + rectangle2.height - this.Y[n9]);
                            }
                            rectangle3.height = (int)(d9 + 0.5);
                            rectangle3.y = this.Y[n9];
                            if (bl2 && n7 > 0) {
                                double d12 = 0.0;
                                n8 = 0;
                                while (n8 < n7) {
                                    if (this.getSampleValue(n8, n6) < 0.0) {
                                        d12 += this.getSampleValue(n8, n6);
                                    }
                                    ++n8;
                                }
                                d8 = 0.0;
                                if (this.aw[n9] != 0.0) {
                                    d8 = d12 / this.aw[n9] * (double)(rectangle2.y + rectangle2.height - this.Y[n9]);
                                }
                                rectangle3.y = (d7 = (double)this.Y[n9] + d8) >= 0.0 ? (int)(d7 + 0.5) : (int)(d7 - 0.5);
                                d6 = d9 + d7 - (double)rectangle3.y;
                                rectangle3.height = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                            }
                            if (rectangle3.y < rectangle2.y) {
                                rectangle3.height -= rectangle2.y - rectangle3.y;
                                rectangle3.y = rectangle2.y;
                            }
                        }
                        if (bl) {
                            rectangle3.y -= this.m.y;
                        }
                        if (this.bx == 0 || n7 == n3 - 1) {
                            d5 += d3;
                        }
                    }
                    ++n7;
                }
                d5 += d4;
                ++n6;
            }
        } else {
            int n12 = 0;
            while (n12 < n2) {
                int n13 = 0;
                while (n13 < n3) {
                    Rectangle rectangle4 = null;
                    try {
                        rectangle4 = this.bs[n13][n12];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rectangle4 != null) {
                        double d13;
                        double d14;
                        double d15;
                        int n14;
                        double d16;
                        if (d5 >= 0.0) {
                            rectangle4.y = (int)(d5 + 0.5);
                            rectangle4.height = (int)(d5 + d3 + 0.5) - rectangle4.y;
                        } else {
                            rectangle4.y = (int)(d5 - 0.5);
                            rectangle4.height = (int)(d5 + d3 - 0.5) - rectangle4.y;
                        }
                        boolean bl3 = this.bx == 1;
                        int n15 = 0;
                        try {
                            n15 = this.getSeriesRange(n13);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        double d17 = 0.0;
                        try {
                            d17 = this.getSampleValue(n13, n12);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (d17 >= 0.0) {
                            d16 = 0.0;
                            if (this.aP[n15] != 0.0) {
                                d16 = d17 / this.aP[n15] * (double)(rectangle2.x + rectangle2.width - this.Y[n15]);
                            }
                            rectangle4.width = (int)(d16 + 0.5);
                            rectangle4.x = this.Y[n15];
                            if (this.bx == 1 && n13 > 0) {
                                double d18 = 0.0;
                                n14 = 0;
                                while (n14 < n13) {
                                    try {
                                        double d19 = this.getSampleValue(n14, n12);
                                        if (d19 >= 0.0) {
                                            d18 += d19;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++n14;
                                }
                                d15 = 0.0;
                                if (this.aP[n15] != 0.0) {
                                    d15 = d18 / this.aP[n15] * (double)(rectangle2.x + rectangle2.width - this.Y[n15]);
                                }
                                rectangle4.x = (d14 = (double)this.Y[n15] + d15) >= 0.0 ? (int)(d14 + 0.5) : (int)(d14 - 0.5);
                                d13 = d16 + d14 - (double)rectangle4.x;
                                rectangle4.width = d13 >= 0.0 ? (int)(d13 + 0.5) : (int)(d13 - 0.5);
                            }
                            if (rectangle4.x < rectangle2.x) {
                                rectangle4.width -= rectangle2.x - rectangle4.x;
                                rectangle4.x = rectangle2.x;
                            }
                        } else {
                            int n16;
                            int n17;
                            d16 = 0.0;
                            if (this.aw[n15] != 0.0) {
                                d16 = d17 / this.aw[n15] * (double)(this.Y[n15] - rectangle2.x);
                            }
                            rectangle4.width = (int)(d16 + 0.5);
                            rectangle4.x = this.Y[n15] - rectangle4.width;
                            if (this.bx == 1 && n13 > 0) {
                                double d20 = 0.0;
                                n14 = 0;
                                while (n14 < n13) {
                                    try {
                                        if (this.getSampleValue(n14, n12) < 0.0) {
                                            d20 += this.getSampleValue(n14, n12);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++n14;
                                }
                                d15 = 0.0;
                                if (this.aw[n15] != 0.0) {
                                    d15 = d20 / this.aw[n15] * (double)(this.Y[n15] - rectangle2.x);
                                }
                                rectangle4.x = (d14 = (double)this.Y[n15] - d15 - d16) >= 0.0 ? (int)(d14 + 0.5) : (int)(d14 - 0.5);
                                d13 = d16 + d14 - (double)rectangle4.x;
                                rectangle4.width = d13 >= 0.0 ? (int)(d13 + 0.5) : (int)(d13 - 0.5);
                            }
                            if ((n17 = rectangle4.x + rectangle4.width) > (n16 = rectangle2.x + rectangle2.width)) {
                                rectangle4.width -= n17 - n16;
                            }
                        }
                        if (bl) {
                            rectangle4.x -= this.m.x;
                        }
                        if (this.bx == 0 || n13 == n3 - 1) {
                            d5 += d3;
                        }
                    }
                    ++n13;
                }
                d5 += d4;
                ++n12;
            }
        }
        this.an = false;
    }

    private void new(Graphics graphics, Rectangle rectangle) {
        int n;
        if (graphics == null || rectangle == null) {
            return;
        }
        if (rectangle.width < 0 || rectangle.height < 0) {
            return;
        }
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        boolean bl = this.is3DModeOn();
        if (bl) {
            graphics.setClip(rectangle.x - this.m.x + 1, rectangle.y + 1, rectangle.width + this.m.x - 1, rectangle.height - this.m.y - 1);
        } else if (this.bj != null && this.bj.is3DModeOn()) {
            graphics.setClip(rectangle.x + 1 - this.bj.m.x, rectangle.y + 1 - this.bj.m.y, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.setClip(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
        int n4 = Math.max(this.visibleSamples[0] - 1, 0);
        int n5 = Math.min(n4 + this.visibleSamples[1] + 1, n3);
        if (this.ak == 1) {
            if (this.bx == 0) {
                n = n4;
                while (n < n5) {
                    int n6 = 0;
                    while (n6 < n2) {
                        this.a(graphics, n6, n);
                        ++n6;
                    }
                    ++n;
                }
            } else {
                int n7;
                n = n4;
                while (n < n5) {
                    n7 = n2 - 1;
                    while (n7 >= 0) {
                        try {
                            if (this.getSampleValue(n7, n) < 0.0) {
                                this.a(graphics, n7, n);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        --n7;
                    }
                    ++n;
                }
                n7 = n4;
                while (n7 < n5) {
                    int n8 = 0;
                    while (n8 < n2) {
                        try {
                            if (this.getSampleValue(n8, n7) >= 0.0) {
                                this.a(graphics, n8, n7);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        ++n8;
                    }
                    ++n7;
                }
            }
        } else if (this.bx == 0) {
            n = n5 - 1;
            while (n >= n4) {
                int n9 = n2 - 1;
                while (n9 >= 0) {
                    this.a(graphics, n9, n);
                    --n9;
                }
                --n;
            }
        } else {
            int n10;
            n = n5 - 1;
            while (n >= n4) {
                n10 = n2 - 1;
                while (n10 >= 0) {
                    try {
                        if (this.getSampleValue(n10, n) < 0.0) {
                            this.a(graphics, n10, n);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    --n10;
                }
                --n;
            }
            n10 = n5 - 1;
            while (n10 >= n4) {
                int n11 = 0;
                while (n11 < n2) {
                    try {
                        if (this.getSampleValue(n11, n10) >= 0.0) {
                            this.a(graphics, n11, n10);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ++n11;
                }
                --n10;
            }
        }
        if (bl) {
            graphics.setColor(this.getBackground());
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height - this.m.y + 1);
            polygon.addPoint(rectangle.x + rectangle.width - this.m.x - 1, rectangle.y + rectangle.height - this.m.y + 1);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getChartForeground());
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width - this.m.x, rectangle.y + rectangle.height - this.m.y);
            polygon.xpoints[0] = rectangle.x;
            polygon.ypoints[0] = rectangle.y;
            polygon.xpoints[1] = rectangle.x - this.m.x;
            polygon.ypoints[1] = rectangle.y;
            polygon.xpoints[2] = rectangle.x - this.m.x;
            polygon.ypoints[2] = rectangle.y - this.m.y;
            graphics.setColor(this.getBackground());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getChartForeground());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x - this.m.x, rectangle.y - this.m.y);
        }
    }

    private void a(Graphics graphics, int n, int n2) {
        if (graphics == null) {
            return;
        }
        ChartSample chartSample = null;
        try {
            chartSample = this.getSample(n, n2);
        }
        catch (Exception exception) {
            return;
        }
        int n3 = this.getSeriesCount();
        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || chartSample.getFloatValue() == 0.0 && this.bx == 1 && n3 > 1) {
            return;
        }
        int n4 = this.getSeriesRange(n);
        double d = chartSample.getFloatValue();
        if (this.bx != 1 && (d < this.aw[n4] && this.aw[n4] > 0.0 || d > this.aP[n4] && this.aP[n4] < 0.0)) {
            return;
        }
        if (this.bt) {
            if (this.getSeriesCount() > 1 || this.bx == 1 || this.aZ) {
                graphics.setColor(this.getSampleColor(n));
            } else {
                graphics.setColor(this.getSampleColor(n2));
            }
        } else {
            graphics.setColor(this.getSampleColor(0));
        }
        Rectangle rectangle = null;
        if (this.bs != null && n < this.bs.length && this.bs[n] != null && n2 < this.bs[n].length) {
            rectangle = this.bs[n][n2];
        }
        if (rectangle != null) {
            boolean bl = chartSample != null && chartSample.isSelected();
            Color color = this.getChartForeground();
            if (this.bv) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height);
                Color color2 = graphics.getColor();
                if (this.by != null) {
                    graphics.setColor(this.by);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (bl) {
                    graphics.drawRect(rectangle.x + 1, rectangle.y + 1, Math.max(rectangle.width - 2, 1), rectangle.height == 2 ? 1 : rectangle.height - 2);
                }
                graphics.setColor(color2);
            } else {
                if (this.ak == 1) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (bl) {
                    Color color3 = graphics.getColor();
                    if (this.by != null) {
                        graphics.setColor(this.by);
                    } else {
                        graphics.setColor(color);
                    }
                    if (this.ak == 1) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    }
                    graphics.setColor(color3);
                }
            }
            if (this.is3DModeOn()) {
                this.a(graphics, rectangle, bl, d);
            }
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, boolean bl, double d) {
        if (graphics == null || rectangle == null) {
            return;
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(polygon.xpoints[0] + this.m.x, polygon.ypoints[0] + this.m.y);
        polygon.addPoint(polygon.xpoints[1] + rectangle.width, polygon.ypoints[1]);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(rectangle.x + rectangle.width, rectangle.y);
        polygon2.addPoint(polygon.xpoints[2], polygon.ypoints[2]);
        polygon2.addPoint(polygon.xpoints[2], polygon.ypoints[2] + rectangle.height);
        polygon2.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.setColor(graphics.getColor().darker());
        graphics.fillPolygon(polygon);
        graphics.setColor(graphics.getColor().darker());
        graphics.fillPolygon(polygon2);
        if (this.bv) {
            if (this.by != null) {
                graphics.setColor(this.by);
            } else {
                graphics.setColor(this.getChartForeground());
            }
            graphics.drawPolygon(polygon);
            graphics.drawPolygon(polygon2);
            if (bl) {
                graphics.drawLine(polygon2.xpoints[1] - 1, polygon2.ypoints[1] + 1, polygon2.xpoints[2] - 1, polygon2.ypoints[2]);
                graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1] + 1, polygon.xpoints[2] - 1, polygon.ypoints[2] + 1);
                if (this.ak == 1) {
                    graphics.drawLine(polygon2.xpoints[2] - 1, polygon2.ypoints[2], polygon2.xpoints[3] - 1, polygon2.ypoints[3]);
                    graphics.drawLine(polygon.xpoints[0] + 1, polygon.ypoints[0], polygon.xpoints[1] + 1, polygon.ypoints[1]);
                    if (rectangle.height != 0) {
                        graphics.drawLine(polygon2.xpoints[0], polygon2.ypoints[0] + 1, polygon2.xpoints[1], polygon2.ypoints[1] + 1);
                    } else {
                        graphics.drawLine(polygon.xpoints[3] - 1, polygon.ypoints[3] - 1, polygon.xpoints[0] + 1, polygon.ypoints[0] - 1);
                    }
                } else {
                    graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2] - 1, polygon2.xpoints[3], polygon2.ypoints[3] - 1);
                    graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0] + 1, polygon.xpoints[1], polygon.ypoints[1] + 1);
                    if (rectangle.width != 0) {
                        graphics.drawLine(polygon.xpoints[2] - 1, polygon.ypoints[2], polygon.xpoints[3] - 1, polygon.ypoints[3]);
                    } else {
                        graphics.drawLine(polygon2.xpoints[3] + 1, polygon2.ypoints[3] - 1, polygon2.xpoints[0] + 1, polygon2.ypoints[0] + 1);
                    }
                }
            }
        } else if (bl) {
            if (this.by != null) {
                graphics.setColor(this.by);
            } else {
                graphics.setColor(this.getChartForeground());
            }
            graphics.drawPolygon(polygon);
            graphics.drawLine(polygon2.xpoints[1], polygon2.ypoints[1], polygon2.xpoints[2], polygon2.ypoints[2]);
            if (this.ak == 1) {
                graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2], polygon2.xpoints[3], polygon2.ypoints[3]);
            } else {
                graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2] - 1, polygon2.xpoints[3], polygon2.ypoints[3] - 1);
                graphics.drawLine(polygon2.xpoints[3] - 1, polygon2.ypoints[3] - 1, polygon2.xpoints[0] - 1, polygon2.ypoints[0]);
            }
        }
    }

    private void do(Graphics graphics, Rectangle rectangle, int n) {
        if (graphics == null || rectangle == null) {
            return;
        }
        if (this.aF != null && n < this.aF.length && !this.aF[n = Math.min(this.aF.length - 1, Math.max(0, n))]) {
            return;
        }
        graphics.setColor(n == 0 ? this.getChartForeground() : this.getRangeColor(n));
        if (this.ak == 1) {
            int n2 = Math.max(this.Y[n], rectangle.y);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
            int n3 = rectangle.x - this.m.x;
            int n4 = n2 - this.m.y;
            graphics.drawLine(n3, n4, n3 + rectangle.width, n4);
            graphics.drawLine(n3 + rectangle.width, n4, rectangle.x + rectangle.width, n2);
        } else {
            int n5 = Math.max(this.Y[n], rectangle.x);
            n5 = Math.min(n5, rectangle.x + rectangle.width);
            int n6 = rectangle.y - this.m.y;
            int n7 = n5 - this.m.x;
            graphics.drawLine(n7, n6, n7, n6 + rectangle.height);
            graphics.drawLine(n7, n6, n5, rectangle.y);
        }
    }

    private void int(Graphics graphics, Rectangle rectangle) {
        if (graphics == null || rectangle == null) {
            return;
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        if (n == 0 || n2 == 0) {
            return;
        }
        boolean bl = this.bu == 1 || this.a3 == 1 || this.aj == 1;
        boolean bl2 = bl && this.bx == 1 && n2 > 1;
        boolean bl3 = this.is3DModeOn();
        int n3 = rectangle.y;
        int n4 = n3 + rectangle.height - (bl3 ? this.m.y : 0);
        int n5 = rectangle.x - (bl3 ? this.m.x : 0);
        int n6 = rectangle.x + rectangle.width;
        Font font = this.getFont("valueLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = this.getLabelAngle("valueLabelAngle");
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        int n10 = fontMetrics.getAscent();
        int n11 = this.getSampleDecimalCount(0);
        Font font2 = this.getFont("sampleLabelFont");
        graphics.setFont(font2);
        fontMetrics = graphics.getFontMetrics();
        int n12 = this.getLabelAngle("sampleLabelAngle");
        Font font3 = new Font("Dialog", 0, 12);
        graphics.setFont(font3);
        fontMetrics = graphics.getFontMetrics();
        int n13 = Math.max(this.visibleSamples[0] - 1, 0);
        int n14 = Math.min(n13 + this.visibleSamples[1] + 1, n);
        int n15 = n13;
        while (n15 < n14) {
            int n16 = 0;
            int n17 = 0;
            boolean bl4 = true;
            int n18 = 0;
            while (n18 < n2) {
                block95: {
                    Dimension dimension;
                    Object object;
                    Object object2;
                    Rectangle rectangle2;
                    Rectangle rectangle3;
                    double d;
                    double d2;
                    String string;
                    String string2;
                    block97: {
                        block96: {
                            if (!this.isValueLabelsOn(0) && !this.s && !this.aL) break block95;
                            string2 = this.getLabel("valueLabelPrefix_" + n18);
                            if (string2 == null || bl2) {
                                string2 = this.getLabel("valueLabelPrefix");
                            }
                            if ((string = this.getLabel("valueLabelPostfix_" + n18)) == null || bl2) {
                                string = this.getLabel("valueLabelPostfix");
                            }
                            d2 = 0.0;
                            d = 0.0;
                            rectangle3 = null;
                            rectangle2 = null;
                            if (this.bs != null) {
                                if (n18 < this.bs.length && this.bs[n18] != null && n15 < this.bs[n18].length) {
                                    rectangle3 = this.bs[n18][n15];
                                }
                                if (this.bs.length > 0 && this.bs[0] != null && n15 < this.bs[0].length) {
                                    rectangle2 = this.bs[0][n15];
                                }
                            }
                            if (!bl2 || rectangle3 == null || rectangle2 == null) break block96;
                            int n19 = 0;
                            while (this.bs != null && n19 < this.bs.length) {
                                Rectangle rectangle4 = null;
                                try {
                                    rectangle4 = this.bs[n19][n15];
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (rectangle4 != null) {
                                    if (this.ak == 1) {
                                        if (rectangle3.y + rectangle3.height > rectangle2.y + rectangle2.height) {
                                            rectangle2 = rectangle3;
                                        }
                                    } else if (rectangle3.x < rectangle2.x) {
                                        rectangle2 = rectangle3;
                                    }
                                }
                                ++n19;
                            }
                            boolean bl5 = false;
                            int n20 = 0;
                            while (n20 < n2) {
                                object2 = null;
                                try {
                                    object2 = this.getSample(n20, n15);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object2 != null && ((ChartSample)object2).value != null && !((ChartSample)object2).value.isNaN()) {
                                    bl5 = true;
                                    double d3 = ((ChartSample)object2).getFloatValue();
                                    if (d2 >= 0.0) {
                                        d2 += d3;
                                    } else {
                                        d += d3;
                                    }
                                }
                                ++n20;
                            }
                            if (bl5) break block97;
                            break block95;
                        }
                        ChartSample chartSample = null;
                        try {
                            chartSample = this.getSample(n18, n15);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) break block95;
                        d2 = chartSample.getFloatValue();
                    }
                    if (rectangle3 != null && (this.aj == 0 || this.a3 == 0 || this.bu == 0)) {
                        int n21 = 0;
                        Color color = null;
                        Font font4 = font3;
                        if (this.bu == 0 && this.isValueLabelsOn(n18)) {
                            n21 = n7;
                            font4 = font;
                        }
                        if (this.a3 == 0 && this.s) {
                            n21 = n12;
                            color = this.getSampleLabelColor(n15);
                            font4 = font2;
                        }
                        if (this.aj == 0 && this.aL && color == null) {
                            color = this.getSeriesLabelColor(n18);
                        }
                        graphics.setFont(font4);
                        if (color == null) {
                            object2 = this.getSampleColor(0);
                            if (this.bt) {
                                object2 = n2 > 1 || this.bx == 1 || this.aZ ? this.getSampleColor(n18) : this.getSampleColor(n15);
                            }
                            if ((((Color)object2).getRed() + ((Color)object2).getGreen() + ((Color)object2).getBlue()) / 3 > 110) {
                                graphics.setColor(Color.black);
                            } else {
                                graphics.setColor(Color.white);
                            }
                        }
                        object2 = this.a(n18, n15, 0, this.aL, null);
                        object = this.a((String)object2, this.getFontMetrics(font4));
                        dimension = this.a((Dimension)object, n21);
                        if (this.ak == 1) {
                            n16 = rectangle3.x + rectangle3.width / 2 - dimension.width / 2 + 1;
                            if (d2 >= 0.0) {
                                if (n21 % 180 == 0) {
                                    n17 = rectangle3.y + fontMetrics.getAscent();
                                    n17 = Math.max(n17, rectangle.y + dimension.height - 1);
                                    n17 = Math.min(n17, rectangle.y + rectangle.height - 2);
                                } else {
                                    n17 = rectangle3.y + 3;
                                    n17 = Math.min(n17, rectangle3.y + rectangle3.height - dimension.height - 2);
                                    n17 = Math.max(n17, rectangle.y + 3);
                                }
                            } else if (n21 % 180 == 0) {
                                n17 = rectangle3.y + rectangle3.height - 2;
                                n17 = Math.min(n17, rectangle.y + rectangle.height - 2 - (bl3 ? this.m.y : 0));
                                n17 = Math.max(n17, rectangle.y + dimension.height - 1);
                            } else {
                                n17 = rectangle3.y + rectangle3.height - dimension.height - 2;
                                n17 = Math.min(n17, rectangle.y + rectangle.height - dimension.height - 2 - (bl3 ? this.m.y : 0));
                                n17 = Math.max(n17, rectangle.y + 3 - (bl3 ? this.m.y : 0));
                            }
                            if (this.bx == 1 && n2 > 1) {
                                bl4 = dimension.height < rectangle3.height;
                            }
                        } else {
                            n17 = n21 % 180 == 0 ? rectangle3.y + rectangle3.height / 2 + dimension.height / 2 - 1 : rectangle3.y + rectangle3.height / 2 - dimension.height / 2 + 1;
                            if (d2 >= 0.0) {
                                n16 = rectangle3.x + rectangle3.width - dimension.width - 1;
                                n16 = Math.max(n16, rectangle3.x + 2);
                                n16 = Math.min(n16, rectangle.x + rectangle.width - dimension.width - 1);
                            } else {
                                n16 = rectangle3.x + 2;
                                n16 = Math.max(n16, rectangle.x + 2 - (bl3 ? this.m.x : 0));
                                n16 = Math.min(n16, rectangle.x + rectangle.width - dimension.width - 1 - (bl3 ? this.m.x : 0));
                            }
                            if (this.bx == 1 && n2 > 1) {
                                boolean bl6 = bl4 = dimension.width < rectangle3.width;
                            }
                        }
                        if (this.ak == 1) {
                            if (n16 + dimension.width / 2 < n5 - 3 || n16 + dimension.width / 2 > n6 + 3) {
                                bl4 = false;
                            }
                        } else if (n21 % 180 == 0) {
                            if (n17 - n8 / 2 < n3 - 3 || n17 - n8 / 2 > n4) {
                                bl4 = false;
                            }
                        } else if (n17 + dimension.height / 2 < n3 - 3 || n17 + dimension.height / 2 > n4) {
                            bl4 = false;
                        }
                        if (bl4) {
                            graphics.setColor(color);
                            this.a(graphics, (String)object2, n16, n17, (Dimension)object, 0, n21);
                        }
                    }
                    if (!(rectangle3 == null || this.aj != 1 && this.a3 != 1 && this.bu != 1 || bl2 && n18 < n2 - 1)) {
                        Object object3;
                        Object object4;
                        int n22 = 0;
                        Color color = null;
                        Font font5 = font3;
                        if (this.bu == 1 && this.isValueLabelsOn(n18)) {
                            n22 = n7;
                            font5 = font;
                        }
                        if (this.a3 == 1 && this.s) {
                            n22 = n12;
                            color = this.getSampleLabelColor(n15);
                            font5 = font2;
                        }
                        if (this.aj == 1 && this.aL && color == null) {
                            color = this.getSeriesLabelColor(n18);
                        }
                        graphics.setFont(font5);
                        if (color == null) {
                            color = this.getChartForeground();
                        }
                        object2 = this.a(n18, n15, 1, this.aL, null);
                        object = null;
                        dimension = null;
                        Dimension dimension2 = null;
                        if (bl2) {
                            object4 = this.formatNumber(d2, n11);
                            object4 = string2 != null ? string2 + (String)object4 : object4;
                            object4 = string != null ? (String)object4 + string : object4;
                            object3 = "";
                            if (this.s && this.a3 == 1) {
                                try {
                                    object3 = this.getSampleLabel(n15);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object3 != null && !((String)object3).endsWith("\n") && object4 != null && this.bu == 1) {
                                    object3 = (String)object3 + " : ";
                                }
                            }
                            Object object5 = object2 = this.bu == 1 ? (String)object3 + (String)object4 : object3;
                            if (d < 0.0) {
                                object = this.formatNumber(d, n11);
                                object = string2 != null ? string2 + (String)object : object;
                                object = string != null ? (String)object + string : object;
                                dimension = this.a((String)object, this.getFontMetrics(font));
                                dimension2 = this.a(dimension, n22);
                            }
                            n22 = n7;
                            graphics.setFont(font);
                        }
                        object4 = this.a((String)object2, this.getFontMetrics(font5));
                        object3 = this.a((Dimension)object4, n22);
                        if (d2 >= 0.0) {
                            if (this.ak == 1) {
                                n16 = rectangle3.x + rectangle3.width / 2 - ((Dimension)object3).width / 2;
                                if (n22 % 180 == 0) {
                                    n17 = rectangle3.y - 2 - ((Dimension)object3).height + n8 - n9;
                                    n17 = Math.max(n3 - 2 - ((Dimension)object3).height + n8 - n9, n17);
                                    n17 = Math.min(n4 - 2 - ((Dimension)object3).height + n8 - n9, n17);
                                } else {
                                    n17 = rectangle3.y - 2 - ((Dimension)object3).height;
                                    n17 = Math.max(n17, n3 - ((Dimension)object3).height - 2);
                                    n17 = Math.min(n17, n4 - ((Dimension)object3).height - 2);
                                }
                                if (n22 % 180 > 0 && n22 % 180 < 90) {
                                    n16 = rectangle3.x + rectangle3.width - ((Dimension)object3).width + 1;
                                } else if (n22 % 180 > 90) {
                                    n16 = rectangle3.x - 1;
                                }
                                if (bl3 && (n2 == 1 || bl2)) {
                                    n17 += this.m.y;
                                    n16 += this.m.x;
                                    n17 = n22 % 180 == 0 ? Math.max(n3 - 2, n17) : Math.max(n3 - ((Dimension)object3).height - 2, n17);
                                }
                                if (n16 + ((Dimension)object3).width / 2 < n5 - 3 || n16 + ((Dimension)object3).width / 2 > n6 + 3) {
                                    bl4 = false;
                                }
                            } else {
                                n17 = rectangle3.y - (((Dimension)object3).height - rectangle3.height) / 2 + n8 - n9 - 1;
                                n16 = rectangle3.x + rectangle3.width + 3;
                                n16 = Math.min(rectangle.x + rectangle.width + 3, n16);
                                n16 = Math.max(n5 + 3, n16);
                                if (bl3 && n2 == 1) {
                                    n17 += this.m.y;
                                    n16 += this.m.x;
                                    n16 = Math.min(rectangle.x + rectangle.width + 3, n16);
                                }
                                if (n17 - n8 / 2 < n3 - 3 || n17 - n8 / 2 > n4) {
                                    bl4 = false;
                                }
                            }
                            if (bl4 && this.r[0] > 0.0 && (d2 != 0.0 || !(d < 0.0))) {
                                graphics.setColor(color);
                                this.a(graphics, (String)object2, n16, n17, (Dimension)object4, 0, this.ak == 1 ? n22 : 0);
                            }
                        }
                        if (bl2 && d < 0.0) {
                            d2 = d;
                            String string3 = this.formatNumber(d2, n11);
                            string3 = string2 != null ? string2 + string3 : string3;
                            string3 = string != null ? string3 + string : string3;
                            String string4 = "";
                            if (this.s && this.a3 == 1) {
                                try {
                                    string4 = this.getSampleLabel(n15);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (string4 != null && !string4.endsWith("\n") && string3 != null && this.bu == 1) {
                                    string4 = string4 + " : ";
                                }
                            }
                            object2 = this.bu == 1 ? string4 + string3 : string4;
                            object2 = this.bu == 1 ? string4 + string3 : string4;
                            object4 = dimension;
                            object3 = dimension2;
                        }
                        if (d2 < 0.0) {
                            if (this.ak == 1) {
                                n16 = rectangle3.x + rectangle3.width / 2 - ((Dimension)object3).width / 2;
                                if (n22 % 180 == 0) {
                                    n17 = rectangle2.y + rectangle2.height + n10;
                                    n17 = Math.min(n4 + n10, n17);
                                    n17 = Math.max(n17, bl3 ? n3 - this.m.y + n10 : n3 + n10);
                                } else {
                                    n17 = rectangle3.y + rectangle3.height + 3;
                                    n17 = Math.min(n4 + 3, n17);
                                    n17 = Math.max(n17, bl3 ? n3 - this.m.y + 2 : n3 + 2);
                                }
                                if (n22 % 180 > 0 && n22 % 180 < 90) {
                                    n16 = rectangle3.x - 1;
                                } else if (n22 % 180 > 90) {
                                    n16 = rectangle3.x + rectangle3.width - ((Dimension)object3).width + 1;
                                }
                                if (n16 + ((Dimension)object3).width / 2 < n5 - 3 || n16 + ((Dimension)object3).width / 2 > n6 + 3) {
                                    bl4 = false;
                                }
                            } else {
                                n17 = rectangle3.y + rectangle3.height / 2 + n8 / 2 - n9 + 1;
                                n16 = rectangle3.x - ((Dimension)object4).width - 3;
                                n16 = Math.max(n5 - ((Dimension)object4).width - 3, n16);
                                n16 = Math.min(n5 + rectangle.width - ((Dimension)object4).width - 3, n16);
                                if (n17 - n8 / 2 < n3 - 3 || n17 - n8 / 2 > n4) {
                                    bl4 = false;
                                }
                            }
                            if (bl4 && this.void[0] < 0.0) {
                                graphics.setColor(color);
                                this.a(graphics, (String)object2, n16, n17, (Dimension)object4, 0, this.ak == 1 ? n22 : 0);
                            }
                        }
                    }
                }
                ++n18;
            }
            ++n15;
        }
    }

    private void for(Graphics graphics, Rectangle rectangle) {
        if (graphics == null || rectangle == null) {
            return;
        }
        if (!this.bk || this.ag == 3) {
            return;
        }
        String[] stringArray = this.getBarLabels();
        if (stringArray == null) {
            return;
        }
        Font font = this.getFont("barLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.ak == 1) {
            int n = this.getLabelAngle("barLabelAngle");
            int n2 = 0;
            int n3 = Math.max(this.visibleSamples[0] - 1, 0);
            int n4 = Math.min(n3 + this.visibleSamples[1] + 1, stringArray.length);
            int n5 = n3;
            while (n5 < n4) {
                if (stringArray[n5] != null) {
                    boolean bl = false;
                    int n6 = this.getSeriesCount();
                    if (n5 < this.getSampleCount()) {
                        int n7 = 0;
                        while (n7 < n6) {
                            if (this.isSelected(n7, n5)) {
                                bl = true;
                                break;
                            }
                            ++n7;
                        }
                    }
                    Color color = this.getSampleLabelColor(n5);
                    if (bl && this.getSampleLabelSelectionColor() != null) {
                        graphics.setColor(this.getSampleLabelSelectionColor());
                    } else if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.getForeground());
                    }
                    Dimension dimension = this.a(stringArray[n5], fontMetrics);
                    Dimension dimension2 = this.a(dimension, n);
                    int n8 = Integer.MIN_VALUE;
                    int n9 = 0;
                    if (this.bs != null && this.bs.length > 0 && n5 < this.bs[0].length) {
                        n8 = this.bs[0][n5].x;
                        n9 = this.bs[this.bs.length - 1][n5].x + this.bs[this.bs.length - 1][n5].width - n8;
                    }
                    int n10 = n8 + n9 / 2;
                    n8 = n % 90 == 0 ? n10 - dimension2.width / 2 : (n % 180 > 90 ? n10 + n9 / 2 - dimension2.width : n10 - n9 / 2);
                    int n11 = rectangle.x - 2 - (this.is3DModeOn() ? this.m.x : 0);
                    if (n10 >= n11 && n10 <= rectangle.x + rectangle.width + 2) {
                        int n12 = rectangle.y + rectangle.height + 6;
                        if (n % 180 == 0) {
                            n12 += fontMetrics.getMaxAscent() - 4;
                        }
                        if (this.is3DModeOn()) {
                            n12 -= this.m.y;
                        }
                        if (this.V) {
                            n12 += 10;
                        }
                        if (this.isValueLabelsOn() && this.bu == 1 && this.void[0] < 0.0) {
                            int n13 = rectangle.y;
                            int n14 = this.Y[0] - (this.is3DModeOn() ? this.m.y : 0);
                            int n15 = 0;
                            while (n15 < this.bs.length) {
                                int n16 = this.bs[n15][n5].y + this.bs[n15][n5].height;
                                if (n16 > n13 && n16 > n14) {
                                    n13 = n16;
                                }
                                ++n15;
                            }
                            n12 = Math.max(n12, n13 + fontMetrics.getMaxAscent() + 10);
                            n13 = rectangle.y + rectangle.height - (this.is3DModeOn() ? this.m.y : 0);
                            n12 = Math.min(n12, n13 + fontMetrics.getMaxAscent() + 10);
                        }
                        if (this.bw) {
                            if (stringArray[n5] != null && stringArray[n5].trim().length() > 0 && (n8 > n2 || n5 == 0)) {
                                this.a(graphics, stringArray[n5], n8, n12, dimension, 0, n);
                                n2 = n8 + dimension2.width;
                            }
                        } else {
                            this.a(graphics, stringArray[n5], n8, n12, dimension, 0, n);
                        }
                    }
                }
                ++n5;
            }
        } else {
            int n = this.getLabelAngle("barLabelAngle");
            int n17 = Math.min(stringArray.length, this.getSampleCount());
            int n18 = Math.max(this.visibleSamples[0] - 1, 0);
            int n19 = Math.min(n18 + this.visibleSamples[1] + 1, n17);
            int n20 = n18;
            while (n20 < n19) {
                if (stringArray[n20] != null) {
                    boolean bl = false;
                    int n21 = this.getSeriesCount();
                    int n22 = 0;
                    while (n22 < n21) {
                        if (this.isSelected(n22, n20)) {
                            bl = true;
                            break;
                        }
                        ++n22;
                    }
                    Color color = this.getSampleLabelColor(n20);
                    if (bl && this.getSampleLabelSelectionColor() != null) {
                        graphics.setColor(this.getSampleLabelSelectionColor());
                    } else if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.getForeground());
                    }
                    Dimension dimension = this.a(stringArray[n20], fontMetrics);
                    Dimension dimension3 = this.a(dimension, n);
                    int n23 = dimension3.height;
                    if (this.bs.length > 0 && n20 < this.bs[this.bs.length - 1].length && n20 < this.bs[0].length) {
                        n23 = this.bs[this.bs.length - 1][n20].y + this.bs[this.bs.length - 1][n20].height - this.bs[0][n20].y;
                    }
                    int n24 = 0;
                    if (n20 < this.bs[0].length) {
                        n24 = this.bs[0][n20].y + n23 / 2;
                    }
                    int n25 = n24 - dimension3.height / 2;
                    if (n % 180 == 0) {
                        n25 += fontMetrics.getAscent() - 1;
                    } else if (n % 180 > 90) {
                        n25 = n24 - n23 / 2;
                    } else if (n % 180 != 90) {
                        n25 = n24 + n23 / 2 - dimension3.height;
                    }
                    if (n24 >= rectangle.y && n24 <= rectangle.y + rectangle.height - (this.is3DModeOn() ? this.m.y : 0)) {
                        int n26 = rectangle.x - dimension3.width - 3;
                        if (this.is3DModeOn()) {
                            n26 -= this.m.x;
                        }
                        if (this.V) {
                            n26 -= 10;
                        }
                        if (this.isValueLabelsOn() && this.bu == 1 && this.void[0] < 0.0) {
                            int n27 = rectangle.x + rectangle.width;
                            int n28 = 0;
                            double d = 0.0;
                            int n29 = 0;
                            while (n29 < this.bs.length) {
                                if (!(this.getSampleValue(n29, n20) >= 0.0)) {
                                    d = this.bx == 1 ? (d += this.getSampleValue(n29, n20)) : this.getSampleValue(n29, n20);
                                    try {
                                        if (this.bs[n29][n20].x < n27) {
                                            String string = this.getLabel("valueLabelPrefix");
                                            String string2 = this.getLabel("valueLabelPostfix");
                                            n27 = this.bs[n29][n20].x;
                                            String string3 = this.formatNumber(d, this.getSampleDecimalCount(0));
                                            string3 = string != null ? string + string3 : string3;
                                            string3 = string2 != null ? string3 + string2 : string3;
                                            n28 = fontMetrics.stringWidth(string3);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                ++n29;
                            }
                            n26 = Math.min(n26, n27 - n28 - dimension3.width - 3);
                            n27 = rectangle.x - (this.is3DModeOn() ? this.m.x : 0);
                            n26 = Math.max(n26, n27 - n28 - dimension3.width - 3);
                            n26 = Math.min(n26, (n27 -= this.V ? 10 : 0) - dimension3.width - 3);
                        }
                        this.a(graphics, stringArray[n20], n26, n25, dimension, 1, n);
                    }
                }
                ++n20;
            }
        }
    }

    String a(int n, int n2, int n3, boolean bl, String string) {
        String string2;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        boolean bl2 = bl && this.aL && this.aj == n3;
        int n4 = this.a3;
        if (this.a3 == 4) {
            n4 = 3;
        }
        boolean bl3 = this.s && n4 == n3;
        boolean bl4 = this.isValueLabelsOn(n) && this.bu == n3;
        String string3 = n3 == 3 ? " : " : ":";
        String string4 = "";
        if (bl2 && (string2 = this.getSeriesLabel(n)) != null) {
            string4 = string4 + string2;
            if (!string2.endsWith("\n") && bl3 && this.getSampleLabel(n2) != null) {
                string4 = string4 + string3;
            }
        }
        if (bl3 && this.getSampleLabel(n2) != null) {
            string4 = string4 + this.getSampleLabel(n2);
        }
        if (bl4) {
            String string5;
            string2 = this.getLabel("valueLabelPrefix_" + n);
            if (string2 == null) {
                string2 = this.getLabel("valueLabelPrefix");
            }
            if ((string5 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string5 = this.getLabel("valueLabelPostfix");
            }
            if (string4.length() > 0) {
                String string6 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string6 = string2 != null ? string2 + string6 : string6;
                String string7 = string6 = string5 != null ? string6 + string5 : string6;
                string4 = string4.endsWith("\n") ? string4 + string6 : string4 + string3 + string6;
            } else {
                string4 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string4 = string2 != null ? string2 + string4 : string4;
                String string8 = string4 = string5 != null ? string4 + string5 : string4;
            }
        }
        if (string != null) {
            if (!string4.equals("") && !string4.endsWith("\n")) {
                string4 = string4 + " : ";
            }
            string4 = string4 + string;
        }
        return string4;
    }

    boolean a(Graphics graphics, Rectangle rectangle) {
        int n = this.overlayCharts.size();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n2);
            if (chart != null && this.isOverlayChartOn(n2) && !bl) {
                bl = chart.a(graphics, rectangle);
            }
            --n2;
        }
        boolean bl2 = false;
        if (this.isValueLabelsOn() && this.bu == 3) {
            bl2 = true;
        }
        if (this.bk && (this.ag == 3 || this.ag == 4)) {
            bl2 = true;
        }
        if (this.s && this.a3 == 3) {
            bl2 = true;
        }
        if (this.aL && this.aj == 3) {
            bl2 = true;
        }
        if (bl2 && this.bq >= -1 && this.T >= -1) {
            Font font = this.getFont("floatingLabelFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.T >= 0) {
                String string = this.a(this.bq, this.T, true);
                this.a(graphics, rectangle, this.bq, this.T, string, font, fontMetrics);
                bl = true;
            } else if (this.bq >= 0 && this.isFloatingOnLegendOn()) {
                int n3 = this.getSampleCount();
                int n4 = 0;
                while (n4 < n3) {
                    try {
                        double d = this.getSampleValue(this.bq, n4);
                        if (!Double.isNaN(d)) {
                            String string = this.a(this.bq, n4, false);
                            this.a(graphics, rectangle, this.bq, n4, string, font, fontMetrics);
                            bl = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ++n4;
                }
            }
            return bl;
        }
        return false;
    }

    private String a(int n, int n2, boolean bl) {
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        String[] stringArray = null;
        if (this.s && (this.a3 == 3 || this.a3 == 4)) {
            stringArray = this.getSampleLabels();
        } else if (this.bk && this.ag == 3) {
            stringArray = this.getBarLabels();
        } else if (this.bk && this.ag == 4) {
            stringArray = this.getSampleLabels();
        }
        String string = "";
        String string2 = this.getSeriesLabel(n);
        if (this.getSeriesCount() > 1 && bl && this.aL && this.aj == 3 && string2 != null) {
            string = string2;
        }
        if (stringArray != null && n2 < stringArray.length && stringArray[n2] != null) {
            string = string != null && (Chart.if(string).endsWith("\n") || Chart.if(stringArray[n2]).startsWith("\n")) ? string + stringArray[n2] : (string != null && string.trim().length() > 0 ? string + " : " + stringArray[n2] : stringArray[n2]);
        }
        if (this.isValueLabelsOn() && this.bu == 3) {
            String string3;
            String string4 = this.getLabel("valueLabelPrefix_" + n);
            if (string4 == null) {
                string4 = this.getLabel("valueLabelPrefix");
            }
            if ((string3 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string3 = this.getLabel("valueLabelPostfix");
            }
            String string5 = "";
            double d = Double.NaN;
            try {
                d = this.getSampleValue(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!Double.isNaN(d)) {
                string5 = this.formatNumber(d, this.getSampleDecimalCount(n));
                if (string4 != null) {
                    string5 = string4 + string5;
                }
                if (string3 != null) {
                    string5 = string5 + string3;
                }
            }
            if (string5 != null && string5.trim().length() > 0) {
                string = string != null && Chart.if(string).endsWith("\n") ? string + string5 : (string != null && string.trim().length() > 0 ? string + " : " + string5 : string5);
            }
        }
        return string;
    }

    private void a(Graphics graphics, Rectangle rectangle, int n, int n2, String string, Font font, FontMetrics fontMetrics) {
        int n3;
        Cloneable cloneable;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount() || fontMetrics == null) {
            return;
        }
        Rectangle rectangle2 = this.bs[n][n2];
        if (rectangle2 == null) {
            return;
        }
        if (this.ak == 1) {
            if (rectangle2.x + rectangle2.width < rectangle.x - this.m.x || rectangle2.x > rectangle.x + rectangle.width) {
                return;
            }
            if (rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height - this.m.y) {
                return;
            }
        } else {
            if (rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height - this.m.y) {
                return;
            }
            if (rectangle2.x + rectangle2.width < rectangle.x - this.m.x || rectangle2.x > rectangle.x + rectangle.width) {
                return;
            }
        }
        Dimension dimension = this.a(string, fontMetrics);
        int n4 = this.aA.x + 3;
        n4 = this.ak == 1 ? rectangle2.x + rectangle2.width / 2 - dimension.width / 2 + 1 : (this.aA.x < 0 ? rectangle2.x + rectangle2.width / 2 - dimension.width / 2 : this.aA.x - dimension.width - 3);
        int n5 = this.aA.y - dimension.height + fontMetrics.getAscent();
        if (this.ak == 0 || this.aA.y < 0) {
            n5 = rectangle2.y + rectangle2.height / 2 - dimension.height / 2 + fontMetrics.getAscent();
        }
        if (this.bx == 1 && n5 - dimension.height / 2 < rectangle2.y) {
            n5 = rectangle2.y + dimension.height / 2 + 1;
        } else if (this.is3DModeOn() && this.m.y != 0 && this.ak == 1 && this.aA.y < rectangle2.y && this.aA.y >= 0) {
            n4 += -this.m.x * (rectangle2.y - this.aA.y) / this.m.y;
            cloneable = null;
            if (n < this.getSeriesCount() - 1) {
                cloneable = this.bs[n + 1][n2];
            } else if (n2 < this.getSampleCount() - 1) {
                cloneable = this.bs[0][n2 + 1];
            }
            if (cloneable != null) {
                n3 = -this.m.x * (((Rectangle)cloneable).y - this.aA.y) / this.m.y;
                if (n5 >= ((Rectangle)cloneable).y && n4 > ((Rectangle)cloneable).x - 10) {
                    n4 = ((Rectangle)cloneable).x - 10;
                } else if (n5 < ((Rectangle)cloneable).y && n4 > ((Rectangle)cloneable).x + n3 - 10) {
                    n4 = ((Rectangle)cloneable).x + n3 - 10;
                }
            }
        }
        cloneable = this.getSize();
        n4 = Math.max(n4, 3);
        n4 = Math.min(n4, cloneable.width - dimension.width - 3);
        n5 = Math.max(n5, fontMetrics.getAscent() + 1);
        n5 = Math.min(n5, cloneable.height - dimension.height + fontMetrics.getAscent() - 1);
        n3 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n4 - 2, n5 - n3 + n6 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(this.getChartForeground());
        if (this.getSeriesCount() == 1 && this.bt) {
            graphics.setColor(this.getSampleColor(n2).darker());
        } else if (this.bt) {
            graphics.setColor(this.getSampleColor(n).darker());
        }
        graphics.drawRect(n4 - 3, n5 - n3 + n6 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.a(graphics, string, n4, n5, dimension, 0, 0);
    }

    boolean a() {
        return this.isValueLabelsOn() && this.bu == 3 || this.bk && (this.ag == 3 || this.ag == 4);
    }
}

