<?php
/**
 * LDAP
 * Implementacion del loguin de usuario mediante LDAP
 * 
 * @author Darío Agüero <daguero@iplan.com.ar>
 * @version 1.0 
 * @date 2011-02-16
 * @package IplanPanelControl.data
 * 
 */


class LDAP
{
	/**
	 * Conexion LDAP 
	 * 
	 * @param string $server   server ldap
	 * @paran string $puerto   puerto server ldap
	 * @return object $conn  devuelve resource_id coneccion ldap 
	 *
	 -------------------------------------------------------------------------*/
	
	private static function connLDAP($server, $port) {
			
		$conn = ldap_connect($server, $port);
		return $conn;
	}
	
	
	/*
	 * Validacion de Credenciales
	 * 
	 * @param  obj     $conn resource_id conexion ldap
	 * @param  string  $username  nombre usuario
	 * @param  string  $password  password usuario
	 * @return bool    $cd true sin son validas las credenciales, sino false
	 ---------------------------------------------------------------------------*/
	
	private static function validCredencials($conn, $username, $password) {
		
		$dn = "uid=$username,ou=Users,dc=iplan,dc=com,dc=ar";
		$cd = @ldap_bind( $conn, $dn, $password ); 
		
		return $cd;
	}


    private static function switchServer() {
        
        //$ip = substr($_SERVER['SERVER_ADDR'], 0, 5);
        $ip="10.30";    
        switch($ip) {

           case '10.30':
              $server = '10.30.1.130';
           break;
                
           case '10.10':
              $server = '10.10.1.6';
           break;
        }

        return $server;
    
    }

   
    /*
     * validateUser
     * 
     * @param string $username  nombre del usuario
     * @param strinf $password  password del usuario
     * @return bool  $cd  true si es valida la conexion, sino false
     --------------------------------------------------------------------------*/

	public static function validateUser($username, $password) {
    
        //switch server
        $server = self::switchServer();
        
		// Conectar al server ldap
		$conn = self::connLDAP($server, "389");
		$cd   = self::validCredencials( $conn, $username, $password ); 

		if(!$cd) {
			$error =  ldap_errno($conn);
            //echo ldap_error($conn);
            //echo $this->server;
		}

		ldap_close($conn);

		return $cd;	
	}
	
	
}

?>
