cb = {
	// settings
	//serverHost: window.location.host, // automatically retrieved from the URL
	serverHost: "190.210.130.10", // automatically retrieved from the URL
	serverPort: 8080,
	//serverPort: 12345,
	usernameMaxLength: 15,
	
	// internal variables
	socket: false,
	connected: false,
   up: false,
	
	// events
	onClickConnect: function() {
		// this function is called when a user clicks the connect or disconnect button
		
		if (cb.isConnected()) {
			// already connected to the server, so disconnect from the server
         var cadenaAnalizar = "wr mem";

         for (var i = 0; i< cadenaAnalizar.length; i++) {
              cb.socket.send('TEXT '+cadenaAnalizar.charAt(i));
         }
         cb.onClickSend("ENTER");

			setTimeout("cb.disconnect()",3000);
			return;
		}
		
		// fetch the username
		var IP = document.getElementById('IPInput').value;
		
		// validate the username
		if (IP == '') {
			cb.log('Debe ingresar una IP\n');
		}
		else if (IP.indexOf(' ') != -1) {
			cb.log('La IP no puede contener un espacio.\n');
		}
		else if (IP.length > cb.usernameMaxLength) {
			cb.log('La IP no puede tener más de '+cb.usernameMaxLength+' caracteres.\n');
		}
		else {
			// connect to the server
			cb.setElementsDisabled(true);
			cb.log('Conectando....\n');
			cb.connect();
         Onload();
		}
	},
	onClickSend: function(comando) {
		// this function is called when a user clicks the send button
		
		if (!cb.isConnected()) {
			cb.log('Sin conexión.\n');
		}
		else{ 
         cb.socket.send('TEXT '+comando);
		}
	},
	
	// chat lines
	log: function(Text) {
		// add text to the chat area on a new line
		var ChatLinesElement = document.getElementById('chatLines');
		ChatLinesElement.value = RemoveBackspaces(ChatLinesElement.value +=Text);
		// scroll the chat area to the far bottom
		ChatLinesElement.scrollTop = 100000;
	},
	
	// server connection
	isConnected: function() {
		return cb.connected;
	},
	connect: function() {
		//var Socket = new MozWebSocket('ws://'+cb.serverHost+':'+cb.serverPort);
		var Socket = new WebSocket('ws://'+cb.serverHost+':'+cb.serverPort);
		cb.setSocketEvents(Socket);
		cb.socket = Socket;
	},
	disconnect: function() {
		cb.socket.send('QUIT');
		cb.socket.close();
	},
	
	// socket events
	setSocketEvents: function(Socket) {
		Socket.onopen = function() {
			// now connected to the server
			cb.connected = true;
			//cb.log('Conectado!\n');
			
			// set elements enabled, and connect button text to "Disconnect"
			document.getElementById('connectButton').value = 'Desconectar';
			document.getElementById('connectButton').disabled = false;
         document.getElementById('chatLines').focus();
         var usuario = document.getElementById('usuario').value;
			
			// fetch username, add username to users list, and send JOIN to server
			var IP = document.getElementById('IPInput').value;
			cb.users.add(IP);
			cb.socket.send('JOIN '+IP+' '+usuario);
		}
		
		Socket.onmessage = function(Message) {
			// fetch data received from server, split data by spaces into array, and fetch command
			var Data = Message.data;
			var Args = Data.split(' ');
			var Command = Args.shift();
			
			// check command
			if (Command == 'ONTEXT') {
				// received chat text
				var Text = Args.join(' ');
    			cb.log(Text);
			}
			else if (Command == 'SERVER') {
				// received server text
				var Text = Args.join(' ');
				cb.log('Server: '+Text);
			}
			else if (Command == 'ONJOIN') {
				// user joined
				var IP = Args[0];
				cb.users.add(IP);
				cb.log(IP+' joined.\n');
			}
			else if (Command == 'ONQUIT') {
				// user quit
				var IP = Args[0];
				cb.users.remove(IP);
				cb.log(IP+' quit.\n');
			}
			else if (Command == 'USERS') {
				// received list of users
				var IPs = Args;
				cb.users.set(IPs);
			}
		}
		
		Socket.onclose = function() {
			if (cb.connected) {
				// was connected to server before onclose was called
				cb.log('\nDesconectado.\n');
				
				// set elements disabled, and connect button text to "Connect"
				document.getElementById('connectButton').value = 'Telnet';
			}
			else {
				// was not connected to server before onclose was called
				cb.log('Falló la conexión\n');
			}
			
			cb.connected = false;
			
			// clear the list of users
			cb.users.clear();
			
			// set elements enabled
			cb.setElementsDisabled(false);
		}
	},
	
	// users list
	users: {
		count: 0,
		
		add: function(IP) {
/*			var List = document.getElementById('usersList');
			
			if (cb.users.count == 0) {
				// remove the "(not connected)" list item
				List.removeChild(List.children[0]);
			}
			
			cb.users.count++;
			
			var ListItem = document.createElement('li');
			ListItem.textContent = IP;
			List.appendChild(ListItem);*/
		},
		remove: function(IP) {
/*			cb.users.count--;
			
			var List = document.getElementById('usersList');
			var ListItems = List.children;
			
			var i, j = ListItems.length;
			for (i=0; i<j; i++) {
				if (ListItems[i].textContent == IP) {
					List.removeChild(ListItems[i]);
					break;
				}
			}*/
		},
		set: function(IPs) {
/*			var List = document.getElementById('usersList');
			var i, j = IPs.length, ListItem;
			for (i=0; i<j; i++) {
				ListItem = document.createElement('li');
				ListItem.textContent = IPs[i];
				List.appendChild(ListItem);
				
				cb.users.count++;
			}*/
		},
		clear: function() {
/*			// reset users count to 0
			cb.users.count = 0;
			
			// add the "(not connected)" list item
			document.getElementById('usersList').innerHTML = "<li style='text-align: center;'>(not connected)</li>";*/
		}
	},
	
	// elements disabled state
	setElementsDisabled: function(State) {
		document.getElementById('IPInput').disabled = State;
		document.getElementById('connectButton').disabled = State;
	}
}

//window.onload = function() {
function Onload() {
	// reset elements values and disabled states when page reload with F5
	cb.setElementsDisabled(false);
	
	// make enter key submit the message in the chat input box
	document.getElementById('chatLines').onkeypress = function(event) {
		if (event.keyCode == 13 && !event.shiftKey) { // enter key pressed down, and shift key is not pressed down
			event.preventDefault(); // prevent a new line being added to the chat input box
      }else{
          if (!event.ctrlKey){
            cb.onClickSend(String.fromCharCode(event.charCode));
          }
      }
	}

   document.getElementById('chatLines').onkeydown = function(event) {
        
        if (event.keyCode == 13){
            cb.onClickSend("ENTER");
            event.preventDefault();
            }
        if (event.keyCode == 37){
//            cb.onClickSend("LEFT");
            event.preventDefault();
            }
        if (event.keyCode == 38){        
         //   cb.onClickSend("RIGHT");
            event.preventDefault();
            }
        if (event.keyCode == 40){
            cb.onClickSend("DOWN");
            event.preventDefault();
            }
        if (event.keyCode == 38){
            cb.onClickSend("UP");
            event.preventDefault();
            }
        if (event.keyCode == 9){
            cb.onClickSend("TAB");
            event.preventDefault();
        }
        
        if (event.keyCode == 8){
            cb.onClickSend("DEL");
            event.preventDefault();
        }else{
        
        }

        if (event.keyCode == 90 && event.ctrlKey){
            cb.onClickSend("CTRLZ");
        }
        
        if (event.keyCode == 67 && event.ctrlKey){
            cb.onClickSend("CTRLC");
        }
   }
   
}

function RemoveBackspaces(str)
{
    while (str.indexOf("\b") != -1)
    {
     str = str.replace(/.\x08/, "");
    }
    return str;
}

function OnPaste(elem, e)
{
    var cadenaAnalizar = e.clipboardData.getData("Text");
    
    for (var i = 0; i< cadenaAnalizar.length; i++) {
        cb.socket.send('TEXT '+cadenaAnalizar.charAt(i));
    }
}

