<?php

require_once('interfaces.php');
require_once('modelo/Usuario.php');
require_once('modelo/Logs.php');
require_once('modelo/Parser.php');
require_once('modelo/Encoder.php');
require_once('modelo/Url.php');
require_once('modelo/Http.php');
require_once('modelo/general_functions.php');
require_once('modelo/PHPCisco.php');
require_once('BaseDeDatos.php');
require_once('constantes.php');
require_once('class.phpmailer.php');

class SistemaNavegacionWeb implements ISistemaNavegacionWeb {
  
  private $db; # base de datos
  public $usuarioweb;
  private $log;
  private $error=false;
  private $estado=0;

  function __construct()
  {
  	# creo la base de datos
	$this->db = BaseDeDatos::conectar();
  }

  function login($nombre, $clave)
  {
     # Valido el usuario contra el LDAP corporativo 
     if(Usuario::login($nombre,$clave)){
     $this->usuarioweb = $nombre;
	  $this->log = new Logs($nombre,LOGIN,'El usuario '.$nombre.' ingreso a la plataforma');
	  $this->log->guardar($this->db);
          return true;
     } else {
         return false;
       }
  }
  
  function navegar($url)
  {
    $knEncoder = new knEncoder();
    $knEncoder->serverKey = KNPROXY_SECRET;

    if(isset($_GET['encrypt_key'])){
        $key = (int)$_GET['encrypt_key'];
        $knEncoder->setKey($key);
        $knEncoder->serverKey='';
    }
    
    if(!preg_match('~/~',$url))
        $url = $knEncoder->decode($url);

    if (strpos($url,"/ChangePassword")){
       return "No puede navegar este men&uacute;"; 
    }
    
    if (strpos($url,"/FileUpload") || strpos($url,"/RegFxs") || strpos($url,"/RegCpt") || strpos($url,"/RegVp")){
       return "Por el momento esta funcionalidad no est&aacute; soportada"; 
    }
    
    $knEncoder->serverKey = KNPROXY_SECRET;
    $knEncoder->setKey(0);
    $url = checkHttpUrl($url);

    /** Get the Scripts URL **/
    $_HOST = $_SERVER['HTTP_HOST'];
    
    if(strtolower(substr($_SERVER['HTTP_HOST'],0,4))!='http' && (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS']=='')){
        $_HOST = 'http://' . $_SERVER['HTTP_HOST'];
    }else{
        $_HOST = 'https://' . $_SERVER['HTTP_HOST'];
    }
    
    $_SCRIPT =$_HOST . $_SERVER['SCRIPT_NAME'];
    
    /** Create the modules **/
    $knURL = new knUrl();
    $knURL->setBaseurl($url);
    $knHTTP = new knHttp($url);
    $knHTTP->set_post($_POST);
    /** Extraemos la IP del equipo para loguearla **/
    preg_match('@^(?:http://)?([^/]+)@i',$url, $matches);
    $IpEquipo = $matches[1];

    /**FIX para mostrar el estado de las tramas en los Mediant. La solucion es hacer un redirect al equipo directmanete ya que no solicita el user y pass**/
    if (strpos($url,"/UE/STATUS")){
        header("Location: http://$IpEquipo/UE/STATUS");
        return;
    }
    
    /**FIX para mostrar el syslog en los audiocodes. La solucion es hacer un redirect al equipo directmanete ya que no solicita el user y pass**/
    if (strpos($url,"/UE/SYSLOG")){
        header("Location: http://$IpEquipo/UE/SYSLOG");
        return;
    }
    
    $knHTTP->set_http_creds(AUDIOCODES_USER_ADMIN,AUDIOCODES_PASS_ADMIN);
    $knHTTP->set_cookies($_COOKIE);
    
    /** Handle Cached Requests **/
    if(isset($_SERVER['HTTP_IF_MODIFIED_SINCE']))
        $knHTTP->set_request_headers(Array('If-Modified-Since',$_SERVER['HTTP_IF_MODIFIED_SINCE']));
    if(isset($_SERVER['HTTP_IF_MATCH']))
        $knHTTP->set_request_headers(Array('If-Match',$_SERVER['HTTP_IF_MATCH']));
    if(isset($_SERVER['HTTP_IF_NONE_MATCH']))
        $knHTTP->set_request_headers(Array('If-None-Match',$_SERVER['HTTP_IF_NONE_MATCH']));
    if(isset($_SERVER['HTTP_IF_UNMODIFIED_SINCE']))
        $knHTTP->set_request_headers(Array('If-Unmodified-Since',$_SERVER['HTTP_IF_UNMODIFIED_SINCE']));
    if(isset($_SERVER['HTTP_IF_RANGE']))
        $knHTTP->set_request_headers(Array('If-Range',$_SERVER['HTTP_IF_RANGE']));
    
    /** HTTP Ranges **/
    if(isset($_SERVER['HTTP_RANGE']))
        $knHTTP->set_request_headers(Array('Range',$_SERVER['RANGE']));
    
    /** Send And Load **/
    $knHTTP->send();
    $headers = $knHTTP->refined_headers();
    
    /** Do some fancy stuff with the headers **/

    if((int)$headers['HTTP_RESPONSE']>=200 && (int)$headers['HTTP_RESPONSE']<400){
        if(!is_array($_POST) ||  count($_POST)<1 || $_POST['accion']=="navegar"){
//            if (!strpos($url,"/Images/"))
            if(count(preg_split("/[\s\/]+/", $url))==2)
                $this->loguear(NAVEGACION_WEB,'El usuario '.$_SESSION["Usuario"].' navego la pagina '.$url,$IpEquipo);
        }else{
            $this->loguear(CONFIGURACION_WEB,'El usuario '.$_SESSION["Usuario"].' configuro la pagina '.$url.' con estos datos: '.$knHTTP->getPost(),$IpEquipo);
        }
    }
    
    if($headers['HTTP_RESPONSE']==401){
        //UNAUTHORIZED
        $realm = $headers['WWW_AUTHENTICATE_REALM'];
        //include('includes/gui_httpauth.php');
        include('vistas/error_auth.php');
        exit();
    }
    /** Await Authentication **/
    header('HTTP/1.1 ' . $headers['HTTP_RESPONSE'] . ' Omitted');
    if(((int)$headers['HTTP_RESPONSE']>=400 && (int)$headers['HTTP_RESPONSE']!=404) || (int)$headers['HTTP_RESPONSE']<1){
        $eobj=Array('status'=>$headers['HTTP_RESPONSE']);
        //include('includes/gui_error.php');
        include('vistas/error_timeout.php');
        exit();
    }
    
    /** Load The Page **/
    header('Content-Type: ' . $knHTTP->doctype);
    
    /** Need Redirection? **/
    if(isset($headers['KNPROXY_LOCATION']) && $headers['KNPROXY_LOCATION']!=""){
        //header('Location: ' . basename(__FILE__) . "?accion=navegar&url=" . $knEncoder->encode($headers['KNPROXY_LOCATION']));
        header('Location: ' . "index.php" . "?accion=navegar&url=" . $knEncoder->encode($headers['KNPROXY_LOCATION']));
        exit();
    }
    
    if(isset($headers['HTTP_LOCATION']) && $headers['HTTP_LOCATION']!=''){
        $url = $knURL->getAbsolute($headers['HTTP_LOCATION']);
        $knurl = $knEncoder->encode($url);
        //$nURL = basename(__FILE__) . "?accion=navegar&url=" . $knurl;
        $nURL = "index.php?accion=navegar&url=" . $knurl;
        header('Location: ' . $nURL );
    }
    /** Downloads And Filename **/
    if(isset($headers['CONTENT_DISPOSITION']) && $headers['CONTENT_DISPOSITION']!='')
        header('Content-Disposition: ' . $headers['CONTENT_DISPOSITION']);
        /** Cache Stuff **/
    if(!empty($headers['CACHE_CONTROL']))
        header('Cache-Control: ' . $headers['CACHE_CONTROL']);
    if(!empty($headers['EXPIRES']))
        header('Expires: ' . $headers['EXPIRES']);
    if(!defined('KNPROXY_CACHE_MODE') || KNPROXY_CACHE_MODE=="none"){
        if(!empty($headers['LAST_MODIFIED']))
            header('Last-Modified: ' . $headers['LAST_MODIFIED']);
        if(defined('KNPROXY_ETAG'))
            switch(KNPROXY_ETAG){
                case 'forward':
                    if(isset($headers['ETAG']) && !empty($headers['ETAG'])){header('ETag: ' . $headers['ETAG']);};
                    break;
                case 'generate':{
                    if(isset($headers['ETAG']) && !empty($headers['ETAG'])){
                        header('ETag: ' . $headers['ETAG']);
                    }else{
                        header('ETag: "' . md5($knHTTP->content) . '"');
                    }
                    }break;
                case 'suppress':{
                    header('ETag: ');//Suppressed
                    }
            }
        }
    
    /** Do a Range Check **/
    if(!empty($headers['ACCEPT_RANGES']))
        header('Accept-Ranges: ' . $headers['ACCEPT_RANGES']);
    if(!empty($headers['CONTENT_RANGE']))
        header('Content-Range: ' . $headers['CONTENT_RANGE']);
    
    /** Http Refresh Headers **/
    if(isset($headers['HTTP_REFRESH'])){
        //$pre=basename(__FILE__) . '?accion=navegar&url=';
        $pre='index.php?accion=navegar&url=';
        header('refresh:'.(int)$headers['refresh'][0].';accion=navegar&url='. $pre . $knEncoder->encode($knURL->getAbsolute($headers['refresh'][1])));
    }

    if(isset($headers['HTTP_COOKIES']) && is_array($headers['HTTP_COOKIES']))
        foreach($headers['HTTP_COOKIES'] as $cookie){
            if($cookie[2]!=''){
                $expires = strtotime($cookie[2]);
                setcookie($cookie[0],$cookie[1],$expires);
            }else{
                setcookie($cookie[0],$cookie[1]);//Session cookie
            }
        }
    
    /** Parsing Process **/
    $knParser = new knParser($knURL,$knHTTP->content,$_SCRIPT . '?accion=navegar&url=');
    $knParser->setMimeType($knHTTP->doctype);
    $knParser->setCharset($knHTTP->doctype,$knHTTP->content);
    $knParser->setEncoder($knEncoder);
    if(defined('KNPROXY_ENCRYPT_PAGE') && KNPROXY_ENCRYPT_PAGE=='true'){
        if($knParser->type=='text/html' || $knParser->type==''){
            $t = '<script language="javascript" type="text/javascript" src="javascripts/denjihou.js"></script>';
            $t.= '<script language="javascript" type="text/javascript">';
            $knParser->set_value('use_page_encryption',true);
            $knParser->parse();
            $key = $knParser->get_value('key','');
            $t.= 'knEncode.setxmkey("' . $key . '");' . "\n";
            $t.= 'knEncode.charset="'. $knParser->charset .'";' . "\n";
            $t.= 'var page = knEncode.decode("' . $knParser->output . '");' . "\n";
            $t.= 'document.write(page);' . "\n";
            $t.= '</script>';
            
            if(defined('KNPROXY_USE_GZIP') && KNPROXY_USE_GZIP == 'true' && substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') && function_exists('ob_gzhandler')){
                ob_start("ob_gzhandler");
                echo $t;
            }else{
                echo $t;
            }
            exit();
        }
    }
    $knParser->parse();

    //En el TITLE de la pagina principal ponemos la IP del equipo para saber cual estamos configurando//
    $knParser->output = preg_replace("/<TITLE>(.*)(AudioCodes)\s<\/TITLE>/is","<TITLE>AudioCodes $IpEquipo</TITLE>", $knParser->output);   
    if(defined('KNPROXY_USE_GZIP') && KNPROXY_USE_GZIP == 'true' && substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') && function_exists('ob_gzhandler')){
        if(substr($knParser->type,0,5)=='text/'){
            ob_start("ob_gzhandler");
            echo $knParser->output;
        }else
            echo $knParser->output;
    }else
        echo $knParser->output;
  }
  
  function baja_equipo($ip,$tipo)
  {
      switch ($tipo){
            case "CISCO":
                $resultado = $this->cambiarPasswordCisco($ip,IAD_DF_PASS_ENABLE);
            break;
            case "AUDIOCODES":
                $resultado = $this->cambiarPasswordAudiocodes($ip,AUDIOCODES_DF_USER_ADMIN,AUDIOCODES_DF_PASS_ADMIN);
            break;
            default:
      }

      if ($resultado){
          $this->loguear(BAJA_EQUIPO,'El usuario '.$_SESSION["Usuario"].' dio de baja el equipo '.$ip,$ip);
          return true;
      }
      return false;
  }
  
  function alta_equipo($ip,$tipo)
  {
        switch ($tipo){
            case "CISCO":
                $resultado = $this->cambiarPasswordCisco($ip,IAD_PASS_ENABLE);
            break;
            case "AUDIOCODES":
                $resultado = $this->cambiarPasswordAudiocodes($ip,AUDIOCODES_USER_ADMIN,AUDIOCODES_PASS_ADMIN);
            break;
            default:
        }
        
        if($resultado){
          $this->loguear(ALTA_EQUIPO,'El usuario '.$_SESSION["Usuario"].' dio de alta el equipo '.$ip,$ip);
          return true;
      }
      return false;
  }
  
  function cambiarPasswordAudiocodes($ip,$username,$password)
  {
    $ch = curl_init();
    //Verificamos si es un alta o baja de equipo en la red, preguntando por la password que se le quiere poner
  
    if ($password == AUDIOCODES_PASS_ADMIN){
        $userpwd = AUDIOCODES_DF_USER_ADMIN.":".AUDIOCODES_DF_PASS_ADMIN;
        $curAdminPW = AUDIOCODES_DF_PASS_ADMIN;
    }
    else{
        $userpwd = AUDIOCODES_USER_ADMIN.":".AUDIOCODES_PASS_ADMIN; 
        $curAdminPW = AUDIOCODES_PASS_ADMIN;
    }
    if ($this->verificarVersionD($ip,$userpwd) == true)
        $data = "NewAdminUN=$username&CurAdminPW=$curAdminPW&NewAdminPW=$password&ConfNewAdminPW=$password&Submit=Change+Password"; 
    else
        $data = "NewUserName=$username&NewPassword=$password&ConfirmPassword=$password&Submit=Change+Administrator+Password";

    // Establecer URL y otras opciones apropiadas
    curl_setopt($ch, CURLOPT_URL, "http://$ip/Forms/ChangePassword");
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    curl_setopt($ch, CURLOPT_USERPWD, $userpwd);
    curl_setopt($ch, CURLOPT_POST,1);
    curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT,AUDIOCODES_CONNECTION_TIMEOUT);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);

    $rta = curl_exec($ch);
    $info = curl_getinfo($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  
    // Cerrar el recurso cURL y liberar recursos del sistema
    curl_close($ch);
  
    if ($http_code==303){
        return true;
    }else
        return false;
  }

  function verificarVersionD($ip,$userpwd)
  {
    //La manera mas facil es entrar al equipo y ver en el menu de la izquierda si tiene la "casita" de color verde. Asi que hacemos un GET para ver si podemos obtener esa imagen

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://$ip/Images/HomePage");
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    curl_setopt($ch, CURLOPT_USERPWD, $userpwd);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, AUDIOCODES_CONNECTION_TIMEOUT);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);

    $rta = curl_exec($ch);
    $info = curl_getinfo($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Cerrar el recurso cURL y liberar recursos del sistema
    curl_close($ch);

    if ($http_code==200)
        return true;
    else
        return false;
  }
  
  function cambiarPasswordCisco($ip,$password)
  {
    //Verificamos si es un alta o baja de equipo en la red, preguntando por la password que se le quiere poner
    if ($password == IAD_PASS_ENABLE){
        $curEnablePW = IAD_DF_PASS_ENABLE;
    }
    else{
        $curEnablePW = IAD_PASS_ENABLE;
    }
    
    $telnet = new PHPCiscoTelnet();
    $result = $telnet->Connect($ip, IAD_USER_ADMIN, IAD_PASS_ADMIN);
    
    switch ($result) {
    case 0:
         $telnet->enable($curEnablePW);
         $telnet->DoCommand("conf t\n");
         sleep(1);
         $telnet->changeEnable($password);
         sleep(1);
         //echo $telnet->display();
         $telnet->Disconnect();
         return true;
    case 1:
         echo '[Telnet] Connect failed: Unable to open network connection';
         return false;
    case 2:
         echo '[Telnet] Connect failed: Unknown host';
         return false;
    case 3:
         echo '[Telnet] Connect failed: Login failed';
         return false;
    default:
         return false;
    }
  }
  
  function listar_logs($idTipo,$usuario,$fecha_desde,$fecha_hasta,$ip)
  {
	return Logs::listar_logs($this->db,$idTipo,$usuario,$fecha_desde,$fecha_hasta,$ip);
  }
  
  function dar_tipos_eventos($idPerfil)
  {
     return Logs::dar_tipos_eventos($this->db,$idPerfil);
  }

  function dar_usuarios($idCliente=0,$idRevendedor=0,$criterio=0)
  {
     $idPerfil=$_SESSION['idPerfil'];
     switch($idPerfil){
          case ADMINISTRADOR:
          case LEGALES:
                        $idPerfil=0;
          break;
          case CONSULTA:
          break;
          default:
       }
    return Usuario::dar_usuarios($this->db,$idPerfil);
  }

  function dar_perfiles()
  {
     $idPerfil=$_SESSION['idPerfil'];
     switch($idPerfil){
          case ADMINISTRADOR:
                        $idPerfil=0;
          break;
          case LEGALES:
          case CONSULTA:
          break;
          default:
       }
    return Usuario::dar_perfiles($this->db,$idPerfil);
  }
  
  function loguear($id_log,$texto,$ip)
  {
    $this->log = new Logs($_SESSION['Usuario'],$id_log,$texto,$ip);
    $this->log->guardar($this->db);
  }
  
  function baja_usuario($idUsuario)
  {
      Usuario::baja($this->db,$idUsuario);
      return true;
  }

  function guardar_usuario($nombre,$usuario,$clave,$idUsuario,$idPerfil)
  {
     if ($idUsuario==0){
         if(Usuario::alta($this->db,$idPerfil,$nombre,$usuario,$clave)){
            $this->loguear(ALTA_USUARIO,"Se ha dado de alta el usuario $nombre");
            return true;
         }
     }else{
         Usuario::modificacion($this->db,$nombre,$usuario,$clave,$idUsuario,$idPerfil);
         $this->loguear(MODIFICACION_USUARIO,"Se ha dado modificado el usuario $nombre");
         return true;
     }
  }

  function enviar_mail($email,$subject,$mensaje,$cabeceras)
  {
  	$mail = new PHPMailer();
        $mail -> From = "miratucamara@gmail.com";
        $mail -> FromName = "Alarmas MiratuCamara";
        $direccionmail=split(",",$email);
	        for ($i=0;$i<count($direccionmail);$i++){
	               $mail -> AddAddress ($direccionmail[$i]);
	        }
        // $mail -> AddAttachment ($archivo);
        $mail -> Subject = "$subject";
        $mail -> Body = "$mensaje";
        $mail -> IsHTML (true);
        $mail->IsSMTP();
        $mail->Host = 'ssl://smtp.gmail.com';
        $mail->Host = 'smtp.gmail.com';
        $mail->Port = 465;
        $mail->SMTPAuth = true;
        $mail->Username = 'miratucamara@gmail.com';
        $mail->Password = 'Qcqhed!!';
        $mail->Send();
  }
}
?>
