<?php

require_once 'SistemaNavegacionWeb.php';
require_once 'modelo/constantes.php';

error_reporting(0);

class InterfaceWeb implements IInterfaceWeb {
  private $sNavegacionWeb;

  function __construct()
  {
   	# Creo una instancia del sistema:
  	$this->sNavegacionWeb = new SistemaNavegacionWeb();
  }

  function mostrar_login()
  {
  	include "vistas/login.php";
  }

  function procesar_login($nombre, $clave)
  {
    if (!$this->sNavegacionWeb->login($nombre,$clave)) {
        $this->mostrar_msg("Usuario o Clave incorrecta!");
        return false;
    }else{
        $_SESSION['Usuario']=$nombre;
        $_SESSION['idPerfil']=ADMINISTRADOR;
        $this->mostrar_inicio();
        return true;
    }
  }

  function eliminar_sesion()
  {
       session_destroy();
  }

  function valida_accion($accion)
  {	
	switch($_SESSION['idPerfil']) {
		case ADMINISTRADOR:
			 switch($accion) {
				case 'menu_navegar':
				case 'menu_navegar_cisco':
				case 'navegar':
				case 'baja_equipo':
				case 'mostrar_baja_equipo':
				case 'mostrar_baja_equipo_cisco':
            case 'mostrar_alta_equipo':
            case 'mostrar_alta_equipo_cisco':
            case 'alta_equipo':
				case 'menu_logs':
				case 'listar_logs':
            case 'exportar_logs_csv':
            case 'descargar_logs':
            case 'telnet_cisco':
				case '':
					break;
				default:
					$accion = 'salir';
					break;
				}
		break;
		case CONSULTA:
			 switch($accion) {
				case 'menu_navegar':
				case 'menu_navegar_cisco':
				case 'navegar':
				case 'baja_equipo':
				case 'mostrar_baja_equipo':
				case 'mostrar_baja_equipo_cisco':
            case 'mostrar_alta_equipo':
				case 'mostrar_alta_equipo_cisco':
            case 'alta_equipo':
				case 'menu_logs':
				case 'listar_logs':
            case 'exportar_logs_csv':
            case 'descargar_logs':
            case 'telnet_cisco':
				case '':
					break;
				default:
					$accion = 'salir';
					break;
				}
		break;
		default:
			switch($accion) {
				case '':
				case 'login':
				        break;
				default:
					$accion = 'salir';
					break;
				}
	}
	return $accion;
  }
 
  function navegar($url)
  {
    if ($url!='')
        return $this->sNavegacionWeb->navegar($url); 
    else
        return mostrar_msg("Debe ingresar una IP para poder navegar!");        
  }

  function mostrar_logs()
  {
      echo "<table class=\"buscar_log\" colspan=\"7\"><tr><th>Seleccione tipo de log</th><th>Filtrar usuario</th><th>Filtrar IP</th><th>Fecha desde</th><th>Fecha hasta</th><th></th></tr>";
      echo "<tr><td>".$this->mostrar_select_tipos_eventos()."</td>";
      echo "<td><input id=\"nombre_usuario\" name=\"nombre_usuario\" size=10/></td>";
      echo "<td><input id=\"filtro_ip\" name=\"filtro_ip\" size=12/></td>";
      echo "<td><input id=\"fecha_desde\" name=\"fecha_desde\"/ value=".date('Y-m-d')." size=12><a href=\"javascript:popUpCalendar(document.getElementById('fecha_desde'),document.getElementById('fecha_desde'),'yyyy-mm-dd')\"><img src=\"Images/calendar.gif\"></a></td><td><input name=\"fecha_hasta\" id=\"fecha_hasta\"/ value=".date('Y-m-d')." size=12><a href=\"javascript:popUpCalendar(document.getElementById('fecha_hasta'),document.getElementById('fecha_hasta'),'yyyy-mm-dd')\"><img src=\"Images/calendar.gif\"></a></td></tr></table><table><tr><th><input type=\"submit\" name=\"buscar_logs\" value=\"Buscar\" onclick='listar_logs()'/><th>   </th><th><input type=\"submit\" name=\"limpiar_filtros\" value=\"Limpiar\" onclick='limpiar_filtros()'/></tr></table>";
  }
  
  function mostrar_baja_equipo_cisco()
  {
    include "vistas/form_baja_equipo_cisco.php";
  }
  
  function mostrar_alta_equipo_cisco()
  { 
    include "vistas/form_alta_equipo_cisco.php";
  }
  
  function mostrar_baja_equipo()
  {
    include "vistas/form_baja_equipo.php";
  }
  
  function mostrar_alta_equipo()
  { 
    include "vistas/form_alta_equipo.php";
  }
 
  function alta_equipo($ip,$tipo)
  {
    if ($this->sNavegacionWeb->alta_equipo($ip,$tipo)){
        if ($tipo=="CISCO"){
            echo "<h2>Se configur&oacute; el nuevo password del modo enable al equipo $ip</h2>";
        }
        else{
            echo "<h2>Se configur&oacute; el nuevo usuario y password al equipo $ip</h2>";
        }
    }
    else{
        echo "<h2>El equipo que intenta dar de alta no puede ser accedido. Verifique si los datos son correctos e intente nuevamente</h2>";
    }
  }

  function baja_equipo($ip,$tipo)
  {
    if ($this->sNavegacionWeb->baja_equipo($ip,$tipo)){
        if ($tipo=="CISCO"){
            echo "<h2>Se reestableci&oacute; el password del modo enable del  equipo $ip </h2>";
        }
        else{
            echo "<h2>Se reestablecieron los valores de usuario y password del equipo $ip con los valores de f&aacute;brica</h2>";
        }
    }
    else{
        echo "<h2>El equipo que intenta dar de baja no puede ser accedido. Verifique si los datos son correctos e intente nuevamente</h2>";
    }
  }

  function mostrar_select_tipos_eventos()
  {
       $tipos_eventos=$this->sNavegacionWeb->dar_tipos_eventos($_SESSION['idPerfil']);

       foreach($tipos_eventos as $tipos=>$valor)
       {
          $options.="<option value=\"".$valor['idTipo']."\">".$valor['descripcion']."</option>";
       }
       
       $html="<select id='tipo_evento'><option value=0>Todos</option>$options</select>";

       return $html;
  }

  function mostrar_select_usuarios()
  {
       $usuarios=$this->sNavegacionWeb->dar_usuarios();

       foreach($usuarios as $usuario=>$valor)
       {
          $options.="<option value=\"".$valor['idUsuario']."\">".$valor['usuario']."</option>";
       }

       $html="<select id='usuario'><option value=0>Todos</option>$options</select>";

       return $html;
  }

  function mostrar_msg($mensaje)
  {
      echo "<script language=\"JavaScript\">\n";
      echo "alert(\"$mensaje\");\n";
      echo "</script>";
  }

  function mostrar_inicio()
  {
    //include('index.bkp.php');
    include('vistas/administrador.php');
  }
 
  function mostrar_administrador()
  {
      include('vistas/administrador.php');
  }

  function form_usuarios()
  {
      $html= "<table bgcolor=\"#C0C0C0\" width=\"672\" cellspacing=\"2\" cellpadding=\"0\" align=\"left\"><tr><td colspan=\"1\">Perfil: ";
      $html.=$this->mostrar_select_perfiles();
      $html.="</td></tr></table></br>";
      echo $html;
      include('vistas/form_usuario.php');
  }
  
  function mostrar_navegar()
  {
  	include "vistas/form_navegar.php";
  }
  function telnet_cisco($ip)
  {
    echo"<div class='box1'>
      <textarea id='chatLines' readonly='readonly'></textarea><br />
    </div>
    <div class='box2'>
        <input id='IPInput' type='text' placeholder='IP del equipo' /><br />
        <input id='connectButton' type='button' value='Telnet' onclick='cb.onClickConnect()' /><br />
    </div>";
//  	include "vistas/form_navegar_iad.php";
  }
  
  function mostrar_navegar_cisco()
  {
    echo"<div class='box1'>
      <textarea id='chatLines' readonly='readonly' onpaste='OnPaste(this, event);'></textarea><br />
    </div>
    <div class='box2'>
        <input id='IPInput' type='text' placeholder='IP del equipo' value='172.17.235.128'/><br />
        <input id='connectButton' type='button' value='Telnet' onclick='cb.onClickConnect()' /><br />
        <input type='hidden' id='usuario' name='usuario' value='".$_SESSION['Usuario']."'/>
    </div>";
  }
  
  function descargar_logs($contenido)
  {
    $archivo="Logs Audiocodes.csv";
    header("Cache-Control: ");
    header("Content-type: text/plain");
    header('Content-Disposition: attachment; filename="'.$archivo.'"');
    echo $contenido;
  }

  function listar_logs($idTipo,$usuario,$fecha_desde,$fecha_hasta,$ip)
  { 
    $caracteresEspeciales = array("<",">");
    $caracteresEspecialesReemplazo = array("&lt;","&gt;");
    echo $this->mostrar_logs();
    $logs=$this->sNavegacionWeb->listar_logs($idTipo,$usuario,$fecha_desde,$fecha_hasta,$ip);
    $csv="Tipo de Log,Descripción,Usuario,IP Equipo,Fecha de creación\n";

  	 $html.="</br><center><table class=\"listados\" ><tr><th colspan=\"5\" style=\"background-color:grey;\">Listado de Logs</th></tr><tr><th>Tipo de log</th><th>Descripcion</th><th>Usuario</th><th>IP Equipo</th><th>Fecha de creacion</th></tr>";	

	 foreach($logs as $log=>$log_info){
        
        $log_info['descripcion']= str_replace($caracteresEspeciales,$caracteresEspecialesReemplazo,$log_info['descripcion']);

        if ($log_info['idTipo'] == LOG_CISCO || $log_info['idTipo'] == CONFIGURACION_WEB) {
    	    if ($log_info['idTipo'] == LOG_CISCO)
	            $rows = count(split("\n",$log_info['descripcion']));
	       else
	            $rows = count(split("&",$log_info['descripcion'])) + 1;
            if ($rows > 20)
                $rows = 20;
            $descripcion = "<textarea rows=\"$rows\" cols=\"90\">".$log_info['descripcion']."</textarea>";
        } else $descripcion = $log_info['descripcion'];
            
		  $html.= "<tr align=\"center\"><td>".$log_info['tipo_log']."</td><td>$descripcion</td><td>".$log_info['usuario']."</td><td>".$log_info['Ip']."</td><td>".$log_info['fechaCreacion']."</td></tr>";
        $csv.=$log_info['tipo_log'].",".$log_info['descripcion'].",".$log_info['usuario'].",".$log_info['Ip'].",".$log_info['fechaCreacion']."\n";
	 }

    $salida = "<form action='index.php' method='post' name='logs_csv'><input type='submit' align='center' name='descargar_csv' id='descargar_csv' value='Exportar CSV'/><input type='hidden' name='accion' value='descargar_logs'/><input type='hidden' id='contenido' name='contenido' value='$csv'/></form>$html</table>";
    
    return $salida; 
  }

  function listar_usuarios()
  {
      $usuarios=$this->sNavegacionWeb->dar_usuarios(0,0,$_POST['criterio']);
//      $html="Ingrese Nombre: <input name=\"criterio\" id=\"criterio\" value=\"\" size=\"20\"/><input type=\"submit\" name=\"buscar\" value=\"Buscar\" onclick=\"buscar('usuarios')\"/>";
      $html.="<center><table class=\"listados\" ><tr><th colspan=\"5\" style=\"background-color:grey;\">Listado de Usuarios</th></tr><tr><th>Nombre</th><th>Usuario</th><th>Perfil</th><th>Acciones</th></tr>";
          foreach($usuarios as $usuario=>$valor){
                   $html.= "<tr align=\"center\"><td>".$valor['nombre']."</td><td>".$valor['usuario']."</td><td>".$valor['descripcion']."</td><td>";
                    if ($_SESSION['idUsuario']!=$valor['idUsuario']){
                             $html.="<a href=\"#\" onclick=\"baja_usuario('".$valor['idUsuario']."','".$valor['usuario']."')\">Borrar</a>";
                    }
             $html.=" <a href=\"#\" onclick=\"modificar_usuario(".$valor['idUsuario'].",'".$valor['nombre']."','".$valor['usuario']."','".$valor['idPerfil']."')\">Modificar</a></td></tr>";
          }
    return $html;
  }

  function baja_usuario($idUsuario)
  {
       $res = $this->sNavegacionWeb->baja_usuario($idUsuario);

           if ($res){
                return $this->listar_usuarios();
           }else{
                return "<h2>No se pudo dar de baja<h2>";
                }
  }

  function guardar_usuario($nombre,$usuario,$clave,$idUsuario,$idPerfil)
  {
     $res=$this->sNavegacionWeb->guardar_usuario($nombre,$usuario,$clave,$idUsuario,$idPerfil);
     
     if ($res){
        return $this->listar_usuarios();
     }else{
        return "<h2>No se pudo guardar el usuario<h2>";
     }
  }
  
  function mostrar_select_perfiles()
  {
	$perfiles=$this->sNavegacionWeb->dar_perfiles();
	foreach($perfiles as $perfil=>$valor)
	{
	        $options.="<option value=\"".$valor['idPerfil']."\">".$valor['descripcion']."</option>";
	}

	$html="<select id='perfil'>$options</select>";
	return $html;
  }
}
# inicializo la sesión con el usuario
$sessionCookieExpireTime=60*60;
session_set_cookie_params($sessionCookieExpireTime);
session_start();

?>
